/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.SoftKeySoftValueHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcFileStatus {
    private final Map<String, StatusEntry> myCache = new SoftKeySoftValueHashMap();

    @NotNull
    public static DbSrcFileStatus getInstance() {
        DbSrcFileStatus dbSrcFileStatus = (DbSrcFileStatus)ServiceManager.getService(DbSrcFileStatus.class);
        if (dbSrcFileStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus", "getInstance"));
        }
        return dbSrcFileStatus;
    }

    @NotNull
    public StatusEntry getStatus(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus", "getStatus"));
        }
        if (!DbSrcStorage.isWritable()) {
            StatusEntry statusEntry = StatusEntry.NON_MODIFIED_ENTRY;
            if (statusEntry == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus", "getStatus"));
            }
            return statusEntry;
        }
        String url = file.getUrl();
        assert (file.getFileSystem() instanceof DbSrcFileSystem) : "DbSrcFile expected, got: " + url;
        if (file.isDirectory()) {
            StatusEntry statusEntry = StatusEntry.NON_MODIFIED_ENTRY;
            if (statusEntry == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus", "getStatus"));
            }
            return statusEntry;
        }
        StatusEntry entry = this.myCache.get(url);
        if (entry == null || !entry.isValid(file)) {
            entry = StatusEntry.of(file);
            this.myCache.put(url, entry);
        }
        StatusEntry statusEntry = entry;
        if (statusEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus", "getStatus"));
        }
        return statusEntry;
    }

    private static long getStamp(@Nullable VirtualFile baseFile) {
        return baseFile == null ? Long.MIN_VALUE : baseFile.getModificationStamp();
    }

    public static String getContent(@Nullable VirtualFile vFile) {
        if (vFile == null) {
            return null;
        }
        Document doc = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(vFile));
        if (doc == null) {
            return null;
        }
        return doc.getText();
    }

    public static class StatusEntry {
        private static final StatusEntry NON_MODIFIED_ENTRY = new StatusEntry(StatusEntryKey.access$200(), null);
        private final StatusEntryKey myKey;
        private final FileStatus myStatus;

        private StatusEntry(@NotNull StatusEntryKey key, @Nullable FileStatus status) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry", "<init>"));
            }
            this.myKey = key;
            this.myStatus = status;
        }

        @NotNull
        public static StatusEntry of(@NotNull VirtualFile file) {
            VirtualFile baseFile;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry", "of"));
            }
            StatusEntryKey key = StatusEntryKey.of(file);
            VirtualFile virtualFile = baseFile = key.myBaseFileUrl == null ? null : VirtualFileManager.getInstance().findFileByUrl(key.myBaseFileUrl);
            if (baseFile == null) {
                if (key.myBaseStamp == key.myStagingStamp) {
                    StatusEntry statusEntry = NON_MODIFIED_ENTRY;
                    if (statusEntry == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry", "of"));
                    }
                    return statusEntry;
                }
                StatusEntry statusEntry = new StatusEntry(key, FileStatus.UNKNOWN);
                if (statusEntry == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry", "of"));
                }
                return statusEntry;
            }
            StatusEntry statusEntry = new StatusEntry(key, Comparing.equal((String)DbSrcFileStatus.getContent(file), (String)DbSrcFileStatus.getContent(baseFile)) ? null : FileStatus.MODIFIED);
            if (statusEntry == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry", "of"));
            }
            return statusEntry;
        }

        @Nullable
        public FileStatus getStatus() {
            return this.myStatus;
        }

        public boolean isValid(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry", "isValid"));
            }
            return StatusEntryKey.of(file).equals(this.myKey);
        }

        @Nullable
        public String getBaseFileUrl() {
            return this.myKey.myBaseFileUrl;
        }
    }

    private static class StatusEntryKey {
        private static StatusEntryKey NON_MODIFIED_KEY = new StatusEntryKey(0L, 0L, null);
        private final long myStagingStamp;
        private final long myBaseStamp;
        private final String myBaseFileUrl;

        public StatusEntryKey(long stagingStamp, long baseStamp, @Nullable String baseFileUrl) {
            this.myStagingStamp = stagingStamp;
            this.myBaseStamp = baseStamp;
            this.myBaseFileUrl = baseFileUrl;
        }

        @NotNull
        public static StatusEntryKey of(@NotNull VirtualFile file) {
            VirtualFile baseFile;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntryKey", "of"));
            }
            DbSrcFileSystem dbFs = (DbSrcFileSystem)((Object)ObjectUtils.tryCast((Object)file.getFileSystem(), DbSrcFileSystem.class));
            if (dbFs == null) {
                StatusEntryKey statusEntryKey = NON_MODIFIED_KEY;
                if (statusEntryKey == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntryKey", "of"));
                }
                return statusEntryKey;
            }
            FileDocumentManager documentManager = FileDocumentManager.getInstance();
            boolean isDocumentModified = documentManager.isFileModified(file);
            boolean isModified = isDocumentModified || dbFs.getBaseFile(file, true) != null;
            VirtualFile virtualFile = baseFile = isModified ? dbFs.getBaseFile(file, false) : null;
            if (baseFile == null && !isModified) {
                StatusEntryKey statusEntryKey = NON_MODIFIED_KEY;
                if (statusEntryKey == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntryKey", "of"));
                }
                return statusEntryKey;
            }
            Document document = isDocumentModified ? StatusEntryKey.getDocument(file, documentManager) : null;
            long stamp = document != null ? document.getModificationStamp() : DbSrcFileStatus.getStamp(file);
            StatusEntryKey statusEntryKey = new StatusEntryKey(stamp, DbSrcFileStatus.getStamp(baseFile), baseFile == null ? null : baseFile.getUrl());
            if (statusEntryKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntryKey", "of"));
            }
            return statusEntryKey;
        }

        @Nullable
        private static Document getDocument(@NotNull VirtualFile file, FileDocumentManager documentManager) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntryKey", "getDocument"));
            }
            Application app = ApplicationManager.getApplication();
            Ref res = Ref.create();
            app.invokeAndWait(() -> {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntryKey", "lambda$getDocument$1"));
                }
                app.runReadAction(() -> {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntryKey", "lambda$null$0"));
                    }
                    res.set((Object)documentManager.getDocument(file));
                });
            });
            return (Document)res.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatusEntryKey key = (StatusEntryKey)o;
            if (this.myStagingStamp != key.myStagingStamp) {
                return false;
            }
            if (this.myBaseStamp != key.myBaseStamp) {
                return false;
            }
            return !(this.myBaseFileUrl != null ? !this.myBaseFileUrl.equals(key.myBaseFileUrl) : key.myBaseFileUrl != null);
        }

        public int hashCode() {
            int result = (int)(this.myStagingStamp ^ this.myStagingStamp >>> 32);
            result = 31 * result + (int)(this.myBaseStamp ^ this.myBaseStamp >>> 32);
            result = 31 * result + (this.myBaseFileUrl != null ? this.myBaseFileUrl.hashCode() : 0);
            return result;
        }

        static /* synthetic */ StatusEntryKey access$200() {
            return NON_MODIFIED_KEY;
        }
    }
}

