/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlPropertiesPanel
extends JPanel
implements Disposable {
    public static final int ROW_LENGTH = 6;
    private final Map<String, TypesRegistry.ParamEditor> myFields;
    private final List<TypesRegistry.ParamEditor> myAllFields;
    private final DataInterchange myDataInterchange;
    private final boolean myAuthSupported;
    private final boolean myEmpty;

    public UrlPropertiesPanel(@NotNull StatelessParametersHolder parametersHolder, @NotNull DataInterchange dataInterchange, final @NotNull Runnable focusCallback) {
        boolean bl;
        if (parametersHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parametersHolder", "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel", "<init>"));
        }
        if (dataInterchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataInterchange", "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel", "<init>"));
        }
        if (focusCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusCallback", "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel", "<init>"));
        }
        this.myFields = ContainerUtil.newHashMap();
        this.myAllFields = ContainerUtil.newArrayList();
        this.myDataInterchange = dataInterchange;
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                focusCallback.run();
            }

            @Override
            public void focusLost(FocusEvent e) {
                focusCallback.run();
            }
        };
        ArrayList parameters = ContainerUtil.newArrayList(parametersHolder.getParameters());
        List<List<TypesRegistry.ParamEditor>> layoutData = UrlPropertiesPanel.getLayout(parametersHolder, UrlPropertiesPanel.pruneParameters(parameters), this.myDataInterchange, this.myFields);
        for (List<TypesRegistry.ParamEditor> list : layoutData) {
            for (TypesRegistry.ParamEditor paramEditor : list) {
                Disposer.register((Disposable)this, (Disposable)paramEditor);
                paramEditor.addFocusListener(focusListener);
            }
        }
        this.myDataInterchange.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TypesRegistry.ParamEditor editor = (TypesRegistry.ParamEditor)UrlPropertiesPanel.this.myFields.get(evt.getPropertyName());
                String value = StringUtil.notNullize((String)((String)ObjectUtils.tryCast((Object)evt.getNewValue(), String.class)));
                if (editor != null && !editor.getText().equals(value)) {
                    editor.setText(value);
                }
            }
        }, this);
        for (Map.Entry entry : this.myFields.entrySet()) {
            ((TypesRegistry.ParamEditor)entry.getValue()).setChangeListener(() -> this.myDataInterchange.putProperty((String)entry.getKey(), ((TypesRegistry.ParamEditor)entry.getValue()).getText()));
        }
        this.myAuthSupported = parametersHolder.getParameters().contains("password") || parametersHolder.getParameters().contains("host") || parametersHolder.getParameters().isEmpty();
        this.myEmpty = layoutData.isEmpty();
        if (!layoutData.isEmpty()) {
            this.setLayout((LayoutManager)new GridLayoutManager(layoutData.size(), 6));
        }
        int row = 0;
        boolean bl2 = true;
        for (List list : layoutData) {
            if (list.size() <= 1) continue;
            bl = false;
            break;
        }
        for (List list : layoutData) {
            int column = 0;
            for (TypesRegistry.ParamEditor editor : list) {
                int span;
                this.myAllFields.add(editor);
                if (editor.getCaption() != null) {
                    JBLabel label = new JBLabel(editor.getCaption());
                    if (column != 0) {
                        label.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
                    }
                    this.add((Component)label, UrlPropertiesPanel.createLabelConstraints(row, column, label.getPreferredSize().getWidth()));
                }
                if (column == 0) {
                    ++column;
                    span = bl ? 5 : 3;
                } else if (editor.getCaption() != null) {
                    ++column;
                    span = 1;
                } else {
                    span = 2;
                }
                this.add((Component)editor.getComponent(), UrlPropertiesPanel.createSimpleConstraints(row, column, span));
                column += span;
            }
            ++row;
        }
    }

    public void dispose() {
    }

    public static GridConstraints createLabelConstraints(int row, int col, double width) {
        return UrlPropertiesPanel.createConstraints(row, col, 1, 0, 3, (int)width, false);
    }

    public static GridConstraints createSimpleConstraints(int row, int col, int colSpan) {
        return UrlPropertiesPanel.createConstraints(row, col, colSpan, 0, 1, -1, true);
    }

    public static GridConstraints createSimpleConstraints(int row, int col, int rowSpan, int colSpan) {
        return UrlPropertiesPanel.createConstraints(row, col, rowSpan, colSpan, 0, 1, -1, true);
    }

    public static GridConstraints createRowConstraints(int row) {
        return UrlPropertiesPanel.createConstraints(row, 0, 6, 1, 1, -1, false);
    }

    public static GridConstraints createAlignedConstraints(int row, int col, int colSpan, int anchor) {
        return UrlPropertiesPanel.createConstraints(row, col, colSpan, anchor, 0, -1, false);
    }

    public static GridConstraints notUseParent(GridConstraints c) {
        c.setUseParentLayout(false);
        return c;
    }

    public static void drawLayout(GridLayoutManager l, Component comp, Graphics g, Color c) {
        g.setColor(c);
        for (int x : l.getVerticalGridLines()) {
            g.drawLine(x, 0, x, comp.getHeight());
        }
        for (int y : l.getHorizontalGridLines()) {
            g.drawLine(0, y, comp.getWidth(), y);
        }
    }

    public static GridConstraints createConstraints(int row, int col, int colSpan, int anchor, int fill, int prefWidth, boolean rubber) {
        return UrlPropertiesPanel.createConstraints(row, col, 1, colSpan, anchor, fill, prefWidth, rubber);
    }

    public static GridConstraints createConstraints(int row, int col, int rowSpan, int colSpan, int anchor, int fill, int prefWidth, boolean rubber) {
        Dimension nonPref = new Dimension(-1, -1);
        Dimension pref = new Dimension(prefWidth == -1 ? 100 : prefWidth, -1);
        int hpolicy = rubber ? 7 : 0;
        return new GridConstraints(row, col, rowSpan, colSpan, anchor, fill, hpolicy, 0, nonPref, pref, nonPref, 0, true);
    }

    private static boolean isPair(@Nullable String param1, @Nullable String param2, Map<String, TypesRegistry.ParamEditor> fields) {
        if (param1 == null || param2 == null) {
            return false;
        }
        if (param1.equals("host") && param2.equals("port")) {
            return true;
        }
        return fields.get(param2).getFieldSize() == TypesRegistry.ParamEditor.FieldSize.SMALL;
    }

    private static void moveTo(@NotNull String param, @NotNull List<String> params2, boolean begin) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel", "moveTo"));
        }
        if (params2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel", "moveTo"));
        }
        if (params2.contains(param)) {
            params2.remove(param);
            params2.add(begin ? 0 : params2.size(), param);
        }
    }

    public boolean isEmpty() {
        return this.myEmpty;
    }

    @NotNull
    private static List<String> pruneParameters(@NotNull List<String> params2) {
        if (params2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel", "pruneParameters"));
        }
        params2.remove("user");
        params2.remove("password");
        UrlPropertiesPanel.moveTo("database", params2, true);
        UrlPropertiesPanel.moveTo("instance", params2, true);
        UrlPropertiesPanel.moveTo("port", params2, true);
        UrlPropertiesPanel.moveTo("host", params2, true);
        UrlPropertiesPanel.moveTo("file", params2, true);
        UrlPropertiesPanel.moveTo("path", params2, true);
        UrlPropertiesPanel.moveTo("driver", params2, false);
        List<String> list = params2;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel", "pruneParameters"));
        }
        return list;
    }

    public boolean isAuthSupported() {
        return this.myAuthSupported;
    }

    private static List<List<TypesRegistry.ParamEditor>> getLayout(@NotNull StatelessParametersHolder parser, @NotNull List<String> params2, @NotNull DataInterchange interchange, @NotNull Map<String, TypesRegistry.ParamEditor> fields) {
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel", "getLayout"));
        }
        if (params2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel", "getLayout"));
        }
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel", "getLayout"));
        }
        if (fields == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fields", "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel", "getLayout"));
        }
        ArrayList editors = ContainerUtil.newArrayList();
        HashMap paramNames = ContainerUtil.newHashMap();
        for (String param : params2) {
            TypesRegistry.TypeDescriptor descriptor = TypesRegistry.INSTANCE.get((String)ObjectUtils.assertNotNull((Object)parser.getParameterType(param)));
            if (descriptor == null) continue;
            editors.addAll(descriptor.createSatellites(interchange));
            TypesRegistry.ParamEditor field = descriptor.createField(param, parser.getParameterConfig(param), interchange);
            editors.add(field);
            fields.put(param, field);
            paramNames.put(field, param);
        }
        ArrayList res = ContainerUtil.newArrayList();
        for (TypesRegistry.ParamEditor editor : editors) {
            boolean append;
            List curRow = (List)ContainerUtil.getLastItem((List)res);
            TypesRegistry.ParamEditor prev = (TypesRegistry.ParamEditor)ContainerUtil.getLastItem((List)curRow);
            assert (prev == null || curRow != null);
            boolean bl = append = prev != null && curRow.size() < 2 && UrlPropertiesPanel.isPair((String)paramNames.get(prev), (String)paramNames.get(editor), fields);
            if (curRow == null || !append) {
                curRow = ContainerUtil.newArrayListWithCapacity((int)1);
                res.add(curRow);
            }
            curRow.add(editor);
        }
        return res;
    }

    public void setFieldsActive(boolean isActive) {
        for (TypesRegistry.ParamEditor panel : this.myAllFields) {
            panel.setActive(isActive);
        }
    }

    @Nullable
    public String getActiveParameter() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return null;
        }
        for (Map.Entry<String, TypesRegistry.ParamEditor> entry : this.myFields.entrySet()) {
            if (!entry.getValue().getComponent().isAncestorOf(owner)) continue;
            return entry.getKey();
        }
        return null;
    }

    @NotNull
    public DataInterchange getDataInterchange() {
        DataInterchange dataInterchange = this.myDataInterchange;
        if (dataInterchange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel", "getDataInterchange"));
        }
        return dataInterchange;
    }
}

