/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDriverValidator
extends DatabaseConfigValidator<DatabaseDriverImpl> {
    @Override
    public Class<DatabaseDriverImpl> getTargetClass() {
        return DatabaseDriverImpl.class;
    }

    @Override
    public void collectProblems(@NotNull DatabaseDriverImpl driver, @NotNull Consumer<DataSourceProblem> problems, @Nullable DatabaseConfigEditor editor) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "collectProblems"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "collectProblems"));
        }
        if (!driver.getTemplatesErrors().isEmpty()) {
            StringBuilder msg = new StringBuilder();
            for (Pair<UrlTemplate, String> pair : driver.getTemplatesErrors()) {
                msg.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;");
                msg.append(StringUtil.escapeXml((String)((UrlTemplate)pair.getFirst()).getName())).append(" &mdash; ").append(StringUtil.escapeXml((String)((String)pair.getSecond())));
            }
            String shortDesc = msg.toString();
            String longDesc = "Driver <a href=\"$ACTION0\">" + StringUtil.escapeXml((String)driver.getFullName()) + "</a> has invalid templates:" + shortDesc;
            problems.consume((Object)new DataSourceProblem(driver, null, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText("Invalid template", shortDesc, longDesc, new DataSourceProblem.Navigate(driver)), null));
        }
    }

    public static boolean isDriverFilesValid(@NotNull String artifact, @Nullable String version, @Nullable Collection<SimpleClasspathElement> actual) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "isDriverFilesValid"));
        }
        DatabaseArtifactManager manager = DatabaseArtifactManager.getInstance();
        if (version == null) {
            return actual != null && !JBIterable.from(actual).flatten(e -> e.getClassesRootUrls()).isEmpty();
        }
        return manager.isValid(artifact, version);
    }

    public static boolean isDriverFilesUpToDate(@NotNull String artifact, @Nullable String version, boolean isRolling, @Nullable Collection<SimpleClasspathElement> actual) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "isDriverFilesUpToDate"));
        }
        DatabaseArtifactManager manager = DatabaseArtifactManager.getInstance();
        String actualVersion = manager.getActualVersion(artifact);
        if (!isRolling && version != null || actualVersion == null || Comparing.equal((String)version, (String)actualVersion) && (manager.isVersionValid(artifact, version) || actual != null && !actual.isEmpty())) {
            return true;
        }
        if (version != null) {
            return false;
        }
        JBIterable urls = JBIterable.from(actual).flatten(SimpleClasspathElement::getClassesRootUrls);
        if (!urls.filter(url -> !FileUtil.exists((String)VfsUtilCore.urlToPath((String)url))).isEmpty()) {
            return false;
        }
        return DatabaseArtifactManager.getInstance().isFreshFiles(artifact, actualVersion, urls.transform(VfsUtil::extractFileName).toSet());
    }

    public static void findDriverFilesProblems(@Nullable DatabaseDriver driver, @NotNull Consumer<DataSourceProblem> problems, @Nullable DatabaseConfigEditor editor) {
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "findDriverFilesProblems"));
        }
        if (driver == null) {
            return;
        }
        DatabaseDriver.ArtifactRef artifact = driver.getArtifact();
        if (artifact != null && artifact.isUsed()) {
            boolean needDownload;
            String driverName = StringUtil.escapeXml((String)driver.getFullName());
            boolean bl = needDownload = !DatabaseDriverValidator.isDriverFilesValid(artifact.getName(), artifact.getVersion(), driver.getClasspathElements());
            if (needDownload) {
                NamedProgressive downloader = DatabaseDriverValidator.createDownloader(driver, editor, (String)ObjectUtils.chooseNotNull((Object)artifact.getVersion(), (Object)"latest"));
                problems.consume((Object)new DataSourceProblem(driver, null, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText("", "<a href=\"$ACTION0\">Download</a> missing driver files", "Download missing <a href=\"$ACTION1\">" + driverName + "</a> driver files", downloader, new DataSourceProblem.Navigate(driver)), downloader));
            } else if (!DatabaseDriverValidator.isDriverFilesUpToDate(artifact.getName(), artifact.getVersion(), artifact.isRolling(), driver.getClasspathElements())) {
                NamedProgressive downloader = DatabaseDriverValidator.createDownloader(driver, editor, "latest");
                problems.consume((Object)new DataSourceProblem(driver, null, DataSourceProblem.Level.HINT, new DataSourceProblem.HyperText("", "<a href=\"$ACTION0\">Update</a> driver files", "Update <a href=\"$ACTION1\">" + driverName + "</a> driver files", downloader, new DataSourceProblem.Navigate(driver)), downloader));
            }
        }
    }

    @NotNull
    private static NamedProgressive createDownloader(@NotNull DatabaseDriver driver, @Nullable DatabaseConfigEditor editor, @NotNull String version) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "createDownloader"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "createDownloader"));
        }
        NamedProgressive namedProgressive = NamedProgressive.named(IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{"Driver Files"}), indicator -> {
            String realVersion;
            if (driver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "lambda$createDownloader$4"));
            }
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "lambda$createDownloader$4"));
            }
            DatabaseDriver.ArtifactRef artifact = driver.getArtifact();
            if (artifact == null) {
                return;
            }
            DatabaseArtifactManager manager = DatabaseArtifactManager.getInstance();
            String prevVer = artifact.getVersion();
            String string = realVersion = version.equals("latest") ? manager.getActualVersion(artifact.getName()) : version;
            if (realVersion == null) {
                return;
            }
            indicator.setText(IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{StringUtil.capitalize((String)artifact.getName()) + " files"}));
            ApplicationManager.getApplication().invokeLater(() -> {
                if (driver == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "lambda$null$2"));
                }
                DatabaseDriverConfigurable configurable = editor == null ? null : editor.getConfigurable(driver, true, DatabaseDriverConfigurable.class);
                DatabaseDriverImpl tempDriver = configurable == null ? (DatabaseDriverImpl)driver : configurable.getTempDriver();
                tempDriver.setArtifact(artifact.getName(), realVersion, artifact.isRolling());
                if (configurable != null) {
                    configurable.resetFromTemp();
                }
            });
            while (!indicator.isCanceled()) {
                try {
                    manager.downloadArtifact(artifact.getName(), version, (Consumer<DownloadableFileSetDescription>)((Consumer)o -> {
                        if (driver == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "lambda$null$3"));
                        }
                        if (!Comparing.equal((String)prevVer, (String)o.getVersionString()) && editor != null) {
                            editor.onDriverDownloaded(driver);
                        }
                    }));
                }
                catch (IOException e) {
                    String msg = IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{StringUtil.capitalize((String)artifact.getName()) + " files"});
                    boolean retry = IOExceptionDialog.showErrorDialog((String)msg, (String)e.getMessage());
                    if (retry) continue;
                }
                break;
            }
        });
        if (namedProgressive == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "createDownloader"));
        }
        return namedProgressive;
    }
}

