/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalDataSourceValidator
extends DatabaseConfigValidator<LocalDataSource> {
    @Override
    public Class<? extends LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    @Override
    public void collectProblems(@NotNull LocalDataSource target, @NotNull Consumer<DataSourceProblem> problems, @Nullable DatabaseConfigEditor editor) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/dataSource/validation/LocalDataSourceValidator", "collectProblems"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/database/dataSource/validation/LocalDataSourceValidator", "collectProblems"));
        }
        DatabaseDriver driver = target.getDatabaseDriver();
        if (driver == null) {
            return;
        }
        DatabaseDriverValidator.findDriverFilesProblems(editor == null ? driver : (DatabaseDriver)editor.getTempTargetOrTarget(driver).get(), problems, editor);
    }
}

