/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ColumnMappingStrategy {
    SIMPLE{

        @Override
        @NotNull
        Condition<DasColumn> condition(@NotNull State state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dbimport/ColumnMappingStrategy$1", "condition"));
            }
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ColumnMappingStrategy$1", "condition"));
            }
            return condition;
        }
    }
    ,
    SKIP_AUTOGENERATED{

        @Override
        @NotNull
        Condition<DasColumn> condition(@NotNull State state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dbimport/ColumnMappingStrategy$2", "condition"));
            }
            Condition condition = column -> {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dbimport/ColumnMappingStrategy$2", "lambda$condition$0"));
                }
                return !DasUtil.isAutoVal((DasColumn)column) || state.additionalColumns-- > 0;
            };
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ColumnMappingStrategy$2", "condition"));
            }
            return condition;
        }
    }
    ,
    SKIP_AUTOGENERATED_AND_DEFAULT{

        @Override
        @NotNull
        Condition<DasColumn> condition(@NotNull State state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dbimport/ColumnMappingStrategy$3", "condition"));
            }
            Condition condition = column -> {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dbimport/ColumnMappingStrategy$3", "lambda$condition$0"));
                }
                return this.shouldNotSkip((DasColumn)column) || (DasUtil.isAutoVal((DasColumn)column) || this.acceptDefault(state, (DasColumn)column)) && state.additionalColumns-- > 0;
            };
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ColumnMappingStrategy$3", "condition"));
            }
            return condition;
        }

        private boolean shouldNotSkip(@NotNull DasColumn column) {
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ColumnMappingStrategy$3", "shouldNotSkip"));
            }
            return !DasUtil.isAutoVal((DasColumn)column) && column.getDefault() == null;
        }

        private boolean acceptDefault(@NotNull State state, @NotNull DasColumn column) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dbimport/ColumnMappingStrategy$3", "acceptDefault"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ColumnMappingStrategy$3", "acceptDefault"));
            }
            return column.getDefault() != null && this.autogenerated(state.columns) < state.additionalColumns;
        }

        @Override
        <T extends ColumnDescriptor> boolean isSuitable(@NotNull List<DasColumn> columns, @NotNull List<T> descriptors) {
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ColumnMappingStrategy$3", "isSuitable"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ColumnMappingStrategy$3", "isSuitable"));
            }
            return true;
        }

        private int autogenerated(@NotNull Collection<DasColumn> columns) {
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ColumnMappingStrategy$3", "autogenerated"));
            }
            return ContainerUtil.filter(columns, DasUtil::isAutoVal).size();
        }
    }
    ,
    BY_NAME{

        @Override
        @NotNull
        Condition<DasColumn> condition(@NotNull State state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dbimport/ColumnMappingStrategy$4", "condition"));
            }
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ColumnMappingStrategy$4", "condition"));
            }
            return condition;
        }

        @Override
        <T extends ColumnDescriptor> boolean isSuitable(@NotNull List<DasColumn> columns, @NotNull List<T> descriptors) {
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ColumnMappingStrategy$4", "isSuitable"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ColumnMappingStrategy$4", "isSuitable"));
            }
            return false;
        }

        @Override
        @NotNull
        <T extends ColumnDescriptor> Map<DasColumn, T> createMapping(@NotNull List<DasColumn> columns, @NotNull List<T> descriptors) {
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ColumnMappingStrategy$4", "createMapping"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ColumnMappingStrategy$4", "createMapping"));
            }
            HashMap result = ContainerUtil.newHashMap();
            for (DasColumn column : columns) {
                T descriptor = this.getSameNameDescriptor(column, descriptors);
                if (descriptor == null || result.containsValue(descriptor)) continue;
                result.put(column, descriptor);
            }
            HashMap hashMap = result;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ColumnMappingStrategy$4", "createMapping"));
            }
            return hashMap;
        }

        @Nullable
        private <T extends ColumnDescriptor> T getSameNameDescriptor(@NotNull DasColumn column, @NotNull List<T> descriptors) {
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ColumnMappingStrategy$4", "getSameNameDescriptor"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ColumnMappingStrategy$4", "getSameNameDescriptor"));
            }
            return (T)((ColumnDescriptor)ContainerUtil.find(descriptors, descriptor -> {
                if (column == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ColumnMappingStrategy$4", "lambda$getSameNameDescriptor$0"));
                }
                return StringUtil.equalsIgnoreCase((CharSequence)descriptor.getName(), (CharSequence)column.getName());
            }));
        }
    };


    @NotNull
    public static <T extends ColumnDescriptor> Map<DasColumn, T> map(@NotNull List<DasColumn> columns, @NotNull List<T> descriptors) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ColumnMappingStrategy", "map"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ColumnMappingStrategy", "map"));
        }
        Map mapping = BY_NAME.createMapping(columns, descriptors);
        List unmappedColumns = ContainerUtil.filter(columns, column -> !mapping.containsKey(column));
        List unmappedDescriptors = ContainerUtil.filter(descriptors, descriptor -> !mapping.containsValue(descriptor));
        mapping.putAll(ColumnMappingStrategy.strategyOf(unmappedColumns, unmappedDescriptors).createMapping(unmappedColumns, unmappedDescriptors));
        Map map = mapping;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ColumnMappingStrategy", "map"));
        }
        return map;
    }

    @Nullable
    public static <T extends ColumnDescriptor> T map(@NotNull DasColumn column, @NotNull List<T> descriptors) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ColumnMappingStrategy", "map"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ColumnMappingStrategy", "map"));
        }
        return (T)((ColumnDescriptor)ColumnMappingStrategy.map(ContainerUtil.list((Object[])new DasColumn[]{column}), descriptors).get(column));
    }

    @NotNull
    <T extends ColumnDescriptor> Map<DasColumn, T> createMapping(@NotNull List<DasColumn> columns, @NotNull List<T> descriptors) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ColumnMappingStrategy", "createMapping"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ColumnMappingStrategy", "createMapping"));
        }
        Map<DasColumn, T> map = ColumnMappingStrategy.createMap(this.filter(columns, descriptors), descriptors);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ColumnMappingStrategy", "createMapping"));
        }
        return map;
    }

    <T extends ColumnDescriptor> boolean isSuitable(@NotNull List<DasColumn> columns, @NotNull List<T> descriptors) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ColumnMappingStrategy", "isSuitable"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ColumnMappingStrategy", "isSuitable"));
        }
        return ContainerUtil.filter(columns, this.condition(State.pure(columns))).size() <= descriptors.size();
    }

    @NotNull
    private <T extends ColumnDescriptor> List<DasColumn> filter(@NotNull List<DasColumn> columns, @NotNull List<T> descriptors) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ColumnMappingStrategy", "filter"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ColumnMappingStrategy", "filter"));
        }
        List filter = ContainerUtil.filter(columns, this.condition(State.pure(columns)));
        int additionalColumns = descriptors.size() - filter.size();
        ArrayList result = ContainerUtil.newArrayList();
        for (DasColumn column : columns) {
            State state = new State(ContainerUtil.subtract(columns, (Collection)result), additionalColumns);
            if (this.condition(state).value((Object)column)) {
                result.add(column);
            }
            additionalColumns = state.additionalColumns;
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ColumnMappingStrategy", "filter"));
        }
        return arrayList;
    }

    @NotNull
    abstract Condition<DasColumn> condition(@NotNull State var1);

    @NotNull
    private static <T extends ColumnDescriptor> Map<DasColumn, T> createMap(@NotNull List<DasColumn> columns, @NotNull List<T> descriptors) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ColumnMappingStrategy", "createMap"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ColumnMappingStrategy", "createMap"));
        }
        HashMap result = ContainerUtil.newHashMap();
        for (int i2 = 0; i2 < Math.min(columns.size(), descriptors.size()); ++i2) {
            result.put(columns.get(i2), descriptors.get(i2));
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ColumnMappingStrategy", "createMap"));
        }
        return hashMap;
    }

    @NotNull
    private static <T extends ColumnDescriptor> ColumnMappingStrategy strategyOf(@NotNull List<DasColumn> columns, @NotNull List<T> descriptors) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ColumnMappingStrategy", "strategyOf"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ColumnMappingStrategy", "strategyOf"));
        }
        for (ColumnMappingStrategy strategy : ColumnMappingStrategy.values()) {
            if (!strategy.isSuitable(columns, descriptors)) continue;
            ColumnMappingStrategy columnMappingStrategy = strategy;
            if (columnMappingStrategy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ColumnMappingStrategy", "strategyOf"));
            }
            return columnMappingStrategy;
        }
        ColumnMappingStrategy columnMappingStrategy = SIMPLE;
        if (columnMappingStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ColumnMappingStrategy", "strategyOf"));
        }
        return columnMappingStrategy;
    }

    private static class State {
        final Collection<DasColumn> columns;
        int additionalColumns;

        State(@NotNull Collection<DasColumn> columns, int additionalColumns) {
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ColumnMappingStrategy$State", "<init>"));
            }
            this.additionalColumns = additionalColumns;
            this.columns = columns;
        }

        @NotNull
        private static State pure(@NotNull List<DasColumn> columns) {
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ColumnMappingStrategy$State", "pure"));
            }
            State state = new State(columns, -1);
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ColumnMappingStrategy$State", "pure"));
            }
            return state;
        }
    }
}

