/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.dbimport.DatabaseTableInput;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.ui.AbstractImportPanel;
import com.intellij.database.dbimport.ui.database.DatabaseImportPanel;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseInputType
implements ImportAction.InputType {
    private static final String TITLE_MASK = "Import \"%s\" Table";
    private final LocalDataSource myProducerLocalDataSource;
    private final DasModel myModel;
    private final DasTable myProducerTable;
    private final Project myProject;

    public DatabaseInputType(@NotNull LocalDataSource producerLocalDataSource, @NotNull DasModel model, @NotNull DasTable producerTable, @NotNull Project project) {
        if (producerLocalDataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producerLocalDataSource", "com/intellij/database/dbimport/DatabaseInputType", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/DatabaseInputType", "<init>"));
        }
        if (producerTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producerTable", "com/intellij/database/dbimport/DatabaseInputType", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/DatabaseInputType", "<init>"));
        }
        this.myProducerLocalDataSource = producerLocalDataSource;
        this.myModel = model;
        this.myProducerTable = producerTable;
        this.myProject = project;
    }

    @Override
    @NotNull
    public ReaderTask.Input createInput(@NotNull ImportInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/DatabaseInputType", "createInput"));
        }
        DatabaseTableInput databaseTableInput = new DatabaseTableInput(this.myProducerLocalDataSource, this.myProducerTable, this.myProject);
        if (databaseTableInput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseInputType", "createInput"));
        }
        return databaseTableInput;
    }

    @Override
    @NotNull
    public AbstractImportPanel getImportPanel(@NotNull ImportAction.ImportEditorContext context, @NotNull Runnable onLoadCallback) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/DatabaseInputType", "getImportPanel"));
        }
        if (onLoadCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onLoadCallback", "com/intellij/database/dbimport/DatabaseInputType", "getImportPanel"));
        }
        DatabaseImportPanel databaseImportPanel = new DatabaseImportPanel(context, this.myProducerTable, onLoadCallback);
        if (databaseImportPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseInputType", "getImportPanel"));
        }
        return databaseImportPanel;
    }

    @Override
    @NotNull
    public String getDialogTitle() {
        String string = String.format(TITLE_MASK, this.myProducerTable.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseInputType", "getDialogTitle"));
        }
        return string;
    }

    @Override
    @Nullable
    public DatabaseSystem getProducerSystem() {
        return this.myProducerLocalDataSource;
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect(this.myProducerLocalDataSource);
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseInputType", "getDialect"));
        }
        return databaseDialectEx;
    }

    @Override
    @NotNull
    public DeTable createNewTable(@NotNull ImportAction.ImportEditorContext context, @NotNull DataGrid grid) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/DatabaseInputType", "createNewTable"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/DatabaseInputType", "createNewTable"));
        }
        DatabaseEditorContext editorContext = DbRefactoringHelper.createContext((DasObject)this.myProducerTable, null);
        if (editorContext == null) {
            DeTable deTable = ImportUtil.createTable(context, grid, (Function<ImportUtil.ColumnTypePredictorInfo, String>)((Function)this::getPreferredConsumerColumnType));
            if (deTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseInputType", "createNewTable"));
            }
            return deTable;
        }
        DeModel model = AbstractDbRefactoringDialog.createModel(editorContext);
        DeTable table = ImportUtil.createDeTableFromDasObject(this.myModel, (DasObject)this.myProducerTable, model);
        table.parent = context.getNamespace();
        table.name = context.getTableName();
        table.editedObject = null;
        table.getChildren().forEach(child -> {
            child.editedObject = null;
        });
        List<DataConsumer.Column> columns = ImportUtil.getColumns(grid);
        List<DataConsumer.Row> rows = grid.getDataModel(DataAccessType.DATABASE_DATA).getRows();
        for (int i2 = 0; i2 < Math.min(columns.size(), table.columns.size()); ++i2) {
            ImportUtil.ColumnTypePredictorInfo info = new ImportUtil.ColumnTypePredictorInfo(context, columns.get(i2), rows);
            table.columns.get((int)i2).dataType = this.getPreferredConsumerColumnType(info);
        }
        ImportUtil.removeUnsupportedObjects(table, context.getCaps());
        ImportUtil.removeUntransferableObjects(table);
        DeTable deTable = table;
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseInputType", "createNewTable"));
        }
        return deTable;
    }

    @NotNull
    private String getPreferredConsumerColumnType(@NotNull ImportUtil.ColumnTypePredictorInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/DatabaseInputType", "getPreferredConsumerColumnType"));
        }
        DatabaseDialectEx producerDialect = DbImplUtil.getDatabaseDialect(this.myProducerLocalDataSource);
        String producerVersion = this.myProducerLocalDataSource.getDatabaseProductVersion();
        Domain producerDomain = DomainRegistry.getDomain(producerDialect, producerVersion, info.column, false);
        DatabaseDialectEx dialect = info.context.getDialect();
        DbDataSource source = info.context.getDataSource();
        String version = source == null ? null : source.getDatabaseProductVersion();
        Domain consumerDomain = producerDomain == null ? null : DomainRegistry.getMostRecentDomain(producerDomain, dialect, version);
        String string = consumerDomain == null ? ImportUtil.getPreferredTypeBasedOnContent(info) : consumerDomain.name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseInputType", "getPreferredConsumerColumnType"));
        }
        return string;
    }
}

