/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dbimport.ImportDatabaseModifier;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.atomic.DoubleAdder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableInput
implements ReaderTask.Input {
    private static final String INDICATOR_MASK = "Importing data from \"%s\" table";
    private static final String CONNECTION_ERROR = "Can't open database connection";
    private static final String COUNT_THREAD = "Select count thread";
    private static final int ROWS = 2000;
    private final LocalDataSource myDataSource;
    private final DasTable myProducer;
    private final Project myProject;
    private final DatabaseDialectEx myDialect;
    private long myLinesCount;
    private boolean myDataRead;
    private Connection myConnection;
    private ResultSet myResultSet;
    private List<DataConsumer.Column> myDescriptors;
    private Statement myStatement;

    public DatabaseTableInput(@NotNull LocalDataSource source, @NotNull DasTable producer, @NotNull Project project) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dbimport/DatabaseTableInput", "<init>"));
        }
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/dbimport/DatabaseTableInput", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/DatabaseTableInput", "<init>"));
        }
        this.myDataSource = source;
        this.myProducer = producer;
        this.myProject = project;
        this.myDialect = DbImplUtil.getDatabaseDialect(source);
    }

    @Override
    @NotNull
    public ImportDatabaseModifier.IndicatorUpdater getIndicatorUpdater(@NotNull ProgressIndicator indicator, @NotNull DoubleAdder adder, @NotNull ImportInfo info) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/DatabaseTableInput", "getIndicatorUpdater"));
        }
        if (adder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adder", "com/intellij/database/dbimport/DatabaseTableInput", "getIndicatorUpdater"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/DatabaseTableInput", "getIndicatorUpdater"));
        }
        ImportDatabaseModifier.IndicatorUpdater indicatorUpdater = new ImportDatabaseModifier.IndicatorUpdater(indicator, adder, info, INDICATOR_MASK){

            @Override
            @NotNull
            public String calculateSpeed(long timeSpent) {
                String string = String.format("%s records per second", (int)(this.myCurrentSize / (double)timeSpent));
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseTableInput$1", "calculateSpeed"));
                }
                return string;
            }
        };
        if (indicatorUpdater == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseTableInput", "getIndicatorUpdater"));
        }
        return indicatorUpdater;
    }

    @Override
    @Nullable
    public ReaderTask.Result read() throws Exception {
        if (this.myDataRead) {
            return null;
        }
        this.init();
        RemoteResultSet remoteResultSet = (RemoteResultSet)RemoteUtil.castToRemote((Object)this.myResultSet, RemoteResultSet.class);
        List objects = (List)RemoteUtil.handleRemoteResult((Object)((RemoteResultSet)ObjectUtils.assertNotNull((Object)remoteResultSet)).getObjects(2000, this.myDialect.getClass().getSimpleName(), Integer.MAX_VALUE), List.class, (Object)this);
        this.myDataRead = objects.size() < 2000;
        DatabaseTableInput.convertValues(objects, this.myDescriptors);
        BatchRecords records = objects.isEmpty() ? null : new BatchRecords(objects, this.myLinesCount, (double)objects.size());
        this.myLinesCount += records == null ? 0L : (long)records.getLinesCount();
        return records == null ? null : new ReaderTask.ResultImpl(records);
    }

    public static void convertValues(@NotNull List<Object[]> rows, @NotNull List<DataConsumer.Column> columns) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/dbimport/DatabaseTableInput", "convertValues"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/DatabaseTableInput", "convertValues"));
        }
        for (Object[] row : rows) {
            for (int i2 = 0; i2 < row.length; ++i2) {
                row[i2] = ObjectFormatter.unwrap(ObjectFormatter.objectToObject(row[i2], columns.get(i2)));
            }
        }
    }

    @Override
    public void calculateSize(@NotNull Consumer<Double> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/dbimport/DatabaseTableInput", "calculateSize"));
        }
        new Thread((Runnable)new MySizeTask(callback), COUNT_THREAD).start();
    }

    @Nullable
    private synchronized Connection getConnection() throws Exception {
        return DatabaseConnectionManager.getInstance().getConnectionSync(this.myProject, this.myDataSource);
    }

    private void init() throws Exception {
        if (this.myConnection != null) {
            return;
        }
        this.createConnectionIfNeeded();
        this.myStatement = this.myConnection.createStatement();
        String query = DbImplUtil.createSelectAllQuery(this.myProducer, this.myDialect, (DatabaseSystem)this.myDataSource).getStatement();
        this.myResultSet = this.myStatement.executeQuery(query);
        this.myDescriptors = ContainerUtil.list((Object[])JdbcEngine.getColumnDescriptors(this.myResultSet, this.myDialect));
    }

    private void createConnectionIfNeeded() throws Exception {
        if (this.myConnection != null) {
            return;
        }
        this.myConnection = this.getConnection();
        if (this.myConnection == null) {
            throw new IllegalStateException(CONNECTION_ERROR);
        }
    }

    @Override
    public void close() throws Exception {
        JdbcUtil.closeResultSetSafe((ResultSet)this.myResultSet);
        JdbcUtil.closeStatementSafe((Statement)this.myStatement);
        JdbcUtil.closeConnectionSafe((Connection)this.myConnection);
    }

    private class MySizeTask
    implements Runnable {
        private final Consumer<Double> myCallback;

        private MySizeTask(Consumer<Double> callback) {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/dbimport/DatabaseTableInput$MySizeTask", "<init>"));
            }
            this.myCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection connection = null;
            try {
                connection = DatabaseTableInput.this.getConnection();
                if (connection == null) {
                    return;
                }
                String query = DbImplUtil.buildCountQuery(DatabaseTableInput.this.myDialect, DatabaseTableInput.this.myProducer).getStatement();
                int count = DbImplUtil.getCount(connection, query);
                this.myCallback.consume((Object)count);
            }
            catch (Exception exception) {
            }
            finally {
                JdbcUtil.closeConnectionSafe((Connection)connection);
            }
        }
    }
}

