/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dbimport.ImportErrorHandler;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ImporterGenerator;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatement;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatementImpl;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.atomic.DoubleAdder;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class ImportDatabaseModifier
extends AbstractDatabaseModifier {
    private static final Logger LOG = Logger.getInstance(ImportDatabaseModifier.class);
    private static final double UNSET = -1.0;
    private static final String ERRORS_LINK = "<a href=\"errors\">errors</a>";
    private static final String INDICATOR_TITLE = "Importing Data...";
    private final AbstractDatabaseModifier.QueryExecutor myExecutor;

    public ImportDatabaseModifier(@NotNull DbDataSource dataSource, @NotNull ImportInfo info, @NotNull Project project, @NotNull DatabaseDialectEx dialectEx, @NotNull ReaderTask.Input reader, @Nullable DasNamespace defaultNs) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dbimport/ImportDatabaseModifier", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportDatabaseModifier", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseModifier", "<init>"));
        }
        if (dialectEx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialectEx", "com/intellij/database/dbimport/ImportDatabaseModifier", "<init>"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dbimport/ImportDatabaseModifier", "<init>"));
        }
        super(dataSource, defaultNs, INDICATOR_TITLE);
        this.myExecutor = new ImportExecutor(info, project, dialectEx, (DatabaseSystem)dataSource, reader);
    }

    @Override
    @NotNull
    protected AbstractDatabaseModifier.QueryExecutor getExecutor() {
        AbstractDatabaseModifier.QueryExecutor queryExecutor = this.myExecutor;
        if (queryExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier", "getExecutor"));
        }
        return queryExecutor;
    }

    private static class MyNotificationListener
    implements NotificationListener {
        private final String myPathToErrorRecords;
        private final Project myProject;

        MyNotificationListener(@NotNull Project project, @NotNull String pathToErrorRecords) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseModifier$MyNotificationListener", "<init>"));
            }
            if (pathToErrorRecords == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToErrorRecords", "com/intellij/database/dbimport/ImportDatabaseModifier$MyNotificationListener", "<init>"));
            }
            this.myPathToErrorRecords = pathToErrorRecords;
            this.myProject = project;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/database/dbimport/ImportDatabaseModifier$MyNotificationListener", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dbimport/ImportDatabaseModifier$MyNotificationListener", "hyperlinkUpdate"));
            }
            File file = new File(this.myPathToErrorRecords);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            if (virtualFile == null) {
                DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("Can't access file", NotificationType.WARNING).notify(this.myProject);
                return;
            }
            if (virtualFile.getLength() > (long)PersistentFSConstants.getMaxIntellisenseFileSize()) {
                ShowFilePathAction.openFile((File)file);
                return;
            }
            FileEditorManager.getInstance((Project)this.myProject).openEditor(new OpenFileDescriptor(this.myProject, virtualFile), true);
        }
    }

    public static abstract class IndicatorUpdater {
        protected final ProgressIndicator myIndicator;
        protected final ImportInfo myInfo;
        protected final DoubleAdder mySize;
        protected double myCurrentSize;
        protected long myLines;
        protected long myStartTime;
        private final String myIndicatorMask;

        public IndicatorUpdater(@NotNull ProgressIndicator indicator, @NotNull DoubleAdder size, @NotNull ImportInfo info, @NotNull String indicatorMask) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater", "<init>"));
            }
            if (size == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater", "<init>"));
            }
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater", "<init>"));
            }
            if (indicatorMask == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicatorMask", "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater", "<init>"));
            }
            this.myIndicator = indicator;
            this.mySize = size;
            this.myInfo = info;
            this.myIndicatorMask = indicatorMask;
        }

        public void start() {
            this.myIndicator.setFraction(0.0);
            this.myIndicator.setText(this.getIndicatorTitle());
            DbDataSource source = this.myInfo.getContext().getDataSource();
            String name = ((DbDataSource)ObjectUtils.assertNotNull((Object)source)).getName();
            this.myIndicator.setText2(name + " " + this.myInfo.getTableName());
            this.myStartTime = System.currentTimeMillis();
        }

        public void update(@NotNull BatchRecords records, long lines) {
            if (records == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater", "update"));
            }
            this.myIndicator.checkCanceled();
            double value = this.mySize.doubleValue();
            if (Double.compare(value, -1.0) == 0) {
                return;
            }
            this.myCurrentSize += records.getBatchSize();
            this.myLines += lines;
            this.myIndicator.setFraction(this.myCurrentSize / value);
            this.myIndicator.setText(this.getIndicatorTitle());
        }

        @NotNull
        private String getIndicatorTitle() {
            String string = String.format(this.myIndicatorMask, this.myInfo.getProducerName()) + this.getStatistics();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater", "getIndicatorTitle"));
            }
            return string;
        }

        @NotNull
        private String getStatistics() {
            long timeSpent = (System.currentTimeMillis() - this.myStartTime) / 1000L;
            if (this.myLines == 0L || timeSpent == 0L) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater", "getStatistics"));
                }
                return "";
            }
            String string = String.format(" (%s %s processed, %s)", this.myLines, ImportUtil.pluralizeRecord(this.myLines), this.calculateSpeed(timeSpent));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater", "getStatistics"));
            }
            return string;
        }

        @NotNull
        public abstract String calculateSpeed(long var1);
    }

    public static class ImportExecutor
    implements AbstractDatabaseModifier.QueryExecutor {
        private static final String COMPLETED = "Import completed\n";
        private static final String STOPPED = "Import stopped\n";
        private static final String NOT_INSERTED_MASK = "Errors count: %s %s\n";
        private static final String TIME_SPENT_MASK = "Time spent: %s\n";
        private static final String INSERTED_MASK = "Inserted: %s %s\n";
        private final ImporterGenerator myGenerator;
        private final ImportInfo myInfo;
        private final DatabaseSystem mySystem;
        private final ReaderTask.Input myInput;
        private final ImportManager myManager;
        private final ImportErrorHandler myHandler;

        public ImportExecutor(@NotNull ImportInfo info, @NotNull Project project, @NotNull DatabaseDialectEx dialectEx, @NotNull DatabaseSystem system, @NotNull ReaderTask.Input input) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "<init>"));
            }
            if (dialectEx == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialectEx", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "<init>"));
            }
            if (system == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "<init>"));
            }
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "<init>"));
            }
            this.myInput = input;
            this.mySystem = system;
            this.myManager = ImportManager.of(dialectEx, this.mySystem.getDatabaseProductVersion());
            this.myHandler = new ImportErrorHandler(project, info);
            this.myGenerator = new ImporterGenerator(project, info, this.myHandler, this.myManager, input);
            this.myInfo = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(@NotNull ProgressIndicator indicator, @NotNull Connection connection, @NotNull Project project, @NotNull ErrorHandler errorHandler) throws Exception {
            Long timeSpent;
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "execute"));
            }
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "execute"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "execute"));
            }
            if (errorHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "execute"));
            }
            indicator.setIndeterminate(false);
            List<String> queriesAfter = null;
            DoubleAdder accumulator = new DoubleAdder();
            this.myInput.calculateSize((Consumer<Double>)((Consumer)accumulator::add));
            Long timeBefore = null;
            boolean completed = false;
            RemoteBatchPreparedStatement remoteStatement = null;
            IndicatorUpdater updater = this.myInput.getIndicatorUpdater(indicator, accumulator, this.myInfo);
            try {
                ReaderTask.Importer importer;
                DatabaseMetaData metaData = connection.getMetaData();
                boolean transactions = metaData.supportsTransactions() && this.myManager.shouldUseTransactions();
                boolean batches = metaData.supportsBatchUpdates() && this.myManager.shouldUseBatches();
                boolean savepoints = metaData.supportsSavepoints() && this.myManager.shouldUseSavepoints();
                RemoteConnection remoteConnection = (RemoteConnection)ObjectUtils.assertNotNull((Object)RemoteUtil.castToRemote((Object)connection, RemoteConnection.class));
                int linesPerStatement = this.myManager.getLinesPerStatement();
                this.myGenerator.start(connection);
                List<String> queriesBefore = this.myManager.getFastModeOnQueries(this.myInfo);
                queriesAfter = this.myManager.getFastModeOffQueries(this.myInfo);
                if (this.myInfo.shouldLockTable()) {
                    ImportExecutor.execute(connection, queriesBefore);
                }
                if (transactions) {
                    connection.setAutoCommit(false);
                }
                String statement = this.myManager.getInsertStatement(this.myInfo, linesPerStatement);
                String oneLine = this.myManager.getInsertStatement(this.myInfo, 1);
                String lockQuery = this.myInfo.shouldLockTable() ? this.myManager.getLockQuery(this.myInfo) : null;
                Rdbms rdbms = DbImplUtil.getRdbms(this.myInfo.getContext().getDialect());
                List<ColumnInfo> columnInfos = this.myInfo.cache().getColumnInfos();
                remoteStatement = remoteConnection.prepareBatchStatement(new RemoteBatchPreparedStatementImpl.Configuration(rdbms, statement, oneLine, lockQuery, columnInfos, transactions, savepoints, batches, linesPerStatement));
                updater.start();
                timeBefore = System.currentTimeMillis();
                while ((importer = this.myGenerator.generate()) != null) {
                    importer.insert(this.myManager, this.myInfo, remoteStatement, updater, this.myHandler);
                }
                completed = true;
                timeSpent = timeBefore == null ? null : Long.valueOf(System.currentTimeMillis() - timeBefore);
            }
            catch (SQLException e) {
                Long timeSpent2;
                boolean bl;
                try {
                    LOG.warn((Throwable)e);
                    if (e.getCause() != null) {
                        LOG.warn(e.getCause());
                    }
                    errorHandler.addError(e.getMessage(), (Throwable)e);
                    bl = false;
                    timeSpent2 = timeBefore == null ? null : Long.valueOf(System.currentTimeMillis() - timeBefore);
                }
                catch (Throwable throwable) {
                    Long timeSpent3 = timeBefore == null ? null : Long.valueOf(System.currentTimeMillis() - timeBefore);
                    this.myGenerator.stop();
                    if (this.myInfo.shouldLockTable() && queriesAfter != null) {
                        ImportExecutor.executeInFinally(connection, queriesAfter);
                    }
                    JdbcNativeUtil.closeRemoteStatementSafe(remoteStatement);
                    long imported = remoteStatement == null ? 0L : remoteStatement.getInsertedLinesCount();
                    long errors = this.myHandler.getErrorsCount();
                    this.createNotification(project, timeSpent3, updater, imported, errors, completed).notify(project);
                    throw throwable;
                }
                this.myGenerator.stop();
                if (this.myInfo.shouldLockTable() && queriesAfter != null) {
                    ImportExecutor.executeInFinally(connection, queriesAfter);
                }
                JdbcNativeUtil.closeRemoteStatementSafe(remoteStatement);
                long imported = remoteStatement == null ? 0L : remoteStatement.getInsertedLinesCount();
                long errors = this.myHandler.getErrorsCount();
                this.createNotification(project, timeSpent2, updater, imported, errors, completed).notify(project);
                return bl;
            }
            this.myGenerator.stop();
            if (this.myInfo.shouldLockTable() && queriesAfter != null) {
                ImportExecutor.executeInFinally(connection, queriesAfter);
            }
            JdbcNativeUtil.closeRemoteStatementSafe((RemoteStatement)remoteStatement);
            long imported = remoteStatement == null ? 0L : remoteStatement.getInsertedLinesCount();
            long errors = this.myHandler.getErrorsCount();
            this.createNotification(project, timeSpent, updater, imported, errors, completed).notify(project);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        private Notification createNotification(@NotNull Project project, @Nullable Long timeSpent, @NotNull IndicatorUpdater updater, long importedCount, long errorsCount, boolean bl) {
            void completed;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            if (updater == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            String title = ImportUtil.getNotificationTitle(this.myInfo);
            String path = this.myInfo.getErrorTaskInfo().getErrorRecordsPath();
            String content = ImportExecutor.getContent(timeSpent, path, updater, importedCount, errorsCount, (boolean)completed);
            boolean hasErrors = errorsCount > 0L;
            NotificationType type = hasErrors ? NotificationType.ERROR : NotificationType.INFORMATION;
            MyNotificationListener listener = hasErrors && path != null ? new MyNotificationListener(project, path) : null;
            Notification notification = ImportExecutor.createNotification(title, content, type, listener);
            if (notification == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            return notification;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        private static String getContent(@Nullable Long timeSpent, @Nullable String path, @NotNull IndicatorUpdater updater, long importedCount, long errorsCount, boolean bl) {
            void completed;
            if (updater == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getContent"));
            }
            String string = ImportExecutor.getResultTitle((boolean)completed) + ImportExecutor.getInsertedCount(importedCount) + ImportExecutor.getErrorsCount(path, errorsCount) + ImportExecutor.getTimeSpent(timeSpent) + ImportExecutor.getSpeed(timeSpent, updater);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getContent"));
            }
            return string;
        }

        @NotNull
        private static String getResultTitle(boolean completed) {
            String string = completed ? COMPLETED : STOPPED;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getResultTitle"));
            }
            return string;
        }

        @NotNull
        private static String getInsertedCount(long importedCount) {
            String string = String.format(INSERTED_MASK, String.valueOf(importedCount), ImportUtil.pluralizeRecord(importedCount));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getInsertedCount"));
            }
            return string;
        }

        @NotNull
        private static String getErrorsCount(@Nullable String path, long errorsCount) {
            String string = errorsCount > 0L ? String.format(NOT_INSERTED_MASK, errorsCount, ImportExecutor.getLink(path)) : "";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getErrorsCount"));
            }
            return string;
        }

        @NotNull
        private static String getTimeSpent(@Nullable Long timeSpent) {
            String string = timeSpent == null ? "" : String.format(TIME_SPENT_MASK, StringUtil.formatDuration((long)timeSpent));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getTimeSpent"));
            }
            return string;
        }

        @NotNull
        private static String getLink(@Nullable String path) {
            String string = path != null ? "(<a href=\"errors\">errors</a>)" : "";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getLink"));
            }
            return string;
        }

        @NotNull
        private static String getSpeed(@Nullable Long timeSpent, @NotNull IndicatorUpdater updater) {
            if (updater == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getSpeed"));
            }
            if (timeSpent == null || timeSpent / 1000L == 0L) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getSpeed"));
                }
                return "";
            }
            String string = String.format("Speed: %s\n", updater.calculateSpeed(timeSpent / 1000L));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getSpeed"));
            }
            return string;
        }

        @NotNull
        private static Notification createNotification(@NotNull String title, @NotNull String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            Notification notification = DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(title, content, type, listener);
            if (notification == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            return notification;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void execute(@NotNull Connection connection, @NotNull List<String> queries) throws Exception {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "execute"));
            }
            if (queries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queries", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "execute"));
            }
            Statement statement = connection.createStatement();
            try {
                for (String query : queries) {
                    statement.execute(query);
                }
            }
            finally {
                JdbcUtil.closeStatementSafe((Statement)statement);
            }
        }

        private static void executeInFinally(@NotNull Connection connection, @NotNull List<String> queries) {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "executeInFinally"));
            }
            if (queries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queries", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "executeInFinally"));
            }
            try {
                ImportExecutor.execute(connection, queries);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

