/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ui.AbstractImportPanel;
import com.intellij.database.dbimport.ui.ImportColumnEditor;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.ResultProcessorProvider;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportDialog
extends DialogWrapper
implements ResultProcessorProvider {
    private static final String EMPTY_DATA = "No data for import";
    private static final String EMPTY_NAME = "Name of the table is empty";
    private static final String TABLE_EXISTS = "Table with this name already exists";
    private static final String MAPPING_ERROR = "Columns are not mapped";
    private static final String EMPTY_TABLE = "Table is empty";
    private static final Dimension SIZE = JBUI.size((int)800, (int)600);
    private final AbstractImportPanel myPanel;
    private final ImportAction.ImportEditorContext myContext;

    public ImportDialog(@NotNull ImportAction.ImportEditorContext context) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportDialog", "<init>"));
        }
        super(context.getProject());
        this.myContext = context;
        this.setTitle(context.getInputType().getDialogTitle());
        this.myPanel = this.myContext.getInputType().getImportPanel(context, () -> {
            this.myOKAction.setEnabled(true);
            this.initValidation();
        });
        this.myPanel.getContentPanel().setPreferredSize(SIZE);
        this.init();
    }

    @NotNull
    public ImportInfo getImportInfo() throws IOException {
        ImportInfo importInfo = this.myPanel.getInfo();
        if (importInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "getImportInfo"));
        }
        return importInfo;
    }

    @Override
    public void settingsChanged() {
    }

    @Override
    @NotNull
    public JBIterable<Pair<PsiElement, String>> collectRenames() {
        JBIterable<Pair<PsiElement, String>> jBIterable = this.myContext.getImportType().isTableCreated() ? DbRenamePsiElementProcessor.collectRenameElements(this.getContext().getModel()) : JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "collectRenames"));
        }
        return jBIterable;
    }

    @Override
    public Project getProject() {
        return this.myContext.getProject();
    }

    @Override
    public boolean isPreviewUsages() {
        return true;
    }

    @Override
    public void success() {
        this.close(0);
    }

    @Override
    public void error(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/database/dbimport/ImportDialog", "error"));
        }
        this.myPanel.reportError(t);
        this.myOKAction.setEnabled(true);
    }

    @Override
    @NotNull
    public String statement() {
        String string = this.myPanel.getDdlPreview().getPreviewText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "statement"));
        }
        return string;
    }

    @Override
    @NotNull
    public ImportAction.ImportEditorContext getContext() {
        ImportAction.ImportEditorContext importEditorContext = this.myContext;
        if (importEditorContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "getContext"));
        }
        return importEditorContext;
    }

    @Override
    @NotNull
    public DeModel getModel() {
        DeModel deModel = this.getContext().getModel();
        if (deModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "getModel"));
        }
        return deModel;
    }

    @Override
    @NotNull
    public DatabaseEditorBaseEx getEditor() {
        DatabaseEditorBaseEx databaseEditorBaseEx = (DatabaseEditorBaseEx)ObjectUtils.assertNotNull(this.myPanel.getEditor());
        if (databaseEditorBaseEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "getEditor"));
        }
        return databaseEditorBaseEx;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction.setEnabled(false);
    }

    protected void doOKAction() {
        if (!this.getOKAction().isEnabled()) {
            return;
        }
        this.getOKAction().setEnabled(false);
        try {
            MyResultProcessor processor = new MyResultProcessor(this, this.myContext.getImportType().getCodeGenerationSettings(), null);
            if (!processor.process()) {
                this.error(new RuntimeException("Failed to process"));
            }
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        boolean empty;
        ImportDatabaseTableEditor<?> editor = this.myPanel.getEditor();
        DataGrid grid = this.myPanel.getPreviewGrid();
        if (grid == null || editor == null) {
            return null;
        }
        boolean bl = empty = grid.getVisibleColumns().size() == 0 || this.myContext.getImportType().isTableCreated() && grid.getVisibleRowsCount() == 0;
        if (empty) {
            return new ValidationInfo(EMPTY_DATA, grid.getComponent());
        }
        JComponent editorComponent = editor.getPreferredFocusedComponent();
        if (editor.getTableModel().getName().isEmpty()) {
            return new ValidationInfo(EMPTY_NAME, editorComponent);
        }
        if (this.myContext.isTableExists(editor.getTable().name)) {
            return new ValidationInfo(TABLE_EXISTS, editorComponent);
        }
        JComponent columnEditorComponent = editor.getColumnsEditor().getComponent();
        if (editor.getTableModel().getColumnsCount() == 0) {
            return new ValidationInfo(EMPTY_TABLE, columnEditorComponent);
        }
        return this.checkMapping() ? null : new ValidationInfo(MAPPING_ERROR, columnEditorComponent);
    }

    protected int getErrorTextAlignment() {
        return 4;
    }

    protected boolean shouldAddErrorNearButtons() {
        return !ImportDialog.isMoveHelpButtonLeft();
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return this.getClass().getName();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private boolean checkMapping() {
        ImportDatabaseTableEditor<?> editor = this.myPanel.getEditor();
        LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> mapping = editor == null ? null : ((ImportColumnEditor)editor.getColumnsEditor()).getMapping();
        return mapping == null || ContainerUtil.exists(mapping.values(), (Condition)Condition.NOT_NULL) || !this.myContext.getImportType().isTableCreated();
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.disposeAll();
    }

    private void disposeAll() {
        Disposer.dispose((Disposable)this.myContext.getDisposable());
    }

    private void runImport() {
        try {
            this.runImport(this.getImportInfo());
        }
        catch (IOException ex) {
            DataSourceUiUtil.showNotification(this.getProject(), "Can't access file", ex.getMessage(), true);
        }
        finally {
            this.disposeAll();
        }
    }

    private void runImport(@NotNull ImportInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportDialog", "runImport"));
        }
        try {
            if (!this.myContext.getImportType().isTableCreated() && info.getConsumersForInsert().isEmpty()) {
                return;
            }
            new DataImporter(this.getProject(), this.myContext.getElement(), this.myContext.getInputType(), info).importData();
        }
        catch (IOException ex) {
            DataSourceUiUtil.showNotification(this.getProject(), "Can't create input", ex.getMessage(), true);
        }
    }

    private class ImportRenameProcessor
    extends DbRenamePsiElementProcessor.MyRenameProcessor {
        private ImportInfo myInfo;

        public ImportRenameProcessor(@NotNull Project project, @NotNull DatabaseRefactoringHandler handler, JBIterable<Pair<PsiElement, String>> renames, boolean isSearchInComments, boolean isSearchTextOccurrences) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor", "<init>"));
            }
            if (renames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renames", "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor", "<init>"));
            }
            super(project, handler, renames, isSearchInComments, isSearchTextOccurrences);
        }

        @Override
        @NotNull
        protected CompletionStage<Void> runStatements(@NotNull UsageInfo[] usages) {
            if (usages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor", "runStatements"));
            }
            CompletionStage<Void> completionStage = super.runStatements(usages).whenCompleteAsync((r, e) -> {
                if (e == null) {
                    ImportDialog.this.runImport(this.myInfo);
                }
            }, AsyncUtil.EDT_EXECUTOR);
            if (completionStage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor", "runStatements"));
            }
            return completionStage;
        }

        protected void prepareSuccessful() {
            try {
                this.myInfo = ImportDialog.this.getImportInfo();
                ImportDialog.this.disposeAll();
                super.prepareSuccessful();
            }
            catch (Throwable t) {
                ImportDialog.this.error(t);
            }
        }
    }

    private class MyResultProcessor
    extends GenericEditingResultProcessor {
        public MyResultProcessor(@NotNull ResultProcessorProvider provider, @Nullable TableDialogSettings.Settings settings, RangeMarker insertPos) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "<init>"));
            }
            super(provider, settings, insertPos);
        }

        @Override
        @NotNull
        protected RenameProcessor createRenameProcessor(@NotNull JBIterable<Pair<PsiElement, String>> renames, @NotNull DatabaseRefactoringHandler handler) {
            if (renames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renames", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "createRenameProcessor"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "createRenameProcessor"));
            }
            ImportRenameProcessor importRenameProcessor = new ImportRenameProcessor((Project)ObjectUtils.assertNotNull((Object)ImportDialog.this.getContext().getProject()), handler, renames, true, true);
            if (importRenameProcessor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "createRenameProcessor"));
            }
            return importRenameProcessor;
        }

        @Override
        @NotNull
        protected CompletionStage<Void> processWithoutRenames(@NotNull DatabaseRefactoringHandler handler) {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "processWithoutRenames"));
            }
            if (StringUtil.isEmpty((String)ImportDialog.this.statement())) {
                ImportDialog.this.success();
                ImportDialog.this.runImport();
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                if (completableFuture == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "processWithoutRenames"));
                }
                return completableFuture;
            }
            CompletionStage<Void> completionStage = super.processWithoutRenames(handler).whenComplete((r, e) -> {
                if (e == null) {
                    ImportDialog.this.runImport();
                }
            });
            if (completionStage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "processWithoutRenames"));
            }
            return completionStage;
        }
    }
}

