/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dbimport.HandleErrorTask;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportErrorHandler {
    private static final String OPEN_ERROR = "Can't open file for error records";
    private final BlockingQueue<List<ErrorRecord>> myQueue;
    private final Thread myThread;
    private final HandleErrorTask myErrorTask;
    private int myErrorsCount;

    ImportErrorHandler(@NotNull Project project, @NotNull ImportInfo info) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportErrorHandler", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportErrorHandler", "<init>"));
        }
        this.myQueue = new LinkedTransferQueue<List<ErrorRecord>>();
        this.myErrorTask = this.createErrorTask(project, info);
        this.myThread = this.shouldWriteErrorRecords() ? new Thread((Runnable)this.myErrorTask, "Import error handler") : null;
    }

    void start() {
        if (this.shouldWriteErrorRecords()) {
            this.myThread.start();
        }
    }

    void stop() {
        if (this.shouldWriteErrorRecords()) {
            this.onStop();
        }
    }

    void handle(@NotNull List<ErrorRecord> record) {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/database/dbimport/ImportErrorHandler", "handle"));
        }
        this.myErrorsCount += record.size();
        if (!this.shouldWriteErrorRecords() || this.myErrorTask.isStopped()) {
            return;
        }
        this.myQueue.add(record);
    }

    int getErrorsCount() {
        return this.myErrorsCount;
    }

    boolean shouldWriteErrorRecords() {
        return this.myErrorTask != null;
    }

    private void onStop() {
        this.myQueue.add(HandleErrorTask.POISON);
    }

    @Nullable
    private HandleErrorTask createErrorTask(@NotNull Project project, @NotNull ImportInfo info) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportErrorHandler", "createErrorTask"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportErrorHandler", "createErrorTask"));
        }
        HandleErrorTask.ErrorTaskInfo errorTaskInfo = info.getErrorTaskInfo();
        try {
            Writer errorRecordsWriter = errorTaskInfo.getErrorRecordsWriter();
            return errorRecordsWriter == null ? null : new HandleErrorTask(project, this.myQueue, errorRecordsWriter, info);
        }
        catch (IOException e) {
            DbDataSource source = info.getContext().getDataSource();
            String title = source == null ? "" : source.getName();
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(title, OPEN_ERROR, NotificationType.ERROR, null).notify(project);
            return null;
        }
    }
}

