/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ImportType {
    NEW_TABLE(false){

        @Override
        boolean suitable(@NotNull DbElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dbimport/ImportType$1", "suitable"));
            }
            return element.getKind() == ObjectKind.SCHEMA || element.getKind() == ObjectKind.DATABASE || element instanceof DbDataSource;
        }

        @Override
        @NotNull
        public DeTable createTable(@NotNull ImportAction.ImportEditorContext context, @NotNull DataGrid grid) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportType$1", "createTable"));
            }
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/ImportType$1", "createTable"));
            }
            DeTable deTable = context.getInputType().createNewTable(context, grid);
            if (deTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportType$1", "createTable"));
            }
            return deTable;
        }

        @Override
        @NotNull
        public TableDialogSettings.Settings getCodeGenerationSettings() {
            TableDialogSettings.Settings settings = new TableDialogSettings.Settings(TableDialogSettings.Settings.FinalAction.EXEC_IN_DB, TableDialogSettings.Settings.CodeType.CREATE_NEW_CODE);
            if (settings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportType$1", "getCodeGenerationSettings"));
            }
            return settings;
        }

        @Override
        @NotNull
        public CsvFormatUISettings getCsvFormatSettings() {
            CsvFormatUISettings csvFormatUISettings = CsvFormatUISettings.DEFAULT;
            if (csvFormatUISettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportType$1", "getCsvFormatSettings"));
            }
            return csvFormatUISettings;
        }
    }
    ,
    EXISTING_TABLE(true){

        @Override
        boolean suitable(@NotNull DbElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dbimport/ImportType$2", "suitable"));
            }
            return element.getKind() == ObjectKind.TABLE;
        }

        @Override
        @NotNull
        public DeTable createTable(@NotNull ImportAction.ImportEditorContext context, @NotNull DataGrid grid) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportType$2", "createTable"));
            }
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/ImportType$2", "createTable"));
            }
            DeTable deTable = ImportUtil.createDeTableFromDasObject(((DbDataSource)ObjectUtils.assertNotNull((Object)context.getDataSource())).getModel(), (DasObject)context.getElement(), context.getModel());
            if (deTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportType$2", "createTable"));
            }
            return deTable;
        }

        @Override
        @NotNull
        public TableDialogSettings.Settings getCodeGenerationSettings() {
            TableDialogSettings.Settings settings = new TableDialogSettings.Settings(TableDialogSettings.Settings.FinalAction.EXEC_IN_DB, TableDialogSettings.Settings.CodeType.ALTER_CODE);
            if (settings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportType$2", "getCodeGenerationSettings"));
            }
            return settings;
        }

        @Override
        @NotNull
        public CsvFormatUISettings getCsvFormatSettings() {
            CsvFormatUISettings csvFormatUISettings = CsvFormatUISettings.IMPORT_IN_TABLE;
            if (csvFormatUISettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportType$2", "getCsvFormatSettings"));
            }
            return csvFormatUISettings;
        }
    };

    private final boolean myTableCreated;

    private ImportType(boolean created) {
        this.myTableCreated = created;
    }

    public boolean isTableCreated() {
        return this.myTableCreated;
    }

    @NotNull
    public abstract CsvFormatUISettings getCsvFormatSettings();

    @NotNull
    public abstract TableDialogSettings.Settings getCodeGenerationSettings();

    @NotNull
    public abstract DeTable createTable(@NotNull ImportAction.ImportEditorContext var1, @NotNull DataGrid var2);

    abstract boolean suitable(@NotNull DbElement var1);

    @Nullable
    public static ImportType of(@NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dbimport/ImportType", "of"));
        }
        for (ImportType type : ImportType.values()) {
            if (!type.suitable(element)) continue;
            return type;
        }
        return null;
    }
}

