/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportEditorState;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

public class ImportUtil {
    private static final String RECORD = "record";
    private static final String TITLE_TAIL_MASK = "%s import";

    private ImportUtil() {
    }

    @NotNull
    public static InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dbimport/ImportUtil", "getInputStream"));
        }
        VirtualFileSystem system = file.getFileSystem();
        InputStream inputStream = system instanceof JarFileSystem ? ImportUtil.getInputStreamForZip(file) : new FileInputStream(file.getPath());
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "getInputStream"));
        }
        return inputStream;
    }

    @NotNull
    public static AutoValueDescriptor createDescriptor(@NotNull ColumnDescriptor delegate, boolean autogenerated, boolean hasDefault) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/dbimport/ImportUtil", "createDescriptor"));
        }
        AutoValueDescriptor.DelegateDescriptor<ColumnDescriptor> delegateDescriptor = new AutoValueDescriptor.DelegateDescriptor<ColumnDescriptor>(delegate, autogenerated, hasDefault);
        if (delegateDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "createDescriptor"));
        }
        return delegateDescriptor;
    }

    @NotNull
    public static AutoValueDescriptor createDescriptor(@NotNull DeColumn column, boolean mapped) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ImportUtil", "createDescriptor"));
        }
        MyDeColumnDescriptor myDeColumnDescriptor = new MyDeColumnDescriptor(column, mapped);
        if (myDeColumnDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "createDescriptor"));
        }
        return myDeColumnDescriptor;
    }

    @NotNull
    public static ImportDatabaseTableEditor<?> createEditor(@NotNull DeTable table, @NotNull DataGrid grid, @NotNull ImportAction.ImportEditorContext context) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportUtil", "createEditor"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/ImportUtil", "createEditor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportUtil", "createEditor"));
        }
        SqlCodeStyleSettings settings = new SqlCodeStyleSettings(CodeStyleSettingsManager.getSettings((Project)context.getProject()));
        TableEditorModel tableEditorModel = new TableEditorModel(table, new EditorModelsCache(settings));
        ImportEditorState<DataConsumer.Column> state = new ImportEditorState<DataConsumer.Column>(context, ImportUtil.getColumns(grid));
        ImportDatabaseTableEditor editor = new ImportDatabaseTableEditor(state, context.getCaps(), tableEditorModel);
        Disposer.register((Disposable)context.getDisposable(), editor);
        ImportDatabaseTableEditor importDatabaseTableEditor = editor;
        if (importDatabaseTableEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "createEditor"));
        }
        return importDatabaseTableEditor;
    }

    @NotNull
    public static DeTable createDeTableFromDasObject(@NotNull DasModel dasModel, @NotNull DasObject element, @NotNull DeModel model) {
        if (dasModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dasModel", "com/intellij/database/dbimport/ImportUtil", "createDeTableFromDasObject"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dbimport/ImportUtil", "createDeTableFromDasObject"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/ImportUtil", "createDeTableFromDasObject"));
        }
        DeTable deTable = (DeTable)model.getExportHelper().exportDeep(dasModel, element, true);
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "createDeTableFromDasObject"));
        }
        return deTable;
    }

    public static void removeUnsupportedObjects(@NotNull DeTable table, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportUtil", "removeUnsupportedObjects"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/dbimport/ImportUtil", "removeUnsupportedObjects"));
        }
        if (!caps.getComment().isSupported()) {
            table.comment = null;
        }
        if (!caps.getColumnCaps(false).getComment().isSupported()) {
            for (DeColumn column : table.columns) {
                column.comment = null;
            }
        }
    }

    public static void removeUntransferableObjects(@NotNull DeTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportUtil", "removeUntransferableObjects"));
        }
        table.foreignKeys.clear();
        for (DeColumn column : table.columns) {
            column.defaultValue = null;
            column.flags.clear();
        }
        table.keys.clear();
        table.indices.clear();
    }

    @NotNull
    public static String getNotificationTitle(@NotNull ImportInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportUtil", "getNotificationTitle"));
        }
        DbDataSource source = info.getContext().getDataSource();
        String name = source == null ? null : source.getName();
        String tail = String.format(TITLE_TAIL_MASK, info.getTableName());
        String string = name == null ? tail : String.format("%s (%s)", name, tail);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "getNotificationTitle"));
        }
        return string;
    }

    @NotNull
    public static DeTable createTable(@NotNull ImportAction.ImportEditorContext context, @NotNull DataGrid grid, @NotNull Function<ColumnTypePredictorInfo, String> columnTypePredictor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportUtil", "createTable"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/ImportUtil", "createTable"));
        }
        if (columnTypePredictor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnTypePredictor", "com/intellij/database/dbimport/ImportUtil", "createTable"));
        }
        DeModel oldModel = context.getModel();
        DeModel newModel = new DeModel(oldModel.getModel(), oldModel.getExportHelper());
        DeTable table = new DeTable(context.getTableName(), context.getNamespace(), newModel);
        table.columns.addAll(ImportUtil.createDeColumns(context, grid, table, newModel, columnTypePredictor));
        newModel.addRoot(table);
        DeTable deTable = table;
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "createTable"));
        }
        return deTable;
    }

    @NotNull
    public static List<DataConsumer.Column> getColumns(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/ImportUtil", "getColumns"));
        }
        List columns = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns();
        List list = ContainerUtil.filter(columns, (Condition)Conditions.not(DbImplUtil::isComputedColumn));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "getColumns"));
        }
        return list;
    }

    @NotNull
    public static String getPreferredTypeBasedOnContent(@NotNull ColumnTypePredictorInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportUtil", "getPreferredTypeBasedOnContent"));
        }
        TypeMerger merger = null;
        ImportManager manager = info.context.getManager();
        for (DataConsumer.Row row : info.rows) {
            Object object = info.column.getValue(row);
            if (!(object instanceof String)) continue;
            String value = (String)object;
            TypeMerger nextMerger = manager.getType(value);
            merger = merger == null ? nextMerger : merger.merge(nextMerger);
        }
        String string = merger == null ? manager.getStringMerger().getName() : merger.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "getPreferredTypeBasedOnContent"));
        }
        return string;
    }

    @NotNull
    private static List<DeColumn> createDeColumns(@NotNull ImportAction.ImportEditorContext context, @NotNull DataGrid grid, @NotNull DeTable table, @NotNull DeModel model, @NotNull Function<ColumnTypePredictorInfo, String> columnTypePredictor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportUtil", "createDeColumns"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/ImportUtil", "createDeColumns"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportUtil", "createDeColumns"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/ImportUtil", "createDeColumns"));
        }
        if (columnTypePredictor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnTypePredictor", "com/intellij/database/dbimport/ImportUtil", "createDeColumns"));
        }
        GridModel dataModel = grid.getDataModel(DataAccessType.DATABASE_DATA);
        List<DataConsumer.Column> columns = ImportUtil.getColumns(grid);
        List<DataConsumer.Row> rows = dataModel.getRows();
        ArrayList result = ContainerUtil.newArrayList();
        for (DataConsumer.Column column : columns) {
            DeColumn deColumn = new DeColumn(column.name, table, model);
            deColumn.dataType = (String)columnTypePredictor.fun((Object)new ColumnTypePredictorInfo(context, column, rows));
            result.add(deColumn);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "createDeColumns"));
        }
        return arrayList;
    }

    @NotNull
    private static InputStream getInputStreamForZip(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dbimport/ImportUtil", "getInputStreamForZip"));
        }
        JarFileSystem instance = JarFileSystem.getInstance();
        VirtualFile jar = instance.getVirtualFileForJar(file);
        VirtualFile root2 = instance.getJarRootForLocalFile((VirtualFile)ObjectUtils.assertNotNull((Object)jar));
        ZipFile zipFile = new ZipFile(((VirtualFile)ObjectUtils.assertNotNull((Object)jar)).getPath());
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)((VirtualFile)ObjectUtils.assertNotNull((Object)root2)));
        ZipEntry entry = zipFile.getEntry(relativePath);
        MyDelegateInputStream myDelegateInputStream = new MyDelegateInputStream(zipFile.getInputStream(entry), zipFile);
        if (myDelegateInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "getInputStreamForZip"));
        }
        return myDelegateInputStream;
    }

    @NotNull
    public static String pluralizeRecord(long count) {
        String string = count == 1L ? RECORD : StringUtil.pluralize((String)RECORD);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "pluralizeRecord"));
        }
        return string;
    }

    private static class MyDeColumnDescriptor
    implements AutoValueDescriptor {
        private final DeColumn myColumn;
        private final boolean myMapped;

        private MyDeColumnDescriptor(@NotNull DeColumn column, boolean mapped) {
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ImportUtil$MyDeColumnDescriptor", "<init>"));
            }
            this.myColumn = column;
            this.myMapped = mapped;
        }

        @Override
        public int getScale() {
            return this.myColumn.getDataType().getScale();
        }

        @Override
        public int getSize() {
            return this.myColumn.getDataType().getPrecision();
        }

        @Override
        public int getType() {
            return JdbcUtil.guessJdbcTypeByName((String)this.myColumn.dataType);
        }

        @Override
        public String getName() {
            return this.myColumn.getName();
        }

        @Override
        public String getTypeName() {
            return this.myColumn.dataType;
        }

        @Override
        public String getJavaClassName() {
            return "";
        }

        @Override
        public boolean isAutogenerated() {
            return !this.myMapped && DasUtil.isAutoVal((DasColumn)this.myColumn);
        }

        @Override
        public boolean hasDefault() {
            return !this.myMapped && this.myColumn.getDefault() != null;
        }
    }

    private static class MyDelegateInputStream
    extends InputStream {
        private final InputStream myStream;
        private final Closeable myCloseable;

        private MyDelegateInputStream(@NotNull InputStream stream, @NotNull Closeable closeable) {
            if (stream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/database/dbimport/ImportUtil$MyDelegateInputStream", "<init>"));
            }
            if (closeable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closeable", "com/intellij/database/dbimport/ImportUtil$MyDelegateInputStream", "<init>"));
            }
            this.myStream = stream;
            this.myCloseable = closeable;
        }

        @Override
        public int read() throws IOException {
            return this.myStream.read();
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/database/dbimport/ImportUtil$MyDelegateInputStream", "read"));
            }
            return this.myStream.read(b, off, len);
        }

        @Override
        public int read(@NotNull byte[] b) throws IOException {
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/database/dbimport/ImportUtil$MyDelegateInputStream", "read"));
            }
            return this.myStream.read(b);
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
            this.myCloseable.close();
        }
    }

    public static class ColumnTypePredictorInfo {
        public final ImportAction.ImportEditorContext context;
        public final DataConsumer.Column column;
        public final List<DataConsumer.Row> rows;

        public ColumnTypePredictorInfo(@NotNull ImportAction.ImportEditorContext context, @NotNull DataConsumer.Column column, @NotNull List<DataConsumer.Row> rows) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportUtil$ColumnTypePredictorInfo", "<init>"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ImportUtil$ColumnTypePredictorInfo", "<init>"));
            }
            if (rows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/dbimport/ImportUtil$ColumnTypePredictorInfo", "<init>"));
            }
            this.context = context;
            this.column = column;
            this.rows = rows;
        }
    }
}

