/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.csv;

import com.intellij.database.dbimport.ImportUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

public class CsvImportPanelModel {
    private static final int MAX_BYTES = 20000;
    private final EventDispatcher<CharsetListener> myDispatcher;
    private final byte[] myBytes;
    private Charset myCharset;
    private final VirtualFile myFile;

    public CsvImportPanelModel(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dbimport/csv/CsvImportPanelModel", "<init>"));
        }
        this.myBytes = CsvImportPanelModel.loadBytes(file);
        this.myCharset = file.getCharset();
        this.myFile = file;
        this.myDispatcher = EventDispatcher.create(CharsetListener.class);
    }

    @NotNull
    public String getText() {
        String s = new String(this.myBytes, this.myCharset);
        String string = StringUtil.convertLineSeparators((String)s);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvImportPanelModel", "getText"));
        }
        return string;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvImportPanelModel", "getCharset"));
        }
        return charset;
    }

    public void addCharsetListener(@NotNull CharsetListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dbimport/csv/CsvImportPanelModel", "addCharsetListener"));
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/database/dbimport/csv/CsvImportPanelModel", "setCharset"));
        }
        this.myCharset = charset;
        ((CharsetListener)this.myDispatcher.getMulticaster()).charsetChanged();
    }

    public void acceptCharset() {
        this.myFile.setCharset(this.myCharset);
    }

    private static byte[] loadBytes(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dbimport/csv/CsvImportPanelModel", "loadBytes"));
        }
        byte[] bytes = new byte[20000];
        try (InputStream stream = ImportUtil.getInputStream(file);){
            int read = Math.max(stream.read(bytes), 0);
            byte[] byArray = Arrays.copyOf(bytes, read);
            return byArray;
        }
    }

    public static interface CharsetListener
    extends EventListener {
        public void charsetChanged();
    }
}

