/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.csv;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatForm;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.csv.ui.preview.TableCsvFormatPreview;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.csv.CsvImportPanel;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.Charset;
import java.util.EventListener;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvImportTableEditorWrapper {
    protected final ImportAction.ImportEditorContext myContext;
    private final CsvImportPanel.PreviewWithCharset myPreviewWithCharset;
    private final EditorModelBase.Listener myPreviewUpdater;
    private final Map<MyFormat, ImportDatabaseTableEditor<?>> myMap;
    private final EventDispatcher<TableEditorListener> myDispatcher;
    private final CsvFormatsSelectionUI myFormats;
    private final String myTableName;
    protected ImportDatabaseTableEditor<?> myEditor;

    public CsvImportTableEditorWrapper(@NotNull ImportAction.ImportEditorContext context, @NotNull CsvImportPanel.PreviewWithCharset previewAndCharset, @NotNull CsvFormatsSelectionUI formats, @NotNull EditorModelBase.Listener previewUpdater) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/csv/CsvImportTableEditorWrapper", "<init>"));
        }
        if (previewAndCharset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previewAndCharset", "com/intellij/database/dbimport/csv/CsvImportTableEditorWrapper", "<init>"));
        }
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/database/dbimport/csv/CsvImportTableEditorWrapper", "<init>"));
        }
        if (previewUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previewUpdater", "com/intellij/database/dbimport/csv/CsvImportTableEditorWrapper", "<init>"));
        }
        this.myContext = context;
        this.myPreviewWithCharset = previewAndCharset;
        this.myPreviewUpdater = previewUpdater;
        this.myTableName = this.myContext.getTableName();
        this.myFormats = formats;
        this.myDispatcher = EventDispatcher.create(TableEditorListener.class);
        this.myMap = ContainerUtil.newHashMap();
        formats.addFormatChangeListener(this::formatChanged, context.getDisposable());
        previewAndCharset.addListener(this::previewAndCharsetChanged);
        this.changeEditor(new MyFormat((CsvFormat)ObjectUtils.assertNotNull((Object)this.myFormats.getSelectedFormat()), previewAndCharset.getCharset()));
    }

    public void addEditorListener(@NotNull TableEditorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dbimport/csv/CsvImportTableEditorWrapper", "addEditorListener"));
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    private void previewAndCharsetChanged() {
        CsvFormat format = this.myFormats.getSelectedFormat();
        this.changeEditor(new MyFormat((CsvFormat)ObjectUtils.assertNotNull((Object)format), this.myPreviewWithCharset.getCharset()));
    }

    private void formatChanged(@NotNull CsvFormatForm source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dbimport/csv/CsvImportTableEditorWrapper", "formatChanged"));
        }
        this.changeEditor(new MyFormat(source.getFormat(), this.myPreviewWithCharset.getCharset()));
    }

    private void changeEditor(@NotNull MyFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/csv/CsvImportTableEditorWrapper", "changeEditor"));
        }
        this.myPreviewWithCharset.getPreview().setFormat(format.myCsvFormat);
        if (this.myMap.containsKey(format)) {
            DeTable table = this.myEditor.getTable();
            this.myEditor = this.myMap.get(format);
            this.myEditor.update(table.name, table.comment);
            this.fireEditorChanged();
        } else {
            this.myEditor = this.createEditor();
            this.myMap.put(format, this.myEditor);
        }
        this.fireEditorChanged();
    }

    @NotNull
    public ImportDatabaseTableEditor<?> getEditor() {
        ImportDatabaseTableEditor<?> importDatabaseTableEditor = this.myEditor;
        if (importDatabaseTableEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvImportTableEditorWrapper", "getEditor"));
        }
        return importDatabaseTableEditor;
    }

    @NotNull
    private ImportDatabaseTableEditor<?> createEditor() {
        String tableName = this.myEditor == null ? this.myTableName : this.myEditor.getTable().name;
        String tableComment = this.myEditor == null ? this.getInitialComment() : this.myEditor.getTable().comment;
        TableCsvFormatPreview preview = this.myPreviewWithCharset.getPreview();
        DeTable table = this.myContext.getImportType().createTable(this.myContext, preview.getGrid());
        table.name = tableName;
        table.comment = tableComment;
        ImportDatabaseTableEditor<?> editor = ImportUtil.createEditor(table, preview.getGrid(), this.myContext);
        editor.addListener(this.myPreviewUpdater, editor);
        ImportDatabaseTableEditor<?> importDatabaseTableEditor = editor;
        if (importDatabaseTableEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvImportTableEditorWrapper", "createEditor"));
        }
        return importDatabaseTableEditor;
    }

    @Nullable
    private String getInitialComment() {
        return this.myContext.getImportType().isTableCreated() ? this.myContext.getElement().getComment() : null;
    }

    private void fireEditorChanged() {
        ((TableEditorListener)this.myDispatcher.getMulticaster()).changed();
    }

    private static class MyFormat {
        private final CsvFormat myCsvFormat;
        private final Charset myCharset;

        private MyFormat(@NotNull CsvFormat format, @NotNull Charset charset) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/csv/CsvImportTableEditorWrapper$MyFormat", "<init>"));
            }
            if (charset == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/database/dbimport/csv/CsvImportTableEditorWrapper$MyFormat", "<init>"));
            }
            this.myCsvFormat = format;
            this.myCharset = charset;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyFormat)) {
                return false;
            }
            MyFormat format = (MyFormat)obj;
            return this.myCsvFormat.equals(format.myCsvFormat) && this.myCharset.equals(format.myCharset);
        }

        public int hashCode() {
            return this.myCsvFormat.hashCode() + this.myCharset.hashCode();
        }
    }

    public static interface TableEditorListener
    extends EventListener {
        public void changed();
    }
}

