/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.csv;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.csv.CsvImportPanelModel;
import com.intellij.database.dbimport.csv.CsvInput;
import com.intellij.database.dbimport.ui.AbstractImportPanel;
import com.intellij.database.dbimport.ui.csv.CsvImportPanel;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvInputType
implements ImportAction.InputType {
    private static final String TITLE_MASK = "Import: \"%s\" Format";
    private final VirtualFile myFile;
    private final int myCharCount;

    public CsvInputType(@NotNull VirtualFile file, int charCountToRead) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dbimport/csv/CsvInputType", "<init>"));
        }
        this.myFile = file;
        this.myCharCount = charCountToRead;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInputType", "getFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public ReaderTask.Input createInput(@NotNull ImportInfo info) throws IOException {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/csv/CsvInputType", "createInput"));
        }
        CsvInput csvInput = new CsvInput((ThrowableComputable<InputStream, IOException>)((ThrowableComputable)() -> ImportUtil.getInputStream(this.myFile)), this.myFile.getCharset(), info, this.myCharCount, this.myFile.getLength());
        if (csvInput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInputType", "createInput"));
        }
        return csvInput;
    }

    @Override
    @NotNull
    public AbstractImportPanel getImportPanel(@NotNull ImportAction.ImportEditorContext context, @NotNull Runnable onLoadCallback) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/csv/CsvInputType", "getImportPanel"));
        }
        if (onLoadCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onLoadCallback", "com/intellij/database/dbimport/csv/CsvInputType", "getImportPanel"));
        }
        CsvImportPanel csvImportPanel = new CsvImportPanel(context, new CsvImportPanelModel(this.myFile), onLoadCallback);
        if (csvImportPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInputType", "getImportPanel"));
        }
        return csvImportPanel;
    }

    @Override
    @Nullable
    public DatabaseSystem getProducerSystem() {
        return null;
    }

    @Override
    @NotNull
    public String getDialogTitle() {
        String string = String.format(TITLE_MASK, this.myFile.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInputType", "getDialogTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDialect() {
        GenericDialect genericDialect = GenericDialect.INSTANCE;
        if (genericDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInputType", "getDialect"));
        }
        return genericDialect;
    }

    @Override
    @NotNull
    public DeTable createNewTable(@NotNull ImportAction.ImportEditorContext context, @NotNull DataGrid grid) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/csv/CsvInputType", "createNewTable"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/csv/CsvInputType", "createNewTable"));
        }
        DeTable deTable = ImportUtil.createTable(context, grid, (Function<ImportUtil.ColumnTypePredictorInfo, String>)((Function)ImportUtil::getPreferredTypeBasedOnContent));
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInputType", "createNewTable"));
        }
        return deTable;
    }
}

