/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.HandleErrorTask;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ui.ImportColumnEditor;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.ImportSettingsPanel;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.ModelTraverserEx;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.ui.ErrorNotificationWrapperPanel;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractImportPanel
extends JBLoadingPanel {
    private static final int INSET = 3;
    protected final ImportAction.ImportEditorContext myContext;
    private final Runnable myLoadCallback;
    private final DdlPreview myDdlPreview;
    private final ErrorNotificationWrapperPanel myErrorPanel;
    private final TabbedPaneWrapper myPane;
    private final TableDialogSettings.Settings mySettings;
    protected ImportSettingsPanel myImportSettingsPanel;
    private DataGrid myGrid;
    private ImportDatabaseTableEditor<?> myEditor;

    public AbstractImportPanel(@NotNull ImportAction.ImportEditorContext context, @NotNull Runnable onLoadCallback) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ui/AbstractImportPanel", "<init>"));
        }
        if (onLoadCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onLoadCallback", "com/intellij/database/dbimport/ui/AbstractImportPanel", "<init>"));
        }
        super((LayoutManager)new BorderLayout(), context.getDisposable());
        this.myContext = context;
        this.myLoadCallback = onLoadCallback;
        this.myPane = new TabbedPaneWrapper(this.myContext.getDisposable());
        this.myDdlPreview = new DdlPreview(this.myContext, this.createProcessor(context));
        this.myErrorPanel = new ErrorNotificationWrapperPanel();
        this.mySettings = this.myContext.getImportType().getCodeGenerationSettings();
    }

    @NotNull
    public DdlPreview getDdlPreview() {
        DdlPreview ddlPreview = this.myDdlPreview;
        if (ddlPreview == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/AbstractImportPanel", "getDdlPreview"));
        }
        return ddlPreview;
    }

    public void reportError(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/database/dbimport/ui/AbstractImportPanel", "reportError"));
        }
        this.myErrorPanel.reportError(t);
    }

    @NotNull
    public ImportInfo getInfo() throws IOException {
        String errorFilePath = AbstractImportPanel.sanitize(this.myImportSettingsPanel.getErrorOutputFilePath());
        LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> mapping = ((ImportColumnEditor)this.myEditor.getColumnsEditor()).getMapping();
        ImportInfo importInfo = new ImportInfo(this.getCsvFormat(), (DeTable)this.myEditor.getTableModel().getObject(), ContainerUtil.newArrayList(mapping.keySet()), ImportUtil.getColumns(this.myGrid), mapping, this.myContext.getName(), this.myContext.getImportType(), this.myContext, this.myContext.getInputType(), new HandleErrorTask.ErrorTaskInfo((ThrowableComputable<Writer, IOException>)((ThrowableComputable)() -> errorFilePath == null ? null : new FileWriter(errorFilePath)), errorFilePath), this.myImportSettingsPanel.getModalityState(), this.myImportSettingsPanel.isInsertAsNull());
        if (importInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/AbstractImportPanel", "getInfo"));
        }
        return importInfo;
    }

    @Nullable
    public DataGrid getPreviewGrid() {
        return this.myGrid;
    }

    @Nullable
    public ImportDatabaseTableEditor<?> getEditor() {
        return this.myEditor;
    }

    protected void init() {
        this.myImportSettingsPanel = this.getSettingsPanel();
        this.startLoading();
        this.load();
    }

    protected abstract void loadGrid(@NotNull Consumer<DataGrid> var1);

    @NotNull
    protected abstract ImportDatabaseTableEditor<?> createEditor(@NotNull DataGrid var1);

    @Nullable
    protected abstract CsvFormat getCsvFormat();

    @NotNull
    protected abstract ImportSettingsPanel getSettingsPanel();

    protected void fillPanel() {
        this.getContentPanel().removeAll();
        int oldSelected = this.myPane.getSelectedIndex();
        this.myPane.removeAll();
        this.myPane.insertTab("Data preview", null, this.myGrid.getComponent(), null, 0);
        this.myPane.insertTab("DDL preview", null, this.myDdlPreview.getComponent(), null, 1);
        if (oldSelected != -1) {
            this.myPane.setSelectedIndex(oldSelected);
        }
        JComponent paneComponent = this.myPane.getComponent();
        JComponent tableEditor = this.myEditor.getComponent();
        paneComponent.setBorder(IdeBorderFactory.createEmptyBorder((int)3, (int)0, (int)0, (int)0));
        tableEditor.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)3, (int)0));
        OnePixelSplitter splitter = new OnePixelSplitter(true);
        splitter.setFirstComponent(tableEditor);
        splitter.setSecondComponent(paneComponent);
        JPanel right = new JPanel(new BorderLayout());
        right.add((Component)splitter, "Center");
        right.add((Component)this.myImportSettingsPanel, "South");
        this.add(right, "Center");
        this.add(this.myErrorPanel, "South");
    }

    protected final void load() {
        this.loadGrid((Consumer<DataGrid>)((Consumer)grid -> {
            this.myGrid = grid;
            this.myEditor = this.createEditor((DataGrid)grid);
            this.updatePreview();
            this.fillPanel();
            if (this.isLoading()) {
                this.stopLoading();
                this.myLoadCallback.run();
            }
        }));
    }

    protected final void updatePreview() {
        this.myDdlPreview.updatePreview(new ModelTraverserEx(this.mySettings, this.myEditor.getTableModel(), this.myContext.getModel()));
    }

    @NotNull
    private Function<Runnable, ActionCallback> createProcessor(@NotNull ImportAction.ImportEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ui/AbstractImportPanel", "createProcessor"));
        }
        Function<Runnable, ActionCallback> function = DatabaseDialogsHelper.createAsyncProcessor((Project)ObjectUtils.assertNotNull((Object)context.getProject()), "Fetching DDL", this::editorChanged);
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/AbstractImportPanel", "createProcessor"));
        }
        return function;
    }

    private void editorChanged() {
        if (this.myEditor != null) {
            this.updatePreview();
        }
    }

    @Nullable
    private static String sanitize(@Nullable String path) {
        if (path == null) {
            return null;
        }
        String parent = PathUtil.getParentPath((String)path);
        String fileName = PathUtil.getFileName((String)path);
        String extension = FileUtilRt.getExtension((String)fileName);
        String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)fileName);
        return parent + File.separator + FileUtil.sanitizeFileName((String)nameWithoutExtension) + (StringUtil.isEmpty((String)extension) ? "" : "." + FileUtil.sanitizeFileName((String)extension));
    }
}

