/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.dbimport.ImportSettings;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.ui.componentsList.layout.VerticalStackLayout;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSettingsPanel
extends JPanel {
    protected static final int GAP = JBUI.scale((int)5);
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH_mm_ss");
    private static final String HANDLE_ERROR_TEXT = "Write errors to file: ";
    private static final String INSERT_AS_NULL = "Insert inconvertible values as null";
    private static final String DISABLE_STATE_TEXT = String.format("Disable %s and triggers, lock table (may be faster)", StringUtil.pluralize((String)"index"));
    protected final ImportAction.ImportEditorContext myContext;
    protected final JCheckBox myHandleErrorCheckBox;
    protected final TextFieldWithBrowseButton myErrorOutput;
    private final JCheckBox myModalityStateCheckBox;
    private final JCheckBox myInsertAsNullCheckBox;
    private final String myTableName;

    public ImportSettingsPanel(@NotNull ImportAction.ImportEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ui/ImportSettingsPanel", "<init>"));
        }
        super((LayoutManager)new VerticalStackLayout());
        this.myContext = context;
        this.myHandleErrorCheckBox = new JBCheckBox(HANDLE_ERROR_TEXT);
        this.myModalityStateCheckBox = new JBCheckBox(DISABLE_STATE_TEXT);
        this.myInsertAsNullCheckBox = new JBCheckBox(INSERT_AS_NULL);
        this.myErrorOutput = new TextFieldWithBrowseButton();
        this.myTableName = this.myContext.getTableName();
        this.myModalityStateCheckBox.setVisible(context.getImportType().isTableCreated() && context.getManager().isSupportFastMode());
        this.configureComponents();
        this.addComponents();
    }

    @Nullable
    public String getErrorOutputFilePath() {
        return this.myErrorOutput.isEnabled() ? this.myErrorOutput.getText() : null;
    }

    public boolean getModalityState() {
        return this.myModalityStateCheckBox.isSelected();
    }

    public boolean isInsertAsNull() {
        return this.myInsertAsNullCheckBox.isSelected();
    }

    protected void addComponents() {
        ImportSettingsPanel.addStrut(this);
        JPanel errorOutputPanel = this.createErrorOutputSettingsPanel();
        this.add(errorOutputPanel);
        ImportSettingsPanel.addStrut(this);
        this.add(this.myInsertAsNullCheckBox);
        ImportSettingsPanel.addStrut(this);
        this.add(this.myModalityStateCheckBox);
    }

    @NotNull
    protected JPanel createErrorOutputSettingsPanel() {
        JPanel errorOutputPanel = new JPanel(new BorderLayout());
        errorOutputPanel.add((Component)this.myHandleErrorCheckBox, "West");
        errorOutputPanel.add((Component)this.myErrorOutput, "Center");
        JPanel jPanel = errorOutputPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportSettingsPanel", "createErrorOutputSettingsPanel"));
        }
        return jPanel;
    }

    protected static void addStrut(@NotNull JPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/dbimport/ui/ImportSettingsPanel", "addStrut"));
        }
        panel.add(Box.createVerticalStrut(GAP));
    }

    protected void configureComponents() {
        boolean errors = ImportSettings.getWriteErrors();
        String directory = ImportSettings.getErrorDirectory();
        this.myErrorOutput.setEnabled(errors);
        this.myErrorOutput.setText(this.getDefaultText((String)ObjectUtils.chooseNotNull((Object)directory, (Object)SystemProperties.getUserHome())));
        this.myErrorOutput.addBrowseFolderListener(new TextBrowseFolderListener(new FileChooserDescriptor(true, true, false, false, false, false)){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/database/dbimport/ui/ImportSettingsPanel$1", "onFileChosen"));
                }
                if (chosenFile.isDirectory()) {
                    ImportSettingsPanel.this.myErrorOutput.setText(ImportSettingsPanel.this.getDefaultText(chosenFile.getPath()));
                    return;
                }
                ImportSettingsPanel.this.myErrorOutput.setText(chosenFile.getPath());
            }
        });
        this.myHandleErrorCheckBox.setSelected(errors);
        this.myModalityStateCheckBox.setSelected(this.myModalityStateCheckBox.isVisible() && ImportSettings.getImportModality());
        this.myInsertAsNullCheckBox.setSelected(ImportSettings.getInsertAsNull());
        this.myHandleErrorCheckBox.addItemListener(e -> this.myErrorOutput.setEnabled(this.myHandleErrorCheckBox.isSelected()));
    }

    @NotNull
    private String getDefaultText(@NotNull String directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/database/dbimport/ui/ImportSettingsPanel", "getDefaultText"));
        }
        String string = directory + File.separator + this.myTableName + "_" + DATE_FORMAT.format(LocalDateTime.now()) + ".txt";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportSettingsPanel", "getDefaultText"));
        }
        return string;
    }
}

