/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.csv;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.csv.ui.preview.TableCsvFormatPreview;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.csv.CsvImportPanelModel;
import com.intellij.database.dbimport.csv.CsvImportTableEditorWrapper;
import com.intellij.database.dbimport.ui.AbstractImportPanel;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.ImportSettingsPanel;
import com.intellij.database.dbimport.ui.csv.CsvImportSettingsPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

public class CsvImportPanel
extends AbstractImportPanel {
    private final CsvImportTableEditorWrapper myWrapper;
    private final CsvFormatsSelectionUI myFormats;
    private final CsvImportPanelModel myModel;
    private final PreviewWithCharset myPreviewWithCharset;
    private Disposable myPreviewDisposable;

    public CsvImportPanel(@NotNull ImportAction.ImportEditorContext context, @NotNull CsvImportPanelModel model, @NotNull Runnable onLoadCallback) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ui/csv/CsvImportPanel", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/ui/csv/CsvImportPanel", "<init>"));
        }
        if (onLoadCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onLoadCallback", "com/intellij/database/dbimport/ui/csv/CsvImportPanel", "<init>"));
        }
        super(context, onLoadCallback);
        model.addCharsetListener(this::charsetChanged);
        CsvFormatUISettings settings = this.myContext.getImportType().getCsvFormatSettings();
        Disposable disposable = this.myContext.getDisposable();
        this.myModel = model;
        this.myFormats = CsvFormatsSelectionUI.createDatabaseSettingsBackedForm(disposable, settings);
        this.myPreviewWithCharset = new PreviewWithCharset(this.recreatePreview(), this.myModel.getCharset());
        this.myWrapper = new CsvImportTableEditorWrapper(context, this.myPreviewWithCharset, this.myFormats, this::updatePreview);
        this.myWrapper.addEditorListener(this::load);
        this.init();
    }

    @Override
    @NotNull
    public ImportInfo getInfo() throws IOException {
        this.myModel.acceptCharset();
        ImportInfo importInfo = super.getInfo();
        if (importInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvImportPanel", "getInfo"));
        }
        return importInfo;
    }

    @Override
    @NotNull
    protected ImportDatabaseTableEditor<?> createEditor(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/ui/csv/CsvImportPanel", "createEditor"));
        }
        ImportDatabaseTableEditor<?> importDatabaseTableEditor = this.myWrapper.getEditor();
        if (importDatabaseTableEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvImportPanel", "createEditor"));
        }
        return importDatabaseTableEditor;
    }

    @Override
    protected void loadGrid(@NotNull Consumer<DataGrid> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dbimport/ui/csv/CsvImportPanel", "loadGrid"));
        }
        consumer.consume((Object)this.myPreviewWithCharset.getPreview().getGrid());
    }

    @Override
    protected void fillPanel() {
        super.fillPanel();
        this.add(this.myFormats.getComponent(), "West");
    }

    @Override
    @NotNull
    protected CsvFormat getCsvFormat() {
        CsvFormat csvFormat = this.myFormats.getSelectedFormat();
        if (csvFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvImportPanel", "getCsvFormat"));
        }
        return csvFormat;
    }

    @Override
    @NotNull
    protected ImportSettingsPanel getSettingsPanel() {
        CsvImportSettingsPanel csvImportSettingsPanel = new CsvImportSettingsPanel(this.myContext, this, this.myModel.getCharset());
        if (csvImportSettingsPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvImportPanel", "getSettingsPanel"));
        }
        return csvImportSettingsPanel;
    }

    void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/database/dbimport/ui/csv/CsvImportPanel", "setCharset"));
        }
        this.myModel.setCharset(charset);
    }

    private void charsetChanged() {
        TableCsvFormatPreview preview = this.recreatePreview();
        this.myPreviewWithCharset.change(preview, this.myModel.getCharset());
    }

    @NotNull
    private TableCsvFormatPreview recreatePreview() {
        if (this.myPreviewDisposable != null) {
            Disposer.dispose((Disposable)this.myPreviewDisposable);
        }
        this.myPreviewDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myContext.getDisposable(), (Disposable)this.myPreviewDisposable);
        TableCsvFormatPreview tableCsvFormatPreview = this.createPreview(this.getCsvFormat());
        if (tableCsvFormatPreview == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvImportPanel", "recreatePreview"));
        }
        return tableCsvFormatPreview;
    }

    @NotNull
    private TableCsvFormatPreview createPreview(@NotNull CsvFormat selectedFormat) {
        if (selectedFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFormat", "com/intellij/database/dbimport/ui/csv/CsvImportPanel", "createPreview"));
        }
        TableCsvFormatPreview preview = new TableCsvFormatPreview((Project)ObjectUtils.assertNotNull((Object)this.myContext.getProject()), selectedFormat, this.myModel.getText(), this.myPreviewDisposable);
        preview.getGrid().getDataHookup().getLoader().loadFirstPage(GridRequestSource.create(preview.getGrid(), null));
        TableCsvFormatPreview tableCsvFormatPreview = preview;
        if (tableCsvFormatPreview == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvImportPanel", "createPreview"));
        }
        return tableCsvFormatPreview;
    }

    public static class PreviewWithCharset {
        private final EventDispatcher<Listener> myDispatcher;
        private TableCsvFormatPreview myPreview;
        private Charset myCharset;

        PreviewWithCharset(@NotNull TableCsvFormatPreview preview, @NotNull Charset charset) {
            if (preview == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/intellij/database/dbimport/ui/csv/CsvImportPanel$PreviewWithCharset", "<init>"));
            }
            if (charset == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/database/dbimport/ui/csv/CsvImportPanel$PreviewWithCharset", "<init>"));
            }
            this.myPreview = preview;
            this.myCharset = charset;
            this.myDispatcher = EventDispatcher.create(Listener.class);
        }

        public void change(@NotNull TableCsvFormatPreview preview, @NotNull Charset charset) {
            if (preview == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/intellij/database/dbimport/ui/csv/CsvImportPanel$PreviewWithCharset", "change"));
            }
            if (charset == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/database/dbimport/ui/csv/CsvImportPanel$PreviewWithCharset", "change"));
            }
            this.myPreview = preview;
            this.myCharset = charset;
            ((Listener)this.myDispatcher.getMulticaster()).changed();
        }

        @NotNull
        public TableCsvFormatPreview getPreview() {
            TableCsvFormatPreview tableCsvFormatPreview = this.myPreview;
            if (tableCsvFormatPreview == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvImportPanel$PreviewWithCharset", "getPreview"));
            }
            return tableCsvFormatPreview;
        }

        @NotNull
        public Charset getCharset() {
            Charset charset = this.myCharset;
            if (charset == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvImportPanel$PreviewWithCharset", "getCharset"));
            }
            return charset;
        }

        public void addListener(@NotNull Listener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dbimport/ui/csv/CsvImportPanel$PreviewWithCharset", "addListener"));
            }
            this.myDispatcher.addListener((EventListener)listener);
        }

        public static interface Listener
        extends EventListener {
            public void changed();
        }
    }
}

