/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.database;

import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ui.AbstractImportPanel;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.ImportSettingsPanel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ui.DataGridRequestSource;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseImportPanel
extends AbstractImportPanel {
    private static final int PAGE_SIZE = 500;
    private final DasTable myProducer;

    public DatabaseImportPanel(@NotNull ImportAction.ImportEditorContext context, @NotNull DasTable producer, @NotNull Runnable loaded) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ui/database/DatabaseImportPanel", "<init>"));
        }
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/dbimport/ui/database/DatabaseImportPanel", "<init>"));
        }
        if (loaded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loaded", "com/intellij/database/dbimport/ui/database/DatabaseImportPanel", "<init>"));
        }
        super(context, loaded);
        this.myProducer = producer;
        this.init();
    }

    @Override
    @NotNull
    protected ImportSettingsPanel getSettingsPanel() {
        ImportSettingsPanel importSettingsPanel = new ImportSettingsPanel(this.myContext);
        if (importSettingsPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/database/DatabaseImportPanel", "getSettingsPanel"));
        }
        return importSettingsPanel;
    }

    @Override
    @NotNull
    protected ImportDatabaseTableEditor<?> createEditor(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/ui/database/DatabaseImportPanel", "createEditor"));
        }
        DeTable table = this.myContext.getImportType().createTable(this.myContext, grid);
        ImportDatabaseTableEditor<?> editor = ImportUtil.createEditor(table, grid, this.myContext);
        editor.addListener(this::updatePreview, editor);
        ImportDatabaseTableEditor<?> importDatabaseTableEditor = editor;
        if (importDatabaseTableEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/database/DatabaseImportPanel", "createEditor"));
        }
        return importDatabaseTableEditor;
    }

    @Override
    protected void loadGrid(@NotNull Consumer<DataGrid> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dbimport/ui/database/DatabaseImportPanel", "loadGrid"));
        }
        Project project = this.myContext.getProject();
        GridDataHookUpManager instance = GridDataHookUpManager.getInstance((Project)ObjectUtils.assertNotNull((Object)project));
        SimpleRequestBroker broker = SimpleRequestBroker.newInstance((Project)ObjectUtils.assertNotNull((Object)project), "Import preview");
        DatabaseGridDataHookUp hookUp = instance.createReadOnlyDatabaseHookUp(broker, this.myContext.getDisposable());
        hookUp.setDatabaseTable(this.myProducer);
        LocalDataSource localDataSource = DbImplUtil.getLocalDataSource((DatabaseSystem)DasUtil.getParentOfClass((DasObject)this.myProducer, DbDataSource.class, (boolean)true));
        JdbcEngine engine = new JdbcEngine((Project)ObjectUtils.assertNotNull((Object)project), broker, localDataSource, null);
        Disposer.register((Disposable)this.myContext.getDisposable(), (Disposable)engine);
        DataGrid grid = DataGridUtil.createPreviewDataGrid((Project)ObjectUtils.assertNotNull((Object)project), hookUp);
        Disposer.register((Disposable)this.myContext.getDisposable(), (Disposable)grid);
        DataGridRequestSource source = new DataGridRequestSource(grid);
        hookUp.addRequestListener(new MyRequestListener(consumer, grid), this.myContext.getDisposable());
        hookUp.getPageModel().setPageSize(500);
        hookUp.getLoader().loadFirstPage(GridRequestSource.create(grid, (Object)source));
    }

    @Override
    @Nullable
    protected CsvFormat getCsvFormat() {
        return null;
    }

    private static class MyRequestListener
    implements GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column> {
        private final Consumer<DataGrid> myConsumer;
        private final DataGrid myGrid;

        private MyRequestListener(@NotNull Consumer<DataGrid> consumer, @NotNull DataGrid grid) {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dbimport/ui/database/DatabaseImportPanel$MyRequestListener", "<init>"));
            }
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/ui/database/DatabaseImportPanel$MyRequestListener", "<init>"));
            }
            this.myConsumer = consumer;
            this.myGrid = grid;
        }

        @Override
        public void error(@NotNull GridRequestSource source, @Nullable String message, @Nullable Throwable th) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dbimport/ui/database/DatabaseImportPanel$MyRequestListener", "error"));
            }
            this.consume();
        }

        @Override
        public void requestFinished(@NotNull GridRequestSource source, boolean success) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dbimport/ui/database/DatabaseImportPanel$MyRequestListener", "requestFinished"));
            }
            this.consume();
        }

        private void consume() {
            this.myConsumer.consume((Object)this.myGrid);
        }

        @Override
        public void updateCountReceived(@NotNull GridRequestSource source, int updateCount) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dbimport/ui/database/DatabaseImportPanel$MyRequestListener", "updateCountReceived"));
            }
        }
    }
}

