/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTransactSqlDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    protected AbstractTransactSqlDialect(MetaModel metaModel, TypeHelper typeHelper, KeywordHelper keywordHelper, Casing casing) {
        super(metaModel, typeHelper, keywordHelper, casing);
    }

    @Override
    public char closeQuote() {
        return ']';
    }

    @Override
    public char openQuote() {
        return '[';
    }

    @Override
    protected String quoteIdentifierUnconditionally(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dialects/AbstractTransactSqlDialect", "quoteIdentifierUnconditionally"));
        }
        return StringUtil.containsAnyChar((String)name, (String)"[]") ? super.quoteIdentifierUnconditionally(name) : '[' + name + ']';
    }

    @NotNull
    public abstract DdlBuilder sqlAlterColumnTypeAndNullable(@NotNull DdlBuilder var1, @NotNull DasColumn var2, boolean var3);

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to, boolean forceOutput) {
        boolean typeChanged;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterColumnDefinition"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterColumnDefinition"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterColumnDefinition"));
        }
        int before = builder.getStatements().size();
        if (!AbstractTransactSqlDialect.isSameName(from, to)) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        if (!AbstractTransactSqlDialect.isSameDefault(from, to)) {
            this.sqlAlterColumnDefault(builder, to).newStatement();
        }
        boolean bl = typeChanged = !this.isSameType(from, to);
        if (typeChanged || !AbstractTransactSqlDialect.isSameNullability(from, to)) {
            this.sqlAlterColumnTypeAndNullable(builder, to, typeChanged).newStatement();
        }
        if (!AbstractTransactSqlDialect.isSameComment(from, to)) {
            this.sqlAlterColumnComment(builder, to).newStatement();
        }
        if (!AbstractTransactSqlDialect.isSameAutoInc(from, to)) {
            this.sqlAddColumnAutoIncrement(builder, to).newStatement();
        }
        if (builder.getStatements().size() == before && forceOutput) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterColumnDefinition"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        boolean fkRecreateable = this.supportsAddForeignKey() && this.supportsDropForeignKey();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || fkRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()));
        if (foreignKeyEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "getForeignKeyEditorCaps"));
        }
        return foreignKeyEditorCaps;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/AbstractTransactSqlDialect", "isValidPlainIdentifier"));
        }
        char c0 = identifier.charAt(0);
        if (!Character.isLetter(c0) && c0 != '_' && c0 != '#') {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    public boolean supportsColumnComment() {
        return false;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterColumnComment"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterColumnComment"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.comment.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterColumnName"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterColumnName"));
        }
        if (toName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterColumnName"));
        }
        DasTable table = from.getTable();
        builder.keyword("EXEC").space().ref(null, "sp_rename").space();
        builder.symbol("'").qualifiedRef((DasObject)table).symbol(".").columnRef((DasObject)from).symbol("'");
        builder.symbol(",").space();
        builder.newName(toName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterColumnName"));
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterColumnDefault"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterColumnDefault"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.default.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropPrimaryKey"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropPrimaryKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropPrimaryKeySQL(builder, pk, true, false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropPrimaryKey"));
        }
        return ddlBuilder;
    }

    public String[] getIndexAccessMethodsTypes() {
        return new String[]{"UNIQUE", "NON-UNIQUE"};
    }

    public String[] getIndexStorageOptions() {
        return new String[]{"NONCLUSTERED", "CLUSTERED"};
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAddColumnAutoIncrement"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAddColumnAutoIncrement"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.auto.increment", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAddForeignKey"));
        }
        if (keyInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyInfo", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAddForeignKey"));
        }
        builder.suppressQuoteConstraints(true);
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, false, false, this).suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAddForeignKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey info, boolean matchFull) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDefineForeignKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.foreignKeyTail(builder, info, DasForeignKey.Deferrability.NOT_DEFERRABLE, false, null, null);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDefineForeignKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column, boolean singlePk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDefineColumn"));
        }
        super.sqlDefineColumn(builder, column, singlePk);
        DdlBuilder ddlBuilder = DasUtil.isAutoVal((DasColumn)column) ? builder.space().keyword("IDENTITY") : builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDefineColumn"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAddUniqueConstraint"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAddUniqueConstraint"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAddUniqueConstraint"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAddUniqueConstraint"));
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keywords("ADD", "CONSTRAINT").space();
        builder.constraintRef(constraint, constraintName).space();
        builder.keyword("UNIQUE").space();
        builder.symbol("(");
        DialectUtils.appendColumnList(builder, columns);
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAddUniqueConstraint"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterSequence"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterSequence"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterSequence"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterSequence"));
        }
        if (restart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restart", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterSequence"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAlterSequence"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.alter.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateIndex"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateIndex"));
        }
        if (accessMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessMethod", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateIndex"));
        }
        if (tablespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tablespace", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateIndex"));
        }
        if (constraints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateIndex"));
        }
        DdlBuilder ddlBuilder = DialectUtils.createIndex(builder, index, "");
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateIndex"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateSequence"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateSequence"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateSequence"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateSequence"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateSequence"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateSequence"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.create.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateView"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateView"));
        }
        if (checkOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkOption", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateView"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateViewWithCheckOptionSQL(builder, view2, definition, checkOption);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlCreateView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropConstraint"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropConstraint"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropConstraint"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropConstraintSQL(builder, table, constraint, constraintName);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropConstraint"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropIndex"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropIndex"));
        }
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropIndex"));
        }
        builder.keywords("DROP", "INDEX").space();
        DasObject schema = DasUtil.getSchemaObject((DasObject)table);
        builder.qualifiedRef((DasObject)table, table.getName(), schema, DasUtil.getName((DasObject)schema), null, null, null, null).symbol(".").identifier((DasObject)index, indexName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropIndex"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropSequence"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view2, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropView"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view2, null);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlDropView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlRenameTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlRenameTable"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlRenameTable"));
        }
        builder.keyword("EXEC").space().ref(null, "sp_rename").space();
        builder.symbol("'").qualifiedRef((DasObject)table).symbol("'").symbol(",").space();
        builder.newName(newName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlRenameTable"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String newName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlRenameView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlRenameView"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlRenameView"));
        }
        DdlBuilder ddlBuilder = this.sqlRenameTable(builder, view2, newName);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlRenameView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlSequenceInformation"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlSequenceInformation"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.sequence.information", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    public ObjectKind getSearchPathObjectKind() {
        return ObjectKind.DATABASE;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseSystem system, @NotNull Connection connection) throws SQLException {
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dialects/AbstractTransactSqlDialect", "tryToLoadSearchPath"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/AbstractTransactSqlDialect", "tryToLoadSearchPath"));
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection, "select db_name() as a", new String[0]);
        return SearchPath.of(new ObjectPath(ObjectKind.DATABASE, Collections.singletonList(String.valueOf(map.get("a")))));
    }

    @Override
    public String sqlSetSearchPath(@NotNull DatabaseSystem system, @NotNull SearchPath path) {
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlSetSearchPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlSetSearchPath"));
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.DATABASE) {
            return null;
        }
        return String.format("use %s", this.quoteIdentifier(current.getName(), false, false));
    }

    public boolean supportsAccessMethods() {
        return true;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    public boolean supportsAlterSequence() {
        return false;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return true;
    }

    public boolean supportsCreateIndex() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return false;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return true;
    }

    public boolean supportsDropIndex() {
        return true;
    }

    public boolean supportsDropSequence() {
        return false;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsMultipleRowInserts() {
        return true;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsRenameView() {
        return true;
    }

    public boolean supportsSequence() {
        return false;
    }

    public boolean supportsSequenceInformation() {
        return false;
    }

    public boolean supportsTablespace() {
        return false;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    public boolean supportsDropType() {
        return true;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryData", "com/intellij/database/dialects/AbstractTransactSqlDialect", "getBinaryLiteralString"));
        }
        String string = "0x" + DialectUtils.toHexString(binaryData);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "getBinaryLiteralString"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getNullColumnString() {
        if (" NULL" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "getNullColumnString"));
        }
        return " NULL";
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAddColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAddColumn"));
        }
        if (attrs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrs", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAddColumn"));
        }
        DialectUtils.getAddColumnSQL(builder, column, true, true, true);
        DdlBuilder ddlBuilder = DasUtil.isAutoVal((DasColumn)column) ? builder.space().keyword("IDENTITY") : builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "sqlAddColumn"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    protected AbstractDatabaseDialect.LimitPlace getPlaceForLimit(@Nullable DatabaseSystem system) {
        AbstractDatabaseDialect.LimitPlace limitPlace = AbstractDatabaseDialect.LimitPlace.BEGIN;
        if (limitPlace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "getPlaceForLimit"));
        }
        return limitPlace;
    }

    @Override
    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @Nullable DatabaseSystem system, int rows) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractTransactSqlDialect", "appendLimit"));
        }
        DdlBuilder ddlBuilder = AbstractTransactSqlDialect.top(builder, "TOP", rows);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractTransactSqlDialect", "appendLimit"));
        }
        return ddlBuilder;
    }
}

