/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.mysql.MysqlDdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public static final MetaModel META_MODEL = MetaModelImpl.builder().put(ObjectKind.ROOT, ObjectKind.SCHEMA).put(ObjectKind.SCHEMA, ObjectKind.TABLE).put(ObjectKind.SCHEMA, ObjectKind.VIEW).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE).put(ObjectKind.TABLE, ObjectKind.COLUMN).put(ObjectKind.TABLE, ObjectKind.INDEX).put(ObjectKind.TABLE, ObjectKind.KEY).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY).put(ObjectKind.TABLE, ObjectKind.TRIGGER).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT).put(ObjectKind.VIEW, ObjectKind.COLUMN).build();
    @NotNull
    public static final MysqlDialect INSTANCE = new MysqlDialect();

    public MysqlDialect() {
        super(META_MODEL, new TypeHelper.MySQLTypeHelper(), new KeywordHelper.MysqlKeywords(), Casing.create((Case)Case.LOWER, (Case)Case.LOWER));
    }

    @NotNull
    public String getDisplayName() {
        if ("MySQL" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getDisplayName"));
        }
        return "MySQL";
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.MYSQL;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getFamilyId"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Mysql;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getIcon"));
        }
        return icon;
    }

    @Override
    public char closeQuote() {
        return '`';
    }

    @Override
    public char openQuote() {
        return '`';
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/MysqlDialect", "isValidPlainIdentifier"));
        }
        if (identifier.isEmpty() || !Character.isLetter(identifier.charAt(0))) {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || i2 > 0 && c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlCreateView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/MysqlDialect", "sqlCreateView"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/database/dialects/MysqlDialect", "sqlCreateView"));
        }
        if (checkOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkOption", "com/intellij/database/dialects/MysqlDialect", "sqlCreateView"));
        }
        builder.keywords("CREATE", "OR", "REPLACE", "VIEW").space();
        builder.qualifiedRef((DasObject)view2).space();
        builder.keyword("AS").space();
        builder.plain(definition).space();
        if (!"".isEmpty()) {
            builder.keyword("WITH").space();
            builder.keyword("CHECK OPTION");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlCreateView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view2, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlDropView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/MysqlDialect", "sqlDropView"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view2, cascade);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlDropView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String newName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlRenameView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/MysqlDialect", "sqlRenameView"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dialects/MysqlDialect", "sqlRenameView"));
        }
        DdlBuilder.Marker mark = builder.mark();
        builder.keywords("RENAME", "TABLE").space().qualifiedRef((DasObject)view2).space().keyword("TO").space().qualifiedRefOpt((DasObject)view2, newName);
        mark.replace(DialectUtils.stripQuotesFromIdentifier(this, newName, mark.extract()));
        mark.finish();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlRenameView"));
        }
        return ddlBuilder;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/MysqlDialect", "sqlViewDefinition"));
        }
        return Pair.create((Object)("SELECT view_definition FROM information_schema.views WHERE table_name = '" + element.getName() + "' AND table_schema = '" + MysqlDialect.getDBName(element) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/MysqlDialect", "sqlProcedureDefinition"));
        }
        Pair pair = Pair.create((Object)("SELECT routine_definition FROM information_schema.routines WHERE routine_name = '" + element.getName() + "' AND routine_schema = '" + MysqlDialect.getDBName((DasObject)element) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlProcedureDefinition"));
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine procedure, @NotNull Connection connection) throws Exception {
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "com/intellij/database/dialects/MysqlDialect", "tryToLoadProcedureDefinition"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/MysqlDialect", "tryToLoadProcedureDefinition"));
        }
        String type = procedure.getRoutineKind().name();
        String query = new DdlBuilder().withDialect(this).qualifyReferences(true).keywords("SHOW", "CREATE", type).space().qualifiedRef((DasObject)procedure).getStatement();
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery(query);
        String result = "";
        if (rs.next()) {
            DdlBuilder builder = new DdlBuilder().withDialect(this).qualifyReferences(true).splitStatements(true);
            this.sqlDropProcedure(builder, procedure).newStatement().plain(rs.getString(3));
            result = DialectUtils.sqlConcat(builder.getStatements());
        }
        JdbcUtil.closeResultSetSafe((ResultSet)rs);
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "tryToLoadProcedureDefinition"));
        }
        return string;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseProductVersion", "com/intellij/database/dialects/MysqlDialect", "supportsProduct"));
        }
        if (databaseProductName == null || !databaseProductName.trim().toLowerCase(Locale.ENGLISH).startsWith("mysql")) {
            return false;
        }
        return databaseProductVersion.startsWith("5");
    }

    public boolean supportsRenameView() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAppendColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn to) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlAppendColumnDefinition"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/MysqlDialect", "sqlAppendColumnDefinition"));
        }
        builder.type((DasTypedObject)to);
        DialectUtils.addNullabilityClause(builder, to, false);
        Set attr = ContainerUtil.notNullize(to.getTable() == null ? null : to.getTable().getColumnAttrs(to));
        if (attr.contains(DasColumn.Attribute.AUTO_GENERATED)) {
            builder.space().keyword("auto_increment");
        }
        DialectUtils.addDefaultClauseIfNeeded(builder, to, "DEFAULT");
        DialectUtils.addCommentClauseIfNeeded(builder, to);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlAppendColumnDefinition"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to, boolean forceOutput) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlAlterColumnDefinition"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/MysqlDialect", "sqlAlterColumnDefinition"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/MysqlDialect", "sqlAlterColumnDefinition"));
        }
        boolean changedName = !MysqlDialect.isSameName(from, to);
        boolean changedDefault = !MysqlDialect.isSameDefault(from, to);
        boolean changeOther = !this.isSameType(from, to);
        changeOther |= !MysqlDialect.isSameNullability(from, to);
        changeOther |= !MysqlDialect.isSameComment(from, to);
        if (!((changeOther |= !MysqlDialect.isSameAutoInc(from, to)) || changedDefault || changedName || forceOutput)) {
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlAlterColumnDefinition"));
            }
            return ddlBuilder;
        }
        if (changedDefault && !changeOther && !changedName) {
            DdlBuilder ddlBuilder = DialectUtils.getColumnDefaultAlterOrDropSQL(builder, to);
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlAlterColumnDefinition"));
            }
            return ddlBuilder;
        }
        builder.keywords("ALTER", "TABLE").space().qualifiedRef((DasObject)from.getTable()).space();
        if (!changedName) {
            builder.keyword("MODIFY").space().columnRef((DasObject)from);
        } else {
            builder.keyword("CHANGE").space().columnRef((DasObject)from).space().columnRef((DasObject)to);
        }
        this.sqlAppendColumnDefinition(builder.space(), to);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlAlterColumnDefinition"));
        }
        return ddlBuilder;
    }

    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropForeignKey(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasForeignKey fk, @NotNull String fkName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlDropForeignKey"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/MysqlDialect", "sqlDropForeignKey"));
        }
        if (fkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fkName", "com/intellij/database/dialects/MysqlDialect", "sqlDropForeignKey"));
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)table).space();
        builder.keywords("DROP", "FOREIGN", "KEY").space();
        builder.constraintRef((DasObject)fk, fkName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlDropForeignKey"));
        }
        return ddlBuilder;
    }

    public String[] getIndexAccessMethodsTypes() {
        return new String[]{"UNIQUE", "FULLTEXT", "SPATIAL"};
    }

    public String[] getIndexStorageOptions() {
        return new String[]{"BTREE", "HASH"};
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlAddColumnAutoIncrement"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/MysqlDialect", "sqlAddColumnAutoIncrement"));
        }
        DdlBuilder.Marker m = builder.mark();
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable());
        builder.space().keyword("MODIFY").space();
        builder.columnRef((DasObject)column).space();
        builder.keywords("BIGINT", "NOT", "NULL", "AUTO_INCREMENT", "PRIMARY", "KEY");
        m.replace(DialectUtils.stripQuotesFromIdentifier(this, column.getName(), m.extract()));
        m.finish();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlAddColumnAutoIncrement"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlAddColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/MysqlDialect", "sqlAddColumn"));
        }
        if (attrs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrs", "com/intellij/database/dialects/MysqlDialect", "sqlAddColumn"));
        }
        builder.suppressQuoteConstraints(true);
        DialectUtils.getAddColumnSQL(builder, column, true, true, true).suppressQuoteConstraints(false);
        if (attrs.contains(DasColumn.Attribute.AUTO_GENERATED)) {
            builder.space().keywords("PRIMARY", "KEY", "AUTO_INCREMENT");
        } else if (attrs.contains(DasColumn.Attribute.PRIMARY_KEY)) {
            builder.space().keywords("PRIMARY", "KEY");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlAddColumn"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column, boolean singlePk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlDefineColumn"));
        }
        super.sqlDefineColumn(builder, column, singlePk);
        DialectUtils.addCommentClauseIfNeeded(builder, column);
        DdlBuilder ddlBuilder = DasUtil.isAutoVal((DasColumn)column) ? builder.space().keyword("AUTO_INCREMENT") : builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlDefineColumn"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsSystemViewDefinition() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlDropProcedure"));
        }
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "com/intellij/database/dialects/MysqlDialect", "sqlDropProcedure"));
        }
        DdlBuilder ddlBuilder = DialectUtils.sqlDropProcedure(builder, procedure, true);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlDropProcedure"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlAddForeignKey"));
        }
        if (keyInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyInfo", "com/intellij/database/dialects/MysqlDialect", "sqlAddForeignKey"));
        }
        builder.suppressQuoteConstraints(true);
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, false, autoFKIndex, this).suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlAddForeignKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey info, boolean matchFull) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlDefineForeignKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.foreignKeyTail(builder, info, DasForeignKey.Deferrability.NOT_DEFERRABLE, false, null, null);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlDefineForeignKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new MysqlDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getDdlOperations"));
        }
        return ddlOperations;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.TableEditorCaps getTableEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = new DatabaseEditorCapabilities.TableEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || this.supportsRenameTable()), DatabaseEditorCapabilities.Capability.supported(this.supportsTableComment()), DatabaseEditorCapabilities.ListCapability.get(true, true, !existing || this.supportsAddColumn(), !existing || this.supportsDropColumn()), DatabaseEditorCapabilities.ListCapability.get(this.supportsIndexes(), false, !existing || this.supportsCreateIndex(), !existing || this.supportsDropIndex()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddForeignKey(), !existing || this.supportsDropForeignKey()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddPrimaryKey(), !existing || this.supportsDropPrimaryKey()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddUniqueConstraint(), !existing || this.supportsDropConstraint()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddUniqueConstraint(), !existing || this.supportsDropConstraint()), this.getColumnEditorCaps(false), this.getColumnEditorCaps(existing), this.getKeyEditorCaps(false), this.getKeyEditorCaps(existing), this.getIndexEditorCaps(false), this.getIndexEditorCaps(existing), this.getForeignKeyEditorCaps(false), this.getForeignKeyEditorCaps(existing));
        if (tableEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getTableEditorCaps"));
        }
        return tableEditorCaps;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        boolean fkRecreateable = this.supportsAddForeignKey() && this.supportsDropForeignKey();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || fkRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()));
        if (foreignKeyEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getForeignKeyEditorCaps"));
        }
        return foreignKeyEditorCaps;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlAddUniqueConstraint"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/MysqlDialect", "sqlAddUniqueConstraint"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/MysqlDialect", "sqlAddUniqueConstraint"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dialects/MysqlDialect", "sqlAddUniqueConstraint"));
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keyword("ADD").space();
        if (!constraintName.isEmpty()) {
            builder.keyword("CONSTRAINT").space().constraintRef(constraint, constraintName).space();
        }
        builder.keyword("UNIQUE").space();
        builder.symbol("(");
        DialectUtils.appendColumnList(builder, columns);
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlAddUniqueConstraint"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlAlterSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/MysqlDialect", "sqlAlterSequence"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/MysqlDialect", "sqlAlterSequence"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/MysqlDialect", "sqlAlterSequence"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/MysqlDialect", "sqlAlterSequence"));
        }
        if (restart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restart", "com/intellij/database/dialects/MysqlDialect", "sqlAlterSequence"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/MysqlDialect", "sqlAlterSequence"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.alter.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlCreateIndex"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/dialects/MysqlDialect", "sqlCreateIndex"));
        }
        if (accessMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessMethod", "com/intellij/database/dialects/MysqlDialect", "sqlCreateIndex"));
        }
        if (tablespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tablespace", "com/intellij/database/dialects/MysqlDialect", "sqlCreateIndex"));
        }
        if (constraints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/intellij/database/dialects/MysqlDialect", "sqlCreateIndex"));
        }
        builder.keyword("CREATE").space();
        if (!accessMethod.isEmpty() && !accessMethod.toLowerCase(Locale.ENGLISH).equals("default")) {
            builder.keyword(accessMethod).space();
        } else if (index.isUnique()) {
            builder.keyword("UNIQUE").space();
        }
        builder.keyword("INDEX").space();
        builder.identifier(index.getName()).space();
        builder.keyword("ON").space();
        builder.qualifiedRef((DasObject)index.getTable()).space();
        DialectUtils.columnList(builder, index);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlCreateIndex"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/dialects/MysqlDialect", "getTypeName"));
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getTypeName"));
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if ("DOUBLE".equals(typeName) && jdbcType == 8 && precision == 22 && scale == 0) {
            if ("double" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getTypeName"));
            }
            return "double";
        }
        if ("MEDIUMINT".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            if ("mediumint" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getTypeName"));
            }
            return "mediumint";
        }
        if ("MEDIUMINT UNSIGNED".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            if ("mediumint unsigned" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getTypeName"));
            }
            return "mediumint unsigned";
        }
        if ("MEDIUMBLOB".equals(typeName) && jdbcType == -4 && precision == 0xFFFFFF && scale == 0) {
            if ("mediumblob" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getTypeName"));
            }
            return "mediumblob";
        }
        if ("TINYBLOB".equals(typeName) && jdbcType == -2 && precision == 255 && scale == 0) {
            if ("tinyblob" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getTypeName"));
            }
            return "tinyblob";
        }
        if ("DATETIME".equals(typeName) && jdbcType == 93 && precision == 19 && scale == 0) {
            if ("datetime" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getTypeName"));
            }
            return "datetime";
        }
        String name = super.getTypeName(dataType);
        String unsigned = "unsigned";
        String string = StringUtil.endsWithIgnoreCase((String)typeName, (String)unsigned) && !StringUtil.endsWithIgnoreCase((String)name, (String)unsigned) ? name + " " + unsigned : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getTypeName"));
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlCreateSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/MysqlDialect", "sqlCreateSequence"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/MysqlDialect", "sqlCreateSequence"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/MysqlDialect", "sqlCreateSequence"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/MysqlDialect", "sqlCreateSequence"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/database/dialects/MysqlDialect", "sqlCreateSequence"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/MysqlDialect", "sqlCreateSequence"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.create.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlDropConstraint"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/MysqlDialect", "sqlDropConstraint"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/MysqlDialect", "sqlDropConstraint"));
        }
        DdlBuilder ddlBuilder = MysqlDialect.sqlDropIndexImpl(builder, table, constraint, constraintName, false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlDropConstraint"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlDropIndex"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/MysqlDialect", "sqlDropIndex"));
        }
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/database/dialects/MysqlDialect", "sqlDropIndex"));
        }
        DdlBuilder ddlBuilder = MysqlDialect.sqlDropIndexImpl(builder, table, (DasObject)index, indexName, cascade);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlDropIndex"));
        }
        return ddlBuilder;
    }

    @NotNull
    private static DdlBuilder sqlDropIndexImpl(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlDropIndexImpl"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/MysqlDialect", "sqlDropIndexImpl"));
        }
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/database/dialects/MysqlDialect", "sqlDropIndexImpl"));
        }
        builder.keyword("DROP").space().keyword("INDEX");
        builder.space();
        builder.pushDefaultSchema(DasUtil.getNamespace((DasObject)table));
        builder.qualifiedRefOpt(index, (DasObject)table, indexName).popDefaultSchema();
        builder.space().keyword("ON").space().qualifiedRef((DasObject)table);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlDropIndexImpl"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlDropSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/MysqlDialect", "sqlDropSequence"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlRenameTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/MysqlDialect", "sqlRenameTable"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dialects/MysqlDialect", "sqlRenameTable"));
        }
        DialectUtils.getRenameTableSQL(builder, table, newName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlRenameTable"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlSequenceInformation"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/MysqlDialect", "sqlSequenceInformation"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.sequence.information", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/MysqlDialect", "sqlTableDefinition"));
        }
        DdlBuilder builder = new DdlBuilder().withDialect(this).qualifyReferences(true);
        Pair pair = Pair.create((Object)("SHOW CREATE TABLE " + builder.qualifiedRef(element).getStatement()), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlTableDefinition"));
        }
        return pair;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull Connection connection) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/MysqlDialect", "tryToLoadTableInfo"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/MysqlDialect", "tryToLoadTableInfo"));
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection, String.format("show table status from `%s` like '%s'", MysqlDialect.getDBName((DasObject)element), DbImplUtil.escapeStr(element.getName())), "TABLE_ROWS", "rows", "ENGINE", "engine", "TABLE_COLLATION", "collation", "CREATE_TIME", "created");
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "tryToLoadTableInfo"));
        }
        return map;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull Connection connection) throws Exception {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/MysqlDialect", "tryToLoadTableDefinition"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/MysqlDialect", "tryToLoadTableDefinition"));
        }
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults(connection, this, (String)pair.first, 2, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "tryToLoadTableDefinition"));
        }
        return string;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseSystem system, @NotNull Connection connection) throws SQLException {
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dialects/MysqlDialect", "tryToLoadSearchPath"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/MysqlDialect", "tryToLoadSearchPath"));
        }
        String s = DbImplUtil.concatStringResults(connection, this, "select database()", 1, DbImplUtil.ConcatenationProps.NO_CONCAT);
        return SearchPath.of(new ObjectPath(ObjectKind.SCHEMA, Collections.singletonList(s)));
    }

    @Override
    public String sqlSetSearchPath(@NotNull DatabaseSystem system, @NotNull SearchPath path) {
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dialects/MysqlDialect", "sqlSetSearchPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dialects/MysqlDialect", "sqlSetSearchPath"));
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("use %s", this.quoteIdentifier(current.getDisplayName(), false, false));
    }

    public boolean supportsAccessMethods() {
        return true;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    public boolean supportsAlterSequence() {
        return false;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    @Override
    public boolean supportsInlineAddPrimaryKey() {
        return true;
    }

    public boolean supportsCreateIndex() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return false;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return true;
    }

    public boolean supportsDropIndex() {
        return true;
    }

    public boolean supportsDropSequence() {
        return false;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsMultipleRowInserts() {
        return true;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsSequence() {
        return false;
    }

    public boolean supportsSequenceInformation() {
        return false;
    }

    public boolean supportsTablespace() {
        return true;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    @NotNull
    private static String getDBName(@NotNull DasObject qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/database/dialects/MysqlDialect", "getDBName"));
        }
        String string = DasUtil.getName((DasObject)MysqlDialect.getDB(qualifier));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getDBName"));
        }
        return string;
    }

    @Nullable
    private static DasObject getDB(@NotNull DasObject qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/database/dialects/MysqlDialect", "getDB"));
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        return schema != null && !StringUtil.isEmpty((String)schema.getName()) ? schema : DasUtil.getCatalogObject((DasObject)qualifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/MysqlDialect", "qualifiedIdentifier"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/database/dialects/MysqlDialect", "qualifiedIdentifier"));
        }
        DasObject db = MysqlDialect.getDB(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, db, DasUtil.getName((DasObject)db), null, null, null, null);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "qualifiedIdentifier"));
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    public boolean supportsSubSecondTimestamps() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlDropColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/MysqlDialect", "sqlDropColumn"));
        }
        builder.suppressQuoteConstraints(true);
        DdlBuilder ddlBuilder = super.sqlDropColumn(builder, column).suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlDropColumn"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlAddPrimaryKey"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/MysqlDialect", "sqlAddPrimaryKey"));
        }
        builder.suppressQuoteConstraints(true);
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)pk.getTable());
        builder.space().keywords("ADD", "PRIMARY", "KEY").space();
        DialectUtils.columnList(builder, (DasConstraint)pk);
        DdlBuilder ddlBuilder = builder.suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlAddPrimaryKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryData", "com/intellij/database/dialects/MysqlDialect", "getBinaryLiteralString"));
        }
        String string = "0x" + DialectUtils.toHexString(binaryData);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "getBinaryLiteralString"));
        }
        return string;
    }

    public boolean supportsCommonTableExpression() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlExplainPlan"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dialects/MysqlDialect", "sqlExplainPlan"));
        }
        if (analyze) {
            throw new UnsupportedOperationException("MYSQL does not support EXPLAIN ANALYZE");
        }
        builder.keywords("explain", "extended").space();
        builder.plain(statement);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "sqlExplainPlan"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/MysqlDialect", "tryToLoadDatabaseList"));
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection, "SHOW DATABASES", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MysqlDialect", "tryToLoadDatabaseList"));
        }
        return list;
    }

    @Override
    public DdlBuilder sqlAlterObjectComment(@NotNull DdlBuilder builder, @NotNull DasObject object) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MysqlDialect", "sqlAlterObjectComment"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dialects/MysqlDialect", "sqlAlterObjectComment"));
        }
        if (object.getKind() == ObjectKind.TABLE) {
            builder.keywords("ALTER", "TABLE").space().qualifiedRef(object).space().keyword("COMMENT").space().symbol("=").space().literal("'" + StringUtil.notNullize((String)object.getComment()) + "'");
            return builder;
        }
        return super.sqlAlterObjectComment(builder, object);
    }
}

