/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.diff.DbDiffElement;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffElement;
import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffModelHolder;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.DirDiffManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbMigrationAction
extends IconWithTextAction
implements DirDiffModelHolder {
    private final Direction myDirection;
    private DirDiffModel myModel;

    public DbMigrationAction(Direction direction) {
        super(direction == Direction.FORWARD ? "Migrate &Left" : "Migrate &Right");
        this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
        this.getTemplatePresentation().setIcon(EmptyIcon.ICON_0);
        this.myDirection = direction;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(!this.myModel.getElements().isEmpty());
        JComponent component = (JComponent)e.getPresentation().getClientProperty("customComponent");
        if (component != null) {
            component.setToolTipText(e.getPresentation().getDescription());
        }
    }

    public void actionPerformed(AnActionEvent e) {
        DirDiffModel m = this.myModel;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        DdlBuilder builder = this.createDdlBuilder(project, m);
        DdlBuilder dropKeyBuilder = this.createDdlBuilder(project, m);
        DdlBuilder addKeyBuilder = this.createDdlBuilder(project, m);
        try {
            DbMigrationAction.createMigration(project, m, builder, addKeyBuilder, dropKeyBuilder, this.myDirection);
        }
        catch (UnsupportedOperationException uoe) {
            Component source = e.getInputEvent().getComponent();
            Messages.showErrorDialog((Component)source, (String)uoe.getLocalizedMessage(), (String)"Migration Not Available");
            return;
        }
        DiffElement forDialect = this.myDirection == Direction.FORWARD ? m.getSourceDir() : m.getTargetDir();
        SqlLanguageDialect language = DbSqlUtil.getSqlDialect((DbElement)forDialect.getValue());
        String sqlFileContent = DialectUtils.sqlConcat(ContainerUtil.concat((List[])new List[]{dropKeyBuilder.getStatements(), builder.getStatements(), addKeyBuilder.getStatements()}));
        final EditorFactory instance = (EditorFactory)ObjectUtils.assertNotNull((Object)EditorFactory.getInstance());
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("migration.sql", (Language)language, (CharSequence)sqlFileContent);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        final Editor editor = instance.createViewer(document);
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)psiFile.getVirtualFile());
        ((EditorEx)editor).setHighlighter((EditorHighlighter)new LexerEditorHighlighter(highlighter, editor.getColorsScheme()));
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        dialogBuilder.setCenterPanel(editor.getComponent());
        dialogBuilder.addCloseButton();
        DiffElement source = this.myDirection == Direction.FORWARD ? m.getSourceDir() : m.getTargetDir();
        DiffElement target = this.myDirection == Direction.FORWARD ? m.getTargetDir() : m.getSourceDir();
        dialogBuilder.setTitle("'" + source.getPresentablePath() + "' to '" + target.getPresentablePath() + "' Migration");
        dialogBuilder.showModal(false);
        dialogBuilder.addDisposable(new Disposable(){

            public void dispose() {
                instance.releaseEditor(editor);
            }
        });
    }

    private DdlBuilder createDdlBuilder(Project project, DirDiffModel m) {
        DasObject target = (DasObject)(this.myDirection == Direction.FORWARD ? m.getSourceDir().getValue() : m.getTargetDir().getValue());
        final DasObject schemaObj = DasUtil.getSchemaObject((DasObject)target);
        final DasObject catalogObj = DasUtil.getCatalogObject((DasObject)target);
        final String schemaName = DasUtil.getName((DasObject)schemaObj);
        final String catalogName = DasUtil.getName((DasObject)catalogObj);
        DdlBuilder builder = new DdlBuilder(){

            @Override
            @NotNull
            public DdlBuilder qualifiedRef(@Nullable DasObject object, @NotNull String name, @Nullable DasObject igSchemaObject, @Nullable String igSchema, @Nullable DasObject igCatalogObject, @Nullable String igCatalog, @Nullable DasObject packageObject, @Nullable String packageName) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/diff/DbMigrationAction$2", "qualifiedRef"));
                }
                DdlBuilder ddlBuilder = super.qualifiedRef(object, name, schemaObj, schemaName, catalogObj, catalogName, packageObject, packageName);
                if (ddlBuilder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/DbMigrationAction$2", "qualifiedRef"));
                }
                return ddlBuilder;
            }
        }.splitStatements(true).qualifyReferences(true).quoteIdentifiers(false).applyCodeStyle(project);
        if (target instanceof DbElement) {
            builder.configureFor((DbElement)target);
        }
        return builder;
    }

    private static void createMigration(Project project, DirDiffModel model, DdlBuilder builder, DdlBuilder addKeyBuilder, DdlBuilder dropKeyBuilder, Direction direction) {
        List elements = model.getElements();
        DatabaseDialectEx sourceDialect = DbImplUtil.getDatabaseDialect(((DbDiffElement)model.getSourceDir()).getValue());
        DatabaseDialectEx targetDialect = DbImplUtil.getDatabaseDialect(((DbDiffElement)model.getTargetDir()).getValue());
        boolean isMigrateSource = direction == Direction.FORWARD;
        HashSet toSkip = ContainerUtil.newHashSet();
        for (DirDiffElement dirDiffElement : elements) {
            DbDiffElement trg;
            DbDiffElement src;
            DbDiffElement e2;
            boolean forwardAccordingType;
            DirDiffOperation operation;
            DiffType type = dirDiffElement.getType();
            if (type == DiffType.SEPARATOR) {
                List childElements;
                DbDiffElement source = (DbDiffElement)((Object)ObjectUtils.tryCast((Object)dirDiffElement.getSource(), DbDiffElement.class));
                DbDiffElement target = (DbDiffElement)((Object)ObjectUtils.tryCast((Object)dirDiffElement.getTarget(), DbDiffElement.class));
                DbDiffElement nonEmpty = (DbDiffElement)((Object)ObjectUtils.chooseNotNull((Object)((Object)source), (Object)((Object)target)));
                if (source == null == (target == null) || !(nonEmpty.getValue() instanceof DasTable)) continue;
                List children = JBIterable.of((Object[])nonEmpty.getChildren()).transform(e -> e.getValue()).toList();
                if (DbMigrationAction.migrateTable(builder, isMigrateSource ? sourceDialect : targetDialect, isMigrateSource, dirDiffElement, childElements = JBIterable.from((Iterable)elements).filter(e -> children.contains(((DiffElement)ObjectUtils.chooseNotNull((Object)e.getSource(), (Object)e.getTarget())).getValue())).toList())) {
                    toSkip.addAll(childElements);
                }
            }
            if ((operation = dirDiffElement.getOperation()) == null || operation == DirDiffOperation.EQUAL || operation == DirDiffOperation.NONE || toSkip.contains(dirDiffElement)) continue;
            boolean bl = forwardAccordingType = type == DiffType.SOURCE && isMigrateSource || type == DiffType.TARGET && !isMigrateSource;
            if (type == DiffType.SOURCE) {
                if (!isMigrateSource && operation == DirDiffOperation.DELETE) continue;
                e2 = (DbDiffElement)dirDiffElement.getSource();
                e2.generateMigrationStatements(builder, addKeyBuilder, dropKeyBuilder, forwardAccordingType ? null : targetDialect);
                continue;
            }
            if (type == DiffType.TARGET) {
                if (isMigrateSource && operation == DirDiffOperation.DELETE) continue;
                e2 = (DbDiffElement)dirDiffElement.getTarget();
                e2.generateMigrationStatements(builder, addKeyBuilder, dropKeyBuilder, forwardAccordingType ? null : sourceDialect);
                continue;
            }
            if (type != DiffType.CHANGED || isMigrateSource && operation == DirDiffOperation.COPY_FROM || !isMigrateSource && operation == DirDiffOperation.COPY_TO) continue;
            DbDiffElement source = (DbDiffElement)dirDiffElement.getSource();
            DbDiffElement target = (DbDiffElement)dirDiffElement.getTarget();
            if (source.getValue() instanceof DasTable && target.getValue() instanceof DasTable) {
                src = new DbDiffElement(source.getValue());
                trg = new DbDiffElement(target.getValue());
                src.setSettings(model.getSettings());
                trg.setSettings(model.getSettings());
                DirDiffModel newModel = DirDiffManager.getInstance((Project)project).createDiffModel((DiffElement)src, (DiffElement)trg, model.getSettings());
                DbMigrationAction.createMigration(project, newModel, builder, addKeyBuilder, dropKeyBuilder, direction);
            }
            if (!(source.getValue() instanceof DasColumn) || !(target.getValue() instanceof DasColumn)) continue;
            src = (DbColumn)source.getValue();
            trg = (DbColumn)target.getValue();
            DatabaseDialectEx dialect = isMigrateSource ? sourceDialect : targetDialect;
            dialect.sqlAlterColumnDefinition(builder, (DasColumn)(isMigrateSource ? src : trg), (DasColumn)(isMigrateSource ? trg : src), false).newStatement();
        }
    }

    private static boolean migrateTable(DdlBuilder builder, DatabaseDialectEx dialect, boolean isMigrateSource, DirDiffElement element, List<? extends DirDiffElement> children) {
        boolean create;
        DeTable table;
        DiffElement dbElement = (DiffElement)ObjectUtils.chooseNotNull((Object)element.getSource(), (Object)element.getTarget());
        DbTable value = (DbTable)ObjectUtils.tryCast((Object)(dbElement == null ? null : dbElement.getValue()), DbTable.class);
        if (value == null) {
            return false;
        }
        SchemaExportHelper helper = dialect.getSchemaEditor().createExportHelper(new DatabaseEditorContext(value.getDataSource(), null), value.getDataSource().getModel());
        DeTable deTable = table = helper.canExport((DasObject)value) ? (DeTable)ObjectUtils.tryCast(helper.export((DasObject)value, true), DeTable.class) : null;
        if (table == null) {
            return false;
        }
        HashSet tableChildren = ContainerUtil.newHashSet();
        for (DirDiffElement dirDiffElement : children) {
            DiffElement e;
            DbElement c;
            DirDiffOperation op = dirDiffElement.getOperation();
            if (op != DirDiffOperation.COPY_FROM && op != DirDiffOperation.COPY_TO && (op != DirDiffOperation.DELETE || (isMigrateSource ? dirDiffElement.getSource() : dirDiffElement.getTarget()) == null) || (c = (DbElement)ObjectUtils.tryCast((Object)((e = (DiffElement)ObjectUtils.chooseNotNull((Object)dirDiffElement.getSource(), (Object)dirDiffElement.getTarget())) == null ? null : e.getValue()), DbElement.class)) == null || !helper.canExport((DasObject)c)) continue;
            tableChildren.add(helper.export((DasObject)c, false));
        }
        boolean bl = create = (isMigrateSource ? element.getTarget() : element.getSource()) != null;
        if (tableChildren.size() == table.getChildren().size()) {
            if (create) {
                dialect.sqlCreateTable(builder, Collections.singletonList(table), false, null).newStatement();
            } else {
                dialect.sqlDropTable(builder, table, true, false, table.model).newStatement();
            }
            return true;
        }
        if (!create) {
            return false;
        }
        for (DeObject child : table.getChildren().toList()) {
            if (tableChildren.contains(child)) continue;
            table.removeChild(child);
        }
        dialect.sqlCreateTable(builder, Collections.singletonList(table), false, null).newStatement();
        return true;
    }

    public void setModel(DirDiffModel model) {
        this.myModel = model;
        String source = this.myModel.getSourceDir().getPresentablePath();
        String target = this.myModel.getTargetDir().getPresentablePath();
        this.getTemplatePresentation().setDescription("Migrate '" + (this.myDirection == Direction.FORWARD ? source : target) + "' to '" + (this.myDirection == Direction.FORWARD ? target : source) + "' state");
    }

    static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

