/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump.argument;

import com.intellij.database.dump.dbdump.DbDumpUtil;
import com.intellij.database.dump.dbdump.DumpCommandLineLexeme;
import com.intellij.database.dump.dbdump.DumpContextDescriptor;
import com.intellij.database.dump.dbdump.MysqlArguments;
import com.intellij.database.dump.dbdump.PgArguments;
import com.intellij.database.dump.dbdump.argument.DefaultValueDumpArgument;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public enum DefaultValueDumpArgumentImpl implements DefaultValueDumpArgument
{
    MYSQL_INSERT("Insert", new String[0]),
    MYSQL_INSERT_WITH_COLUMNS("Insert with columns", MysqlArguments.INSERTS_WITH_COLUMNS),
    PG_COPY("Copy", new String[0]){

        @Override
        public boolean isOnByDefault() {
            return true;
        }
    }
    ,
    PG_INSERT("Insert", "--inserts"),
    PG_INSERT_WITH_COLUMNS("Insert with columns", PgArguments.INSERTS_WITH_COLUMNS),
    PG_FILE("File", PgArguments.FILE_AND_DIR){

        @Override
        public boolean isMyLexeme(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$2", "isMyLexeme"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$2", "isMyLexeme"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$2", "isMyLexeme"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$2", "isMyLexeme"));
            }
            return super.isMyLexeme(text, current, next, cd) && (DefaultValueDumpArgumentImpl.hasParameter(text, current, next, PgArguments.FILE_PARAMETER) || DefaultValueDumpArgumentImpl.isIncorrect(text, current, next));
        }

        @Override
        @NotNull
        public String getCommandLineArgument(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$2", "getCommandLineArgument"));
            }
            String string = DbDumpUtil.extractParameterizable(PgArguments.FILE_AND_DIR) + DbDumpUtil.extractNonParameterizable(PgArguments.FILE_PARAMETER);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$2", "getCommandLineArgument"));
            }
            return string;
        }

        @Override
        public boolean isOnByDefault() {
            return true;
        }
    }
    ,
    PG_DIRECTORY("Directory", PgArguments.FILE_AND_DIR){

        @Override
        public boolean isMyLexeme(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$3", "isMyLexeme"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$3", "isMyLexeme"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$3", "isMyLexeme"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$3", "isMyLexeme"));
            }
            return super.isMyLexeme(text, current, next, cd) && DefaultValueDumpArgumentImpl.hasParameter(text, current, next, PgArguments.DIR_PARAMETERS);
        }

        @Override
        @NotNull
        public String getCommandLineArgument(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$3", "getCommandLineArgument"));
            }
            String string = DbDumpUtil.extractParameterizable(PgArguments.FILE_AND_DIR) + DbDumpUtil.extractNonParameterizable(PgArguments.DIR_PARAMETERS);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$3", "getCommandLineArgument"));
            }
            return string;
        }
    }
    ,
    PG_CUSTOM("Custom-format archive", PgArguments.FILE_AND_DIR){

        @Override
        public boolean isMyLexeme(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$4", "isMyLexeme"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$4", "isMyLexeme"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$4", "isMyLexeme"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$4", "isMyLexeme"));
            }
            return super.isMyLexeme(text, current, next, cd) && DefaultValueDumpArgumentImpl.hasParameter(text, current, next, PgArguments.CUSTOM_PARAMETERS);
        }

        @Override
        @NotNull
        public String getCommandLineArgument(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$4", "getCommandLineArgument"));
            }
            String string = DbDumpUtil.extractParameterizable(PgArguments.FILE_AND_DIR) + DbDumpUtil.extractNonParameterizable(PgArguments.CUSTOM_PARAMETERS);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$4", "getCommandLineArgument"));
            }
            return string;
        }
    }
    ,
    PG_TAR("Tar archive", PgArguments.FILE_AND_DIR){

        @Override
        public boolean isMyLexeme(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$5", "isMyLexeme"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$5", "isMyLexeme"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$5", "isMyLexeme"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$5", "isMyLexeme"));
            }
            return super.isMyLexeme(text, current, next, cd) && DefaultValueDumpArgumentImpl.hasParameter(text, current, next, PgArguments.TAR_PARAMETERS);
        }

        @Override
        @NotNull
        public String getCommandLineArgument(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$5", "getCommandLineArgument"));
            }
            String string = DbDumpUtil.extractParameterizable(PgArguments.FILE_AND_DIR) + DbDumpUtil.extractNonParameterizable(PgArguments.TAR_PARAMETERS);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl$5", "getCommandLineArgument"));
            }
            return string;
        }
    };

    private final String[] myOptions;
    private final String myUiName;

    private DefaultValueDumpArgumentImpl(String uiName, String ... options) {
        if (uiName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "<init>"));
        }
        this.myOptions = options;
        this.myUiName = uiName;
    }

    @Override
    public boolean isOnByDefault() {
        return false;
    }

    @Override
    @NotNull
    public String getCommandLineArgument(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "getCommandLineArgument"));
        }
        String string = this.myOptions.length == 0 ? "" : this.myOptions[0];
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "getCommandLineArgument"));
        }
        return string;
    }

    @Override
    public boolean isMyLexeme(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "isMyLexeme"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "isMyLexeme"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "isMyLexeme"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "isMyLexeme"));
        }
        return ArrayUtil.find((Object[])this.myOptions, (Object)current.getText()) != -1;
    }

    @Override
    @NotNull
    public String getUiName() {
        String string = this.myUiName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "getUiName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String[] getArguments() {
        if (this.myOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "getArguments"));
        }
        return this.myOptions;
    }

    private static boolean hasParameter(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, String ... parameters) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "hasParameter"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "hasParameter"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "hasParameter"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "hasParameter"));
        }
        String parameter = DbDumpUtil.cutParameter(text, current, next);
        return ArrayUtil.find((Object[])parameters, (Object)parameter) != -1;
    }

    private static boolean isIncorrect(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "isIncorrect"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "isIncorrect"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/DefaultValueDumpArgumentImpl", "isIncorrect"));
        }
        String parameter = DbDumpUtil.cutParameter(text, current, next);
        return ArrayUtil.find((Object[])PgArguments.FILE_PARAMETER, (Object)parameter) == -1 && ArrayUtil.find((Object[])PgArguments.DIR_PARAMETERS, (Object)parameter) == -1 && ArrayUtil.find((Object[])PgArguments.TAR_PARAMETERS, (Object)parameter) == -1 && ArrayUtil.find((Object[])PgArguments.CUSTOM_PARAMETERS, (Object)parameter) == -1;
    }
}

