/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump.pg;

import com.intellij.database.dump.dbdump.DumpComponent;
import com.intellij.database.dump.dbdump.DumpContextDescriptor;
import com.intellij.database.dump.dbdump.DumpSettings;
import com.intellij.database.dump.dbdump.PgArguments;
import com.intellij.database.dump.dbdump.SimpleDumpDialogValidator;
import com.intellij.database.dump.dbdump.argument.DefaultValueDumpArgumentImpl;
import com.intellij.database.dump.dbdump.argument.DumpArgument;
import com.intellij.database.dump.dbdump.argument.StringDumpArgumentImpl;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgDumpDialogValidator
extends SimpleDumpDialogValidator {
    private static final String INVALID_DIR = "Path must point on not existing directory";
    private static final String INVALID_FILE = "Path must point on file";
    private static final String DATA_ONLY = "Options \"-c/--clean\" and \"-a/--data-only\" cannot be used together";
    private static final String IF_EXISTS = "Option \"--if-exists\" requires option \"-c/--clean\"";

    public PgDumpDialogValidator() {
        super(PgArguments.OUT_PATH, PgArguments.PASSWORD);
    }

    @Override
    @Nullable
    public ValidationInfo createInfo(@NotNull DumpSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dump/dbdump/pg/PgDumpDialogValidator", "createInfo"));
        }
        ValidationInfo info = super.createInfo(settings);
        return info == null ? PgDumpDialogValidator.createInfoInternal(settings) : info;
    }

    @Nullable
    private static ValidationInfo createInfoInternal(@NotNull DumpSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dump/dbdump/pg/PgDumpDialogValidator", "createInfoInternal"));
        }
        DumpArgument argument = PgDumpDialogValidator.getFormatArgument(settings.getDumpComponents());
        DumpComponent pathComponent = PgDumpDialogValidator.getPathComponent(settings.getDumpComponents());
        if (PgDumpDialogValidator.checkFileError(pathComponent, argument)) {
            return new ValidationInfo(INVALID_FILE, ((DumpComponent)ObjectUtils.assertNotNull((Object)pathComponent)).getComponent());
        }
        if (PgDumpDialogValidator.checkDirError(pathComponent, argument)) {
            return new ValidationInfo(INVALID_DIR, ((DumpComponent)ObjectUtils.assertNotNull((Object)pathComponent)).getComponent());
        }
        DumpContextDescriptor cd = settings.getContext();
        return PgDumpDialogValidator.checkDataOnly(cd) ? new ValidationInfo(DATA_ONLY, settings.getCommandComponent()) : (PgDumpDialogValidator.checkIfExists(cd) ? new ValidationInfo(IF_EXISTS, settings.getCommandComponent()) : null);
    }

    private static boolean checkFileError(@Nullable DumpComponent component, @Nullable DumpArgument argument) {
        String text = PgDumpDialogValidator.getText(component);
        if (text == null) {
            return false;
        }
        File file = new File(text);
        return file.isDirectory() && (argument == DefaultValueDumpArgumentImpl.PG_FILE || argument == DefaultValueDumpArgumentImpl.PG_CUSTOM || argument == DefaultValueDumpArgumentImpl.PG_TAR);
    }

    private static boolean checkDirError(@Nullable DumpComponent component, @Nullable DumpArgument argument) {
        String text = PgDumpDialogValidator.getText(component);
        if (text == null) {
            return false;
        }
        File file = new File(text);
        return (file.isDirectory() && file.exists() || file.isFile()) && argument == DefaultValueDumpArgumentImpl.PG_DIRECTORY;
    }

    @Nullable
    private static String getText(@Nullable DumpComponent component) {
        if (component == null) {
            return null;
        }
        JComponent swingComponent = component.getComponent();
        if (!(swingComponent instanceof TextFieldWithBrowseButton)) {
            return null;
        }
        return ((TextFieldWithBrowseButton)swingComponent).getText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkDataOnly(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/pg/PgDumpDialogValidator", "checkDataOnly"));
        }
        if (ContainerUtil.find((Object[])PgArguments.DATA_ONLY, cd::contains) == null) return false;
        if (ContainerUtil.find((Object[])PgArguments.CLEAN_DATABASE, cd::contains) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkIfExists(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/pg/PgDumpDialogValidator", "checkIfExists"));
        }
        if (!cd.contains("--if-exists")) return false;
        if (ContainerUtil.find((Object[])PgArguments.CLEAN_DATABASE, cd::contains) != null) return false;
        return true;
    }

    @Nullable
    private static DumpArgument getFormatArgument(@NotNull List<DumpComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/database/dump/dbdump/pg/PgDumpDialogValidator", "getFormatArgument"));
        }
        Condition condition = component -> component.getArgument() == DefaultValueDumpArgumentImpl.PG_DIRECTORY || component.getArgument() == DefaultValueDumpArgumentImpl.PG_FILE || component.getArgument() == DefaultValueDumpArgumentImpl.PG_CUSTOM || component.getArgument() == DefaultValueDumpArgumentImpl.PG_TAR;
        DumpComponent component2 = (DumpComponent)ContainerUtil.find(components, (Condition)condition);
        return component2 == null ? null : component2.getArgument();
    }

    @Nullable
    private static DumpComponent getPathComponent(List<DumpComponent> components) {
        return (DumpComponent)ContainerUtil.find(components, component -> component.getArgument() == StringDumpArgumentImpl.PG_PATH);
    }
}

