/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.OraIntroQueries;
import com.intellij.database.introspection.OraIntrospector;
import com.intellij.database.introspection.OraIntrospectorFunctions$WhenMappings;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.SingletonFamily;
import com.intellij.database.model.oracle.OraModArgument;
import com.intellij.database.model.oracle.OraModCluster;
import com.intellij.database.model.oracle.OraModConstraint;
import com.intellij.database.model.oracle.OraModLikeTable;
import com.intellij.database.model.oracle.OraModModule;
import com.intellij.database.model.oracle.OraModObjectType;
import com.intellij.database.model.oracle.OraModPackage;
import com.intellij.database.model.oracle.OraModRoot;
import com.intellij.database.model.oracle.OraModRoutine;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraModSchemaObject;
import com.intellij.database.model.oracle.OraModSourceAware;
import com.intellij.database.model.oracle.OraModSynonym;
import com.intellij.database.model.oracle.OraModTable;
import com.intellij.database.model.oracle.OraModTrigger;
import com.intellij.database.model.oracle.OraModView;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.TLongHashSet;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u00bc\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0002\u001a\u001a\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0002\u001a\u001a\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0002\u001a\t\u0010\u0018\u001a\u00020\u000eH\u0086\b\u001a\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a \u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\nH\u0002\u001a<\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020\nH\u0002\u001a>\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020#2\b\u0010-\u001a\u0004\u0018\u00010\n2\b\u0010.\u001a\u0004\u0018\u00010\n2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\b\u00102\u001a\u0004\u0018\u00010\nH\u0002\u001a3\u00103\u001a\u00020\u000e2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\n052\u000e\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001f2\u0006\u00107\u001a\u000208H\u0002\u00a2\u0006\u0002\u00109\u001a\u001e\u0010:\u001a\u00020\u000e2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<2\u0006\u0010>\u001a\u00020?H\u0002\u001a\u0010\u0010@\u001a\u00020\n2\u0006\u0010A\u001a\u00020\nH\u0003\u001a$\u0010B\u001a\u00020\u000e*\u00020\u001b2\u0006\u0010C\u001a\u00020\n2\u0006\u0010A\u001a\u00020\n2\u0006\u0010D\u001a\u00020\nH\u0002\u001a\f\u0010E\u001a\u00020\n*\u00020\nH\u0000\u001a\u0016\u0010F\u001a\u0004\u0018\u00010G*\u00020H2\u0006\u0010A\u001a\u00020\nH\u0002\u001a\u0016\u0010I\u001a\u0004\u0018\u00010J*\u00020\u001b2\u0006\u0010A\u001a\u00020\nH\u0002\u001a\u0016\u0010K\u001a\u0004\u0018\u00010L*\u00020\u001b2\u0006\u0010A\u001a\u00020\nH\u0002\u001a\u0016\u0010M\u001a\u0004\u0018\u00010\u0014*\u00020\u001b2\u0006\u0010N\u001a\u00020\nH\u0002\u001a\u0015\u0010O\u001a\u000208*\u00020\f2\u0006\u0010P\u001a\u000208H\u0082\b\u001a \u0010Q\u001a\u00020\u000e*\u00020 2\b\u0010R\u001a\u0004\u0018\u00010S2\b\u0010T\u001a\u0004\u0018\u00010SH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"AUTO_NOT_NULL_CHECK_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SIMPLE_QUOTED_NAME_PATTERN", "SURROGATE_NAME_PATTERN", "SYSTEM_SCHEMAS", "Ljava/util/TreeSet;", "", "delim", "", "applyStoredProgramSources", "", "obj", "Lcom/intellij/database/model/oracle/OraModSourceAware;", "text", "applyTriggerSources", "trigger", "Lcom/intellij/database/model/oracle/OraModTrigger;", "applyViewSources", "view", "Lcom/intellij/database/model/oracle/OraModView;", "doNoting", "dropUnexistentObjectsInSchema", "schema", "Lcom/intellij/database/model/oracle/OraModSchema;", "identifiers", "Lgnu/trove/TLongHashSet;", "majorFamilyOf", "Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "Lcom/intellij/database/model/oracle/OraModSchemaObject;", "code", "makeArgument", "Lcom/intellij/database/model/basic/BasicSchema;", "routine", "Lcom/intellij/database/model/oracle/OraModRoutine;", "argName", "argDirection", "dataTypeSchemaName", "dataTypeSpec", "makeDataType", "Lcom/intellij/database/model/DataType;", "thisSchema", "typeSchemaName", "typeName", "precision", "", "scale", "units", "processNames", "items", "", "modelSchemas", "renew", "", "([Ljava/lang/String;Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;Z)V", "processSynonyms", "ss", "", "Lcom/intellij/database/introspection/OraIntroQueries$OneSynonym;", "root", "Lcom/intellij/database/model/oracle/OraModRoot;", "unquoteNameIfPossible", "name", "applySources", "type", "sourceText", "c2s", "findModConstraint", "Lcom/intellij/database/model/oracle/OraModConstraint;", "Lcom/intellij/database/model/oracle/OraTable;", "findModuleByName", "Lcom/intellij/database/model/oracle/OraModModule;", "findTableOrViewByName", "Lcom/intellij/database/model/oracle/OraModLikeTable;", "findTrigger", "triggerName", "isSameForCatalogAndScript", "atBegin", "setCreatedAndModifiedTimestamps", "createdTimestamp", "Ljava/util/Date;", "modifiedTimestamp", "database-introspection"})
@JvmName(name="OraIntrospectorFunctions")
public final class OraIntrospectorFunctions {
    private static final TreeSet<String> SYSTEM_SCHEMAS = SetsKt.sortedSetOf((Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE), (Object[])new String[]{"SYS", "SYSTEM", "CTXSYS"});
    private static final Logger LOG = Logger.getInstance(OraIntrospector.class);
    private static final Pattern SIMPLE_QUOTED_NAME_PATTERN = Pattern.compile("^\\s*\"([^\"]*)\"\\s*$");
    private static final Pattern AUTO_NOT_NULL_CHECK_PATTERN = Pattern.compile("\".+\" IS NOT NULL");
    private static final Pattern SURROGATE_NAME_PATTERN = Pattern.compile("^SYS_\\w*\\d+$");
    public static final char delim = '\uffff';

    /*
     * WARNING - void declaration
     */
    private static final void processNames(String[] items, ModNamingIdentifyingFamily<? extends OraModSchema> modelSchemas, boolean renew) {
        int n = 0;
        int n2 = ((Object[])items).length - 1;
        if (n <= n2) {
            while (true) {
                void i2;
                String item = items[i2];
                try {
                    String objectName;
                    String kindCode;
                    OraModSchema schema;
                    String objectIdStr;
                    String schemaIdStr;
                    String string;
                    boolean bl = item.length() >= 23;
                    if (_Assertions.ENABLED && !bl) {
                        string = "The item should be at least 23 characters length";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    String $i$a$1$assert = item;
                    int n3 = 0;
                    int n4 = 2;
                    String string2 = $i$a$1$assert;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n3, n4), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string = item;
                    n4 = 2;
                    int n5 = 12;
                    String string3 = string;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n4, n5), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string4 = item;
                    n5 = 12;
                    int n6 = 22;
                    String string5 = string4;
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5.substring(n5, n6), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string6 = item;
                    n6 = 22;
                    String string7 = string6;
                    if (string7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7.substring(n6), (String)"(this as java.lang.String).substring(startIndex)");
                    int schemaId = Integer.parseInt(schemaIdStr);
                    int objectId = Integer.parseInt(objectIdStr);
                    if ((OraModSchema)modelSchemas.getByObjectId((long)schemaId) == null) {
                        String string8 = "Schema should exist, id:" + schemaId;
                        throw (Throwable)new IllegalStateException(string8.toString());
                    }
                    ModNamingIdentifyingFamily<? extends OraModSchemaObject> family = OraIntrospectorFunctions.majorFamilyOf(schema, kindCode);
                    if (renew) {
                        family.renew(objectId, objectName);
                    } else {
                        OraModSchemaObject majorObject = (OraModSchemaObject)family.createOrGet(objectName);
                        majorObject.setObjectId(objectId);
                    }
                }
                catch (NumberFormatException e) {
                    LOG.warn(String.format("Failed to handle item '%s': %s: %s", item, e.getClass().getSimpleName(), e.getMessage()));
                }
                if (i2 == n2) break;
                ++i2;
            }
        }
    }

    private static final ModNamingIdentifyingFamily<? extends OraModSchemaObject> majorFamilyOf(OraModSchema schema, String code) {
        switch (code) {
            case "TA": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getTables();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.tables");
                return namingIdentifyingFamily;
            }
            case "CL": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getClusters();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.clusters");
                return namingIdentifyingFamily;
            }
            case "VI": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getViews();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.views");
                return namingIdentifyingFamily;
            }
            case "SY": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getSynonyms();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.synonyms");
                return namingIdentifyingFamily;
            }
            case "SE": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getSequences();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.sequences");
                return namingIdentifyingFamily;
            }
            case "PR": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getRoutines();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.routines");
                return namingIdentifyingFamily;
            }
            case "FU": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getRoutines();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.routines");
                return namingIdentifyingFamily;
            }
            case "PA": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getPackages();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.packages");
                return namingIdentifyingFamily;
            }
            case "MA": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getMatViews();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.matViews");
                return namingIdentifyingFamily;
            }
            case "YB": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getObjectTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.objectTypes");
                return namingIdentifyingFamily;
            }
            case "YC": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getCollectionTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.collectionTypes");
                return namingIdentifyingFamily;
            }
        }
        throw (Throwable)new IllegalArgumentException("Unknown object code: " + code);
    }

    private static final void processSynonyms(List<OraIntroQueries.OneSynonym> ss, OraModRoot root2) {
        for (OraIntroQueries.OneSynonym s : ss) {
            OraModSchema schema;
            if ((OraModSchema)root2.getSchemas().get(s.synonym_schema_name) == null) {
                continue;
            }
            OraModSynonym synonym = (OraModSynonym)schema.getSynonyms().renew(s.synonym_id, s.synonym_name);
            synonym.setCreatedTimestamp(s.created_timestamp);
            synonym.setModifiedTimestamp(s.modified_timestamp);
            synonym.setTargetSchemaName(s.origin_schema_name);
            synonym.setTargetObjectName(s.origin_object_name);
        }
    }

    private static final void dropUnexistentObjectsInSchema(OraModSchema schema, TLongHashSet identifiers) {
        ModIdentifyingFamily modIdentifyingFamily = (ModIdentifyingFamily)((Object)schema.getSequences());
        Intrinsics.checkExpressionValueIsNotNull((Object)modIdentifyingFamily, (String)"schema.sequences");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modIdentifyingFamily, identifiers);
        ModIdentifyingFamily modIdentifyingFamily2 = (ModIdentifyingFamily)((Object)schema.getClusters());
        Intrinsics.checkExpressionValueIsNotNull((Object)modIdentifyingFamily2, (String)"schema.clusters");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modIdentifyingFamily2, identifiers);
        ModIdentifyingFamily modIdentifyingFamily3 = (ModIdentifyingFamily)((Object)schema.getTables());
        Intrinsics.checkExpressionValueIsNotNull((Object)modIdentifyingFamily3, (String)"schema.tables");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modIdentifyingFamily3, identifiers);
        ModIdentifyingFamily modIdentifyingFamily4 = (ModIdentifyingFamily)((Object)schema.getMatViews());
        Intrinsics.checkExpressionValueIsNotNull((Object)modIdentifyingFamily4, (String)"schema.matViews");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modIdentifyingFamily4, identifiers);
        ModIdentifyingFamily modIdentifyingFamily5 = (ModIdentifyingFamily)((Object)schema.getViews());
        Intrinsics.checkExpressionValueIsNotNull((Object)modIdentifyingFamily5, (String)"schema.views");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modIdentifyingFamily5, identifiers);
        ModIdentifyingFamily modIdentifyingFamily6 = (ModIdentifyingFamily)((Object)schema.getPackages());
        Intrinsics.checkExpressionValueIsNotNull((Object)modIdentifyingFamily6, (String)"schema.packages");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modIdentifyingFamily6, identifiers);
        ModIdentifyingFamily modIdentifyingFamily7 = (ModIdentifyingFamily)((Object)schema.getObjectTypes());
        Intrinsics.checkExpressionValueIsNotNull((Object)modIdentifyingFamily7, (String)"schema.objectTypes");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modIdentifyingFamily7, identifiers);
        ModIdentifyingFamily modIdentifyingFamily8 = (ModIdentifyingFamily)((Object)schema.getCollectionTypes());
        Intrinsics.checkExpressionValueIsNotNull((Object)modIdentifyingFamily8, (String)"schema.collectionTypes");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modIdentifyingFamily8, identifiers);
        ModIdentifyingFamily modIdentifyingFamily9 = (ModIdentifyingFamily)((Object)schema.getRoutines());
        Intrinsics.checkExpressionValueIsNotNull((Object)modIdentifyingFamily9, (String)"schema.routines");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modIdentifyingFamily9, identifiers);
        ModIdentifyingFamily modIdentifyingFamily10 = (ModIdentifyingFamily)((Object)schema.getSynonyms());
        Intrinsics.checkExpressionValueIsNotNull((Object)modIdentifyingFamily10, (String)"schema.synonyms");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modIdentifyingFamily10, identifiers);
        for (OraModCluster cluster : schema.getClusters()) {
            SingletonFamily singletonFamily = cluster.getIndices();
            Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"cluster.indices");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModSingletonFamily<? extends BasicModIdentifiedElement>)singletonFamily, identifiers);
        }
        for (OraModLikeTable table : schema.getTables()) {
            ModIdentifyingFamily modIdentifyingFamily11 = (ModIdentifyingFamily)((Object)table.getIndices());
            Intrinsics.checkExpressionValueIsNotNull((Object)modIdentifyingFamily11, (String)"table.indices");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modIdentifyingFamily11, identifiers);
            ModIdentifyingFamily modIdentifyingFamily12 = (ModIdentifyingFamily)((Object)table.getTriggers());
            Intrinsics.checkExpressionValueIsNotNull((Object)modIdentifyingFamily12, (String)"table.triggers");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modIdentifyingFamily12, identifiers);
        }
        for (OraModLikeTable table : schema.getMatViews()) {
        }
        for (OraModView view2 : schema.getViews()) {
            ModIdentifyingFamily modIdentifyingFamily13 = (ModIdentifyingFamily)((Object)view2.getTriggers());
            Intrinsics.checkExpressionValueIsNotNull((Object)modIdentifyingFamily13, (String)"view.triggers");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modIdentifyingFamily13, identifiers);
        }
        for (OraModPackage pack : schema.getPackages()) {
            SingletonFamily singletonFamily = pack.getBodies();
            Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"pack.bodies");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModSingletonFamily<? extends BasicModIdentifiedElement>)singletonFamily, identifiers);
        }
        for (OraModObjectType ot : schema.getObjectTypes()) {
            SingletonFamily singletonFamily = ot.getBodies();
            Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"ot.bodies");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModSingletonFamily<? extends BasicModIdentifiedElement>)singletonFamily, identifiers);
        }
    }

    private static final void setCreatedAndModifiedTimestamps(@NotNull OraModSchemaObject $receiver, Date createdTimestamp, Date modifiedTimestamp) {
        $receiver.setCreatedTimestamp(createdTimestamp);
        $receiver.setModifiedTimestamp(modifiedTimestamp);
    }

    private static final OraModLikeTable findTableOrViewByName(@NotNull OraModSchema $receiver, String name) {
        OraModLikeTable oraModLikeTable;
        OraModLikeTable oraModLikeTable2 = (OraModLikeTable)$receiver.getTables().get(name);
        if (oraModLikeTable2 == null) {
            oraModLikeTable2 = oraModLikeTable = (OraModLikeTable)$receiver.getMatViews().get(name);
        }
        if (oraModLikeTable2 == null) {
            oraModLikeTable = (OraModLikeTable)$receiver.getViews().get(name);
        }
        return oraModLikeTable;
    }

    private static final OraModModule findModuleByName(@NotNull OraModSchema $receiver, String name) {
        OraModModule oraModModule = (OraModModule)$receiver.getObjectTypes().get(name);
        if (oraModModule == null) {
            oraModModule = (OraModModule)$receiver.getPackages().get(name);
        }
        return oraModModule;
    }

    private static final OraModConstraint findModConstraint(@NotNull OraTable $receiver, String name) {
        OraModConstraint oraModConstraint;
        OraModConstraint oraModConstraint2 = (OraModConstraint)$receiver.getKeys().get(name);
        if (oraModConstraint2 == null) {
            oraModConstraint2 = oraModConstraint = (OraModConstraint)$receiver.getForeignKeys().get(name);
        }
        if (oraModConstraint2 == null) {
            oraModConstraint = (OraModConstraint)$receiver.getChecks().get(name);
        }
        return oraModConstraint;
    }

    private static final OraModTrigger findTrigger(@NotNull OraModSchema $receiver, String triggerName) {
        OraModTrigger trigger2;
        for (OraModTable table : $receiver.getTables()) {
            trigger2 = (OraModTrigger)table.getTriggers().get(triggerName);
            if (trigger2 == null) continue;
            return trigger2;
        }
        for (OraModLikeTable view2 : $receiver.getViews()) {
            trigger2 = (OraModTrigger)view2.getTriggers().get(triggerName);
            if (trigger2 == null) continue;
            return trigger2;
        }
        for (OraModLikeTable view2 : $receiver.getMatViews()) {
            trigger2 = (OraModTrigger)view2.getTriggers().get(triggerName);
            if (trigger2 == null) continue;
            return trigger2;
        }
        return null;
    }

    @Contract(pure=true)
    private static final String unquoteNameIfPossible(String name) {
        Matcher m = SIMPLE_QUOTED_NAME_PATTERN.matcher(name);
        if (m.matches()) {
            String string = m.group(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(1)");
            return string;
        }
        return name;
    }

    private static final void makeArgument(BasicSchema schema, OraModRoutine routine2, String argName, char argDirection, String dataTypeSchemaName, String dataTypeSpec) {
        OraModArgument argument;
        DasArgument.Direction dir = DasArgument.Direction.of((char)argDirection);
        if (dir == null && argName != null) {
            dir = DasArgument.Direction.IN;
        }
        if (dir == null) {
            dir = DasArgument.Direction.IN;
        }
        if (Intrinsics.areEqual((Object)dir, (Object)DasArgument.Direction.RETURN)) {
            BasicModArgument basicModArgument = routine2.createOrGetReturnArgument();
            if (basicModArgument == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraModArgument");
            }
            argument = (OraModArgument)basicModArgument;
            argument.setRealName(argName);
        } else if (argName != null) {
            Object e = routine2.getArguments().createOrGet(argName);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"routine.arguments.createOrGet(argName)");
            argument = (OraModArgument)e;
            argument.setArgumentDirection(dir);
        } else {
            return;
        }
        DataType dataType = OraIntrospectorFunctions.makeDataType(schema, dataTypeSchemaName, dataTypeSpec, -1, 0, null);
        argument.setDataType(dataType);
    }

    private static final DataType makeDataType(BasicSchema thisSchema, String typeSchemaName, String typeName, int precision, int scale, String units) {
        DataType type;
        if (typeName == null) {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataType.UNKNOWN");
            type = dataType;
        } else if (StringsKt.contains$default((CharSequence)typeName, (CharSequence)"(", (boolean)false, (int)2, null)) {
            DataType dataType = DataTypeFactory.of(typeName);
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(typeName)");
            type = dataType;
        } else {
            DataType dataType;
            String explicitSchemaName;
            boolean customType;
            boolean explicitUnits = (StringsKt.equals((String)typeName, (String)"varchar", (boolean)true) || StringsKt.equals((String)typeName, (String)"char", (boolean)true)) && units != null && StringsKt.equals((String)units, (String)"C", (boolean)true);
            boolean bl = customType = typeSchemaName != null;
            String string = customType ? (Intrinsics.areEqual((Object)thisSchema.getRealName(), (Object)typeSchemaName) ? (String)null : typeSchemaName) : (explicitSchemaName = (String)null);
            if (customType) {
                DataType dataType2 = DataTypeFactory.of(explicitSchemaName, typeName, -1, 0, null, null, false, true);
                dataType = dataType2;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType2, (String)"DataTypeFactory.of(expli\u2026 null, null, false, true)");
            } else {
                DataType dataType3 = DataTypeFactory.of(null, typeName, precision, scale, LengthUnit.of((String)units), null, explicitUnits, false);
                dataType = dataType3;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType3, (String)"DataTypeFactory.of(null,\u2026ll, explicitUnits, false)");
            }
            type = dataType;
        }
        return type;
    }

    private static final void applySources(@NotNull OraModSchema $receiver, String type, String name, String sourceText) {
        OraModSourceAware oraModSourceAware;
        CharSequence charSequence = sourceText;
        if (charSequence.length() == 0) {
            return;
        }
        switch (type) {
            case "TYPE": {
                OraModSourceAware oraModSourceAware2 = (OraModSourceAware)$receiver.getObjectTypes().createOrGet(name);
                oraModSourceAware = oraModSourceAware2;
                Intrinsics.checkExpressionValueIsNotNull((Object)oraModSourceAware2, (String)"this.objectTypes.createOrGet(name)");
                break;
            }
            case "TYPE BODY": {
                OraModSourceAware oraModSourceAware3 = (OraModSourceAware)((OraModObjectType)$receiver.getObjectTypes().createOrGet(name)).getBodies().createOrGet();
                oraModSourceAware = oraModSourceAware3;
                Intrinsics.checkExpressionValueIsNotNull((Object)oraModSourceAware3, (String)"this.objectTypes.createO\u2026ame).bodies.createOrGet()");
                break;
            }
            case "PACKAGE": {
                OraModSourceAware oraModSourceAware4 = (OraModSourceAware)$receiver.getPackages().createOrGet(name);
                oraModSourceAware = oraModSourceAware4;
                Intrinsics.checkExpressionValueIsNotNull((Object)oraModSourceAware4, (String)"this.packages.createOrGet(name)");
                break;
            }
            case "PACKAGE BODY": {
                OraModSourceAware oraModSourceAware5 = (OraModSourceAware)((OraModPackage)$receiver.getPackages().createOrGet(name)).getBodies().createOrGet();
                oraModSourceAware = oraModSourceAware5;
                Intrinsics.checkExpressionValueIsNotNull((Object)oraModSourceAware5, (String)"this.packages.createOrGe\u2026ame).bodies.createOrGet()");
                break;
            }
            case "PROCEDURE": 
            case "FUNCTION": {
                OraModSourceAware oraModSourceAware6 = (OraModSourceAware)$receiver.getRoutines().createOrGet(name);
                oraModSourceAware = oraModSourceAware6;
                Intrinsics.checkExpressionValueIsNotNull((Object)oraModSourceAware6, (String)"this.routines.createOrGet(name)");
                break;
            }
            default: {
                return;
            }
        }
        OraModSourceAware sourceAware = oraModSourceAware;
        OraIntrospectorFunctions.applyStoredProgramSources(sourceAware, sourceText);
    }

    private static final void applyStoredProgramSources(OraModSourceAware obj, String text) {
        obj.setSourceText(text != null ? "create " + text : (String)null);
        obj.setObfuscated(false);
    }

    private static final void applyViewSources(OraModView view2, String text) {
        if (text == null) {
            view2.setSourceText(null);
            return;
        }
        String sourceText = "create view " + OraIntrospectorFunctions.c2s(view2.getName()) + " as" + "\n" + text + "\n";
        view2.setSourceText(sourceText);
    }

    private static final void applyTriggerSources(OraModTrigger trigger2, String text) {
        int n;
        Object object;
        Object object2;
        BasicNode basicNode;
        int tableColumnsCount;
        if (text == null) {
            trigger2.setSourceText(null);
            return;
        }
        BasicLikeTable table = trigger2.getTable();
        if (table == null) {
            LOG.warn("While processing a trigger sources, the related table is unknown");
        }
        int n2 = tableColumnsCount = (basicNode = table) != null && (basicNode = basicNode.getColumns()) != null ? basicNode.size() : 0;
        Object object3 = table;
        if (object3 == null || (object3 = object3.getRealName()) == null) {
            object3 = object2 = trigger2.getTableName();
        }
        if (object3 == null) {
            BasicElement basicElement = trigger2.getDbParent();
            object2 = object = basicElement != null ? basicElement.getRealName() : null;
        }
        if (object2 == null) {
            object = "UNKNOWN_TABLE";
        }
        Object tableName = object;
        TrigTurn turn = trigger2.getTurn();
        Set<TrigEvent> events = trigger2.getEvents();
        boolean onInsert = events.contains((Object)TrigEvent.INSERT);
        boolean onUpdate = events.contains((Object)TrigEvent.UPDATE);
        boolean onDelete = events.contains((Object)TrigEvent.DELETE);
        List<String> specificColumns = trigger2.getColNames();
        boolean explicitColumns = table instanceof OraTable && onUpdate && 1 <= (n = specificColumns.size()) && n <= tableColumnsCount - 1;
        StringBuilder b = new StringBuilder(text.length() + 60);
        b.append("create trigger ").append(OraIntrospectorFunctions.c2s(trigger2.getName())).append('\n');
        TrigTurn trigTurn = turn;
        if (trigTurn != null) {
            switch (OraIntrospectorFunctions$WhenMappings.$EnumSwitchMapping$0[trigTurn.ordinal()]) {
                case 1: 
                case 2: {
                    b.append("\tbefore ");
                    break;
                }
                case 3: 
                case 4: {
                    b.append("\tafter ");
                    break;
                }
                case 5: {
                    b.append("\tinstead of ");
                    break;
                }
            }
        }
        if (onInsert) {
            b.append("insert");
        }
        if (onInsert && onUpdate) {
            b.append(" or ");
        }
        if (onUpdate) {
            b.append("update");
        }
        if (explicitColumns) {
            b.append(" of ").append(CollectionsKt.joinToString$default((Iterable)specificColumns, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        if ((onInsert || onUpdate) && onDelete) {
            b.append(" or ");
        }
        if (onDelete) {
            b.append("delete");
        }
        b.append('\n');
        b.append("\ton ").append((String)tableName).append('\n');
        if (Intrinsics.areEqual((Object)((Object)turn), (Object)((Object)TrigTurn.BEFORE_ROW)) || Intrinsics.areEqual((Object)((Object)turn), (Object)((Object)TrigTurn.AFTER_ROW)) || Intrinsics.areEqual((Object)((Object)turn), (Object)((Object)TrigTurn.INSTEAD_OF))) {
            b.append("\tfor each row\n");
        }
        b.append(text);
        trigger2.setSourceText(b.toString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String c2s(@NotNull String $receiver) {
        char c;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int n = $receiver.length();
        boolean ok = true;
        for (int p = 0; p < n; ++p) {
            void atBegin$iv;
            void $receiver$iv;
            c = $receiver.charAt(p);
            boolean bl = p == 0;
            boolean bl2 = ok = Character.isUpperCase((char)$receiver$iv) || $receiver$iv >= 48 && $receiver$iv <= 57 && atBegin$iv == false || $receiver$iv == 95 || $receiver$iv == 35 || $receiver$iv == 36;
            if (!ok) break;
        }
        if (ok) {
            return $receiver;
        }
        c = '\"';
        String string = StringsKt.replace$default((String)$receiver, (String)"\"", (String)"\"\"", (boolean)false, (int)4, null);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = String.valueOf(c) + string;
        return stringBuilder.append(string2).append('\"').toString();
    }

    private static final boolean isSameForCatalogAndScript(char $receiver, boolean atBegin) {
        return Character.isUpperCase($receiver) || $receiver >= '0' && $receiver <= '9' && !atBegin || $receiver == '_' || $receiver == '#' || $receiver == '$';
    }

    public static final void doNoting() {
    }

    public static final /* synthetic */ void access$processNames(@NotNull String[] items, @NotNull ModNamingIdentifyingFamily modelSchemas, boolean renew) {
        OraIntrospectorFunctions.processNames(items, modelSchemas, renew);
    }

    public static final /* synthetic */ void access$processSynonyms(@NotNull List ss, @NotNull OraModRoot root2) {
        OraIntrospectorFunctions.processSynonyms(ss, root2);
    }

    public static final /* synthetic */ void access$dropUnexistentObjectsInSchema(@NotNull OraModSchema schema, @NotNull TLongHashSet identifiers) {
        OraIntrospectorFunctions.dropUnexistentObjectsInSchema(schema, identifiers);
    }

    @NotNull
    public static final /* synthetic */ TreeSet access$getSYSTEM_SCHEMAS$p() {
        return SYSTEM_SCHEMAS;
    }

    public static final /* synthetic */ void access$setCreatedAndModifiedTimestamps(@NotNull OraModSchemaObject $receiver, @Nullable Date createdTimestamp, @Nullable Date modifiedTimestamp) {
        OraIntrospectorFunctions.setCreatedAndModifiedTimestamps($receiver, createdTimestamp, modifiedTimestamp);
    }

    @NotNull
    public static final /* synthetic */ DataType access$makeDataType(@NotNull BasicSchema thisSchema, @Nullable String typeSchemaName, @Nullable String typeName, int precision, int scale, @Nullable String units) {
        return OraIntrospectorFunctions.makeDataType(thisSchema, typeSchemaName, typeName, precision, scale, units);
    }

    public static final /* synthetic */ Pattern access$getSURROGATE_NAME_PATTERN$p() {
        return SURROGATE_NAME_PATTERN;
    }

    @NotNull
    public static final /* synthetic */ String access$unquoteNameIfPossible(@NotNull String name) {
        return OraIntrospectorFunctions.unquoteNameIfPossible(name);
    }

    public static final /* synthetic */ Pattern access$getAUTO_NOT_NULL_CHECK_PATTERN$p() {
        return AUTO_NOT_NULL_CHECK_PATTERN;
    }

    @Nullable
    public static final /* synthetic */ OraModConstraint access$findModConstraint(@NotNull OraTable $receiver, @NotNull String name) {
        return OraIntrospectorFunctions.findModConstraint($receiver, name);
    }

    @Nullable
    public static final /* synthetic */ OraModLikeTable access$findTableOrViewByName(@NotNull OraModSchema $receiver, @NotNull String name) {
        return OraIntrospectorFunctions.findTableOrViewByName($receiver, name);
    }

    @Nullable
    public static final /* synthetic */ OraModModule access$findModuleByName(@NotNull OraModSchema $receiver, @NotNull String name) {
        return OraIntrospectorFunctions.findModuleByName($receiver, name);
    }

    public static final /* synthetic */ void access$makeArgument(@NotNull BasicSchema schema, @NotNull OraModRoutine routine2, @Nullable String argName, char argDirection, @Nullable String dataTypeSchemaName, @NotNull String dataTypeSpec) {
        OraIntrospectorFunctions.makeArgument(schema, routine2, argName, argDirection, dataTypeSchemaName, dataTypeSpec);
    }

    public static final /* synthetic */ void access$applyViewSources(@NotNull OraModView view2, @Nullable String text) {
        OraIntrospectorFunctions.applyViewSources(view2, text);
    }

    public static final /* synthetic */ void access$applyTriggerSources(@NotNull OraModTrigger trigger2, @Nullable String text) {
        OraIntrospectorFunctions.applyTriggerSources(trigger2, text);
    }

    public static final /* synthetic */ void access$applySources(@NotNull OraModSchema $receiver, @NotNull String type, @NotNull String name, @NotNull String sourceText) {
        OraIntrospectorFunctions.applySources($receiver, type, name, sourceText);
    }

    @Nullable
    public static final /* synthetic */ OraModTrigger access$findTrigger(@NotNull OraModSchema $receiver, @NotNull String triggerName) {
        return OraIntrospectorFunctions.findTrigger($receiver, triggerName);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

