/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.BaseSingleDatabaseIntrospector;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.introspection.SqliteIntroQueries;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.database.model.sqlite.SqliteModCheck;
import com.intellij.database.model.sqlite.SqliteModForeignKey;
import com.intellij.database.model.sqlite.SqliteModIndex;
import com.intellij.database.model.sqlite.SqliteModKey;
import com.intellij.database.model.sqlite.SqliteModLikeColumn;
import com.intellij.database.model.sqlite.SqliteModLikeTable;
import com.intellij.database.model.sqlite.SqliteModModel;
import com.intellij.database.model.sqlite.SqliteModRoot;
import com.intellij.database.model.sqlite.SqliteModSchema;
import com.intellij.database.model.sqlite.SqliteModTable;
import com.intellij.database.model.sqlite.SqliteModTableColumn;
import com.intellij.database.model.sqlite.SqliteModTrigger;
import com.intellij.database.model.sqlite.SqliteModView;
import com.intellij.database.model.sqlite.SqliteSchema;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlForeignKeyDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.script.SqlReader;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransaction;
import org.jetbrains.dekaf.exceptions.DBException;

public class SqliteIntrospector
extends BaseSingleDatabaseIntrospector<SqliteModModel, SqliteModRoot, SqliteSchema, SqliteModSchema> {
    private static final SequenceIdentity SEQUENCE_IDENTITY = SequenceIdentity.of(1L, null, 1L, null);
    private static final Logger LOG = Logger.getInstance(SqliteIntrospector.class);
    private final SqlReader myReader;
    private final SqlLanguageDialect myLanguage;

    protected SqliteIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/introspection/SqliteIntrospector", "<init>"));
        }
        super(facade, SqliteModModel.class, SqliteModRoot.class, SqliteModSchema.class);
        this.myReader = SqlPsiFacade.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).createSqlReader();
        this.myLanguage = (SqlLanguageDialect)ObjectUtils.assertNotNull((Object)((SqlLanguageDialect)Language.findLanguageByID((String)"SQLite")));
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends SqliteSchema> schemas2) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/database/introspection/SqliteIntrospector", "introspectSchemasAuto"));
        }
        if (schemas2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/database/introspection/SqliteIntrospector", "introspectSchemasAuto"));
        }
        for (SqliteSchema sqliteSchema : schemas2) {
            SqliteSchemaRetriever retriever = new SqliteSchemaRetriever(tran, sqliteSchema);
            retriever.init();
            retriever.process();
        }
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/database/introspection/SqliteIntrospector", "introspectNamespacesInTran"));
        }
        List schemaInfos = (List)tran.query(SqliteIntroQueries.QUERIES.listSchemas).run();
        this.applySchemas(schemaInfos);
    }

    @Override
    public void retrieveAndApplySchemas() {
        List schemaInfos = (List)this.getDbFacade().inTransaction((InTransaction)new InTransaction<List<SqliteIntroQueries.SchemaInfo>>(){

            public List<SqliteIntroQueries.SchemaInfo> run(@NotNull DBTransaction tran) {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/database/introspection/SqliteIntrospector$1", "run"));
                }
                return (List)tran.query(SqliteIntroQueries.QUERIES.listSchemas).run();
            }
        });
        this.applySchemas(schemaInfos);
    }

    private void applySchemas(List<SqliteIntroQueries.SchemaInfo> schemaInfos) {
        ((SqliteModModel)this.getModel()).modify(r -> {
            this.updateStatus("introspecting schemas", "");
            NamingFamily schemas2 = r.getSchemas();
            boolean wasEmpty = schemas2.isEmpty();
            schemas2.markChildrenAsSyncPending();
            for (SqliteIntroQueries.SchemaInfo schemaInfo : schemaInfos) {
                SqliteModSchema schema = (SqliteModSchema)schemas2.createOrGet(schemaInfo.name);
                boolean main = SqliteIntrospector.isMain(schemaInfo.name);
                boolean temp = SqliteIntrospector.isTemp(schemaInfo.name);
                if (!wasEmpty || !main && !temp) continue;
                schema.setCurrent(main);
                schema.setVisible(true);
            }
            schemas2.removeSyncPendingChildren();
        });
    }

    private static boolean isMain(String name) {
        return "main".equals(name);
    }

    private static boolean isTemp(String name) {
        return "temp".equals(name);
    }

    private static ObjectKind getKind(String type) {
        return "table".equals(type) ? ObjectKind.TABLE : ("view".equals(type) ? ObjectKind.VIEW : ("index".equals(type) ? ObjectKind.INDEX : ("trigger".equals(type) ? ObjectKind.TRIGGER : null)));
    }

    private class SqliteSchemaRetriever
    extends BaseIntrospector.SchemaRetriever {
        public SqliteSchemaRetriever(@NotNull DBTransaction transaction, SqliteSchema schema) {
            if (transaction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "<init>"));
            }
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "<init>"));
            }
            super((BaseIntrospector)SqliteIntrospector.this, transaction, (BasicSchema)schema, IntrospectionMode.INCREMENT);
        }

        @Override
        protected void prepareParameters() {
            SqliteIntrospector.this.queryParameters.put("SCHEMA", SqliteIntroQueries.quote(((SqliteSchema)this.getSchema()).getName()));
            super.prepareParameters();
        }

        @Override
        protected void retrieveMainContent() {
            SqliteIntrospector.this.updateStatus(String.format("introspecting schema %s", ((SqliteSchema)this.getSchema()).getName()), "");
            this.retrieveTablesAndViews();
            this.retrieveColumns();
            this.retrieveIndicesAndForeignKeys();
            this.retrieveSourcesAndExtras();
        }

        private void retrieveTablesAndViews() {
            SqliteIntrospector.this.updateDetails("introspecting tables and views");
            boolean temp = SqliteIntrospector.isTemp(((SqliteSchema)this.getSchema()).getName());
            List<SqliteIntroQueries.MajorInfo> majorInfos = this.performQuery(temp ? SqliteIntroQueries.QUERIES.retrieveTempMajors : SqliteIntroQueries.QUERIES.retrieveMajors);
            ((SqliteModModel)this.getModel()).modify((BasicElement)this.getSchema(), SqliteModSchema.class, s -> s.getModel().writeSources(() -> {
                s.getTables().markChildrenAsSyncPending();
                s.getViews().markChildrenAsSyncPending();
                s.getTables().createOrGet(temp ? "sqlite_temp_master" : "sqlite_master");
                for (SqliteIntroQueries.MajorInfo majorInfo : majorInfos) {
                    ObjectKind kind = SqliteIntrospector.getKind(majorInfo.type);
                    if (kind == ObjectKind.TABLE) {
                        SqliteModTable table = (SqliteModTable)s.getTables().createOrGet(majorInfo.name);
                        table.setTemporary(temp);
                        continue;
                    }
                    if (kind != ObjectKind.VIEW) continue;
                    s.getViews().createOrGet(majorInfo.name);
                }
                s.getTables().removeSyncPendingChildren();
                s.getTables().sort();
                s.getViews().removeSyncPendingChildren();
                s.getViews().sort();
            }));
        }

        private void retrieveColumns() {
            ((SqliteModModel)this.getModel()).modify((BasicElement)this.getSchema(), SqliteModSchema.class, s -> s.getModel().writeSources(() -> {
                for (SqliteModLikeTable table : s.getTables()) {
                    this.retrieveColumns(table);
                }
                for (SqliteModLikeTable table : s.getViews()) {
                    this.retrieveColumns(table);
                }
            }));
        }

        private void retrieveIndicesAndForeignKeys() {
            ((SqliteModModel)this.getModel()).modify((BasicElement)this.getSchema(), SqliteModSchema.class, s -> s.getModel().writeSources(() -> {
                for (SqliteModTable table : s.getTables()) {
                    this.retrieveIndicesAndForeignKeys(table);
                }
            }));
        }

        private void retrieveIndicesAndForeignKeys(@NotNull SqliteModTable table) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "retrieveIndicesAndForeignKeys"));
            }
            this.getQueryParameters().put("TABLE", SqliteIntroQueries.quote(table.getName()));
            this.retrieveIndices(table);
            for (SqliteModIndex index : table.getIndices()) {
                this.retrieveIndexColumns(index);
            }
            this.retrieveForeignKeys(table);
        }

        private void retrieveIndexColumns(@NotNull SqliteModIndex index) {
            if (index == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "retrieveIndexColumns"));
            }
            SqliteIntrospector.this.updateDetails(String.format("introspecting columns of index %s", index.getName()));
            this.getQueryParameters().put("INDEX", SqliteIntroQueries.quote(index.getName()));
            try {
                List<SqliteIntroQueries.IndexColumnInfo> indexColumnInfos = this.performQuery(SqliteIntroQueries.QUERIES.listIndexColumns);
                indexColumnInfos.sort((o1, o2) -> Comparing.compare((Comparable)o1.seqno, (Comparable)o2.seqno));
                ArrayList cols = ContainerUtil.newArrayListWithCapacity((int)indexColumnInfos.size());
                LinkedHashSet rev = ContainerUtil.newLinkedHashSet();
                int cnt = 1;
                String prefix = null;
                for (SqliteIntroQueries.IndexColumnInfo info : indexColumnInfos) {
                    String name;
                    if (info.key != 1) continue;
                    if (info.name != null) {
                        name = info.name;
                    } else {
                        if (prefix == null) {
                            prefix = this.findPlaceholderPrefix(indexColumnInfos);
                        }
                        name = prefix + cnt;
                        ++cnt;
                    }
                    cols.add(name);
                    if (info.desc != 1) continue;
                    rev.add(name);
                }
                index.setColNames(cols);
                index.setReverseColNames(rev);
            }
            catch (DBException e) {
                LOG.warn(String.format("Failed to retrieve columns of index %s", index.getName()), (Throwable)e);
            }
        }

        private String findPlaceholderPrefix(List<SqliteIntroQueries.IndexColumnInfo> indexColumnInfos) {
            int num = 0;
            for (SqliteIntroQueries.IndexColumnInfo info : indexColumnInfos) {
                int cnt;
                if (info.name == null) continue;
                for (cnt = 0; cnt < info.name.length() && info.name.charAt(cnt) == '#'; ++cnt) {
                }
                if (num >= cnt) continue;
                num = cnt;
            }
            return StringUtil.repeat((String)"#", (int)(num + 1));
        }

        private void retrieveIndices(@NotNull SqliteModTable table) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "retrieveIndices"));
            }
            SqliteIntrospector.this.updateDetails(String.format("introspecting indices of %s", table.getName()));
            NamingFamily indices = table.getIndices();
            indices.markChildrenAsSyncPending();
            try {
                List<SqliteIntroQueries.IndexInfo> indexInfos = this.performQuery(SqliteIntroQueries.QUERIES.listIndices);
                for (SqliteIntroQueries.IndexInfo indexInfo : indexInfos) {
                    SqliteModIndex index = (SqliteModIndex)indices.createOrGet(indexInfo.name);
                    index.setUnique(indexInfo.unique == 1);
                }
            }
            catch (DBException e) {
                LOG.warn(String.format("Failed to retrieve indices of %s", table.getName()), (Throwable)e);
            }
            indices.removeSyncPendingChildren();
            indices.sort();
        }

        private void retrieveForeignKeys(@NotNull SqliteModTable table) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "retrieveForeignKeys"));
            }
            SqliteIntrospector.this.updateDetails(String.format("introspecting foreign keys of %s", table.getName()));
            NamingFamily foreignKeys = table.getForeignKeys();
            foreignKeys.markChildrenAsSyncPending();
            try {
                List<SqliteIntroQueries.ForeignKeyInfo> foreignKeyInfos = this.performQuery(SqliteIntroQueries.QUERIES.listForeignKeys);
                TIntObjectHashMap groups = new TIntObjectHashMap();
                for (SqliteIntroQueries.ForeignKeyInfo foreignKeyInfo : foreignKeyInfos) {
                    List list = (List)groups.get(foreignKeyInfo.id.intValue());
                    if (list == null) {
                        list = ContainerUtil.newArrayList();
                        groups.put(foreignKeyInfo.id.intValue(), (Object)list);
                    }
                    list.add(foreignKeyInfo);
                }
                HashSet visited = ContainerUtil.newHashSet();
                groups.forEachValue(arg_0 -> this.lambda$retrieveForeignKeys$8((ModNamingFamily)foreignKeys, visited, arg_0));
            }
            catch (DBException e) {
                LOG.warn(String.format("Failed to retrieve foreign keys of %s", table.getName()), (Throwable)e);
            }
            foreignKeys.removeSyncPendingChildren();
        }

        private void retrieveColumns(@NotNull SqliteModLikeTable table) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "retrieveColumns"));
            }
            this.getQueryParameters().put("TABLE", SqliteIntroQueries.quote(table.getName()));
            SqliteIntrospector.this.updateDetails(String.format("introspecting columns of %s", table.getName()));
            PositioningNamingFamily columns = table.getColumns();
            columns.markChildrenAsSyncPending();
            try {
                if (table instanceof SqliteModView) {
                    ((SqliteModView)table).setInvalid(false);
                }
                List<SqliteIntroQueries.ColumnInfo> columnInfos = this.performQuery(SqliteIntroQueries.QUERIES.listColumns);
                for (SqliteIntroQueries.ColumnInfo columnInfo : columnInfos) {
                    SqliteModLikeColumn column = (SqliteModLikeColumn)columns.createOrGetAt(columnInfo.cid.shortValue());
                    column.setName(columnInfo.name);
                    column.setDataType(DataTypeFactory.of(columnInfo.type));
                    column.setNotNull(columnInfo.notnull == 1);
                    column.setDefaultExpression(columnInfo.dflt_value);
                }
            }
            catch (DBException e) {
                String msg = e.getMessage();
                if (msg != null && msg.contains("no such table")) {
                    if (table instanceof SqliteModView) {
                        ((SqliteModView)table).setInvalid(true);
                    }
                }
                LOG.warn(String.format("Failed to retrieve columns of %s", table.getName()), (Throwable)e);
            }
            columns.removeSyncPendingChildren();
        }

        private void retrieveSourcesAndExtras() {
            List<SqliteIntroQueries.SourceInfo> sourceInfos = this.performQuery(SqliteIntrospector.isTemp(((SqliteSchema)this.getSchema()).getName()) ? SqliteIntroQueries.QUERIES.retrieveTempSources : SqliteIntroQueries.QUERIES.retrieveSources);
            ((SqliteModModel)this.getModel()).modify((BasicElement)this.getSchema(), SqliteModSchema.class, s -> s.getModel().writeSources(() -> {
                for (SqliteModLikeTable t : s.getTables()) {
                    t.getTriggers().markChildrenAsSyncPending();
                }
                for (SqliteModLikeTable t : s.getViews()) {
                    t.getTriggers().markChildrenAsSyncPending();
                }
                for (SqliteIntroQueries.SourceInfo sourceInfo : sourceInfos) {
                    SqliteIntrospector.this.updateDetails(String.format("introspecting sources of %s %s", sourceInfo.type, sourceInfo.name));
                    SqliteModLikeTable table = (SqliteModLikeTable)s.getLikeTable(sourceInfo.tbl_name);
                    if (table == null) continue;
                    ObjectKind kind = SqliteIntrospector.getKind(sourceInfo.type);
                    if (kind == ObjectKind.TRIGGER) {
                        this.fillTrigger(sourceInfo, table);
                        continue;
                    }
                    if (kind == ObjectKind.INDEX) {
                        this.fillIndex(sourceInfo, table);
                        continue;
                    }
                    if (kind == ObjectKind.TABLE) {
                        this.fillTable(sourceInfo, table);
                        continue;
                    }
                    if (kind != ObjectKind.VIEW) continue;
                    this.fillView(sourceInfo, table);
                }
                for (SqliteModLikeTable t : s.getTables()) {
                    t.getTriggers().removeSyncPendingChildren();
                    t.getTriggers().sort();
                    t.getForeignKeys().sort();
                    t.getIndices().sort();
                    Iterator iterator = t.getKeys().iterator();
                    while (iterator.hasNext()) {
                        SqliteModKey key;
                        List<String> cols = (key = (SqliteModKey)iterator.next()).getColNames();
                        SqliteModIndex index = this.findAutoIndexByCols((SqliteModTable)t, cols);
                        key.setUnderlyingIndexName(index == null ? null : index.getName());
                    }
                }
                for (SqliteModLikeTable t : s.getViews()) {
                    t.getTriggers().removeSyncPendingChildren();
                    t.getTriggers().sort();
                }
            }));
        }

        private void fillView(SqliteIntroQueries.SourceInfo info, SqliteModLikeTable tbl) {
            SqliteModView view2 = (SqliteModView)ObjectUtils.tryCast((Object)tbl, SqliteModView.class);
            if (view2 == null) {
                return;
            }
            view2.setSourceText(info.sql);
        }

        private void fillTable(SqliteIntroQueries.SourceInfo info, SqliteModLikeTable tbl) {
            SqliteModTable table = (SqliteModTable)ObjectUtils.tryCast((Object)tbl, SqliteModTable.class);
            if (table == null) {
                return;
            }
            table.getKeys().markChildrenAsSyncPending();
            table.getChecks().markChildrenAsSyncPending();
            SqlCreateTableStatement stmt = this.getStatement(info.sql, SqlCreateTableStatement.class);
            SqlDefinition[] defs = (SqlDefinition[])PsiTreeUtil.getChildrenOfType((PsiElement)stmt, SqlDefinition.class);
            if (defs != null) {
                for (SqlDefinition[] column : table.getColumns()) {
                    column.setSequenceIdentity(null);
                }
                ArrayList foreignKeys = ContainerUtil.newArrayList();
                for (SqlDefinition def : defs) {
                    if (def instanceof SqlColumnDefinition) {
                        this.fillColumn(table, (SqlColumnDefinition)def, foreignKeys);
                        continue;
                    }
                    if (def instanceof SqlForeignKeyDefinition) {
                        foreignKeys.add((SqlForeignKeyDefinition)def);
                        continue;
                    }
                    if (def instanceof SqlTableKeyDefinition) {
                        this.fillTableKey(table, (SqlTableKeyDefinition)def);
                        continue;
                    }
                    if (!(def instanceof SqlConstraintDefinition)) continue;
                    this.fillConstraint(table, (SqlConstraintDefinition)def);
                }
                foreignKeys.sort((o1, o2) -> StringUtil.isEmpty((String)o1.getName()) ? (StringUtil.isEmpty((String)o2.getName()) ? 0 : 1) : (StringUtil.isEmpty((String)o2.getName()) ? -1 : 0));
                HashSet visited = ContainerUtil.newHashSet();
                for (SqlForeignKeyDefinition def : foreignKeys) {
                    this.fillForeignKey(table, def, visited);
                }
            }
            table.getKeys().removeSyncPendingChildren();
            table.getKeys().sort();
            table.getChecks().removeSyncPendingChildren();
            table.getChecks().sort();
        }

        private void fillConstraint(SqliteModTable table, SqlConstraintDefinition def) {
            SqliteModCheck check;
            String exprText;
            if (def.getConstraintType() != SqlConstraintDefinition.Type.CHECK) {
                return;
            }
            String name = StringUtil.nullize((String)def.getName());
            SqlExpression expr = (SqlExpression)def.getConstraintParameter(SqlConstraintDefinition.CHECK_EXPRESSION);
            String string = exprText = expr == null ? null : expr.getText();
            if (name != null) {
                check = (SqliteModCheck)table.getChecks().createOrGet(name);
            } else {
                check = table.getChecks().find(c -> c.isSyncPending() && c.getRealName() == null && Comparing.equal((String)exprText, (String)c.getPredicate()));
                if (check == null) {
                    check = (SqliteModCheck)table.getChecks().createNewOne();
                } else {
                    check.resetSyncPending();
                }
            }
            check.setPredicate(exprText);
        }

        private void fillTableKey(SqliteModTable table, SqlTableKeyDefinition def) {
            SqliteModKey key;
            String name = StringUtil.nullize((String)def.getName());
            ArrayList cols = ContainerUtil.newArrayList((Iterable)def.getColumnsRef().names());
            boolean primary = def.isPrimary();
            if (name != null) {
                key = (SqliteModKey)table.getKeys().createOrGet(name);
            } else {
                key = table.getKeys().find(k -> k.isSyncPending() && k.getRealName() == null && this.keyMatches((SqliteModKey)k, cols, primary));
                if (key == null) {
                    key = (SqliteModKey)table.getKeys().createNewOne();
                } else {
                    key.resetSyncPending();
                }
            }
            key.setPrimary(primary);
            key.setColNames(cols);
        }

        private void fillForeignKey(SqliteModTable table, SqlForeignKeyDefinition def, Set<SqliteModForeignKey> visited) {
            SqliteModForeignKey matchedByName;
            String name = StringUtil.nullize((String)def.getName());
            SqliteModForeignKey sqliteModForeignKey = matchedByName = name != null ? (SqliteModForeignKey)table.getForeignKeys().get(name, false) : null;
            if (visited.contains(matchedByName)) {
                matchedByName = null;
            }
            ArrayList refCols = ContainerUtil.newArrayList((Iterable)def.getRefColumns().names());
            ArrayList cols = ContainerUtil.newArrayList((Iterable)def.getColumnsRef().names());
            CascadeRule onUpdate = this.toCascadeRule(def.getUpdateRule(), true);
            CascadeRule onDelete = this.toCascadeRule(def.getDeleteRule(), false);
            SqliteModForeignKey target = null;
            for (int step = 0; step < 2 && target == null; ++step) {
                if (matchedByName != null && this.fkMatches(matchedByName, name, cols, refCols, onDelete, onUpdate, step == 0)) {
                    target = matchedByName;
                } else {
                    SqliteModForeignKey foreignKey = this.findFk(table.getForeignKeys(), def.getRefTableName(), cols, refCols, onDelete, onUpdate, visited, step == 0);
                    if (foreignKey != null) {
                        target = foreignKey;
                    }
                }
                if (step != 1 || target == null) continue;
                LOG.warn("Partial match: " + def.getNameElement() + " sql: " + (Object)((Object)onUpdate) + ", " + (Object)((Object)onDelete) + " db: " + (Object)((Object)target.getOnUpdate()) + ", " + (Object)((Object)target.getOnDelete()));
            }
            if (target == null) {
                LOG.warn("Unmatched FK: " + def.getName());
                return;
            }
            visited.add(target);
            target.setRealName(name);
        }

        private void fillColumn(SqliteModTable table, SqlColumnDefinition columnDef, List<SqlForeignKeyDefinition> foreignKeys) {
            SqlClause[] clauses;
            SqlDefinition[] defs = (SqlDefinition[])PsiTreeUtil.getChildrenOfType((PsiElement)columnDef, SqlDefinition.class);
            if (defs != null) {
                for (SqlDefinition def : defs) {
                    if (def instanceof SqlForeignKeyDefinition) {
                        foreignKeys.add((SqlForeignKeyDefinition)def);
                        continue;
                    }
                    if (def instanceof SqlTableKeyDefinition) {
                        this.fillTableKey(table, (SqlTableKeyDefinition)def);
                        continue;
                    }
                    if (!(def instanceof SqlConstraintDefinition)) continue;
                    this.fillConstraint(table, (SqlConstraintDefinition)def);
                }
            }
            if ((clauses = (SqlClause[])PsiTreeUtil.getChildrenOfType((PsiElement)columnDef, SqlClause.class)) != null) {
                for (SqlClause clause : clauses) {
                    if (!clause.getText().equalsIgnoreCase("autoincrement")) continue;
                    String name = columnDef.getName();
                    SqliteModTableColumn column = table.getColumns().find(c -> c.getName().equalsIgnoreCase(name));
                    if (column == null) break;
                    column.setSequenceIdentity(SEQUENCE_IDENTITY);
                    break;
                }
            }
        }

        private void fillIndex(SqliteIntroQueries.SourceInfo info, SqliteModLikeTable tbl) {
            SqliteModTable table = (SqliteModTable)ObjectUtils.tryCast((Object)tbl, SqliteModTable.class);
            if (table == null) {
                return;
            }
            SqliteModIndex index = (SqliteModIndex)table.getIndices().createOrGet(info.name);
            SqlCreateIndexStatement stmt = this.getStatement(info.sql, SqlCreateIndexStatement.class);
            SqlWhereClause where = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)stmt, SqlWhereClause.class);
            SqlExpression whereExpr = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)where, SqlExpression.class);
            index.setCondition(whereExpr == null ? null : whereExpr.getText());
            SqlReferenceExpression tableRef = stmt == null ? null : stmt.getTableReference();
            SqlTableColumnsList columnsList = tableRef == null ? null : (SqlTableColumnsList)ObjectUtils.tryCast((Object)tableRef.getParent(), SqlTableColumnsList.class);
            SqlReferenceList columns = columnsList == null ? null : columnsList.getColumnsReferenceList();
            SqlExpression[] columnExprs = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)columns, SqlExpression.class);
            if (columnExprs != null) {
                List<String> names = index.getColNames();
                if (columnExprs.length != names.size()) {
                    LOG.warn("Index columns mismatch `" + StringUtil.join(names, (String)", ") + "` and `" + columns.getText());
                }
                Set<String> rev = index.getReverseColNames();
                ArrayList newNames = ContainerUtil.newArrayListWithCapacity((int)columnExprs.length);
                LinkedHashSet newRev = ContainerUtil.newLinkedHashSet();
                for (int i2 = 0; i2 < columnExprs.length; ++i2) {
                    boolean curRev;
                    SqlExpression expr = columnExprs[i2];
                    boolean bl = curRev = i2 < names.size() && rev.contains(names.get(i2));
                    if (expr instanceof SqlReferenceExpression && i2 < names.size()) {
                        newNames.add(names.get(i2));
                    } else {
                        newNames.add(expr.getText());
                    }
                    if (!curRev) continue;
                    newRev.add(newNames.get(newNames.size() - 1));
                }
                index.setColNames(newNames);
                index.setReverseColNames(newRev);
            }
        }

        private void fillTrigger(@NotNull SqliteIntroQueries.SourceInfo info, @NotNull SqliteModLikeTable tbl) {
            PsiElement element;
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "fillTrigger"));
            }
            if (tbl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tbl", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "fillTrigger"));
            }
            SqliteModTrigger trigger2 = (SqliteModTrigger)tbl.getTriggers().createOrGet(info.name);
            trigger2.setSourceText(info.sql);
            SqlCreateTriggerStatement stmt = this.getStatement(info.sql, SqlCreateTriggerStatement.class);
            TrigTurn turn = null;
            TrigEvent event = null;
            List<String> cols = null;
            SqlNameElement name = stmt == null ? null : stmt.getNameElement();
            PsiElement afterName = this.skipUnsignificant(name == null ? null : name.getNextSibling());
            if (afterName instanceof SqlClause && (element = this.skipUnsignificant(afterName.getFirstChild())) != null) {
                String text = element.getText();
                event = this.getEvent(text);
                if (event == null) {
                    turn = this.getTurn(text);
                    PsiElement nextClause = this.skipUnsignificant(afterName.getNextSibling());
                    if (nextClause instanceof SqlClause && (element = this.skipUnsignificant(nextClause.getFirstChild())) != null) {
                        text = element.getText();
                        event = this.getEvent(text);
                        cols = this.getColumns(nextClause);
                    }
                } else {
                    cols = this.getColumns(afterName);
                }
            }
            turn = turn == null ? TrigTurn.BEFORE_ROW : turn;
            SqlWhenClause when = (SqlWhenClause)PsiTreeUtil.getChildOfType((PsiElement)stmt, SqlWhenClause.class);
            SqlExpression whenExpr = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)when, SqlExpression.class);
            trigger2.setCondition(whenExpr == null ? null : whenExpr.getText());
            trigger2.setTurn(turn);
            trigger2.setColNames(cols == null ? Collections.emptyList() : cols);
            trigger2.setEvents(event == null ? Collections.emptySet() : Collections.singleton(event));
        }

        @Nullable
        private List<String> getColumns(@NotNull PsiElement el) {
            if (el == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "getColumns"));
            }
            SqlReferenceExpression[] cols = (SqlReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)el, SqlReferenceExpression.class);
            if (cols == null) {
                return null;
            }
            ArrayList names = ContainerUtil.newArrayList();
            for (SqlReferenceExpression col : cols) {
                names.add(col.getName());
            }
            return names;
        }

        @Nullable
        private TrigEvent getEvent(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "getEvent"));
            }
            if (text.equalsIgnoreCase("insert")) {
                return TrigEvent.INSERT;
            }
            if (text.equalsIgnoreCase("delete")) {
                return TrigEvent.DELETE;
            }
            if (text.equalsIgnoreCase("update")) {
                return TrigEvent.UPDATE;
            }
            return null;
        }

        @Nullable
        private TrigTurn getTurn(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "getTurn"));
            }
            if (text.equalsIgnoreCase("before")) {
                return TrigTurn.BEFORE_ROW;
            }
            if (text.equalsIgnoreCase("after")) {
                return TrigTurn.AFTER_ROW;
            }
            if (text.equalsIgnoreCase("instead")) {
                return TrigTurn.INSTEAD_OF;
            }
            return null;
        }

        @Nullable
        private PsiElement skipUnsignificant(@Nullable PsiElement el) {
            while (el instanceof PsiWhiteSpace || el instanceof PsiComment) {
                el = el.getNextSibling();
            }
            return el;
        }

        @Nullable
        private <T extends SqlStatement> T getStatement(@Nullable String sql, @NotNull Class<T> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "getStatement"));
            }
            if (sql == null) {
                return null;
            }
            try {
                return (T)((SqlStatement)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)SqliteIntrospector.this.myReader.getReadOnlyPsi(SqliteIntrospector.this.myLanguage, (CharSequence)sql)).expandAndSkip(e -> !(e instanceof SqlStatement))).filter(clazz).first());
            }
            catch (Exception e2) {
                LOG.warn("Failed to parse sources", (Throwable)e2);
                return null;
            }
        }

        private SqliteModIndex findAutoIndexByCols(SqliteModTable t, List<String> cols) {
            for (SqliteModIndex index : t.getIndices()) {
                if (!index.getName().startsWith("sqlite_autoindex_") || !this.equalInsensitive(index.getColNames(), cols)) continue;
                return index;
            }
            for (SqliteModIndex index : t.getIndices()) {
                if (index.getName().startsWith("sqlite_autoindex_") || !this.equalInsensitive(index.getColNames(), cols)) continue;
                return index;
            }
            return null;
        }

        private SqliteModForeignKey findFk(Family<? extends SqliteModForeignKey> fks, @Nullable String refTable, @NotNull List<String> cols, @NotNull List<String> refCols, @NotNull CascadeRule onDelete, @NotNull CascadeRule onUpdate, @NotNull Set<SqliteModForeignKey> ignore, boolean full) {
            if (cols == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cols", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "findFk"));
            }
            if (refCols == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refCols", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "findFk"));
            }
            if (onDelete == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDelete", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "findFk"));
            }
            if (onUpdate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onUpdate", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "findFk"));
            }
            if (ignore == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignore", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "findFk"));
            }
            return fks.find(fk -> {
                if (ignore == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignore", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "lambda$findFk$16"));
                }
                if (cols == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cols", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "lambda$findFk$16"));
                }
                if (refCols == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refCols", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "lambda$findFk$16"));
                }
                if (onDelete == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDelete", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "lambda$findFk$16"));
                }
                if (onUpdate == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onUpdate", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "lambda$findFk$16"));
                }
                if (ignore.contains(fk)) {
                    return false;
                }
                return this.fkMatches((SqliteModForeignKey)fk, refTable, cols, refCols, onDelete, onUpdate, full);
            });
        }

        private boolean fkMatches(SqliteModForeignKey fk, @Nullable String refTable, @NotNull List<String> cols, @NotNull List<String> refCols, @NotNull CascadeRule onDelete, @NotNull CascadeRule onUpdate, boolean full) {
            if (cols == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cols", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "fkMatches"));
            }
            if (refCols == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refCols", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "fkMatches"));
            }
            if (onDelete == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDelete", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "fkMatches"));
            }
            if (onUpdate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onUpdate", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "fkMatches"));
            }
            if (!Comparing.strEqual((String)fk.getRefTableName(), (String)refTable, (boolean)false)) {
                return false;
            }
            if (!this.equalInsensitive(fk.getColNames(), cols)) {
                return false;
            }
            if (!this.equalInsensitive(fk.getRefColNames(), refCols)) {
                return false;
            }
            if (full && !Comparing.equal((Object)((Object)fk.getOnDelete()), (Object)((Object)onDelete))) {
                return false;
            }
            return !full || Comparing.equal((Object)((Object)fk.getOnUpdate()), (Object)((Object)onUpdate));
        }

        private boolean keyMatches(SqliteModKey key, @NotNull List<String> cols, boolean primary) {
            if (cols == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cols", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "keyMatches"));
            }
            if (!this.equalInsensitive(key.getColNames(), cols)) {
                return false;
            }
            return primary != key.isPrimary();
        }

        private boolean equalInsensitive(@NotNull List<String> a, @NotNull List<String> b) {
            if (a == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "equalInsensitive"));
            }
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "equalInsensitive"));
            }
            if (a.size() != b.size()) {
                return false;
            }
            for (int i2 = 0; i2 < a.size(); ++i2) {
                if (Comparing.strEqual((String)a.get(i2), (String)b.get(i2), (boolean)false)) continue;
                return false;
            }
            return true;
        }

        private CascadeRule toCascadeRule(String rule, boolean update2) {
            if (rule == null || rule.equalsIgnoreCase("no action")) {
                return CascadeRule.no_action;
            }
            if (rule.equalsIgnoreCase("restrict")) {
                return CascadeRule.restrict;
            }
            if (rule.equalsIgnoreCase("set null")) {
                return CascadeRule.set_null;
            }
            if (rule.equalsIgnoreCase("set default")) {
                return CascadeRule.set_default;
            }
            if (rule.equalsIgnoreCase("cascade")) {
                return update2 ? CascadeRule.update : CascadeRule.delete;
            }
            return CascadeRule.no_action;
        }

        @NotNull
        private CascadeRule toCascadeRule(DasForeignKey.RuleAction rule, boolean update2) {
            for (CascadeRule cascadeRule : CascadeRule.values()) {
                if (cascadeRule == CascadeRule.delete && update2 || cascadeRule == CascadeRule.update && !update2 || cascadeRule.action != rule) continue;
                CascadeRule cascadeRule2 = cascadeRule;
                if (cascadeRule2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "toCascadeRule"));
                }
                return cascadeRule2;
            }
            CascadeRule cascadeRule = CascadeRule.no_action;
            if (cascadeRule == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever", "toCascadeRule"));
            }
            return cascadeRule;
        }

        private /* synthetic */ boolean lambda$retrieveForeignKeys$8(ModNamingFamily foreignKeys, Set visited, List list) {
            CascadeRule onUpdate;
            list.sort((o1, o2) -> Comparing.compare((Comparable)o1.seq, (Comparable)o2.seq));
            ArrayList from = ContainerUtil.newArrayListWithCapacity((int)list.size());
            ArrayList to = ContainerUtil.newArrayListWithCapacity((int)list.size());
            for (SqliteIntroQueries.ForeignKeyInfo aList : list) {
                from.add(aList.from);
                to.add(aList.to);
            }
            SqliteIntroQueries.ForeignKeyInfo foreignKeyInfo = (SqliteIntroQueries.ForeignKeyInfo)list.get(0);
            CascadeRule onDelete = this.toCascadeRule(foreignKeyInfo.on_delete, false);
            SqliteModForeignKey foreignKey = this.findFk(foreignKeys, foreignKeyInfo.table, from, to, onDelete, onUpdate = this.toCascadeRule(foreignKeyInfo.on_update, true), visited, true);
            if (foreignKey == null) {
                foreignKey = (SqliteModForeignKey)foreignKeys.createNewOne();
                foreignKey.setRefTableName(foreignKeyInfo.table);
                foreignKey.setColNames(from);
                foreignKey.setRefColNames(to);
                foreignKey.setOnDelete(onDelete);
                foreignKey.setOnUpdate(onUpdate);
            } else {
                foreignKey.resetSyncPending();
            }
            visited.add(foreignKey);
            return true;
        }
    }
}

