/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelUtil {
    public static final Comparator<? super BasicElement> DISPLAY_ORDER_COMPARATOR = (e1, e2) -> {
        String s1 = e1.getDisplayOrder();
        String s2 = e2.getDisplayOrder();
        return s1.compareTo(s2);
    };
    public static final Comparator<? super BasicArrangedElement> POSITIONS_COMPARATOR = (e1, e2) -> {
        short p2;
        short p1 = e1.getPosition();
        return p1 < (p2 = e2.getPosition()) ? -1 : (p1 > p2 ? 1 : 0);
    };

    @Nullable
    public static String nameOf(@Nullable BasicNamedElement element) {
        return element != null ? element.getRealName() : null;
    }

    @NotNull
    public static <T> List<T> listOfNN(T ... elements) {
        if (elements == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/ModelUtil", "listOfNN"));
            }
            return list;
        }
        int n = elements.length;
        switch (n) {
            case 0: {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/ModelUtil", "listOfNN"));
                }
                return list;
            }
            case 1: {
                T element = elements[0];
                List list = element != null ? Collections.singletonList(element) : Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/ModelUtil", "listOfNN"));
                }
                return list;
            }
        }
        ArrayList<T> list = new ArrayList<T>(n);
        for (T element : elements) {
            if (element == null) continue;
            list.add(element);
        }
        ArrayList<T> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/ModelUtil", "listOfNN"));
        }
        return arrayList;
    }
}

