/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicTrigger
extends BasicColumniation,
DasTrigger {
    @NotNull
    default public Set<TrigEvent> getEvents() {
        Set<TrigEvent> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicTrigger", "getEvents"));
        }
        return set;
    }

    @Nullable
    default public TrigTurn getTurn() {
        return null;
    }

    @Nullable
    default public String getCondition() {
        return null;
    }

    @Override
    @NotNull
    default public String calculateDisplayOrder() {
        StringBuilder b = new StringBuilder(40);
        Set<TrigEvent> events = this.getEvents();
        if (events.contains((Object)TrigEvent.SELECT)) {
            b.append('0');
        }
        if (events.contains((Object)TrigEvent.INSERT)) {
            b.append('1');
        }
        if (events.contains((Object)TrigEvent.UPDATE)) {
            b.append('2');
        }
        if (events.contains((Object)TrigEvent.DELETE)) {
            b.append('3');
        }
        b.append('\u0001');
        TrigTurn turn = this.getTurn();
        int turnOrd = turn != null ? turn.ordinal() + 1 : 9;
        b.append(turnOrd);
        String name = this.getRealName();
        if (name != null) {
            b.append('\u0002').append(name);
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicTrigger", "calculateDisplayOrder"));
        }
        return string;
    }
}

