/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.db2;

import com.intellij.database.model.DataType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModColumn;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.db2.Db2ModLikeColumn;
import com.intellij.database.model.db2.Db2ModSchema;
import com.intellij.database.model.db2.Db2ModTable;
import com.intellij.database.model.db2.Db2TableColumn;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Db2ModTableColumn
extends Db2TableColumn,
Db2ModLikeColumn,
BasicModColumn {
    @Override
    @NotNull
    public Db2ModTable getTable();

    @Override
    @NotNull
    default public Db2ModTable getDbParent() {
        Db2ModTable db2ModTable = this.getTable();
        if (db2ModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ModTableColumn", "getDbParent"));
        }
        return db2ModTable;
    }

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends Db2ModTableColumn> getParentFamily();

    @Override
    @NotNull
    default public Db2ModSchema getSchema() {
        Db2ModSchema db2ModSchema = this.getTable().getSchema();
        if (db2ModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ModTableColumn", "getSchema"));
        }
        return db2ModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ModTableColumn", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ModTableColumn", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setPosition(short var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setDataType(@NotNull DataType var1);

    @Override
    public void setNotNull(boolean var1);

    @Override
    public void setSequenceIdentity(@Nullable SequenceIdentity var1);

    @Override
    public void setDefaultExpression(@Nullable String var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/db2/Db2ModTableColumn", "importProperties"));
        }
        String position = properties.get("Position");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String dataType = properties.get("DataType");
        String notNull = properties.get("NotNull");
        String sequenceIdentity = properties.get("SequenceIdentity");
        String defaultExpression = properties.get("DefaultExpression");
        if (position != null) {
            this.setPosition(PropertyConverter.importShort(position));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (dataType != null) {
            this.setDataType(PropertyConverter.importDataType(dataType));
        }
        if (notNull != null) {
            this.setNotNull(PropertyConverter.importBoolean(notNull));
        }
        if (sequenceIdentity != null) {
            this.setSequenceIdentity(PropertyConverter.importSequenceIdentity(sequenceIdentity));
        }
        if (defaultExpression != null) {
            this.setDefaultExpression(PropertyConverter.importString(defaultExpression));
        }
    }
}

