/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.impl.ModelDescribing$WhenMappings;
import com.intellij.database.model.mssql.MsAliasType;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.model.postgres.PostgresDefType;
import com.intellij.database.model.postgres.PostgresOperator;
import com.intellij.database.model.postgres.PostgresSequence;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.PostgresDataTypeSubCategory;
import com.intellij.database.model.properties.PostgresDataTypeSubKind;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u00a8\u0001\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0019H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0010\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0002\u001a\u0010\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%H\u0002\u001a\u0010\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(H\u0002\u001a\u000e\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+\u001a \u0010,\u001a\u00020-2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0003H\u0002\u001a\u0010\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u000203H\u0002\u001a\u0010\u00104\u001a\u00020\u00032\u0006\u0010\b\u001a\u000205H\u0002\u001a \u00106\u001a\u0004\u0018\u00010\u0003*\u0004\u0018\u00010\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003H\u0002\u001a\u0010\u00109\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020;0:\u001a\u001a\u00109\u001a\u00020-*\b\u0012\u0004\u0012\u00020;0:2\u0006\u0010.\u001a\u00020/H\u0002\u001a\n\u0010<\u001a\u00020\u0003*\u00020;\u001a\u0014\u0010<\u001a\u00020-*\u00020;2\u0006\u0010.\u001a\u00020/H\u0002\u001a\n\u0010=\u001a\u00020\u0003*\u00020\t\u001a\n\u0010>\u001a\u00020\u0003*\u00020\t\u001a\u001a\u0010?\u001a\u0004\u0018\u00010\u0003*\u0004\u0018\u00010\u00032\b\u0010@\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0016\u0010A\u001a\u00020\u0003*\u0004\u0018\u00010\u00032\u0006\u0010@\u001a\u00020\u0003H\u0002\u001a\u0016\u0010B\u001a\f0\u0003\u00a2\u0006\u0002\bC\u00a2\u0006\u0002\bC*\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"eoln", "", "indentStep", "", "describeArgument", "a", "Lcom/intellij/database/model/basic/BasicArgument;", "describeBasicElement", "e", "Lcom/intellij/database/model/basic/BasicElement;", "describeCheck", "check", "Lcom/intellij/database/model/basic/BasicCheck;", "describeColumn", "Lcom/intellij/database/model/basic/BasicColumn;", "describeForeignKey", "fk", "Lcom/intellij/database/model/basic/BasicForeignKey;", "describeIndex", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "describeKey", "key", "Lcom/intellij/database/model/basic/BasicKey;", "describeMsAliasType", "Lcom/intellij/database/model/mssql/MsAliasType;", "describeOraCluster", "cluster", "Lcom/intellij/database/model/oracle/OraCluster;", "describePostgresDefType", "dt", "Lcom/intellij/database/model/postgres/PostgresDefType;", "describePostgresOperator", "op", "Lcom/intellij/database/model/postgres/PostgresOperator;", "describePostgresSequence", "seq", "Lcom/intellij/database/model/postgres/PostgresSequence;", "describeRoutine", "r", "Lcom/intellij/database/model/basic/BasicRoutine;", "describeSequence", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "describeTreeRecursively", "", "b", "Ljava/lang/StringBuilder;", "indent", "describeTrigger", "trig", "Lcom/intellij/database/model/basic/BasicTrigger;", "describeTypedElement", "Lcom/intellij/database/model/basic/BasicTypedElement;", "decorate", "prefix", "suffix", "describeForest", "", "Lcom/intellij/database/model/basic/BasicNode;", "describeTree", "description", "descriptionContent", "notSame", "another", "or", "pluralize", "Lorg/jetbrains/annotations/NotNull;", "database-model-impl"})
@JvmName(name="ModelDescribing")
public final class ModelDescribing {
    private static final String indentStep = "    ";
    private static final char eoln = '\n';

    @NotNull
    public static final String describeForest(@NotNull Iterable<? extends BasicNode> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        StringBuilder b = new StringBuilder();
        ModelDescribing.describeForest($receiver, b);
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    private static final void describeForest(@NotNull Iterable<? extends BasicNode> $receiver, StringBuilder b) {
        Iterable<? extends BasicNode> $receiver$iv = $receiver;
        Iterator<? extends BasicNode> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            BasicNode element$iv;
            BasicNode it = element$iv = iterator.next();
            ModelDescribing.describeTree(it, b);
        }
    }

    @NotNull
    public static final String describeTree(@NotNull BasicNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringBuilder b = new StringBuilder();
        ModelDescribing.describeTree($receiver, b);
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    private static final void describeTree(@NotNull BasicNode $receiver, StringBuilder b) {
        BasicNode basicNode = $receiver;
        if (basicNode instanceof BasicElement) {
            ModelDescribing.describeTreeRecursively((BasicElement)$receiver, b, "");
        } else if (basicNode instanceof Family) {
            ModelDescribing.describeForest((Iterable)((Object)$receiver), b);
        } else {
            b.append($receiver.toString());
        }
    }

    private static final void describeTreeRecursively(BasicElement e, StringBuilder b, String indent) {
        String d = ModelDescribing.description(e);
        b.append(indent).append(d).append(eoln);
        String comment = e.getComment();
        if (comment != null) {
            CharSequence charSequence = comment;
            if (!(charSequence.length() == 0)) {
                b.append(indent).append(indentStep).append("--  ").append(comment).append(eoln);
            }
        }
        List<ObjectKind> kinds = e.getFamilyKinds();
        Collection collection = kinds;
        if (!collection.isEmpty()) {
            String indent1 = indent + indentStep;
            String indent2 = indent1 + indentStep;
            for (ObjectKind kind : kinds) {
                Family<? extends BasicElement> children = e.familyOf(kind);
                if (children == null || children.isEmpty()) continue;
                b.append(indent1).append('+').append(' ').append(ModelDescribing.pluralize(kind.code())).append(eoln);
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    BasicElement child;
                    BasicElement basicElement = child = (BasicElement)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"child");
                    ModelDescribing.describeTreeRecursively(basicElement, b, indent2);
                }
            }
        }
    }

    private static final String pluralize(@NotNull String $receiver) {
        return StringUtil.pluralize((String)$receiver);
    }

    private static final String notSame(@Nullable String $receiver, String another) {
        return Intrinsics.areEqual((Object)$receiver, (Object)another) ? (String)null : $receiver;
    }

    private static final String decorate(@Nullable String $receiver, String prefix, String suffix) {
        return $receiver == null ? (String)null : prefix + $receiver + suffix;
    }

    private static final String or(@Nullable String $receiver, String another) {
        return $receiver != null ? $receiver : another;
    }

    @NotNull
    public static final String description(@NotNull BasicElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.identity(false) + ": " + ModelDescribing.descriptionContent($receiver);
    }

    @NotNull
    public static final String descriptionContent(@NotNull BasicElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BasicElement basicElement = $receiver;
        return basicElement instanceof OraCluster ? ModelDescribing.describeOraCluster((OraCluster)$receiver) : (basicElement instanceof PostgresSequence ? ModelDescribing.describePostgresSequence((PostgresSequence)$receiver) : (basicElement instanceof PostgresDefType ? ModelDescribing.describePostgresDefType((PostgresDefType)$receiver) : (basicElement instanceof PostgresOperator ? ModelDescribing.describePostgresOperator((PostgresOperator)$receiver) : (basicElement instanceof MsAliasType ? ModelDescribing.describeMsAliasType((MsAliasType)$receiver) : (basicElement instanceof BasicSequence ? ModelDescribing.describeSequence((BasicSequence)$receiver) : (basicElement instanceof BasicIndex ? ModelDescribing.describeIndex((BasicIndex)$receiver) : (basicElement instanceof BasicKey ? ModelDescribing.describeKey((BasicKey)$receiver) : (basicElement instanceof BasicForeignKey ? ModelDescribing.describeForeignKey((BasicForeignKey)$receiver) : (basicElement instanceof BasicCheck ? ModelDescribing.describeCheck((BasicCheck)$receiver) : (basicElement instanceof BasicTrigger ? ModelDescribing.describeTrigger((BasicTrigger)$receiver) : (basicElement instanceof BasicRoutine ? ModelDescribing.describeRoutine((BasicRoutine)$receiver) : (basicElement instanceof BasicColumn ? ModelDescribing.describeColumn((BasicColumn)$receiver) : (basicElement instanceof BasicArgument ? ModelDescribing.describeArgument((BasicArgument)$receiver) : (basicElement instanceof BasicTypedElement ? ModelDescribing.describeTypedElement((BasicTypedElement)$receiver) : ModelDescribing.describeBasicElement($receiver)))))))))))))));
    }

    @NotNull
    public static final String describeSequence(@NotNull BasicSequence sequence) {
        Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
        StringBuilder stringBuilder = new StringBuilder().append("sequence: ");
        Object object = sequence.getSequenceIdentity();
        if (object == null || (object = ((SequenceIdentity)object).getSpecification()) == null) {
            object = "???";
        }
        return stringBuilder.append(object).toString();
    }

    private static final String describeIndex(BasicIndex index) {
        List<String> names = index.getColNames();
        Set<String> ds = index.getReverseColNames();
        Collection collection = names;
        String inner2 = !collection.isEmpty() ? (ds.isEmpty() ? CollectionsKt.joinToString$default((Iterable)names, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : CollectionsKt.joinToString$default((Iterable)names, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(ds){
            final /* synthetic */ Set $ds;

            @NotNull
            public final String invoke(String it) {
                return it + (this.$ds.contains(it) ? " desc" : " asc");
            }
            {
                this.$ds = set;
                super(1);
            }
        }), (int)30, null)) : "???";
        return (index.isUnique() ? "unique" : "index") + " (" + inner2 + ")";
    }

    private static final String describeKey(BasicKey key) {
        List<String> names = key.getColNames();
        String k = key.isPrimary() ? "PK" : "AK";
        Collection collection = names;
        String inner2 = !collection.isEmpty() ? CollectionsKt.joinToString$default((Iterable)names, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : "???";
        String string = ModelDescribing.decorate(ModelDescribing.notSame(key.getUnderlyingIndexName(), key.getName()), " (underlying index ", ")");
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String underlying = string2;
        return k + " (" + inner2 + ")" + underlying;
    }

    private static final String describeForeignKey(BasicForeignKey fk) {
        String deferrable;
        List<String> names = fk.getColNames();
        Collection collection = names;
        String inner2 = !collection.isEmpty() ? CollectionsKt.joinToString$default((Iterable)names, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : "???";
        String refTable = ModelDescribing.or(fk.getRefTableName(), "???");
        BasicKey basicKey = fk.getRefKey();
        String string = ModelDescribing.decorate(basicKey != null ? basicKey.getNaturalName() : null, "[.", "]");
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String refKey = string2;
        List<String> refCols = fk.getRefColNames();
        Collection collection2 = refCols;
        String refInner = !collection2.isEmpty() ? CollectionsKt.joinToString$default((Iterable)refCols, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : "???";
        String onUpdate = Intrinsics.areEqual((Object)((Object)fk.getOnUpdate()), (Object)((Object)CascadeRule.restrict)) ? "" : " u:" + (Object)((Object)fk.getOnUpdate());
        String onDelete = Intrinsics.areEqual((Object)((Object)fk.getOnDelete()), (Object)((Object)CascadeRule.restrict)) ? "" : " d:" + (Object)((Object)fk.getOnDelete());
        String string3 = deferrable = fk.isDeferrable() ? " deferrable" : "";
        String deferred = fk.isInitiallyDeferred() && !fk.isDeferrable() ? " [deferred]" : (!fk.isInitiallyDeferred() && fk.isDeferrable() ? "[immediate]" : "");
        return "foreign key (" + inner2 + ") -> " + refTable + refKey + " (" + refInner + ")" + onUpdate + onDelete + deferrable + deferred;
    }

    private static final String describeCheck(BasicCheck check) {
        StringBuilder stringBuilder = new StringBuilder().append("check (");
        String string = check.getPredicate();
        if (string == null) {
            string = "???";
        }
        return stringBuilder.append((Object)string).append(")").toString();
    }

    /*
     * Unable to fully structure code
     */
    private static final String describeTrigger(BasicTrigger trig) {
        var2_1 = trig.getKind().name();
        v0 = var2_1;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        v1 = v0.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"(this as java.lang.String).toLowerCase()");
        k = v1;
        cols = trig.getColNames();
        var4_3 = String.valueOf((Object)trig.getTurn());
        v2 = var4_3;
        if (v2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        v3 = v2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"(this as java.lang.String).toLowerCase()");
        wn = StringsKt.replace$default((String)v3, (char)'_', (char)' ', (boolean)false, (int)4, null);
        var5_5 = trig.getEvents();
        var6_6 = $receiver$iv;
        var7_7 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (T item$iv$iv : $receiver$iv$iv) {
            var10_10 = (TrigEvent)item$iv$iv;
            var15_12 = destination$iv$iv;
            if (!Intrinsics.areEqual((Object)it, (Object)TrigEvent.UPDATE)) ** GOTO lbl-1000
            var11_11 = cols;
            if (var11_11.isEmpty() == false) {
                v4 = "update of " + CollectionsKt.joinToString$default((Iterable)cols, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            } else lbl-1000:
            // 2 sources

            {
                var11_11 = it.name();
                v5 = var11_11;
                if (v5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                v6 = ((String)v5).toLowerCase();
                v4 = v6;
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"(this as java.lang.String).toLowerCase()");
            }
            var16_13 = v4;
            var15_12.add(var16_13);
        }
        wt = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" or ", null, null, (int)0, null, null, (int)62, null);
        cond = trig.getCondition() == null ? "" : "c:" + trig.getCondition();
        return k + " " + wn + " " + wt + " " + cond;
    }

    private static final String describeRoutine(BasicRoutine r) {
        String string;
        switch (ModelDescribing$WhenMappings.$EnumSwitchMapping$0[r.getRoutineKind().ordinal()]) {
            case 1: {
                string = "procedure";
                break;
            }
            case 2: {
                string = "function";
                break;
            }
            default: {
                string = "routine";
            }
        }
        String s = string;
        return s;
    }

    private static final String describeColumn(BasicColumn e) {
        String s = e.getDataType().toString();
        if (e.isComputed()) {
            s = "computed " + s;
        }
        if (e.isNotNull()) {
            s = s + " NN";
        }
        if (e.getSequenceIdentity() != null) {
            StringBuilder stringBuilder = new StringBuilder().append(s);
            StringBuilder stringBuilder2 = new StringBuilder().append(" identity ");
            SequenceIdentity sequenceIdentity = e.getSequenceIdentity();
            if (sequenceIdentity == null) {
                Intrinsics.throwNpe();
            }
            s = stringBuilder.append(stringBuilder2.append(sequenceIdentity).toString()).toString();
        }
        if (e.getDefaultExpression() != null) {
            StringBuilder stringBuilder = new StringBuilder().append(s);
            StringBuilder stringBuilder3 = new StringBuilder().append(" default ");
            String string = e.getDefaultExpression();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            s = stringBuilder.append(stringBuilder3.append(string).toString()).toString();
        }
        String string = s;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"s");
        return string;
    }

    private static final String describeArgument(BasicArgument a) {
        String string = a.getArgumentDirection().name();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String argWord = string3;
        String dataType = a.getDataType().toString();
        String def = a.getDefaultExpression();
        String s = argWord + ' ' + dataType;
        if (def != null) {
            s = s + " default " + def;
        }
        return s;
    }

    private static final String describeTypedElement(BasicTypedElement e) {
        String string = e.getDataType().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.dataType.toString()");
        return string;
    }

    private static final String describeBasicElement(BasicElement e) {
        String string = e.getKind().code();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.kind.code()");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String describeOraCluster(OraCluster cluster) {
        String columns = CollectionsKt.joinToString$default((Iterable)cluster.getColumns().getNames(), null, null, null, (int)0, null, null, (int)63, null);
        ClusterType clusterType = cluster.getClusterType();
        if (clusterType == null) return "cluster (" + columns + ")";
        switch (ModelDescribing$WhenMappings.$EnumSwitchMapping$1[clusterType.ordinal()]) {
            case 1: {
                return "index cluster (" + columns + ") block size " + cluster.getBlockSize();
            }
            case 2: {
                String exp = cluster.getHashExpression();
                return exp == null ? "hash cluster (" + columns + ") hash by column cardinality " + cluster.getHashCardinality() : "hash cluster (" + columns + ") hash by (" + exp + ") cardinality " + cluster.getHashCardinality();
            }
            default: {
                return "cluster (" + columns + ")";
            }
        }
    }

    private static final String describePostgresSequence(PostgresSequence seq) {
        String def = ModelDescribing.describeSequence(seq);
        String category = seq.isBelongsToColumn() ? "private" : "shared";
        return category + ' ' + def;
    }

    private static final String describePostgresDefType(PostgresDefType dt) {
        PostgresDataTypeSubKind sk = dt.getSubKind();
        PostgresDataTypeSubCategory sc = dt.getSubCategory();
        StringBuilder b = new StringBuilder(60);
        b.append(sk.human_readable_name());
        if (Intrinsics.areEqual((Object)((Object)sc), (Object)((Object)PostgresDataTypeSubCategory.NONE)) ^ true && Intrinsics.areEqual((Object)sc.human_readable_name(), (Object)sk.human_readable_name()) ^ true) {
            b.append(' ').append('(').append(sc.human_readable_name()).append(')');
        }
        if (dt.getDefinition() != null) {
            b.append(" of ").append(dt.getDefinition());
        }
        Collection collection = dt.getLabels();
        if (!collection.isEmpty()) {
            b.append(" of {").append(CollectionsKt.joinToString$default((Iterable)dt.getLabels(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).append("}");
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    private static final String describePostgresOperator(PostgresOperator op) {
        StringBuilder b = new StringBuilder(60);
        String string = op.getOperatorKind().name();
        StringBuilder stringBuilder = b;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        stringBuilder.append(string4).append(" operator (");
        if (Intrinsics.areEqual((Object)op.getLeftType(), (Object)DataType.UNKNOWN) ^ true) {
            b.append(op.getLeftType());
        }
        if (Intrinsics.areEqual((Object)op.getLeftType(), (Object)DataType.UNKNOWN) ^ true && Intrinsics.areEqual((Object)op.getRightType(), (Object)DataType.UNKNOWN) ^ true) {
            b.append(", ");
        }
        if (Intrinsics.areEqual((Object)op.getRightType(), (Object)DataType.UNKNOWN) ^ true) {
            b.append(op.getRightType());
        }
        b.append(") -> ");
        b.append(op.getResultType());
        if (op.getCallRoutineName() != null) {
            b.append(" [bound to ").append(op.getCallRoutineName()).append(']');
        }
        String string5 = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"b.toString()");
        return string5;
    }

    private static final String describeMsAliasType(MsAliasType e) {
        return e.getDataType().toString() + (e.isNotNull() ? " NN" : "");
    }
}

