/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.generation;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class DdlOperation {
    @NotNull
    private final String myName;
    @NotNull
    private final DdlOperation[] myInterfaces;
    public static final DdlOperation ANY_OP = new DdlOperation("any", new DdlOperation[0]);
    public static final DdlOperation CREATE = new DdlOperation("create", new DdlOperation[0]);
    public static final DdlOperation DROP = new DdlOperation("drop", new DdlOperation[0]);
    public static final DdlOperation POST_RENAME = new DdlOperation("post-rename", new DdlOperation[0]);
    public static final DdlOperation RENAME = new DdlOperation("rename", new DdlOperation[0]);
    public static final DdlOperation ALTER = new DdlOperation("alter", RENAME);
    public static final DdlOperation ALTER_COMMENT = new DdlOperation("alter-comment", new DdlOperation[0]);
    public static final DdlOperation TEMPORARY_RENAME = new DdlOperation("temporary-rename", RENAME);
    public static final DdlOperation BEGIN_TRANSACTION = new DdlOperation("begin-transaction", new DdlOperation[0]);
    public static final DdlOperation COMMIT = new DdlOperation("commit", new DdlOperation[0]);

    public DdlOperation(@NotNull String name, DdlOperation ... ifaces) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/schemaEditor/generation/DdlOperation", "<init>"));
        }
        if (ifaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifaces", "com/intellij/database/schemaEditor/generation/DdlOperation", "<init>"));
        }
        this.myName = name;
        LinkedHashSet allIfaces = ContainerUtil.newLinkedHashSet();
        for (DdlOperation op : ifaces) {
            allIfaces.add(op);
            Collections.addAll(allIfaces, op.getInterfaces());
        }
        this.myInterfaces = (DdlOperation[])ContainerUtil.toArray((Collection)allIfaces, (Object[])new DdlOperation[allIfaces.size()]);
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public DdlOperation[] getInterfaces() {
        if (this.myInterfaces == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperation", "getInterfaces"));
        }
        return this.myInterfaces;
    }

    public static interface DdlOperationSupport {
        public boolean isSupported(@NotNull DdlOperation var1, @NotNull DeObject var2);

        public boolean isSupportedLight(@NotNull DdlOperation var1, @NotNull ObjectKind var2);
    }
}

