/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.coding.CodeTextBuilder;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.scripting.AbortException;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.AbstractScriptingService$CreatingGenerator$WhenMappings;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.NamingService;
import com.intellij.database.scripting.ScriptContext;
import com.intellij.database.scripting.ScriptingPreferences;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\n\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u00020\u0007:\u0003YZ[B\u001f\b\u0015\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00028\u0001\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u00109\u001a\u00020:2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016J\u0006\u0010;\u001a\u00020:J&\u0010<\u001a\u00180=R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010>\u001a\u00020?H$J\u0013\u0010@\u001a\b\u0012\u0004\u0012\u00020-0AH\u0016\u00a2\u0006\u0002\u0010BJ\b\u0010C\u001a\u00020-H\u0016J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020F0E2\u0006\u0010G\u001a\u00020FH\u0014J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020I0E2\u0006\u0010G\u001a\u00020\u0006H\u0014J\r\u0010J\u001a\u00020:H\u0010\u00a2\u0006\u0002\bKJ\u001a\u0010L\u001a\u00020:2\u0006\u0010>\u001a\u00020?2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016J&\u0010L\u001a\u00020:2\u0006\u0010>\u001a\u00020?2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020F0N2\u0006\u0010O\u001a\u00020PH\u0016J\u001e\u0010L\u001a\u00020:2\u0006\u0010>\u001a\u00020?2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00060RH\u0016J\u001e\u0010S\u001a\u00020:2\u0006\u0010>\u001a\u00020?2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020F0EH\u0004J\u001c\u0010U\u001a\b\u0012\u0004\u0012\u00020F0N2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020F0EH\u0004J\u001c\u0010V\u001a\b\u0012\u0004\u0012\u00020F0N2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020F0NH\u0002J\b\u0010W\u001a\u00020-H\u0016J\u0010\u0010X\u001a\u00020:2\u0006\u0010\t\u001a\u00020\u0004H\u0016R(\u0010\u000e\u001a\u0004\u0018\u00018\u00022\b\u0010\r\u001a\u0004\u0018\u00018\u00028V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u0004\u0018\u00018\u0002X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R&\u0010\t\u001a\u00028\u00012\u0006\u0010\t\u001a\u00028\u0001@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 R$\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#@DX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R \u0010+\u001a\b\u0012\u0004\u0012\u00020-0,X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0014\u00102\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0018\u00106\u001a\u00020-*\u00020-8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006\\"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService;", "M", "Lcom/intellij/database/model/basic/BasicModel;", "D", "Lcom/intellij/database/model/basic/BasicDatabase;", "S", "Lcom/intellij/database/model/basic/BasicSchema;", "Lcom/intellij/database/scripting/ScriptingService;", "model", "database", "prefs", "Lcom/intellij/database/scripting/ScriptingPreferences;", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/database/model/basic/BasicDatabase;Lcom/intellij/database/scripting/ScriptingPreferences;)V", "schema", "currentSchema", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "setCurrentSchema", "(Lcom/intellij/database/model/basic/BasicSchema;)V", "currentSchema_", "Lcom/intellij/database/model/basic/BasicSchema;", "getDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "setDatabase", "(Lcom/intellij/database/model/basic/BasicDatabase;)V", "Lcom/intellij/database/model/basic/BasicDatabase;", "generated", "", "Lcom/intellij/database/model/basic/BasicElement;", "getGenerated", "()Ljava/util/Set;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "Lcom/intellij/database/model/basic/BasicModel;", "<set-?>", "Lcom/intellij/database/scripting/NamingService;", "naming", "getNaming", "()Lcom/intellij/database/scripting/NamingService;", "setNaming", "(Lcom/intellij/database/scripting/NamingService;)V", "getPrefs", "()Lcom/intellij/database/scripting/ScriptingPreferences;", "script", "", "", "getScript", "()Ljava/util/List;", "setScript", "(Ljava/util/List;)V", "statementDelimiter", "", "getStatementDelimiter", "()C", "scr", "getScr", "(Ljava/lang/String;)Ljava/lang/String;", "assumeCurrentSchema", "", "clearScript", "createGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "getScriptStatements", "", "()[Ljava/lang/String;", "getScriptText", "getScriptableChildren", "", "Lcom/intellij/database/model/basic/BasicSchemaObject;", "o", "getScriptableMajorObjects", "Lcom/intellij/database/model/basic/BasicMajorObject;", "init", "init$database_scripting", "makeScript", "objects", "", "recursive", "", "schemata", "", "sortAndGenerate", "unsortedObjects", "sortPreliminary", "sortTopologically", "toString", "useDatabase", "CodeGenerator", "CreatingGenerator", "StupidGenerator", "database-scripting"})
public abstract class AbstractScriptingService<M extends BasicModel, D extends BasicDatabase, S extends BasicSchema>
implements ScriptingService {
    @NotNull
    private final M model;
    @NotNull
    private final ScriptingPreferences prefs;
    @NotNull
    protected NamingService naming;
    @NotNull
    private D database;
    private S currentSchema_;
    @NotNull
    private List<String> script;
    @NotNull
    private final Set<BasicElement> generated;

    @NotNull
    public final M getModel() {
        return this.model;
    }

    @NotNull
    public final ScriptingPreferences getPrefs() {
        return this.prefs;
    }

    @NotNull
    public final NamingService getNaming() {
        NamingService namingService = this.naming;
        if (namingService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"naming");
        }
        return namingService;
    }

    protected final void setNaming(@NotNull NamingService namingService) {
        Intrinsics.checkParameterIsNotNull((Object)namingService, (String)"<set-?>");
        this.naming = namingService;
    }

    @NotNull
    public D getDatabase() {
        return this.database;
    }

    public void setDatabase(@NotNull D database) {
        Intrinsics.checkParameterIsNotNull(database, (String)"database");
        boolean bl = database.getModel() == this.model;
        if (_Assertions.ENABLED && !bl) {
            String string = "Alien database";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.currentSchema_ != null && CollectionsKt.contains((Iterable)database.getSchemas(), this.currentSchema_) ^ true) {
            BasicSchema newCurrentSchema = ModelFun.getCurrentSchema(database);
            if (newCurrentSchema != null) {
                BasicSchema basicSchema = newCurrentSchema;
                if (basicSchema == null) {
                    throw new TypeCastException("null cannot be cast to non-null type S");
                }
                this.currentSchema_ = basicSchema;
            } else {
                this.currentSchema_ = null;
            }
        }
    }

    @Nullable
    public S getCurrentSchema() {
        return this.currentSchema_;
    }

    public void setCurrentSchema(@Nullable S schema) {
        if (schema != null && this.getDatabase() != null) {
            boolean bl = CollectionsKt.contains((Iterable)this.getDatabase().getSchemas(), schema);
            if (_Assertions.ENABLED && !bl) {
                String string = "Alien schema " + schema.getName() + "; expected a schema of the database " + this.getDatabase().getName();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        this.currentSchema_ = schema;
    }

    @NotNull
    protected final List<String> getScript() {
        return this.script;
    }

    protected final void setScript(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.script = list;
    }

    @NotNull
    protected final Set<BasicElement> getGenerated() {
        return this.generated;
    }

    public void init$database_scripting() {
    }

    @Override
    public void useDatabase(@NotNull BasicDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        BasicDatabase basicDatabase = database;
        if (basicDatabase == null) {
            throw new TypeCastException("null cannot be cast to non-null type D");
        }
        this.setDatabase(basicDatabase);
    }

    @Override
    public void assumeCurrentSchema(@Nullable BasicSchema schema) {
        if (schema != null) {
            BasicSchema basicSchema = schema;
            if (basicSchema == null) {
                throw new TypeCastException("null cannot be cast to non-null type S");
            }
            this.setCurrentSchema(basicSchema);
        } else {
            this.setCurrentSchema(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void makeScript(@NotNull ScriptingTask task, @Nullable BasicSchema schema) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        BasicSchema basicSchema = schema;
        if (basicSchema == null) {
            basicSchema = this.getCurrentSchema();
        }
        if (basicSchema == null) {
            return;
        }
        BasicSchema s = basicSchema;
        ArrayList<BasicMajorObject> elements = new ArrayList<BasicMajorObject>();
        Iterable<BasicMajorObject> iterable = this.getScriptableMajorObjects(s);
        for (Object element$iv : $receiver$iv) {
            BasicMajorObject it = (BasicMajorObject)element$iv;
            elements.add(it);
        }
        this.sortAndGenerate(task, (Iterable<BasicSchemaObject>)elements);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void makeScript(@NotNull ScriptingTask task, @NotNull List<? extends BasicSchema> schemata) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull(schemata, (String)"schemata");
        ArrayList<BasicMajorObject> elements = new ArrayList<BasicMajorObject>();
        for (BasicSchema basicSchema : schemata) {
            void $receiver$iv;
            Iterable<BasicMajorObject> iterable = this.getScriptableMajorObjects(basicSchema);
            for (Object element$iv : $receiver$iv) {
                BasicMajorObject it = (BasicMajorObject)element$iv;
                elements.add(it);
            }
        }
        this.sortAndGenerate(task, (Iterable<BasicSchemaObject>)elements);
    }

    @Override
    public void makeScript(@NotNull ScriptingTask task, @NotNull Collection<? extends BasicSchemaObject> objects, boolean recursive) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        ArrayList<? extends BasicSchemaObject> elements = new ArrayList<BasicSchemaObject>(objects);
        this.sortAndGenerate(task, (Iterable<BasicSchemaObject>)elements);
    }

    @NotNull
    protected Iterable<BasicMajorObject> getScriptableMajorObjects(@NotNull BasicSchema o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        Iterable iterable = (Iterable)o.getDbChildren(BasicMajorObject.class, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"o.getDbChildren(BasicMaj\u2026Object::class.java, null)");
        return iterable;
    }

    @NotNull
    protected Iterable<BasicSchemaObject> getScriptableChildren(@NotNull BasicSchemaObject o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        Iterable iterable = (Iterable)o.getDbChildren(BasicSchemaObject.class, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"o.getDbChildren(BasicSch\u2026Object::class.java, null)");
        return iterable;
    }

    protected final void sortAndGenerate(@NotNull ScriptingTask task, @NotNull Iterable<? extends BasicSchemaObject> unsortedObjects) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull(unsortedObjects, (String)"unsortedObjects");
        Collection<BasicSchemaObject> preliminarySortedObjects = this.sortPreliminary(unsortedObjects);
        Collection<BasicSchemaObject> topoSortedObjects = this.sortTopologically(preliminarySortedObjects);
        CodeGenerator generator = this.createGenerator(task);
        generator.setElementsToGenerate((Iterable<? extends BasicElement>)topoSortedObjects);
        generator.generate();
    }

    @NotNull
    protected abstract CodeGenerator createGenerator(@NotNull ScriptingTask var1);

    @NotNull
    protected final Collection<BasicSchemaObject> sortPreliminary(@NotNull Iterable<? extends BasicSchemaObject> objects) {
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        TreeMap<String, BasicSchemaObject> sortingTree = new TreeMap<String, BasicSchemaObject>();
        for (BasicSchemaObject basicSchemaObject : objects) {
            String order = ScriptingUtilsKt.scriptingPreliminaryOrder(basicSchemaObject);
            sortingTree.put(order, basicSchemaObject);
        }
        Collection<BasicSchemaObject> collection = sortingTree.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"sortingTree.values");
        return collection;
    }

    private final Collection<BasicSchemaObject> sortTopologically(Collection<? extends BasicSchemaObject> objects) {
        return objects;
    }

    @NotNull
    protected final String getScr(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        NamingService namingService = this.naming;
        if (namingService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"naming");
        }
        return namingService.nameToScript($receiver);
    }

    @Override
    @NotNull
    public String[] getScriptStatements() {
        Collection $receiver$iv = this.script;
        Collection collection = $receiver$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (String[])((Object[])stringArray);
    }

    @Override
    @NotNull
    public String getScriptText() {
        StringBuilder b = new StringBuilder();
        for (String s : this.script) {
            b.append(s);
            b.append(this.getStatementDelimiter()).append('\n').append('\n');
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    @Override
    public final void clearScript() {
        this.script = new ArrayList();
    }

    public char getStatementDelimiter() {
        return ';';
    }

    @NotNull
    public String toString() {
        return this.script.isEmpty() ? "ScriptingService for " + this.model.getRdbms() + ". Empty." : "ScriptingService for " + this.model.getRdbms() + "\n" + "Generated " + this.script.size() + " statements:" + "\n" + this.getScriptText();
    }

    protected AbstractScriptingService(@NotNull M model, @NotNull D database, @NotNull ScriptingPreferences prefs) {
        BasicSchema basicSchema;
        BasicSchema cs;
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        Intrinsics.checkParameterIsNotNull(database, (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)prefs, (String)"prefs");
        this.script = new ArrayList();
        this.generated = new HashSet();
        this.model = model;
        this.prefs = prefs;
        this.setDatabase(database);
        D d = database;
        BasicSchema basicSchema2 = cs = d != null ? ModelFun.getCurrentSchema(d) : null;
        if (cs != null) {
            BasicSchema basicSchema3 = cs;
            if (basicSchema3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type S");
            }
            basicSchema = basicSchema3;
        } else {
            basicSchema = null;
        }
        this.setCurrentSchema(basicSchema);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0000\b\u00a4\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 H\u0004J\u0006\u0010!\u001a\u00020\u001cJ\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0012H$J\b\u0010$\u001a\u00020\u001cH\u0002J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0012H\u0004J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0012H\u0004J\u0014\u0010'\u001a\u00020\u001c2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120)R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006*"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "builder", "Lcom/intellij/coding/CodeTextBuilder;", "getBuilder", "()Lcom/intellij/coding/CodeTextBuilder;", "<set-?>", "Lcom/intellij/database/scripting/ScriptContext;", "context", "getContext", "()Lcom/intellij/database/scripting/ScriptContext;", "setContext", "(Lcom/intellij/database/scripting/ScriptContext;)V", "deck", "Ljava/util/Deque;", "Lcom/intellij/database/model/basic/BasicElement;", "getDeck", "()Ljava/util/Deque;", "postponed", "Lcom/intellij/util/containers/MultiMap;", "getPostponed", "()Lcom/intellij/util/containers/MultiMap;", "getTask", "()Lcom/intellij/database/scripting/ScriptingTask;", "coding", "", "indent", "", "block", "Lkotlin/Function0;", "generate", "generateElement", "element", "postStatement", "process", "processElement", "setElementsToGenerate", "elements", "", "database-scripting"})
    protected abstract class CodeGenerator {
        @NotNull
        private final Deque<BasicElement> deck;
        @NotNull
        private final MultiMap<BasicElement, BasicElement> postponed;
        @NotNull
        private final CodeTextBuilder builder;
        @NotNull
        private ScriptContext context;
        @NotNull
        private final ScriptingTask task;

        @NotNull
        protected final Deque<BasicElement> getDeck() {
            return this.deck;
        }

        @NotNull
        protected final MultiMap<BasicElement, BasicElement> getPostponed() {
            return this.postponed;
        }

        @NotNull
        protected final CodeTextBuilder getBuilder() {
            return this.builder;
        }

        @NotNull
        protected final ScriptContext getContext() {
            return this.context;
        }

        private final void setContext(ScriptContext scriptContext) {
            this.context = scriptContext;
        }

        public final void setElementsToGenerate(@NotNull Iterable<? extends BasicElement> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            for (BasicElement basicElement : elements) {
                this.deck.offer(basicElement);
            }
        }

        public final void generate() {
            while (this.deck.poll() != null) {
                BasicElement element;
                this.process(element);
            }
        }

        protected final void process(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (AbstractScriptingService.this.getGenerated().contains(element) ^ true) {
                Iterable<? extends BasicElement> predecessors = element.getPredecessors();
                boolean postpone = false;
                for (BasicElement basicElement : predecessors) {
                    if (!(AbstractScriptingService.this.getGenerated().contains(basicElement) ^ true) || !this.deck.contains(basicElement)) continue;
                    this.postponed.putValue((Object)basicElement, (Object)element);
                    postpone = true;
                }
                if (postpone) {
                    return;
                }
                this.processElement(element);
                if (AbstractScriptingService.this.getGenerated().contains(element) ^ true) {
                    return;
                }
            }
            if (Intrinsics.areEqual((Object)((Object)this.context), (Object)((Object)ScriptContext.IN_SCHEMA)) || Intrinsics.areEqual((Object)((Object)this.context), (Object)((Object)ScriptContext.OUTSIDE))) {
                Collection collection = this.postponed.get((Object)element);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"postponed[element]");
                Iterable pendingElements = collection;
                for (BasicElement pendingElement : pendingElements) {
                    this.process(pendingElement);
                }
            }
        }

        protected final void processElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            try {
                this.generateElement(element);
                AbstractScriptingService.this.getGenerated().add(element);
            }
            catch (AbortException abortException) {
                // empty catch block
            }
        }

        protected abstract void generateElement(@NotNull BasicElement var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void coding(@Nullable ScriptContext context, boolean indent, @NotNull Function0<Unit> block) {
            boolean complete;
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            ScriptContext oldContext = this.context;
            ScriptContext scriptContext = context;
            if (scriptContext == null) {
                scriptContext = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptContext.OUTSIDE)) ? ScriptContext.IN_STATEMENT : oldContext;
            }
            ScriptContext newContext = scriptContext;
            CodeTextBuilder.IndentationState savedIndentation = this.builder.getCurrentIndentationState();
            try {
                this.context = newContext;
                if (indent) {
                    CodeTextBuilder.indent$default(this.builder, null, 1, null);
                }
                block.invoke();
                this.builder.returnToIndentation(savedIndentation);
                this.context = oldContext;
            }
            catch (Throwable throwable) {
                boolean complete2;
                this.builder.returnToIndentation(savedIndentation);
                this.context = oldContext;
                boolean bl = complete2 = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptContext.OUTSIDE)) && Intrinsics.areEqual((Object)((Object)newContext), (Object)((Object)ScriptContext.OUTSIDE)) ^ true && this.builder.isNotEmpty();
                if (complete2) {
                    this.postStatement();
                }
                throw throwable;
            }
            boolean bl = complete = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptContext.OUTSIDE)) && Intrinsics.areEqual((Object)((Object)newContext), (Object)((Object)ScriptContext.OUTSIDE)) ^ true && this.builder.isNotEmpty();
            if (complete) {
                this.postStatement();
            }
        }

        public static /* bridge */ /* synthetic */ void coding$default(CodeGenerator codeGenerator, ScriptContext scriptContext, boolean bl, Function0 function0, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: coding");
            }
            if ((n & 1) != 0) {
                scriptContext = null;
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            codeGenerator.coding(scriptContext, bl, (Function0<Unit>)function0);
        }

        private final void postStatement() {
            String text = this.builder.getText();
            AbstractScriptingService.this.getScript().add(text);
            this.builder.clearAll();
        }

        @NotNull
        protected final ScriptingTask getTask() {
            return this.task;
        }

        public CodeGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            this.task = task;
            this.deck = new ArrayDeque();
            this.postponed = new MultiMap();
            this.builder = new CodeTextBuilder();
            this.context = ScriptContext.OUTSIDE;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-H\u0014J\u001a\u0010/\u001a\u00020\u00072\u0006\u0010\r\u001a\u0002002\b\b\u0002\u00101\u001a\u00020\fH\u0014J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u000e032\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u00104\u001a\u00020\fH\u0014J\u0012\u00105\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0012\u00106\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0012\u00107\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u00108\u001a\u0002092\u0006\u0010,\u001a\u00020-H\u0014J\u0010\u0010:\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010;\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0004\u00a8\u0006<"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$CreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "addInnerConstraintNameAndIndent", "", "name", "", "addOuterConstraintNameAndIndent", "canCreateInColumn", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "canCreateInTable", "canCreateIndexInCurrentContext", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "canGenerateElementRightNow", "canGenerateInnerElement", "generateCascadeRules", "fk", "Lcom/intellij/database/model/basic/BasicForeignKey;", "generateCheck", "check", "Lcom/intellij/database/model/basic/BasicCheck;", "generateColumn", "column", "Lcom/intellij/database/model/basic/BasicColumn;", "generateComment", "generateDeferrability", "constraint", "Lcom/intellij/database/model/basic/BasicConstraint;", "generateElement", "generateForeignKey", "generateIndex", "generateKey", "key", "Lcom/intellij/database/model/basic/BasicKey;", "generateSequence", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "generateTable", "table", "Lcom/intellij/database/model/basic/BasicTable;", "generateTableOutsideStuff", "generateUnspecificSourceAwareElement", "Lcom/intellij/database/model/basic/BasicSourceAware;", "processChildren", "getSingleColumnElements", "", "isNullExplicit", "makeColumnDefinition", "makeColumnSpecification", "makeDeferrability", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "processElementChildren", "weDontKnowHowToGenerateThis", "database-scripting"})
    protected class CreatingGenerator
    extends CodeGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof BasicSequence) {
                this.generateSequence((BasicSequence)element);
            } else if (basicElement instanceof BasicTable) {
                this.generateTable((BasicTable)element);
            } else if (basicElement instanceof BasicColumn) {
                this.generateColumn((BasicColumn)element);
            } else if (basicElement instanceof BasicIndex) {
                this.generateIndex((BasicIndex)element);
            } else if (basicElement instanceof BasicKey) {
                this.generateKey((BasicKey)element);
            } else if (basicElement instanceof BasicForeignKey) {
                this.generateForeignKey((BasicForeignKey)element);
            } else if (basicElement instanceof BasicCheck) {
                this.generateCheck((BasicCheck)element);
            } else if (basicElement instanceof BasicSourceAware) {
                this.generateUnspecificSourceAwareElement((BasicSourceAware)element, true);
            } else {
                this.weDontKnowHowToGenerateThis(element);
            }
        }

        protected void generateSequence(@NotNull BasicSequence sequence) {
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            String name = AbstractScriptingService.this.getScr(sequence.getName());
            SequenceIdentity q = sequence.getSequenceIdentity();
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name, q){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ SequenceIdentity $q;

                public final void invoke() {
                    String s = "create sequence " + this.$name;
                    this.this$0.getBuilder().addText(s);
                    if (this.$q != null) {
                        CodeGenerator.coding$default(this.this$0, null, true, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ generateSequence.1 this$0;

                            public final void invoke() {
                                if (Intrinsics.areEqual((Object)this.this$0.$q.min, (Object)BigInteger.ONE) ^ true) {
                                    this.this$0.this$0.getBuilder().addText("minvalue " + this.this$0.$q.min);
                                }
                                if (Intrinsics.areEqual((Object)this.this$0.$q.increment, (Object)BigInteger.ONE) ^ true) {
                                    this.this$0.this$0.getBuilder().addText("increment by " + this.this$0.$q.increment);
                                }
                                if (this.this$0.$q.max != null) {
                                    this.this$0.this$0.getBuilder().addText("maxvalue " + this.this$0.$q.max);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }, 1, null);
                    }
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$name = string;
                    this.$q = sequenceIdentity;
                    super(0);
                }
            }, 3, null);
        }

        protected void generateTable(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, table){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ BasicTable $table;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void footer;
                    void header;
                    HeaderFooter headerFooter = this.this$0.makeTableHeaderFooter(this.$table);
                    String string = headerFooter.component1();
                    String string2 = headerFooter.component2();
                    headerFooter = null;
                    this.this$0.getBuilder().addText((CharSequence)header);
                    this.this$0.getBuilder().addText("(");
                    this.this$0.coding(ScriptContext.IN_TABLE, true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateTable.1 this$0;

                        public final void invoke() {
                            for (BasicElement element : this.this$0.$table.getDbChildren()) {
                                CreatingGenerator creatingGenerator = this.this$0.this$0;
                                BasicElement basicElement = element;
                                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"element");
                                if (!creatingGenerator.canCreateInTable(basicElement) || this.this$0.this$0.AbstractScriptingService.this.getGenerated().contains(element)) continue;
                                CreatingGenerator creatingGenerator2 = this.this$0.this$0;
                                BasicElement basicElement2 = element;
                                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement2, (String)"element");
                                creatingGenerator2.process(basicElement2);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                    this.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                    this.this$0.getBuilder().addText(")");
                    this.this$0.getBuilder().addText((CharSequence)footer);
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$table = basicTable;
                    super(0);
                }
            }, 3, null);
            if (Intrinsics.areEqual((Object)((Object)this.getContext()), (Object)((Object)ScriptContext.OUTSIDE)) || Intrinsics.areEqual((Object)((Object)this.getContext()), (Object)((Object)ScriptContext.IN_STATEMENT))) {
                this.generateTableOutsideStuff(table);
            }
        }

        protected void generateTableOutsideStuff(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            for (BasicElement element : table.getDbChildren()) {
                if (element instanceof BasicColumn || AbstractScriptingService.this.getGenerated().contains(element)) continue;
                BasicElement basicElement = element;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"element");
                this.process(basicElement);
            }
            if (table.getComment() != null) {
                this.generateComment(table);
            }
            for (BasicColumn column : table.getColumns()) {
                if (column.getComment() == null) continue;
                BasicElement basicElement = column;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"column");
                this.generateComment(basicElement);
            }
        }

        @NotNull
        protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            String h = table.isTemporary() ? "create temporary table " + AbstractScriptingService.this.getScr(table.getName()) : "create table " + AbstractScriptingService.this.getScr(table.getName());
            return new HeaderFooter(h, null);
        }

        protected boolean canCreateInColumn(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return element instanceof BasicConstraint;
        }

        protected boolean canCreateInTable(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return element instanceof BasicColumn || element instanceof BasicConstraint;
        }

        protected void generateColumn(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            LinkedList<BasicElement> singleColumnElementsToGenerate = new LinkedList<BasicElement>();
            for (BasicElement e : this.getSingleColumnElements(column)) {
                singleColumnElementsToGenerate.add(e);
            }
            ListIterator listIterator = singleColumnElementsToGenerate.listIterator();
            Intrinsics.checkExpressionValueIsNotNull(listIterator, (String)"singleColumnElementsToGenerate.listIterator()");
            ListIterator it = listIterator;
            while (it.hasNext()) {
                BasicElement e = (BasicElement)it.next();
                if (!AbstractScriptingService.this.getGenerated().contains(e) && this.canGenerateElementRightNow(e)) continue;
                it.remove();
            }
            Collection collection = singleColumnElementsToGenerate;
            boolean hasInnerElements = !collection.isEmpty();
            String string = this.makeColumnDefinition(column);
            if (string == null) {
                return;
            }
            String line = string;
            this.getBuilder().addText(line);
            if (hasInnerElements) {
                this.coding(ScriptContext.IN_COLUMN, true, (Function0<Unit>)((Function0)new Function0<Unit>(this, singleColumnElementsToGenerate){
                    final /* synthetic */ CreatingGenerator this$0;
                    final /* synthetic */ LinkedList $singleColumnElementsToGenerate;

                    public final void invoke() {
                        Iterator<E> iterator = this.$singleColumnElementsToGenerate.iterator();
                        while (iterator.hasNext()) {
                            BasicElement e;
                            BasicElement basicElement = e = (BasicElement)iterator.next();
                            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"e");
                            this.this$0.process(basicElement);
                        }
                    }
                    {
                        this.this$0 = creatingGenerator;
                        this.$singleColumnElementsToGenerate = linkedList;
                        super(0);
                    }
                }));
            }
            this.getBuilder().addSuffixToTheListLine(',');
        }

        @Nullable
        protected String makeColumnDefinition(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            String name = AbstractScriptingService.this.getScr(column.getName());
            String specification = this.makeColumnSpecification(column);
            return ScriptingUtilsKt.concat(name, specification);
        }

        @Nullable
        protected String makeColumnSpecification(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            String specification = column.getDataType().getSpecification();
            if (column.getDefaultExpression() != null) {
                specification = specification + " default " + column.getDefaultExpression();
            }
            if (column.isNotNull()) {
                specification = specification + " not null";
            }
            if (!column.isNotNull() && this.isNullExplicit()) {
                specification = specification + " null";
            }
            return specification;
        }

        protected boolean isNullExplicit() {
            return false;
        }

        @NotNull
        protected Iterable<BasicElement> getSingleColumnElements(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            BasicLikeTable basicLikeTable = column.getTable();
            if (basicLikeTable == null) {
                return SetsKt.emptySet();
            }
            BasicLikeTable table = basicLikeTable;
            Iterable iterable = (Iterable)table.getDbChildren(BasicConstraint.class, null).filter((Condition)new Condition<BasicConstraint>(this, column){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ BasicColumn $column;

                public final boolean value(BasicConstraint it) {
                    BasicElement basicElement = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"it");
                    return this.this$0.canCreateInColumn(basicElement) && it.getColNames().size() == 1 && Intrinsics.areEqual((Object)((String)CollectionsKt.first(it.getColNames())), (Object)this.$column.getName());
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$column = basicColumn;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"table.getDbChildren(Basi\u2026s.first() == column.name}");
            return iterable;
        }

        protected void generateIndex(@NotNull BasicIndex index) {
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            if (!this.canCreateIndexInCurrentContext(index)) {
                throw (Throwable)new AbortException();
            }
            String name = AbstractScriptingService.this.getScr(index.getName());
            String w = index.isUnique() ? "unique index" : "index";
            StringBuilder b = new StringBuilder();
            Set<String> reverseColNames = index.getReverseColNames();
            Collection collection = reverseColNames;
            boolean d = !collection.isEmpty();
            for (String cn : index.getColNames()) {
                CharSequence charSequence = b;
                if (charSequence.length() > 0) {
                    b.append(", ");
                }
                b.append(AbstractScriptingService.this.getScr(cn));
                if (!d) continue;
                b.append(reverseColNames.contains(cn) ? " desc" : " asc");
            }
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, w, index, name, b){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $w;
                final /* synthetic */ BasicIndex $index;
                final /* synthetic */ String $name;
                final /* synthetic */ StringBuilder $b;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$0[this.this$0.getContext().ordinal()]) {
                        case 1: {
                            this.this$0.getBuilder().addText(this.$w);
                            break;
                        }
                        case 2: {
                            String s = this.$index.getNaturalName() != null ? this.$w + " " + this.$name + " (" + this.$b + ")" : this.$w + " (" + this.$b + ")";
                            this.this$0.getBuilder().addText(s);
                            break;
                        }
                        default: {
                            this.this$0.getBuilder().addText("create " + this.$w + " " + this.$name);
                            CodeTextBuilder this_$iv = this.this$0.getBuilder();
                            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                            try {
                                String string = this.$index.getTableName();
                                this.this$0.getBuilder().addText("on " + (string != null ? this.this$0.AbstractScriptingService.this.getScr(string) : null) + " (" + this.$b + ")");
                                break;
                            }
                            finally {
                                this_$iv.unindent();
                            }
                        }
                    }
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$w = string;
                    this.$index = basicIndex;
                    this.$name = string2;
                    this.$b = stringBuilder;
                    super(0);
                }
            }, 3, null);
        }

        protected boolean canCreateIndexInCurrentContext(@NotNull BasicIndex index) {
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            return Intrinsics.areEqual((Object)((Object)this.getContext()), (Object)((Object)ScriptContext.IN_STATEMENT)) || Intrinsics.areEqual((Object)((Object)this.getContext()), (Object)((Object)ScriptContext.OUTSIDE));
        }

        /*
         * WARNING - void declaration
         */
        protected void generateKey(@NotNull BasicKey key) {
            boolean indexIsExplicit;
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            String string = key.getNaturalName();
            String name = string != null ? AbstractScriptingService.this.getScr(string) : null;
            String w = key.isPrimary() ? "primary key" : "unique";
            BasicIndex index = null;
            if (key.getUnderlyingIndexName() != null) {
                BasicIndex basicIndex;
                BasicNode basicNode = key.getTable();
                if (basicNode != null && (basicNode = basicNode.getIndices()) != null) {
                    Object v2;
                    block8: {
                        void $receiver$iv;
                        Iterable iterable = (Iterable)((Object)basicNode);
                        for (Object element$iv : $receiver$iv) {
                            BasicIndex it = (BasicIndex)element$iv;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)key.getUnderlyingIndexName())) continue;
                            v2 = element$iv;
                            break block8;
                        }
                        v2 = null;
                    }
                    basicIndex = v2;
                } else {
                    basicIndex = null;
                }
                index = basicIndex;
            }
            boolean bl = indexIsExplicit = index != null && index.getNaturalName() != null && Intrinsics.areEqual((Object)index.getName(), (Object)key.getName()) ^ true;
            if (indexIsExplicit) {
                Set<BasicElement> set = AbstractScriptingService.this.getGenerated();
                BasicIndex basicIndex = index;
                if (basicIndex == null) {
                    Intrinsics.throwNpe();
                }
                if (set.contains(basicIndex) ^ true) {
                    this.getPostponed().putValue((Object)index, (Object)key);
                    throw (Throwable)new AbortException();
                }
            }
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name, w, key){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ String $w;
                final /* synthetic */ BasicKey $key;

                public final void invoke() {
                    switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$1[this.this$0.getContext().ordinal()]) {
                        case 1: {
                            CreatingGenerator.access$addInnerConstraintNameAndIndent(this.this$0, this.$name);
                            this.this$0.getBuilder().addText(this.$w);
                            this.this$0.generateDeferrability(this.$key);
                            break;
                        }
                        case 2: {
                            CreatingGenerator.access$addInnerConstraintNameAndIndent(this.this$0, this.$name);
                            this.this$0.getBuilder().addText(this.$w + " (" + CollectionsKt.joinToString$default((Iterable)this.$key.getColNames(), null, null, null, (int)0, null, null, (int)63, null) + ")");
                            this.this$0.generateDeferrability(this.$key);
                            this.this$0.getBuilder().addSuffixToTheListLine(',');
                            break;
                        }
                        default: {
                            String string = this.$key.getTableName();
                            this.this$0.getBuilder().addText("alter table " + (string != null ? this.this$0.AbstractScriptingService.this.getScr(string) : null));
                            CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                            CreatingGenerator.access$addOuterConstraintNameAndIndent(this.this$0, this.$name);
                            String w1 = this.$name == null ? "add " : "";
                            this.this$0.getBuilder().addText(w1 + this.$w + " (" + CollectionsKt.joinToString$default((Iterable)this.$key.getColNames(), null, null, null, (int)0, null, null, (int)63, null) + ")");
                            this.this$0.generateDeferrability(this.$key);
                        }
                    }
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$name = string;
                    this.$w = string2;
                    this.$key = basicKey;
                    super(0);
                }
            }, 3, null);
            if (index != null) {
                AbstractScriptingService.this.getGenerated().add(index);
            }
        }

        protected void generateForeignKey(@NotNull BasicForeignKey fk) {
            Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
            String name = fk.getNaturalName();
            String refTableName = fk.getRefTableName();
            String refKeyColNames = CollectionsKt.joinToString$default((Iterable)fk.getRefColNames(), null, null, null, (int)0, null, null, (int)63, null);
            BasicKey basicKey = fk.getRefKey();
            boolean refPrimary = basicKey != null ? basicKey.isPrimary() : false;
            String w = "references " + refTableName + (!refPrimary ? " (" + refKeyColNames + ")" : "");
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name, w, fk){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ String $w;
                final /* synthetic */ BasicForeignKey $fk;

                public final void invoke() {
                    switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$2[this.this$0.getContext().ordinal()]) {
                        case 1: {
                            CreatingGenerator.access$addInnerConstraintNameAndIndent(this.this$0, this.$name);
                            this.this$0.getBuilder().addText(this.$w);
                            this.this$0.generateDeferrability(this.$fk);
                            this.this$0.generateCascadeRules(this.$fk);
                            break;
                        }
                        case 2: {
                            CreatingGenerator.access$addInnerConstraintNameAndIndent(this.this$0, this.$name);
                            this.this$0.getBuilder().addText("foreign key (" + CollectionsKt.joinToString$default((Iterable)this.$fk.getColNames(), null, null, null, (int)0, null, null, (int)63, null) + ") " + this.$w);
                            this.this$0.generateDeferrability(this.$fk);
                            this.this$0.generateCascadeRules(this.$fk);
                            this.this$0.getBuilder().addSuffixToTheListLine(',');
                            break;
                        }
                        default: {
                            this.this$0.getBuilder().addText("alter table " + this.$fk.getTableName());
                            CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                            CreatingGenerator.access$addOuterConstraintNameAndIndent(this.this$0, this.$name);
                            String w1 = this.$name == null ? "add " : "";
                            this.this$0.getBuilder().addText(w1 + ("foreign key (" + CollectionsKt.joinToString$default((Iterable)this.$fk.getColNames(), null, null, null, (int)0, null, null, (int)63, null) + ") " + this.$w));
                            this.this$0.generateDeferrability(this.$fk);
                            this.this$0.generateCascadeRules(this.$fk);
                        }
                    }
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$name = string;
                    this.$w = string2;
                    this.$fk = basicForeignKey;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        protected void generateCascadeRules(@NotNull BasicForeignKey fk) {
            String string;
            String string2;
            Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
            switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$3[fk.getOnUpdate().ordinal()]) {
                case 1: {
                    string2 = "on update cascade";
                    break;
                }
                case 2: {
                    string2 = "on update set default";
                    break;
                }
                case 3: {
                    string2 = "on update set null";
                    break;
                }
                case 4: {
                    string2 = "on update set no action";
                    break;
                }
                default: {
                    string2 = null;
                }
            }
            String c1 = string2;
            switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$4[fk.getOnDelete().ordinal()]) {
                case 1: {
                    string = "on delete cascade";
                    break;
                }
                case 2: {
                    string = "on delete set default";
                    break;
                }
                case 3: {
                    string = "on delete set null";
                    break;
                }
                case 4: {
                    string = "on delete no action";
                    break;
                }
                default: {
                    string = null;
                }
            }
            String c2 = string;
            String c = ScriptingUtilsKt.concat(c1, c2);
            if (c != null) {
                void this_$iv;
                CodeTextBuilder codeTextBuilder = this.getBuilder();
                CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
                try {
                    this.getBuilder().addText(c);
                }
                finally {
                    this_$iv.unindent();
                }
            }
        }

        protected void generateCheck(@NotNull BasicCheck check) {
            Object w1;
            Intrinsics.checkParameterIsNotNull((Object)check, (String)"check");
            String name = check.getNaturalName();
            String def = "check (" + check.getPredicate() + ")";
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = "";
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name, check, (Ref.ObjectRef)w1, def){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ BasicCheck $check;
                final /* synthetic */ Ref.ObjectRef $w1;
                final /* synthetic */ String $def;

                public final void invoke() {
                    switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$5[this.this$0.getContext().ordinal()]) {
                        case 1: 
                        case 2: {
                            CreatingGenerator.access$addInnerConstraintNameAndIndent(this.this$0, this.$name);
                            break;
                        }
                        default: {
                            this.this$0.getBuilder().addText("alter table " + this.$check.getTableName());
                            CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                            CreatingGenerator.access$addOuterConstraintNameAndIndent(this.this$0, this.$name);
                            if (this.$name != null) break;
                            this.$w1.element = "add ";
                        }
                    }
                    this.this$0.generateDeferrability(this.$check);
                    String text = (String)this.$w1.element + this.$def;
                    if (Intrinsics.areEqual((Object)((Object)this.this$0.getContext()), (Object)((Object)ScriptContext.IN_TABLE))) {
                        text = text + ',';
                    }
                    this.this$0.getBuilder().addText(text);
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$name = string;
                    this.$check = basicCheck;
                    this.$w1 = objectRef;
                    this.$def = string2;
                    super(0);
                }
            }, 3, null);
            w1 = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void generateDeferrability(@NotNull BasicConstraint constraint) {
            Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
            String dfr = this.makeDeferrability(constraint);
            if (dfr != null) {
                CodeTextBuilder this_$iv = this.getBuilder();
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    this.getBuilder().addText(dfr);
                }
                finally {
                    this_$iv.unindent();
                }
            }
        }

        @Nullable
        protected String makeDeferrability(@NotNull BasicConstraint constraint) {
            Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
            return constraint.isDeferrable() ? (constraint.isInitiallyDeferred() ? "deferrable initially deferred" : "deferrable") : (String)null;
        }

        private final void addInnerConstraintNameAndIndent(String name) {
            if (name != null) {
                this.getBuilder().addText("constraint " + name);
                CodeTextBuilder.indent$default(this.getBuilder(), null, 1, null);
            }
        }

        private final void addOuterConstraintNameAndIndent(String name) {
            if (name != null) {
                this.getBuilder().addText("add constraint " + name);
                CodeTextBuilder.indent$default(this.getBuilder(), null, 1, null);
            }
        }

        protected void generateUnspecificSourceAwareElement(@NotNull BasicSourceAware element, boolean processChildren) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            String text = element.getSourceText();
            if (text != null) {
                CharSequence charSequence = text;
                if (charSequence.length() > 0) {
                    CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, text){
                        final /* synthetic */ CreatingGenerator this$0;
                        final /* synthetic */ String $text;

                        public final void invoke() {
                            this.this$0.getBuilder().addText(this.$text);
                        }
                        {
                            this.this$0 = creatingGenerator;
                            this.$text = string;
                            super(0);
                        }
                    }, 3, null);
                }
            }
            if (element.getComment() != null) {
                this.generateComment(element);
                if (element instanceof BasicView) {
                    NamingFamily columns = ((BasicView)element).getColumns();
                    for (BasicColumn column : columns) {
                        BasicElement basicElement = column;
                        Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"column");
                        this.generateComment(basicElement);
                    }
                }
            }
            if (processChildren) {
                this.processElementChildren(element);
            }
        }

        public static /* bridge */ /* synthetic */ void generateUnspecificSourceAwareElement$default(CreatingGenerator creatingGenerator, BasicSourceAware basicSourceAware, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateUnspecificSourceAwareElement");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            creatingGenerator.generateUnspecificSourceAwareElement(basicSourceAware, bl);
        }

        protected void processElementChildren(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            JBIterable<? extends BasicElement> children = element.getDbChildren();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                BasicElement child;
                BasicElement basicElement = child = (BasicElement)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"child");
                if (!this.canGenerateInnerElement(basicElement) || !(AbstractScriptingService.this.getGenerated().contains(child) ^ true) || !(this.getDeck().contains(child) ^ true)) continue;
                BasicElement basicElement2 = child;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement2, (String)"child");
                this.processElement(basicElement2);
            }
        }

        protected boolean canGenerateInnerElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return element instanceof BasicSchemaObject || element instanceof BasicSourceAware;
        }

        protected void generateComment(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            String string = element.getComment();
            if (string == null) {
                return;
            }
            String comment = string;
            ObjectKind kind = element.getKind();
            String w = Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MAT_VIEW) ? "materialized view" : kind.code();
            String name = AbstractScriptingService.this.getScr(element.getName());
            BasicElement basicElement = element;
            if (basicElement instanceof BasicLikeTable) {
                CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, w, name, comment){
                    final /* synthetic */ CreatingGenerator this$0;
                    final /* synthetic */ String $w;
                    final /* synthetic */ String $name;
                    final /* synthetic */ String $comment;

                    public final void invoke() {
                        this.this$0.getBuilder().addText("comment on " + this.$w + " " + this.$name + " is '" + this.$comment + "'");
                    }
                    {
                        this.this$0 = creatingGenerator;
                        this.$w = string;
                        this.$name = string2;
                        this.$comment = string3;
                        super(0);
                    }
                }, 3, null);
            } else if (basicElement instanceof BasicColumn) {
                String tableName = ((BasicColumn)element).getTableName();
                CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, tableName, name, comment){
                    final /* synthetic */ CreatingGenerator this$0;
                    final /* synthetic */ String $tableName;
                    final /* synthetic */ String $name;
                    final /* synthetic */ String $comment;

                    public final void invoke() {
                        this.this$0.getBuilder().addText("comment on column " + this.this$0.AbstractScriptingService.this.getScr(this.$tableName) + "." + this.$name + " is '" + this.$comment + "'");
                    }
                    {
                        this.this$0 = creatingGenerator;
                        this.$tableName = string;
                        this.$name = string2;
                        this.$comment = string3;
                        super(0);
                    }
                }, 3, null);
            }
        }

        protected boolean canGenerateElementRightNow(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (element instanceof BasicMinorObject && this.getContext().compareTo((Enum)ScriptContext.IN_TABLE) < 0) {
                BasicMajorObject majorObject = ((BasicMinorObject)element).getMajorObject();
                return majorObject == null || AbstractScriptingService.this.getGenerated().contains(majorObject);
            }
            return true;
        }

        protected final void weDontKnowHowToGenerateThis(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            CodeTextBuilder codeTextBuilder = this.getBuilder();
            StringBuilder stringBuilder = new StringBuilder().append("-- we don't know how to generate ").append(element.getKind().code()).append(" ");
            String string = element.getRealName();
            if (string == null) {
                string = "<with-no-name>";
            }
            codeTextBuilder.addText(stringBuilder.append(string).append(" (class ").append(element.getClass().getSimpleName()).append(") :( --").toString());
        }

        public CreatingGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
        }

        public static final /* synthetic */ void access$addInnerConstraintNameAndIndent(CreatingGenerator $this, @Nullable String name) {
            $this.addInnerConstraintNameAndIndent(name);
        }

        public static final /* synthetic */ void access$addOuterConstraintNameAndIndent(CreatingGenerator $this, @Nullable String name) {
            $this.addOuterConstraintNameAndIndent(name);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$StupidGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "database-scripting"})
    protected final class StupidGenerator
    extends CodeGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            AbstractScriptingService.this.getScript().add("-- " + element.getKind().code() + " " + element.getName());
        }

        public StupidGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
            AbstractScriptingService.this.getScript().add("-- We don't know how to generate " + this.getTask().name() + " :(");
        }
    }
}

