/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.coding.CodeTextBuilder;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.oracle.OraBody;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.model.oracle.OraClusterColumn;
import com.intellij.database.model.oracle.OraClusterIndex;
import com.intellij.database.model.oracle.OraCollectionType;
import com.intellij.database.model.oracle.OraModel;
import com.intellij.database.model.oracle.OraModule;
import com.intellij.database.model.oracle.OraRoot;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.OraNamingService;
import com.intellij.database.scripting.OraScriptingService;
import com.intellij.database.scripting.OraScriptingService$WhenMappings;
import com.intellij.database.scripting.ScriptingPreferences;
import com.intellij.database.scripting.ScriptingTask;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u0014B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\r\u001a\u00180\u000eR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\r\u0010\u0011\u001a\u00020\u0012H\u0010\u00a2\u0006\u0002\b\u0013R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/scripting/OraScriptingService;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/oracle/OraModel;", "Lcom/intellij/database/model/oracle/OraRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "model", "prefs", "Lcom/intellij/database/scripting/ScriptingPreferences;", "(Lcom/intellij/database/model/oracle/OraModel;Lcom/intellij/database/scripting/ScriptingPreferences;)V", "statementDelimiter", "", "getStatementDelimiter", "()C", "createGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "init", "", "init$database_scripting", "OraCreatingGenerator", "database-scripting"})
public final class OraScriptingService
extends AbstractScriptingService<OraModel, OraRoot, OraSchema> {
    @Override
    public void init$database_scripting() {
        super.init$database_scripting();
        this.setNaming(OraNamingService.INSTANCE);
    }

    @Override
    public char getStatementDelimiter() {
        return '/';
    }

    @Override
    @NotNull
    protected AbstractScriptingService.CodeGenerator createGenerator(@NotNull ScriptingTask task) {
        AbstractScriptingService.CodeGenerator codeGenerator;
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        switch (OraScriptingService$WhenMappings.$EnumSwitchMapping$0[task.ordinal()]) {
            case 1: {
                codeGenerator = new OraCreatingGenerator(task);
                break;
            }
            default: {
                codeGenerator = new AbstractScriptingService.StupidGenerator(task);
            }
        }
        return codeGenerator;
    }

    public OraScriptingService(@NotNull OraModel model, @NotNull ScriptingPreferences prefs) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)prefs, (String)"prefs");
        BasicModel basicModel = model;
        BasicDatabase basicDatabase = model.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicDatabase, (String)"model.root");
        super(basicModel, basicDatabase, prefs);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u001aH\u0014\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/scripting/OraScriptingService$OraCreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/oracle/OraModel;", "Lcom/intellij/database/model/oracle/OraRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/OraScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateCluster", "", "cluster", "Lcom/intellij/database/model/oracle/OraCluster;", "generateCollectionType", "col", "Lcom/intellij/database/model/oracle/OraCollectionType;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateModule", "module", "Lcom/intellij/database/model/oracle/OraModule;", "generateObjectTable", "table", "Lcom/intellij/database/model/oracle/OraTable;", "generateTable", "Lcom/intellij/database/model/basic/BasicTable;", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "database-scripting"})
    private final class OraCreatingGenerator
    extends AbstractScriptingService.CreatingGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof OraCluster) {
                this.generateCluster((OraCluster)element);
            } else if (basicElement instanceof OraModule) {
                this.generateModule((OraModule)element);
            } else if (basicElement instanceof OraCollectionType) {
                this.generateCollectionType((OraCollectionType)element);
            } else {
                super.generateElement(element);
            }
        }

        @Override
        protected void generateTable(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            if (table instanceof OraTable && ((OraTable)table).getRowTypeObjectName() != null) {
                BasicTable basicTable = table;
                if (basicTable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraTable");
                }
                this.generateObjectTable((OraTable)basicTable);
            } else {
                super.generateTable(table);
            }
        }

        private final void generateObjectTable(OraTable table) {
            String objectSchemaName = table.getRowTypeSchemaName();
            if (Intrinsics.areEqual((Object)objectSchemaName, (Object)table.getSchemaName())) {
                objectSchemaName = null;
            }
            String string = table.getRowTypeObjectName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String objectName = string;
            String n = objectSchemaName == null ? OraScriptingService.this.getScr(objectName) : OraScriptingService.this.getScr(objectSchemaName) + '.' + OraScriptingService.this.getScr(objectName);
            String s = "create table " + table.getName() + " of " + n;
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $s;

                public final void invoke() {
                    this.this$0.getBuilder().addText(this.$s);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$s = string;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateCluster(OraCluster cluster) {
            String name = OraScriptingService.this.getScr(cluster.getName());
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name, cluster){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ OraCluster $cluster;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    this.this$0.getBuilder().addText("create cluster " + this.$name);
                    this.this$0.getBuilder().addText("(");
                    AbstractScriptingService.CodeGenerator.coding$default(this.this$0, null, true, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateCluster.1 this$0;

                        public final void invoke() {
                            for (OraClusterColumn oraClusterColumn : this.this$0.$cluster.getColumns()) {
                                String name1 = this.this$0.this$0.OraScriptingService.this.getScr(oraClusterColumn.getName());
                                String type1 = oraClusterColumn.getDataType().getSpecification();
                                this.this$0.this$0.getBuilder().addText(name1 + " " + type1 + ",");
                            }
                            this.this$0.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }, 1, null);
                    this.this$0.getBuilder().addText(")");
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (this.$cluster.getBlockSize() > 0) {
                            this.this$0.getBuilder().addText("size " + this.$cluster.getBlockSize());
                        }
                        if (this.$cluster.getHashExpression() != null) {
                            this.this$0.getBuilder().addText("hash is " + this.$cluster.getHashExpression());
                        }
                        if (this.$cluster.getHashCardinality() != 0) {
                            this.this$0.getBuilder().addText("hashkeys " + this.$cluster.getHashCardinality());
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$name = string;
                    this.$cluster = oraCluster;
                    super(0);
                }
            }, 3, null);
            OraClusterIndex index = cluster.getIndices().get();
            if (index != null) {
                AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, index, name){
                    final /* synthetic */ OraCreatingGenerator this$0;
                    final /* synthetic */ OraClusterIndex $index;
                    final /* synthetic */ String $name;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke() {
                        this.this$0.getBuilder().addText("create index " + this.this$0.OraScriptingService.this.getScr(this.$index.getName()));
                        CodeTextBuilder this_$iv = this.this$0.getBuilder();
                        CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                        try {
                            this.this$0.getBuilder().addText("on cluster " + this.$name);
                        }
                        finally {
                            this_$iv.unindent();
                        }
                    }
                    {
                        this.this$0 = oraCreatingGenerator;
                        this.$index = oraClusterIndex;
                        this.$name = string;
                        super(0);
                    }
                }, 3, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
            void h;
            String f;
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            BasicTable basicTable = table;
            if (basicTable == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraTable");
            }
            OraTable t = (OraTable)basicTable;
            HeaderFooter headerFooter = super.makeTableHeaderFooter(table);
            String string = headerFooter.component1();
            String string2 = headerFooter.component2();
            headerFooter = null;
            if (Intrinsics.areEqual((Object)((Object)t.getOrganization()), (Object)((Object)TableOrganization.INDEX))) {
                f = Intrinsics.stringPlus((String)f, (Object)"\n\torganization index");
            }
            return new HeaderFooter((String)h, f);
        }

        public final void generateCollectionType(@NotNull OraCollectionType col) {
            Intrinsics.checkParameterIsNotNull((Object)col, (String)"col");
            String name = OraScriptingService.this.getScr(col.getName());
            int n = col.getUpperBound();
            String d = col.getElementType().getSpecification();
            String s1 = col.isArray() && n > 0 ? "create type " + name + " is varray(" + n + ") of " + d : "create type " + name + " as table of " + d;
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s1){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $s1;

                public final void invoke() {
                    this.this$0.getBuilder().addText(this.$s1);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$s1 = string;
                    super(0);
                }
            }, 3, null);
        }

        public final void generateModule(@NotNull OraModule module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            AbstractScriptingService.CreatingGenerator.generateUnspecificSourceAwareElement$default(this, module, false, 2, null);
            OraBody body = module.getBodies().get();
            if (body != null) {
                AbstractScriptingService.CreatingGenerator.generateUnspecificSourceAwareElement$default(this, body, false, 2, null);
            }
        }

        public OraCreatingGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
        }
    }
}

