/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DataType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresDatabase;
import com.intellij.database.model.postgres.PostgresModel;
import com.intellij.database.model.postgres.PostgresOperator;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgres.PostgresSequence;
import com.intellij.database.model.postgres.PostgresTableColumn;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.GenericLowerCaseNamingService;
import com.intellij.database.scripting.PostgresScriptingService$WhenMappings;
import com.intellij.database.scripting.ScriptingPreferences;
import com.intellij.database.scripting.ScriptingTask;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u0011B\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010\n\u001a\u00180\u000bR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\f\u001a\u00020\rH\u0014J\r\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/scripting/PostgresScriptingService;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/postgres/PostgresModel;", "Lcom/intellij/database/model/postgres/PostgresDatabase;", "Lcom/intellij/database/model/postgres/PostgresSchema;", "model", "database", "prefs", "Lcom/intellij/database/scripting/ScriptingPreferences;", "(Lcom/intellij/database/model/postgres/PostgresModel;Lcom/intellij/database/model/postgres/PostgresDatabase;Lcom/intellij/database/scripting/ScriptingPreferences;)V", "createGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "init", "", "init$database_scripting", "PgCreatingGenerator", "database-scripting"})
public final class PostgresScriptingService
extends AbstractScriptingService<PostgresModel, PostgresDatabase, PostgresSchema> {
    @Override
    public void init$database_scripting() {
        super.init$database_scripting();
        this.setNaming(GenericLowerCaseNamingService.INSTANCE);
    }

    @Override
    @NotNull
    protected AbstractScriptingService.CodeGenerator createGenerator(@NotNull ScriptingTask task) {
        AbstractScriptingService.CodeGenerator codeGenerator;
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        switch (PostgresScriptingService$WhenMappings.$EnumSwitchMapping$0[task.ordinal()]) {
            case 1: {
                codeGenerator = new PgCreatingGenerator(task);
                break;
            }
            default: {
                codeGenerator = new AbstractScriptingService.StupidGenerator(task);
            }
        }
        return codeGenerator;
    }

    public PostgresScriptingService(@NotNull PostgresModel model, @NotNull PostgresDatabase database, @NotNull ScriptingPreferences prefs) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)prefs, (String)"prefs");
        super((BasicModel)model, (BasicDatabase)database, prefs);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000b\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/scripting/PostgresScriptingService$PgCreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/postgres/PostgresModel;", "Lcom/intellij/database/model/postgres/PostgresDatabase;", "Lcom/intellij/database/model/postgres/PostgresSchema;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/PostgresScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateColumn", "", "column", "Lcom/intellij/database/model/basic/BasicColumn;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateOperator", "op", "Lcom/intellij/database/model/postgres/PostgresOperator;", "generateSequence", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "makeColumnSpecification", "", "makeSerialColumnSpecification", "Lcom/intellij/database/model/postgres/PostgresTableColumn;", "database-scripting"})
    private final class PgCreatingGenerator
    extends AbstractScriptingService.CreatingGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof PostgresOperator) {
                this.generateOperator((PostgresOperator)element);
            } else {
                super.generateElement(element);
            }
        }

        @Override
        protected void generateSequence(@NotNull BasicSequence sequence) {
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            if (!(sequence instanceof PostgresSequence) || !((PostgresSequence)sequence).isBelongsToColumn()) {
                super.generateSequence(sequence);
            }
        }

        @Override
        protected void generateColumn(@NotNull BasicColumn column) {
            PostgresSchema schema;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            super.generateColumn(column);
            if (column instanceof PostgresTableColumn && ((PostgresTableColumn)column).getSequenceName() != null && (schema = ((PostgresTableColumn)column).getSchema()) != null) {
                PostgresSequence sequence;
                NamingIdentifyingFamily<? extends PostgresSequence> namingIdentifyingFamily = schema.getSequences();
                String string = ((PostgresTableColumn)column).getSequenceName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((sequence = (PostgresSequence)namingIdentifyingFamily.get(string)) != null) {
                    PostgresScriptingService.this.getGenerated().add(sequence);
                }
            }
        }

        @Override
        @Nullable
        protected String makeColumnSpecification(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            return column instanceof PostgresTableColumn && ((PostgresTableColumn)column).getSequenceName() != null ? this.makeSerialColumnSpecification((PostgresTableColumn)column) : super.makeColumnSpecification(column);
        }

        private final String makeSerialColumnSpecification(PostgresTableColumn column) {
            String specification;
            DataType dt = column.getDataType();
            SequenceIdentity sq = column.getSequenceIdentity();
            String string = StringsKt.startsWith$default((String)dt.typeName, (String)"small", (boolean)false, (int)2, null) ? "smallserial" : (specification = StringsKt.startsWith$default((String)dt.typeName, (String)"big", (boolean)false, (int)2, null) ? "bigserial" : "serial");
            if (column.isNotNull()) {
                specification = specification + " not null";
            }
            return specification;
        }

        private final void generateOperator(PostgresOperator op) {
            ArrayList<String> props = new ArrayList<String>(4);
            if (op.getCallRoutineName() != null) {
                StringBuilder stringBuilder = new StringBuilder().append("procedure = ");
                String string = op.getCallRoutineName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                props.add(stringBuilder.append(PostgresScriptingService.this.getScr(string)).toString());
            }
            if (Intrinsics.areEqual((Object)op.getLeftType(), (Object)DataType.UNKNOWN) ^ true) {
                props.add("leftarg = " + op.getLeftType().getSpecification());
            }
            if (Intrinsics.areEqual((Object)op.getRightType(), (Object)DataType.UNKNOWN) ^ true) {
                props.add("rightarg = " + op.getRightType().getSpecification());
            }
            String specification = CollectionsKt.joinToString$default((Iterable)props, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            String cmd = "create operator " + op.getName() + " (" + specification + ")";
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, cmd){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ String $cmd;

                public final void invoke() {
                    this.this$0.getBuilder().addText(this.$cmd);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$cmd = string;
                    super(0);
                }
            }, 3, null);
        }

        public PgCreatingGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
        }
    }
}

