/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.scripting.AbortException;
import java.util.Date;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\u001a\t\u0010\u0002\u001a\u00020\u0003H\u0080\b\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001b\u0010\n\u001a\u0004\u0018\u00010\u000b*\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0086\u0004\u001a\u0017\u0010\r\u001a\u00020\u000e*\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\n\u0010\u0012\u001a\u00020\u000b*\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\u000b*\u00020\u0007\u001a\n\u0010\u0015\u001a\u00020\u000b*\u00020\u0007\u001a\n\u0010\u0016\u001a\u00020\u000b*\u00020\u0001\u001a\f\u0010\u0017\u001a\u00020\u000b*\u00020\u0018H\u0002\u001a\f\u0010\u0017\u001a\u00020\u000b*\u00020\u0019H\u0002\u001a\f\u0010\u0017\u001a\u00020\u000b*\u00020\u001aH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"__0__", "", "abort", "", "combineScriptingPreliminaryOrderRecursively", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "b", "Ljava/lang/StringBuilder;", "concat", "", "that", "matches", "", "", "pattern", "Ljava/util/regex/Pattern;", "orderString", "Lcom/intellij/database/model/ObjectKind;", "scriptingMateOrder", "scriptingPreliminaryOrder", "toFixedOrderString", "toOrderString", "Ljava/util/Date;", "", "", "database-scripting"})
public final class ScriptingUtilsKt {
    public static final short __0__ = 0;

    @NotNull
    public static final Void abort() {
        throw (Throwable)new AbortException();
    }

    public static final boolean matches(@Nullable CharSequence $receiver, @NotNull Pattern pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        return $receiver != null ? pattern.matcher($receiver).matches() : false;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final String concat(@Nullable String $receiver, @Nullable String that) {
        if ($receiver == null) ** GOTO lbl-1000
        var3_2 = $receiver;
        if (var3_2.length() > 0) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = y1 = false;
        }
        if (that == null) ** GOTO lbl-1000
        var4_5 = that;
        if (var4_5.length() > 0) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = y2 = false;
        }
        return y1 != false && y2 != false ? $receiver + ' ' + that : (y1 != false ? $receiver : (y2 != false ? that : (String)null));
    }

    @NotNull
    public static final String scriptingPreliminaryOrder(@NotNull BasicElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringBuilder b = new StringBuilder();
        ScriptingUtilsKt.combineScriptingPreliminaryOrderRecursively($receiver, b);
        if ($receiver.getRealName() != null) {
            b.append('\t').append($receiver.getRealName());
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    private static final void combineScriptingPreliminaryOrderRecursively(BasicElement element, StringBuilder b) {
        BasicElement parent = element.getDbParent();
        if (parent != null) {
            ScriptingUtilsKt.combineScriptingPreliminaryOrderRecursively(parent, b);
            b.append('\t');
        }
        b.append(ScriptingUtilsKt.orderString(element.getKind())).append('.').append(ScriptingUtilsKt.scriptingMateOrder(element));
    }

    @NotNull
    public static final String scriptingMateOrder(@NotNull BasicElement $receiver) {
        String name;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof BasicRoot) {
            return "";
        }
        if ($receiver instanceof BasicArrangedElement && ((BasicArrangedElement)$receiver).getPosition() != 0) {
            return ScriptingUtilsKt.toFixedOrderString(((BasicArrangedElement)$receiver).getPosition());
        }
        if ($receiver instanceof BasicIdentifiedElement) {
            if (((BasicIdentifiedElement)$receiver).getCreatedTimestamp() != null) {
                StringBuilder stringBuilder = new StringBuilder().append("!");
                Date date = ((BasicIdentifiedElement)$receiver).getCreatedTimestamp();
                if (date == null) {
                    Intrinsics.throwNpe();
                }
                return stringBuilder.append(ScriptingUtilsKt.toOrderString(date)).toString();
            }
            if (((BasicIdentifiedElement)$receiver).getModifiedTimestamp() != null) {
                StringBuilder stringBuilder = new StringBuilder().append("!");
                Date date = ((BasicIdentifiedElement)$receiver).getModifiedTimestamp();
                if (date == null) {
                    Intrinsics.throwNpe();
                }
                return stringBuilder.append(ScriptingUtilsKt.toOrderString(date)).toString();
            }
            if (((BasicIdentifiedElement)$receiver).getObjectId() != Long.MIN_VALUE) {
                return "#" + ScriptingUtilsKt.toOrderString(((BasicIdentifiedElement)$receiver).getObjectId());
            }
        }
        if ($receiver instanceof BasicNamedElement && (name = ((BasicNamedElement)$receiver).getRealName()) != null) {
            return (((BasicNamedElement)$receiver).isNameSurrogate() ? "N?." : "N!.") + name;
        }
        char c = '{';
        String string = String.valueOf($receiver.hashCode());
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = String.valueOf(c) + string;
        return stringBuilder.append(string2).append('}').toString();
    }

    private static final String toOrderString(@NotNull Date $receiver) {
        return ScriptingUtilsKt.toOrderString($receiver.getTime());
    }

    /*
     * WARNING - void declaration
     */
    private static final String toOrderString(int $receiver) {
        if ($receiver == 0) {
            return "0";
        }
        if ($receiver > 0) {
            char c;
            String s = String.valueOf($receiver);
            int n = s.length();
            char c2 = c = (char)(65 + (n - 1));
            return String.valueOf(c2) + s;
        }
        if ($receiver < 0) {
            int p = -$receiver;
            StringBuilder b = new StringBuilder(14);
            b.append(p);
            int n = b.length();
            int n2 = 0;
            int n3 = n - 1;
            if (n2 <= n3) {
                while (true) {
                    void i2;
                    char d = b.charAt((int)i2);
                    char c = (char)(90 - (d - 48));
                    StringBuilder stringBuilder = b;
                    char c3 = c;
                    stringBuilder.setCharAt((int)i2, c3);
                    if (i2 == n3) break;
                    ++i2;
                }
            }
            b.insert(0, '-');
            b.insert(1, (char)(90 - n));
            String string = b.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
            return string;
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private static final String toOrderString(long $receiver) {
        if ($receiver == 0L) {
            return "0";
        }
        if ($receiver > 0L) {
            char c;
            String s = String.valueOf($receiver);
            int n = s.length();
            char c2 = c = (char)(65 + (n - 1));
            return String.valueOf(c2) + s;
        }
        if ($receiver < 0L) {
            long p = -$receiver;
            StringBuilder b = new StringBuilder(24);
            b.append(p);
            int n = b.length();
            int n2 = 0;
            int n3 = n - 1;
            if (n2 <= n3) {
                while (true) {
                    void i2;
                    char d = b.charAt((int)i2);
                    char c = (char)(90 - (d - 48));
                    StringBuilder stringBuilder = b;
                    char c3 = c;
                    stringBuilder.setCharAt((int)i2, c3);
                    if (i2 == n3) break;
                    ++i2;
                }
            }
            b.insert(0, '-');
            b.insert(1, (char)(90 - n));
            String string = b.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
            return string;
        }
        return "";
    }

    @NotNull
    public static final String orderString(@NotNull ObjectKind $receiver) {
        int order;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int n = order = $receiver.getOrder();
        if (1 <= n && n <= 9999) {
            String string;
            String s = String.valueOf(order);
            int n2 = s.length();
            int n3 = n2;
            if (1 <= n3 && n3 <= 3) {
                String string2 = "000";
                int n4 = 0;
                int n5 = 4 - n2;
                String string3 = string2.substring(n4, n5);
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = "";
            }
            String padding = string;
            return padding + s;
        }
        return "ZZZZ";
    }

    @NotNull
    public static final String toFixedOrderString(short $receiver) {
        if ($receiver < __0__) {
            return "-X";
        }
        String s = String.valueOf($receiver);
        String string = "00000";
        int n = s.length();
        int n2 = 5;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string3 = string2;
        return stringBuilder.append(string3).append(s).toString();
    }
}

