/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.view.editors.DatabaseEditorBase;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.editors.ObjectEditorWithPreview;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.database.view.ui.ErrorNotificationWrapperPanel;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.ResultProcessorProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDbRefactoringDialog<Ed extends DatabaseEditorBaseEx>
extends RefactoringDialog
implements ResultProcessorProvider {
    protected Ed myEditor;
    protected final ObjectEditorWithPreview myEditorPreview;
    protected final DatabaseEditorState myState;
    protected final EditorModelsCache myEditorModelsCache;
    protected final DeModel myModel;
    protected final MyOkAction myNewOkAction;
    protected final ErrorNotificationWrapperPanel myErrorPanel;
    @Nullable
    private ResultProcessor myProcessor;
    protected boolean myRefactoring;
    private final JPanel myCentralPanel;

    @NotNull
    public DatabaseEditorState getState() {
        DatabaseEditorState databaseEditorState = this.myState;
        if (databaseEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "getState"));
        }
        return databaseEditorState;
    }

    public AbstractDbRefactoringDialog(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "<init>"));
        }
        super((Project)ObjectUtils.assertNotNull((Object)context.getProject()), true);
        SqlCodeStyleSettings settings = (SqlCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)context.getProject()).getCustomSettings(SqlCodeStyleSettings.class);
        if (settings == null) {
            settings = new SqlCodeStyleSettings(CodeStyleSettingsManager.getSettings((Project)context.getProject()));
        }
        this.myEditorModelsCache = new EditorModelsCache(settings);
        this.setModal(true);
        this.myModel = AbstractDbRefactoringDialog.createModel(context);
        this.myState = new DatabaseEditorState(context);
        this.myEditorPreview = new ObjectEditorWithPreview();
        this.myEditorPreview.subscribePreviewChanged(new ObjectEditorWithPreview.PreviewListener(){

            @Override
            public void changed() {
                AbstractDbRefactoringDialog.this.updateActions();
            }
        });
        this.myCentralPanel = new JPanel(new BorderLayout());
        this.myErrorPanel = new ErrorNotificationWrapperPanel();
        this.myErrorPanel.add((Component)this.myEditorPreview.getComponent(), "Center");
        this.myCentralPanel.add((Component)this.myErrorPanel, "Center");
        this.myNewOkAction = new MyOkAction();
        this.setRefactoring(false);
        this.setResultProcessor(new GenericEditingResultProcessor(this, DbRefactoringHelper.DB_SETTINGS, null));
    }

    public void doCancelAction() {
        if (this.userCancelledCancel()) {
            return;
        }
        super.doCancelAction();
    }

    private boolean userCancelledCancel() {
        boolean confirmLoss = DatabaseSettings.getSettings().ddlConfirmLoss;
        return this.isModified() && confirmLoss && Messages.showCheckboxMessageDialog((String)"You're about to lose your changes", (String)"Warning", (String[])new String[]{Messages.OK_BUTTON, Messages.CANCEL_BUTTON}, (String)"Do not ask again", (boolean)false, (int)0, (int)0, (Icon)Messages.getWarningIcon(), (code, cb) -> {
            DatabaseSettings.getSettings().ddlConfirmLoss = !cb.isSelected();
            DatabaseSettings.fireSettingsChanged();
            return code;
        }) != 0;
    }

    private boolean isModified() {
        return !this.myEditorPreview.isInvalid() && StringUtil.isNotEmpty((String)this.myEditorPreview.getStatement());
    }

    @Override
    @NotNull
    public DeModel getModel() {
        DeModel deModel = this.myModel;
        if (deModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "getModel"));
        }
        return deModel;
    }

    @NotNull
    protected abstract String getTitle(boolean var1);

    public void finish() {
        this.myEditorPreview.updatePreview();
        this.init();
    }

    public void finishAndShow() {
        this.finish();
        this.show();
    }

    public void setRefactoring(boolean refactoring) {
        this.myRefactoring = refactoring;
        this.setTitle(this.getTitle(refactoring));
    }

    public void setResultProcessor(@NotNull ResultProcessor proc) {
        if (proc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proc", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "setResultProcessor"));
        }
        if (this.myEditor != null) {
            throw new AssertionError((Object)"Result processor must be set before editor");
        }
        this.myProcessor = proc;
    }

    @Override
    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myState.context;
        if (databaseEditorContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "getContext"));
        }
        return databaseEditorContext;
    }

    protected void setEditor(@NotNull Ed editor) {
        JComponent settings;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "setEditor"));
        }
        if (this.myEditor != null) {
            throw new AssertionError((Object)"Editor is already set");
        }
        if (this.myProcessor == null) {
            throw new AssertionError((Object)"Result processor must be set before editor");
        }
        this.myEditor = editor;
        Disposer.register((Disposable)this.getDisposable(), editor);
        this.myEditorPreview.setTrailWidget(this.myProcessor.getPreviewWidget());
        JComponent jComponent = settings = this.myProcessor == null ? null : this.myProcessor.getSettingsPanel();
        if (settings != null) {
            this.myCentralPanel.add((Component)settings, "South");
        }
        this.myEditorPreview.setEditor((DatabaseEditorBaseEx)editor, this.myProcessor.createTraverser(((DatabaseEditorBase)editor).getModel()));
        this.setTitle(this.getTitle(this.myRefactoring));
    }

    @Override
    public void settingsChanged() {
        this.myEditorPreview.updatePreview();
    }

    public boolean isValid() {
        return ((DatabaseEditorBase)this.myEditor).areEditorsValid();
    }

    @Override
    @NotNull
    public JBIterable<Pair<PsiElement, String>> collectRenames() {
        if (!this.myRefactoring) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "collectRenames"));
            }
            return jBIterable;
        }
        JBIterable<Pair<PsiElement, String>> jBIterable = DbRenamePsiElementProcessor.collectRenameElements(this.myModel);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "collectRenames"));
        }
        return jBIterable;
    }

    @Override
    public Project getProject() {
        return this.getContext().getProject();
    }

    @NotNull
    public static DeModel createModel(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "createModel"));
        }
        SchemaExportHelper helper = context.getDialect().getSchemaEditor().createExportHelper(context, context.getModel());
        helper = context.getDialect().getSchemaEditor().createExportHelper(context, helper.getModel());
        DeModel deModel = helper.getModel();
        if (deModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "createModel"));
        }
        return deModel;
    }

    protected boolean hasPreviewButton() {
        return this.myRefactoring;
    }

    @NotNull
    public <De extends DeObject> De export(@NotNull DasObject obj, boolean withChildren) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "export"));
        }
        Object De = this.myModel.getExportHelper().exportDeep(this.getContext().getModel(), obj, withChildren);
        if (De == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "export"));
        }
        return De;
    }

    @Contract(value="!null, _ -> !null")
    public <De extends DeObject> De exportOp(@Nullable DasObject obj, boolean withChildren) {
        return obj == null ? null : (De)this.export(obj, withChildren);
    }

    @NotNull
    protected <De extends DeObject> De copyExport(@NotNull De obj, boolean withChildren) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "copyExport"));
        }
        De De = DeObject.copy(obj, withChildren, DeObject.DeCopier.exportExisting(this.myModel, this.getContext().getModel()));
        if (De == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "copyExport"));
        }
        return De;
    }

    @NotNull
    protected Action[] createActions() {
        Object[] actions = super.createActions();
        int i2 = ArrayUtil.indexOf((Object[])actions, (Object)this.getRefactorAction());
        assert (i2 != -1);
        actions[i2] = this.getOKAction();
        if (actions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "createActions"));
        }
        return actions;
    }

    protected void updateActions() {
        boolean valid = this.isRefactoringValid();
        this.setOKActionEnabled(valid);
        this.getPreviewAction().setEnabled(valid && !this.collectRenames().isEmpty());
        this.myNewOkAction.updateText();
        if (this.myProcessor != null) {
            this.myProcessor.update();
        }
    }

    public void setOKActionEnabled(boolean isEnabled) {
        this.getOKAction().setEnabled(isEnabled);
    }

    @NotNull
    protected Action getOKAction() {
        MyOkAction myOkAction = this.myNewOkAction;
        if (myOkAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "getOKAction"));
        }
        return myOkAction;
    }

    protected boolean isRefactoringValid() {
        return !this.myEditorPreview.isInvalid() && !StringUtil.isEmptyOrSpaces((String)this.statement());
    }

    protected void doAction() {
        this.processDoNotAskOnOk(0);
        if (this.myProcessor != null && this.getOKAction().isEnabled() && !this.myProcessor.process()) {
            this.reportError("Failed to process");
        }
    }

    protected void reportError(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "reportError"));
        }
        this.error(new RuntimeException(message));
    }

    @Override
    public void error(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "error"));
        }
        this.myErrorPanel.reportError(e);
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return AbstractDbRefactoringDialog.class.getName();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCentralPanel;
    }

    @Override
    @NotNull
    public String statement() {
        String string = this.myEditorPreview.getStatement();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "statement"));
        }
        return string;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myEditorPreview.getPreferredFocusedComponent();
    }

    protected void checkObjectInContext(@Nullable DasObject object) {
        if (object != null && ((JBTreeTraverser)this.getContext().getModel().traverser().filter(Conditions.is((Object)object))).bfsTraversal().first() == null) {
            throw new AssertionError((Object)("Object " + object.getName() + " " + object.getClass().getName() + " " + object + " not in context"));
        }
    }

    @Override
    public void success() {
        this.close(0);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo info = super.doValidate();
        if (info != null || this.myProcessor == null) {
            return info;
        }
        return this.myProcessor.validate();
    }

    @NotNull
    public Ed getEditor() {
        Ed Ed = this.myEditor;
        if (Ed == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "getEditor"));
        }
        return Ed;
    }

    @NotNull
    public ResultProcessor getProcessor() {
        ResultProcessor resultProcessor = (ResultProcessor)ObjectUtils.assertNotNull((Object)this.myProcessor);
        if (resultProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "getProcessor"));
        }
        return resultProcessor;
    }

    @NotNull
    public DatabaseEditorBaseEx getActiveEditor() {
        Ed Ed = this.myEditor;
        if (Ed == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractDbRefactoringDialog", "getActiveEditor"));
        }
        return Ed;
    }

    private class MyOkAction
    extends DialogWrapper.OkAction {
        private MyOkAction() {
            super((DialogWrapper)AbstractDbRefactoringDialog.this);
        }

        public void updateText() {
            this.putValue("Name", AbstractDbRefactoringDialog.this.myProcessor == null ? "OK" : AbstractDbRefactoringDialog.this.myProcessor.getCurrentAction());
        }

        public boolean isEnabled() {
            return super.isEnabled() && AbstractDbRefactoringDialog.this.isRefactoringValid();
        }

        protected void doAction(ActionEvent e) {
            AbstractDbRefactoringDialog.this.setPreviewResults(false);
            super.doAction(e);
        }
    }

    public static interface ResultProcessor {
        @Nullable
        public JComponent getPreviewWidget();

        public boolean process();

        @NotNull
        public DdlPreview.ModelTraverser createTraverser(@NotNull EditorModelBase var1);

        @Nullable
        public JComponent getSettingsPanel();

        public String getCurrentAction();

        public void update();

        public ValidationInfo validate();
    }
}

