/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseColumnRefEditor;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseTableColumnEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.AbstractTableDialog;
import com.intellij.openapi.util.Computable;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTableDialogHelper {
    @NotNull
    public static AbstractTableDialog newAddTableDialog(@NotNull DatabaseEditorContext context, @Nullable DasNamespace schema, @NotNull String tabName, @NotNull Collection<String> colNames) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddTableDialog"));
        }
        if (tabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabName", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddTableDialog"));
        }
        if (colNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colNames", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddTableDialog"));
        }
        AbstractTableDialog dialog = new AbstractTableDialog(context);
        dialog.setTable(dialog.createTable(schema, tabName, colNames), false);
        AbstractTableDialog abstractTableDialog = dialog;
        if (abstractTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddTableDialog"));
        }
        return abstractTableDialog;
    }

    @NotNull
    public static AbstractTableDialog newModifyTableDialog(@NotNull DatabaseEditorContext context, @NotNull DasTable table, boolean forceCreate) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newModifyTableDialog"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newModifyTableDialog"));
        }
        AbstractTableDialog dialog = new AbstractTableDialog(context);
        dialog.configureForModification((DasObject)table, forceCreate);
        AbstractTableDialog abstractTableDialog = dialog;
        if (abstractTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newModifyTableDialog"));
        }
        return abstractTableDialog;
    }

    @NotNull
    public static AbstractTableDialog newModifyTableDialog(@NotNull DatabaseEditorContext context, @NotNull DasTable table) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newModifyTableDialog"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newModifyTableDialog"));
        }
        AbstractTableDialog abstractTableDialog = AbstractTableDialogHelper.newModifyTableDialog(context, table, false);
        if (abstractTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newModifyTableDialog"));
        }
        return abstractTableDialog;
    }

    @NotNull
    public static AbstractTableDialog newAddColumnDialog(@NotNull DatabaseEditorContext context, @NotNull DasTable table, @NotNull String colName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddColumnDialog"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddColumnDialog"));
        }
        if (colName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colName", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddColumnDialog"));
        }
        AbstractTableDialog dialog = new AbstractTableDialog(context);
        dialog.configureForModification(AbstractTableDialogHelper.createColumn(dialog, table, colName), false);
        AbstractTableDialog abstractTableDialog = dialog;
        if (abstractTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddColumnDialog"));
        }
        return abstractTableDialog;
    }

    @NotNull
    public static AbstractTableDialog newModifyColumnDialog(@NotNull DatabaseEditorContext context, @NotNull DasColumn column, boolean forceCreate) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newModifyColumnDialog"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newModifyColumnDialog"));
        }
        AbstractTableDialog dialog = new AbstractTableDialog(context);
        dialog.configureForModification((DasObject)column, forceCreate);
        AbstractTableDialog abstractTableDialog = dialog;
        if (abstractTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newModifyColumnDialog"));
        }
        return abstractTableDialog;
    }

    public static AbstractTableDialog newAddForeignKeyDialog(@NotNull DatabaseEditorContext context, @NotNull DasTable table, @NotNull String fkName, @NotNull List<? extends DasColumn> columns) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddForeignKeyDialog"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddForeignKeyDialog"));
        }
        if (fkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fkName", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddForeignKeyDialog"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddForeignKeyDialog"));
        }
        AbstractTableDialog dialog = new AbstractTableDialog(context);
        dialog.configureForModification(AbstractTableDialogHelper.createForeignKey(dialog, table, fkName, columns), false);
        return dialog;
    }

    @NotNull
    public static AbstractTableDialog newModifyForeignKeyDialog(@NotNull DatabaseEditorContext context, @NotNull DasForeignKey fk, boolean forceCreate) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newModifyForeignKeyDialog"));
        }
        if (fk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fk", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newModifyForeignKeyDialog"));
        }
        AbstractTableDialog dialog = new AbstractTableDialog(context);
        dialog.configureForModification((DasObject)fk, forceCreate);
        AbstractTableDialog abstractTableDialog = dialog;
        if (abstractTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newModifyForeignKeyDialog"));
        }
        return abstractTableDialog;
    }

    @NotNull
    public static AbstractTableDialog newAddIndexDialog(@NotNull DatabaseEditorContext context, @NotNull DasTable table, @NotNull String idxName, @NotNull List<? extends DasColumn> columns) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddIndexDialog"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddIndexDialog"));
        }
        if (idxName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idxName", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddIndexDialog"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddIndexDialog"));
        }
        AbstractTableDialog dialog = new AbstractTableDialog(context);
        dialog.configureForModification(AbstractTableDialogHelper.createIndex(dialog, table, idxName, columns), false);
        AbstractTableDialog abstractTableDialog = dialog;
        if (abstractTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newAddIndexDialog"));
        }
        return abstractTableDialog;
    }

    @NotNull
    public static AbstractTableDialog newModifyIndexDialog(@NotNull DatabaseEditorContext context, @NotNull DasIndex index, boolean forceCreate) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newModifyIndexDialog"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newModifyIndexDialog"));
        }
        AbstractTableDialog dialog = new AbstractTableDialog(context);
        dialog.configureForModification((DasObject)index, forceCreate);
        AbstractTableDialog abstractTableDialog = dialog;
        if (abstractTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractTableDialogHelper", "newModifyIndexDialog"));
        }
        return abstractTableDialog;
    }

    @NotNull
    public static DeIndex createIndex(@NotNull AbstractDbRefactoringDialog<?> dialog, @NotNull DasTable table, @NotNull String idxName, @NotNull List<? extends DasColumn> columns) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/AbstractTableDialogHelper", "createIndex"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/AbstractTableDialogHelper", "createIndex"));
        }
        if (idxName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idxName", "com/intellij/database/view/ui/AbstractTableDialogHelper", "createIndex"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/ui/AbstractTableDialogHelper", "createIndex"));
        }
        dialog.checkObjectInContext((DasObject)table);
        DeTable tab = (DeTable)dialog.export((DasObject)table, true);
        ArrayList items = ContainerUtil.newArrayListWithCapacity((int)columns.size());
        for (DasColumn dasColumn : columns) {
            items.add(new DeIndex.Item((DeColumn)dialog.export((DasObject)dasColumn, false), DasIndex.Sorting.NONE));
        }
        DeIndex index = new DeIndex(idxName, tab, dialog.myModel);
        index.items.addAll(items);
        tab.indices.add(index);
        DeIndex deIndex = index;
        if (deIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractTableDialogHelper", "createIndex"));
        }
        return deIndex;
    }

    @NotNull
    public static DeForeignKey createForeignKey(@NotNull AbstractDbRefactoringDialog<?> dialog, @NotNull DasTable table, @NotNull String fkName, @NotNull List<? extends DasColumn> columns) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/AbstractTableDialogHelper", "createForeignKey"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/AbstractTableDialogHelper", "createForeignKey"));
        }
        if (fkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fkName", "com/intellij/database/view/ui/AbstractTableDialogHelper", "createForeignKey"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/ui/AbstractTableDialogHelper", "createForeignKey"));
        }
        dialog.checkObjectInContext((DasObject)table);
        DeTable tab = (DeTable)dialog.export((DasObject)table, true);
        ArrayList refs = ContainerUtil.newArrayListWithCapacity((int)columns.size());
        for (DasColumn dasColumn : columns) {
            refs.add(new DeForeignKey.Ref((DeColumn)dialog.export((DasObject)dasColumn, true), DatabaseColumnRefEditor.createStub("", tab)));
        }
        DeForeignKey fk = new DeForeignKey(fkName, tab, dialog.myModel);
        fk.refs.addAll(refs);
        tab.foreignKeys.add(fk);
        DeForeignKey deForeignKey = fk;
        if (deForeignKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractTableDialogHelper", "createForeignKey"));
        }
        return deForeignKey;
    }

    @NotNull
    public static DeColumn createColumn(@NotNull AbstractDbRefactoringDialog<?> dialog, @NotNull DasTable table, @NotNull String colName) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/AbstractTableDialogHelper", "createColumn"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/AbstractTableDialogHelper", "createColumn"));
        }
        if (colName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colName", "com/intellij/database/view/ui/AbstractTableDialogHelper", "createColumn"));
        }
        dialog.checkObjectInContext((DasObject)table);
        DeTable tab = (DeTable)dialog.export((DasObject)table, true);
        DeColumn column = new DeColumn(colName, tab, dialog.myModel);
        tab.columns.add(column);
        DeColumn deColumn = column;
        if (deColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractTableDialogHelper", "createColumn"));
        }
        return deColumn;
    }

    public static void runOnceValid(final @NotNull DatabaseEditorState state, final @NotNull Runnable r) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/view/ui/AbstractTableDialogHelper", "runOnceValid"));
        }
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/view/ui/AbstractTableDialogHelper", "runOnceValid"));
        }
        if (state.areAllEditorsValid()) {
            r.run();
        } else {
            state.validationTopic.addListener((EventListener)new EditorModelBase.Listener(){

                @Override
                public void changed() {
                    try {
                        r.run();
                    }
                    finally {
                        state.validationTopic.removeListener((EventListener)this);
                    }
                }
            });
        }
    }

    public static void runOnceValid(@NotNull AbstractDbRefactoringDialog<?> dialog, @NotNull Runnable r) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/AbstractTableDialogHelper", "runOnceValid"));
        }
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/view/ui/AbstractTableDialogHelper", "runOnceValid"));
        }
        AbstractTableDialogHelper.runOnceValid(dialog.getState(), r);
    }

    public static AbstractTableDialog bootstrap(@NotNull AbstractTableDialog dialog, @NotNull Computable<DeObject> comp) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/AbstractTableDialogHelper", "bootstrap"));
        }
        if (comp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/database/view/ui/AbstractTableDialogHelper", "bootstrap"));
        }
        AbstractTableDialogHelper.runOnceValid(dialog, () -> {
            if (comp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/database/view/ui/AbstractTableDialogHelper", "lambda$bootstrap$1"));
            }
            if (dialog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/AbstractTableDialogHelper", "lambda$bootstrap$1"));
            }
            DeObject toModify = (DeObject)comp.compute();
            AbstractTableDialogHelper.runOnceValid(dialog, () -> {
                if (dialog == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/AbstractTableDialogHelper", "lambda$null$0"));
                }
                dialog.startItemEditing(toModify);
            });
        });
        return dialog;
    }

    public static <T extends DeObject> JBIterable<T> export(final @NotNull AbstractTableDialog dialog, @NotNull Iterable<? extends DasObject> objects) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/AbstractTableDialogHelper", "export"));
        }
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/view/ui/AbstractTableDialogHelper", "export"));
        }
        return JBIterable.from(objects).transform(new Function<DasObject, T>(){

            public T fun(DasObject object) {
                return dialog.export(object, true);
            }
        });
    }

    public static boolean canAddIndex(@NotNull DatabaseEditorContext context, @NotNull DasTable table) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractTableDialogHelper", "canAddIndex"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/AbstractTableDialogHelper", "canAddIndex"));
        }
        DatabaseDialectEx dialect = context.getDialect();
        return table.getKind() == ObjectKind.TABLE && dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true).getIndexCaps(false).canDoAnything();
    }

    public static boolean canModifyIndex(@NotNull DatabaseEditorContext context, @NotNull DasIndex index) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractTableDialogHelper", "canModifyIndex"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/view/ui/AbstractTableDialogHelper", "canModifyIndex"));
        }
        DatabaseDialectEx dialect = context.getDialect();
        return dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true).getIndexCaps(true).canDoAnything();
    }

    public static boolean canAddForeignKey(@NotNull DatabaseEditorContext context, @NotNull DasTable table) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractTableDialogHelper", "canAddForeignKey"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/AbstractTableDialogHelper", "canAddForeignKey"));
        }
        DatabaseDialectEx dialect = context.getDialect();
        return table.getKind() == ObjectKind.TABLE && dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true).getForeignKeyCaps(false).canDoAnything();
    }

    public static boolean canModifyForeignKey(@NotNull DatabaseEditorContext context, @NotNull DasForeignKey fk) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractTableDialogHelper", "canModifyForeignKey"));
        }
        if (fk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fk", "com/intellij/database/view/ui/AbstractTableDialogHelper", "canModifyForeignKey"));
        }
        DatabaseDialectEx dialect = context.getDialect();
        return dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true).getForeignKeyCaps(true).canDoAnything();
    }

    public static boolean canModifyColumn(@NotNull DatabaseEditorContext context, @NotNull DasColumn columnElement) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractTableDialogHelper", "canModifyColumn"));
        }
        if (columnElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnElement", "com/intellij/database/view/ui/AbstractTableDialogHelper", "canModifyColumn"));
        }
        DatabaseDialectEx dialect = context.getDialect();
        return AbstractTableDialogHelper.getColumnCaps(dialect, columnElement).canDoAnything();
    }

    @NotNull
    public static DatabaseEditorCapabilities.TableColumnEditorCaps getColumnCaps(@NotNull DatabaseDialectEx dialect, @NotNull DasColumn column) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/view/ui/AbstractTableDialogHelper", "getColumnCaps"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/view/ui/AbstractTableDialogHelper", "getColumnCaps"));
        }
        DatabaseEditorCapabilities.TableColumnEditorCaps tableColumnEditorCaps = DatabaseTableColumnEditor.getTableColumnCaps(dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true), column.getTable(), column);
        if (tableColumnEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractTableDialogHelper", "getColumnCaps"));
        }
        return tableColumnEditorCaps;
    }
}

