/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.SchemaEditorHelper;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.operations.ConfigurableDdlGenerator;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DdlPreviewBase;
import com.intellij.database.view.ui.ErrorNotificationWrapperPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbOperationDialog
extends DialogWrapper {
    private final DdlPreviewBase myPreview;
    private final DatabaseEditorContext myContext;
    private Processor<SchemaEditorHelper> myGenerator;
    private final List<ConfigurableDdlGenerator.OptionValue<?>> myOptions;
    private final SchemaExportHelper myExportHelper;
    private ErrorNotificationWrapperPanel myErrorNotificationWrapperPanel;
    private static final int OP_COLUMNS = 3;

    public DbOperationDialog(@NotNull DatabaseEditorContext context, @NotNull List<ConfigurableDdlGenerator.OptionValue<?>> options) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbOperationDialog", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/view/ui/DbOperationDialog", "<init>"));
        }
        super(context.getProject());
        this.myContext = context;
        this.myOptions = options;
        this.myPreview = new DdlPreviewBase(this.myContext, DatabaseDialogsHelper.createAsyncProcessor((Project)ObjectUtils.assertNotNull((Object)this.myContext.getProject()), "Fetching DDL", this::updatePreview));
        this.myExportHelper = this.myContext.getDialect().getSchemaEditor().createExportHelper(this.myContext, this.myContext.getModel());
        this.init();
    }

    public void setGenerator(@NotNull PairProcessor<SchemaEditorHelper, Iterable<ConfigurableDdlGenerator.OptionValue<?>>> generator) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/view/ui/DbOperationDialog", "setGenerator"));
        }
        this.myGenerator = helper -> {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/view/ui/DbOperationDialog", "lambda$setGenerator$0"));
            }
            return generator.process(helper, this.myOptions);
        };
        this.updatePreview();
    }

    protected void updatePreview() {
        this.myPreview.updatePreview(this.myGenerator, this.myExportHelper.getModel());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myPreview.getComponent(), "Center");
        if (!this.myOptions.isEmpty()) {
            panel.add((Component)new OptionEditorPanel(), "South");
        }
        this.myErrorNotificationWrapperPanel = new ErrorNotificationWrapperPanel();
        this.myErrorNotificationWrapperPanel.add((Component)panel, "Center");
        return this.myErrorNotificationWrapperPanel;
    }

    protected void doOKAction() {
        DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler((DbDataSource)ObjectUtils.assertNotNull((Object)this.myContext.getDataSource()), null);
        handler.setStatement(this.myPreview.getPreviewText());
        handler.runStatements(true).whenCompleteAsync((r, e) -> {
            if (e != null) {
                AsyncUtil.addUnhandledError(handler.getErrorHandler(), e, handler.getDataSource().getName(), DbImplUtil.getDatabaseDialect((DbElement)handler.getDataSource()).getFamilyId());
                this.myErrorNotificationWrapperPanel.reportError(new RuntimeException(handler.getErrorHandler().getSummary("Cancelled"), (Throwable)e));
            } else {
                this.close(0);
            }
        }, AsyncUtil.EDT_EXECUTOR);
    }

    private static int getNumRows(int size) {
        return (int)Math.ceil((double)size / 3.0);
    }

    public static List<ConfigurableDdlGenerator.OptionValue<?>> getDefaults(@NotNull DdlOperations operations, DdlOperation ... ops) {
        if (operations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operations", "com/intellij/database/view/ui/DbOperationDialog", "getDefaults"));
        }
        if (ops == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ops", "com/intellij/database/view/ui/DbOperationDialog", "getDefaults"));
        }
        return JBIterable.of((Object[])ops).flatten(operation -> {
            if (operations == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operations", "com/intellij/database/view/ui/DbOperationDialog", "lambda$getDefaults$2"));
            }
            ConfigurableDdlGenerator generator = (ConfigurableDdlGenerator)ObjectUtils.tryCast(operations.get((DdlOperation)operation), ConfigurableDdlGenerator.class);
            if (generator == null) {
                return JBIterable.empty();
            }
            return JBIterable.of((Object[])generator.getOptions());
        }).transform(option -> ConfigurableDdlGenerator.OptionValue.defaultOf(option)).toList();
    }

    @NotNull
    public static PairProcessor<SchemaEditorHelper, Iterable<ConfigurableDdlGenerator.OptionValue<?>>> createGenerator(@NotNull DbOperationDialog dialog, @NotNull Iterable<? extends DasObject> objects, DdlOperation ... ops) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/DbOperationDialog", "createGenerator"));
        }
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/view/ui/DbOperationDialog", "createGenerator"));
        }
        if (ops == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ops", "com/intellij/database/view/ui/DbOperationDialog", "createGenerator"));
        }
        ArrayList exported = ContainerUtil.newArrayList();
        JBIterable.from(objects).transform(object -> {
            if (dialog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/DbOperationDialog", "lambda$createGenerator$4"));
            }
            return dialog.export((DasObject)object, true);
        }).addAllTo((Collection)exported);
        PairProcessor pairProcessor = (helper, values) -> {
            if (ops == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ops", "com/intellij/database/view/ui/DbOperationDialog", "lambda$createGenerator$5"));
            }
            DdlGenerator generator = helper.getDdlGenerator();
            DdlGraphBuilder builder = helper.getDdlGraphBuilder();
            UserDataHolder data = builder.newData(null);
            ConfigurableDdlGenerator.OPTION_VALUES.set(data, values);
            for (DeObject object : exported) {
                for (DdlOperation op : ops) {
                    generator.addOperation(builder, op, object, data);
                }
            }
            return true;
        };
        if (pairProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbOperationDialog", "createGenerator"));
        }
        return pairProcessor;
    }

    @NotNull
    private DeObject export(@NotNull DasObject object, boolean withChildren) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/DbOperationDialog", "export"));
        }
        Object De = this.myExportHelper.exportDeep(this.myContext.getModel(), object, withChildren);
        if (De == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbOperationDialog", "export"));
        }
        return De;
    }

    @NotNull
    public static DbOperationDialog createDialog(@NotNull DatabaseEditorContext context, @NotNull Iterable<? extends DasObject> objects, DdlOperation ... ops) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbOperationDialog", "createDialog"));
        }
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/view/ui/DbOperationDialog", "createDialog"));
        }
        if (ops == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ops", "com/intellij/database/view/ui/DbOperationDialog", "createDialog"));
        }
        DbOperationDialog dialog = new DbOperationDialog(context, DbOperationDialog.getDefaults(context.getDialect().getSchemaEditor().getDdlOperations(), ops));
        dialog.setGenerator(DbOperationDialog.createGenerator(dialog, objects, ops));
        DbOperationDialog dbOperationDialog = dialog;
        if (dbOperationDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbOperationDialog", "createDialog"));
        }
        return dbOperationDialog;
    }

    private class OptionEditorPanel
    extends JPanel {
        public OptionEditorPanel() {
            super((LayoutManager)new GridLayoutManager(DbOperationDialog.getNumRows(DbOperationDialog.this.myOptions.size()), 4));
            Dimension sz = new Dimension(-1, -1);
            for (int i2 = 0; i2 < DbOperationDialog.this.myOptions.size(); ++i2) {
                ConfigurableDdlGenerator.OptionValue option = (ConfigurableDdlGenerator.OptionValue)DbOperationDialog.this.myOptions.get(i2);
                GridConstraints constraints = new GridConstraints(i2 / 3, i2 % 3, 1, 1, 8, 3, 0, 0, sz, sz, sz);
                this.add((Component)this.createEditor(option), constraints);
            }
            this.add(Box.createHorizontalGlue(), new GridConstraints(0, 3, DbOperationDialog.getNumRows(DbOperationDialog.this.myOptions.size()), 1, 8, 3, 6, 0, sz, sz, sz));
        }

        @NotNull
        private JComponent createEditor(@NotNull ConfigurableDdlGenerator.OptionValue<?> option) {
            if (option == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/database/view/ui/DbOperationDialog$OptionEditorPanel", "createEditor"));
            }
            if (option.option.valueClass.isAssignableFrom(Boolean.class)) {
                JComponent jComponent = this.createBooleanEditor(option);
                if (jComponent == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbOperationDialog$OptionEditorPanel", "createEditor"));
                }
                return jComponent;
            }
            throw new AssertionError((Object)"Unsupported option");
        }

        @NotNull
        private JComponent createBooleanEditor(final @NotNull ConfigurableDdlGenerator.OptionValue<Boolean> option) {
            if (option == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/database/view/ui/DbOperationDialog$OptionEditorPanel", "createBooleanEditor"));
            }
            JBCheckBox ed = new JBCheckBox(option.option.name, option.value == Boolean.TRUE);
            ed.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    option.value = e.getStateChange() == 1;
                    DbOperationDialog.this.updatePreview();
                }
            });
            JBCheckBox jBCheckBox = ed;
            if (jBCheckBox == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbOperationDialog$OptionEditorPanel", "createBooleanEditor"));
            }
            return jBCheckBox;
        }
    }
}

