/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteringTree<T extends DefaultMutableTreeNode, U> {
    private final Project myProject;
    private final T myRoot;
    private final Tree myTree;
    private final SearchTextField myField;
    private final JComponent myPanel;
    private final MySpeedSearch mySpeedSearch;
    private final JScrollPane myScrollPane;

    public FilteringTree(@NotNull Project project, @NotNull Tree tree, @NotNull T root2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/ui/FilteringTree", "<init>"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/database/view/ui/FilteringTree", "<init>"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/view/ui/FilteringTree", "<init>"));
        }
        this.myProject = project;
        this.myRoot = root2;
        this.myTree = tree;
        this.myField = new SearchTextField(false){

            protected boolean preprocessEventForTextField(KeyEvent e) {
                if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
                    FilteringTree.this.myTree.dispatchEvent((AWTEvent)e);
                    return true;
                }
                return false;
            }
        };
        this.mySpeedSearch = new MySpeedSearch<T>((JComponent)this.myTree, (JTextComponent)this.myField.getTextEditor()){

            @Override
            protected void onSearchFieldUpdated(String pattern) {
                TreePath[] paths = FilteringTree.this.myTree.getSelectionModel().getSelectionPaths();
                FilteringTree.this.getSearchModel().refilter();
                FilteringTree.this.myTree.getSelectionModel().setSelectionPaths(paths);
            }

            @Override
            public void select(@NotNull T node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/view/ui/FilteringTree$2", "select"));
                }
                TreeUtil.selectInTree(node, (boolean)false, (JTree)FilteringTree.this.myTree);
            }

            @Override
            public boolean isMatching(@NotNull T node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/view/ui/FilteringTree$2", "isMatching"));
                }
                String text = FilteringTree.this.getText(FilteringTree.this.getUserObject((TreeNode)node));
                return text != null && this.matchingFragments(text) != null;
            }

            @Override
            @Nullable
            public T getSelection() {
                return (DefaultMutableTreeNode)ArrayUtil.getFirstElement((Object[])FilteringTree.this.myTree.getSelectedNodes(FilteringTree.this.getNodeClass(), null));
            }

            @Override
            @NotNull
            public Iterator<T> iterate(@Nullable T start, boolean fwd) {
                JBTreeTraverser traverser = (JBTreeTraverser)new JBTreeTraverser(n -> {
                    int count = n.getChildCount();
                    ArrayList children = ContainerUtil.newArrayListWithCapacity((int)count);
                    for (int i2 = 0; i2 < count; ++i2) {
                        DefaultMutableTreeNode c = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)n.getChildAt(fwd ? i2 : count - i2 - 1), FilteringTree.this.getNodeClass());
                        if (c == null) continue;
                        children.add(c);
                    }
                    return children;
                }).expand(Conditions.alwaysTrue());
                if (start == null) {
                    traverser = (JBTreeTraverser)traverser.withRoot(FilteringTree.this.getRoot());
                } else {
                    ArrayList roots = ContainerUtil.newArrayList();
                    TreeNode node = null;
                    Object parent = start;
                    while (parent != null) {
                        int c;
                        int idx = node == null ? -1 : parent.getIndex(node);
                        int n2 = c = fwd ? parent.getChildCount() : idx;
                        for (int i2 = fwd ? idx + 1 : 0; i2 < c; ++i2) {
                            DefaultMutableTreeNode child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)parent.getChildAt(fwd ? i2 : idx - i2 - 1), FilteringTree.this.getNodeClass());
                            if (child == null) continue;
                            roots.add(child);
                        }
                        node = (TreeNode)parent;
                        parent = node.getParent();
                    }
                    traverser = (JBTreeTraverser)traverser.withRoots((Iterable)roots);
                }
                Iterator iterator = traverser.preOrderDfsTraversal().iterator();
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$2", "iterate"));
                }
                return iterator;
            }
        };
        this.myTree.setModel(new SearchTreeModel(this.myRoot, this.mySpeedSearch, o -> this.getText(o), this::createNode, this::getChildren));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)this.myField, "West");
        JComponent component = this.createToolbarComponent();
        if (component != null) {
            northPanel.add((Component)component, "Center");
        }
        northPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)northPanel, "North");
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree, (boolean)true);
        this.myPanel.add((Component)this.myScrollPane, "Center");
        this.rebuildTree();
    }

    protected abstract JComponent createToolbarComponent();

    public JScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    protected abstract Class<? extends T> getNodeClass();

    @NotNull
    protected abstract T createNode(@NotNull U var1);

    @NotNull
    protected abstract Iterable<U> getChildren(@NotNull U var1);

    @NotNull
    public Tree getTree() {
        Tree tree = this.myTree;
        if (tree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree", "getTree"));
        }
        return tree;
    }

    @NotNull
    public SearchTextField getField() {
        SearchTextField searchTextField = this.myField;
        if (searchTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree", "getField"));
        }
        return searchTextField;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree", "getComponent"));
        }
        return jComponent;
    }

    protected void rebuildTree() {
    }

    @Nullable
    protected abstract String getText(@Nullable U var1);

    @NotNull
    public SearchTreeModel<T, U> getSearchModel() {
        SearchTreeModel searchTreeModel = (SearchTreeModel)this.myTree.getModel();
        if (searchTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree", "getSearchModel"));
        }
        return searchTreeModel;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree", "getProject"));
        }
        return project;
    }

    public void resetSearch() {
        this.mySpeedSearch.reset();
    }

    @NotNull
    public T getRoot() {
        T t = this.myRoot;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree", "getRoot"));
        }
        return t;
    }

    public void update() {
        this.rebuildTree();
        this.myTree.revalidate();
        this.myTree.repaint();
    }

    @Nullable
    public final U getUserObject(@Nullable TreeNode node) {
        return (U)(node == null || !this.getNodeClass().isAssignableFrom(node.getClass()) ? null : ((DefaultMutableTreeNode)node).getUserObject());
    }

    private static class MySpeedSearch<Item>
    extends SpeedSearchSupply {
        private boolean myUpdating;
        private final PropertyChangeSupport myChangeSupport;
        private final SpeedSearch mySpeedSearch;
        private final JTextComponent myField;

        public MySpeedSearch(@NotNull JComponent comp, @NotNull JTextComponent field) {
            if (comp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "<init>"));
            }
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "<init>"));
            }
            this.myUpdating = false;
            this.myChangeSupport = new PropertyChangeSupport((Object)this);
            this.mySpeedSearch = new SpeedSearch(){

                public void update() {
                    String filter = mySpeedSearch.getFilter();
                    myChangeSupport.firePropertyChange("ENTERED_PREFIX_PROPERTY", null, filter);
                    if (!myUpdating) {
                        myUpdating = true;
                        try {
                            myField.setText(filter);
                        }
                        finally {
                            myUpdating = false;
                        }
                    }
                    this.onSearchFieldUpdated(filter);
                    this.updateSelection();
                }
            };
            this.myField = field;
            this.myField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    if (!myUpdating) {
                        myUpdating = true;
                        try {
                            mySpeedSearch.updatePattern(myField.getText());
                            mySpeedSearch.update();
                        }
                        finally {
                            myUpdating = false;
                        }
                    }
                }
            });
            this.mySpeedSearch.setEnabled(true);
            comp.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (this.selectTargetElement(e.getKeyCode())) {
                        e.consume();
                        return;
                    }
                    if ((e.getModifiers() & 8) == 0) {
                        mySpeedSearch.process(e);
                    }
                }
            });
            this.installSupplyTo(comp);
        }

        @Nullable
        public Iterable<TextRange> matchingFragments(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "matchingFragments"));
            }
            MinusculeMatcher matcher = (MinusculeMatcher)ObjectUtils.tryCast((Object)this.mySpeedSearch.getMatcher(), MinusculeMatcher.class);
            return matcher == null ? null : matcher.matchingFragments(text);
        }

        public void updateSelection() {
            Item selection = this.getSelection();
            if (selection != null && this.isMatching(selection)) {
                return;
            }
            JBIterator it = JBIterator.from(this.iterate(selection, true, true)).filter(item -> item != selection && this.isMatching(item));
            if (!it.advance()) {
                return;
            }
            this.select(it.current());
        }

        public void refreshSelection() {
        }

        public boolean isPopupActive() {
            return this.mySpeedSearch.isHoldingFilter();
        }

        public void addChangeListener(@NotNull PropertyChangeListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "addChangeListener"));
            }
            this.myChangeSupport.addPropertyChangeListener(listener);
        }

        public void removeChangeListener(@NotNull PropertyChangeListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "removeChangeListener"));
            }
            this.myChangeSupport.removePropertyChangeListener(listener);
        }

        public void findAndSelectElement(@NotNull String searchQuery) {
            if (searchQuery == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchQuery", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "findAndSelectElement"));
            }
        }

        public void reset() {
            this.mySpeedSearch.reset();
        }

        protected void onSearchFieldUpdated(String pattern) {
        }

        public void select(@NotNull Item item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "select"));
            }
        }

        @Nullable
        public Item getSelection() {
            return null;
        }

        public boolean isMatching(@NotNull Item item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "isMatching"));
            }
            return false;
        }

        @NotNull
        public Iterator<Item> iterate(@Nullable Item start, boolean fwd) {
            JBIterator jBIterator = new JBIterator<Item>(){

                protected Item nextImpl() {
                    return this.stop();
                }
            };
            if (jBIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "iterate"));
            }
            return jBIterator;
        }

        @NotNull
        public Iterator<Item> iterate(final @Nullable Item start, final boolean fwd, boolean wrap) {
            if (!wrap || start == null) {
                Iterator<Item> iterator = this.iterate(start, fwd);
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "iterate"));
                }
                return iterator;
            }
            JBIterator jBIterator = new JBIterator<Item>(){
                boolean wrapped = false;
                Iterator<Item> it = this.iterate(start, fwd);

                protected Item nextImpl() {
                    if (this.it.hasNext()) {
                        return this.it.next();
                    }
                    if (this.wrapped) {
                        return this.stop();
                    }
                    this.wrapped = true;
                    this.it = JBIterator.from(this.iterate(null, fwd)).takeWhile(item -> item != start);
                    return this.it.hasNext() ? this.it.next() : this.stop();
                }
            };
            if (jBIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "iterate"));
            }
            return jBIterator;
        }

        private boolean selectTargetElement(int keyCode) {
            JBIterator it;
            if (!this.isPopupActive()) {
                return false;
            }
            if (keyCode == 38) {
                it = this.iterate(this.getSelection(), false, UISettings.getInstance().getCycleScrolling());
            } else if (keyCode == 40) {
                it = this.iterate(this.getSelection(), true, UISettings.getInstance().getCycleScrolling());
            } else if (keyCode == 36) {
                it = this.iterate(null, true);
            } else if (keyCode == 35) {
                it = this.iterate(null, false);
            } else {
                return false;
            }
            it = JBIterator.from(it).filter(item -> this.isMatching(item));
            if (it.hasNext()) {
                this.select(it.next());
            }
            return true;
        }
    }

    public static class SearchTreeModel<N extends DefaultMutableTreeNode, U>
    extends DefaultTreeModel {
        private final SpeedSearchSupply mySpeedSearch;
        private final Function<U, String> myNamer;
        private final Function<U, N> myFactory;
        private final U myRootObject;
        private final Function<U, Iterable<U>> myStructure;
        private Map<U, N> myNodeCache;
        private final EventDispatcher<Listener<U>> myNodeChanged;

        public SearchTreeModel(@NotNull N root2, @NotNull SpeedSearchSupply speedSearch, @NotNull Function<U, String> namer, @NotNull Function<U, N> nodeFactory, @NotNull Function<U, Iterable<U>> structure) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "<init>"));
            }
            if (speedSearch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "speedSearch", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "<init>"));
            }
            if (namer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namer", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "<init>"));
            }
            if (nodeFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeFactory", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "<init>"));
            }
            if (structure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "<init>"));
            }
            super((TreeNode)root2);
            this.myNodeCache = ContainerUtil.newIdentityHashMap();
            this.myNodeChanged = EventDispatcher.create(Listener.class);
            this.myRootObject = ObjectUtils.assertNotNull(this.getUserObject(root2));
            this.mySpeedSearch = speedSearch;
            this.myNamer = namer;
            this.myFactory = nodeFactory;
            this.myStructure = structure;
            this.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    Object object = this.getUserObject((DefaultMutableTreeNode)e.getTreePath().getLastPathComponent());
                    if (object != null) {
                        this.nodeChanged(object);
                    }
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                }
            });
        }

        public void nodeChanged(@NotNull U object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "nodeChanged"));
            }
            ((Listener)this.myNodeChanged.getMulticaster()).consume(object);
        }

        public void addNodeListener(@NotNull Listener<U> listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "addNodeListener"));
            }
            this.myNodeChanged.addListener(listener);
        }

        public void updateStructure() {
            IdentityHashMap newNodes = ContainerUtil.newIdentityHashMap();
            Iterator iterator = ((JBTreeTraverser)new JBTreeTraverser(this.myStructure).withRoot(this.getRootObject())).iterator();
            while (iterator.hasNext()) {
                Object node;
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.myNodeCache.get(node = iterator.next());
                newNodes.put(node, treeNode == null ? this.createNode(node) : treeNode);
            }
            ArrayList oldNodes = ContainerUtil.newArrayList();
            for (Map.Entry<U, N> entry : this.myNodeCache.entrySet()) {
                if (newNodes.containsKey(entry.getKey())) continue;
                oldNodes.add(entry.getValue());
            }
            this.myNodeCache = newNodes;
            for (DefaultMutableTreeNode node : oldNodes) {
                if (node.getParent() == null) continue;
                this.removeNodeFromParent(node);
            }
            this.refilter();
        }

        public N getRoot() {
            return (N)((DefaultMutableTreeNode)this.root);
        }

        @NotNull
        public U getRootObject() {
            U u = this.myRootObject;
            if (u == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "getRootObject"));
            }
            return u;
        }

        @NotNull
        public N getNode(@NotNull U object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "getNode"));
            }
            if (object == this.myRootObject) {
                Object object2 = this.getRoot();
                if (object2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "getNode"));
                }
                return (N)object2;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.myNodeCache.get(object);
            if (node == null) {
                node = this.createNode(object);
                this.myNodeCache.put(object, node);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = node;
            if (defaultMutableTreeNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "getNode"));
            }
            return (N)defaultMutableTreeNode;
        }

        @NotNull
        protected N createNode(@NotNull U object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "createNode"));
            }
            assert (!(object instanceof DefaultMutableTreeNode));
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myFactory.fun(object);
            if (defaultMutableTreeNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "createNode"));
            }
            return (N)defaultMutableTreeNode;
        }

        public void refilter() {
            if (this.mySpeedSearch.isPopupActive()) {
                THashSet acceptCache = ContainerUtil.newIdentityTroveSet();
                this.computeAcceptCache(this.myRootObject, (Set<U>)acceptCache);
                this.filterChildren(this.myRootObject, arg_0 -> SearchTreeModel.lambda$refilter$0((Set)acceptCache, arg_0));
            } else {
                this.filterChildren(this.myRootObject, x -> true);
            }
        }

        private boolean computeAcceptCache(@NotNull U object, @NotNull Set<U> cache) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "computeAcceptCache"));
            }
            if (cache == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "computeAcceptCache"));
            }
            boolean isAccepted = false;
            for (U child : this.getChildren(object)) {
                isAccepted |= this.computeAcceptCache(child, cache);
            }
            if (isAccepted |= object == this.myRootObject || this.accept(object)) {
                cache.add(object);
            }
            return isAccepted;
        }

        @NotNull
        public Iterable<U> getChildren(@Nullable U object) {
            Object object2 = object == null ? JBIterable.empty() : (Iterable)this.myStructure.fun(object);
            if (object2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "getChildren"));
            }
            return object2;
        }

        @NotNull
        public Function<U, Iterable<U>> getStructure() {
            Function<U, Iterable<U>> function = this.myStructure;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "getStructure"));
            }
            return function;
        }

        @Nullable
        private static <N extends DefaultMutableTreeNode> N getChildSafe(@NotNull N node, int i2) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "getChildSafe"));
            }
            return node.getChildCount() <= i2 ? null : (N)SearchTreeModel.getChild(node, i2);
        }

        private static <N extends DefaultMutableTreeNode> N getChild(@NotNull N node, int i2) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "getChild"));
            }
            return (N)((DefaultMutableTreeNode)node.getChildAt(i2));
        }

        private void filterChildren(@Nullable U object, @NotNull Condition<U> filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "filterChildren"));
            }
            if (object == null) {
                return;
            }
            N node = this.getNode(object);
            this.filterDirectChildren(node, filter);
            int c = ((DefaultMutableTreeNode)node).getChildCount();
            for (int i2 = 0; i2 < c; ++i2) {
                this.filterChildren(this.getUserObject(SearchTreeModel.getChild(node, i2)), filter);
            }
        }

        private void filterDirectChildren(@NotNull N node, @NotNull Condition<U> filter) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "filterDirectChildren"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "filterDirectChildren"));
            }
            int k = 0;
            N cur = SearchTreeModel.getChildSafe(node, 0);
            for (U child : this.getChildren(this.getUserObject(node))) {
                boolean isCur;
                boolean accepted = filter.value(child);
                boolean bl = isCur = cur != null && this.getUserObject(cur) == child;
                if (accepted) {
                    if (!isCur) {
                        N childNode = this.getNode(child);
                        if (((DefaultMutableTreeNode)childNode).getParent() != null) {
                            this.removeNodeFromParent((MutableTreeNode)childNode);
                        }
                        this.insertNodeInto((MutableTreeNode)childNode, (MutableTreeNode)node, k);
                    } else {
                        cur = SearchTreeModel.getChildSafe(node, k + 1);
                    }
                    ++k;
                    continue;
                }
                if (!isCur) continue;
                this.removeNodeFromParent((MutableTreeNode)cur);
                cur = SearchTreeModel.getChildSafe(node, k);
            }
            if (((DefaultMutableTreeNode)node).getChildCount() > k) {
                for (int i2 = ((DefaultMutableTreeNode)node).getChildCount() - 1; i2 >= k; --i2) {
                    this.removeNodeFromParent((MutableTreeNode)SearchTreeModel.getChild(node, i2));
                }
            }
        }

        protected boolean accept(@NotNull U child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "accept"));
            }
            if (!this.mySpeedSearch.isPopupActive()) {
                return true;
            }
            String name = (String)this.myNamer.fun(child);
            if (name == null) {
                return true;
            }
            return this.mySpeedSearch.matchingFragments(name) != null;
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getRoot() != node && super.isLeaf(node);
        }

        @Nullable
        public final U getUserObject(@Nullable N node) {
            return (U)(node == null ? null : ((DefaultMutableTreeNode)node).getUserObject());
        }

        private static /* synthetic */ boolean lambda$refilter$0(Set acceptCache, Object x) {
            return acceptCache.contains(x);
        }

        public static interface Listener<U>
        extends EventListener,
        Consumer<U> {
        }
    }
}

