/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.lang.cacheBuilder.VersionedWordsScanner;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.impl.SqlElementDescriptionProvider;
import com.intellij.util.Processor;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFindUsagesProvider
implements FindUsagesProvider {
    @Nullable
    public WordsScanner getWordsScanner() {
        return new VersionedWordsScanner(){

            public void processWords(CharSequence fileText, Processor<WordOccurrence> processor) {
                int index = 0;
                WordOccurrence occurrence = null;
                char[] fileTextArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)fileText);
                while (index != fileText.length()) {
                    char c;
                    char c2 = c = fileTextArray != null ? fileTextArray[index] : fileText.charAt(index);
                    if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || Character.isJavaIdentifierStart(c))) {
                        ++index;
                        continue;
                    }
                    int index1 = index;
                    while (++index != fileText.length()) {
                        char c3;
                        char c4 = c3 = fileTextArray != null ? fileTextArray[index] : fileText.charAt(index);
                        if (c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z' || c3 >= '0' && c3 <= '9' || Character.isJavaIdentifierPart(c3)) continue;
                        break;
                    }
                    if (index - index1 > 100) continue;
                    if (occurrence == null) {
                        occurrence = new WordOccurrence(fileText, index1, index, null);
                    } else {
                        occurrence.init(fileText, index1, index, null);
                    }
                    processor.process((Object)occurrence);
                }
            }
        };
    }

    public boolean canFindUsagesFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlFindUsagesProvider", "canFindUsagesFor"));
        }
        return element instanceof SqlElement && element instanceof PsiNamedElement;
    }

    @Nullable
    public String getHelpId(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/sql/SqlFindUsagesProvider", "getHelpId"));
        }
        return null;
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlFindUsagesProvider", "getType"));
        }
        if (element instanceof SqlDefinition) {
            String string = SqlElementDescriptionProvider.getKindName((SqlDefinition)element);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlFindUsagesProvider", "getType"));
            }
            return string;
        }
        String string = element.getClass().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlFindUsagesProvider", "getType"));
        }
        return string;
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlFindUsagesProvider", "getDescriptiveName"));
        }
        String string = this.getNodeText(element, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlFindUsagesProvider", "getDescriptiveName"));
        }
        return string;
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        String name;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlFindUsagesProvider", "getNodeText"));
        }
        if (element instanceof PsiNamedElement && (name = ((PsiNamedElement)element).getName()) != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlFindUsagesProvider", "getNodeText"));
        }
        return string;
    }
}

