/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.MethodInfo;
import com.intellij.codeInsight.hints.Option;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlValuesParameterInfoHandler;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlInlayValuesParameterHintsHandler
implements InlayParameterHintsProvider {
    private static final Option COLUMN_NAMES_IN_INSERT_VALUES = new Option("sql.show.column.names.in.insert.values", "Show column names in insert values", true);

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getParameterHints"));
        }
        if (!COLUMN_NAMES_IN_INSERT_VALUES.get()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getParameterHints"));
            }
            return list;
        }
        if (!(element instanceof SqlParenthesizedExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getParameterHints"));
            }
            return list;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, SqlValuesExpression.class) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getParameterHints"));
            }
            return list;
        }
        SqlFunctionsUtil.ExpressionList first = (SqlFunctionsUtil.ExpressionList)JBIterable.of((Object[])SqlValuesParameterInfoHandler.getLists((SqlExpressionList)((SqlParenthesizedExpression)element))).filter(SqlFunctionsUtil.ExpressionList::isMatched).first();
        if (first == null || !first.isValid()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getParameterHints"));
            }
            return list;
        }
        ArrayList objects = ContainerUtil.newArrayList();
        first.processArgumentTypes((e, name, type) -> objects.add(new InlayInfo(StringUtil.notNullize((String)name), e.getTextRange().getStartOffset())));
        ArrayList arrayList = objects;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getParameterHints"));
        }
        return arrayList;
    }

    @Nullable
    public MethodInfo getMethodInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getMethodInfo"));
        }
        return new MethodInfo("<values>", ContainerUtil.newSmartList());
    }

    @NotNull
    public Set<String> getDefaultBlackList() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getDefaultBlackList"));
        }
        return set;
    }

    @Nullable
    public Language getBlackListDependencyLanguage() {
        return null;
    }

    @NotNull
    public List<Option> getSupportedOptions() {
        List list = ContainerUtil.newSmartList((Object)COLUMN_NAMES_IN_INSERT_VALUES);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getSupportedOptions"));
        }
        return list;
    }
}

