/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.script.QueryParametersProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQueryParametersProvider
extends QueryParametersProvider<SqlFile> {
    @Nullable
    public Map<String, PsiElement> getParameters(@NotNull SqlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/SqlQueryParametersProvider", "getParameters"));
        }
        SqlStatement statement = (SqlStatement)SqlImplUtil.sqlChildren((PsiElement)file).filter(SqlStatement.class).first();
        if (statement == null) {
            return null;
        }
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        for (SqlParameter o : SqlImplUtil.sqlTraverser((PsiElement)statement).filter(SqlParameter.class)) {
            String realName;
            String name = o.getName();
            String string = realName = StringUtil.isEmpty((String)name) ? String.valueOf(map.size() + 1) : name;
            if (map.containsKey(realName)) continue;
            map.put(realName, new Parameter(file, o));
        }
        return map;
    }

    private static class Parameter
    extends RenameableFakePsiElement {
        final SqlParameter usage;

        Parameter(SqlFile containingFile, SqlParameter usage) {
            super((PsiElement)containingFile);
            this.usage = usage;
        }

        @NotNull
        public String getName() {
            String string = this.usage.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlQueryParametersProvider$Parameter", "getName"));
            }
            return string;
        }

        @Nullable
        public TextRange getTextRange() {
            return this.usage.getTextRange();
        }

        @NotNull
        public PsiElement getNavigationElement() {
            SqlParameter sqlParameter = this.usage;
            if (sqlParameter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlQueryParametersProvider$Parameter", "getNavigationElement"));
            }
            return sqlParameter;
        }

        public boolean isValid() {
            if (!super.isValid()) {
                return false;
            }
            SqlFile file = (SqlFile)this.getContainingFile();
            Map<String, PsiElement> params2 = new SqlQueryParametersProvider().getParameters(file);
            return params2 != null && params2.containsValue((Object)this);
        }

        public String getTypeName() {
            return "Query Parameter";
        }

        @Nullable
        public Icon getIcon() {
            return PlatformIcons.PARAMETER_ICON;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Parameter that = (Parameter)((Object)o);
            return this.usage.equals(that.usage);
        }

        public int hashCode() {
            return this.usage.hashCode();
        }
    }
}

