/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.hsqldb;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.hsqldb.HsqlDdlParsing;
import com.intellij.sql.dialects.hsqldb.HsqlDmlParsing;
import com.intellij.sql.dialects.hsqldb.HsqlExpressionParsing;
import com.intellij.sql.dialects.hsqldb.HsqlGeneratedParser;
import com.intellij.sql.dialects.hsqldb.HsqlTypes;
import com.intellij.sql.dialects.hsqldb.HsqldbDialect;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.impl.parser.SqlParser;
import com.intellij.sql.psi.impl.parser.SqlParserUtil;

public class HsqlParser
extends SqlParser {
    public HsqlParser() {
        super(HsqldbDialect.INSTANCE);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return HsqlGeneratedParser.statement(builder, level);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return HsqlGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return HsqlDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = HsqlExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error("<expression> expected");
        }
        return result;
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level) {
        return HsqlDdlParsing.type_element(builder, level);
    }

    @Override
    public IElementType parseLiteralOther(PsiBuilder builder, int level) {
        if (SqlParserUtil.consumeOptionalToken(builder, HsqlTypes.HSQL_ARRAY) && SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_LEFT_BRACKET)) {
            this.parseSimpleExpressionList(builder, level, true);
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_RIGHT_BRACKET);
            return SQL_ARRAY_LITERAL;
        }
        return super.parseLiteralOther(builder, level);
    }

    @Override
    public boolean parseFunctionParametersAndParens(PsiBuilder builder, int level, String functionName, SqlFunctionDefinition definition, boolean allowNoParens) {
        if ("ARRAY".equals(functionName)) {
            if (SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_LEFT_BRACKET)) {
                return false;
            }
            if (SqlParserUtil.consumeToken(builder, (IElementType)SQL_LEFT_PAREN)) {
                this.parseQueryExpression(builder, level);
                SqlParserUtil.consumeToken(builder, (IElementType)SQL_RIGHT_PAREN);
            }
            return true;
        }
        return super.parseFunctionParametersAndParens(builder, level, functionName, definition, allowNoParens);
    }

    public SqlCompositeElementType parseIntervalLiteral(PsiBuilder builder, int level) {
        if (HsqlExpressionParsing.unary_interval_literal_expr_tail(builder, level)) {
            return SQL_INTERVAL_LITERAL;
        }
        return null;
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, HsqlExpressionParsing::parenthesized_values_expr, HsqlDmlParsing::top_query_expression_simple, HsqlParser::parseTopQueryExpressionTail, HsqlExpressionParsing::row_element_list, (b, l) -> HsqlExpressionParsing.root_expr_0(b, l, -1) && HsqlExpressionParsing.row_element_list_separator(b, l) && HsqlExpressionParsing.row_element_list(b, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, HsqlDmlParsing::parenthesized_aliased_join_expression, HsqlDmlParsing::top_query_expression, HsqlParser::parseTopQueryExpressionTail, (b, l) -> HsqlDmlParsing.join_expression(b, l, -1), (b, l) -> HsqlDmlParsing.join_expression_0(b, l, -1));
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        HsqlDmlParsing.query_expression_0(builder, level, -1);
        return HsqlDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

