/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.psi.SqlTokens;

public class OraGeneratedParserUtil
extends SqlGeneratedParserUtil {
    public static boolean divOperatorCondition(PsiBuilder b, int l) {
        int start;
        IElementType type;
        if (b.getTokenType() != OraTypes.ORA_OP_DIV) {
            return false;
        }
        int idx = -1;
        int end = b.getCurrentOffset();
        while (true) {
            if ((type = b.rawLookup(idx)) == null) {
                return false;
            }
            start = b.rawTokenTypeStart(idx);
            if (!SqlTokens.WHITE_SPACE_TOKENS.contains(type)) {
                return true;
            }
            if (StringUtil.containsLineBreak((CharSequence)b.getOriginalText().subSequence(start, end))) break;
            --idx;
            end = start;
        }
        idx = 1;
        start = b.getCurrentOffset();
        while (true) {
            if ((type = b.rawLookup(idx)) == null) {
                return true;
            }
            end = b.rawTokenTypeStart(idx + 1);
            if (!SqlTokens.COMMENT_TOKENS.contains(type)) {
                if (!SqlTokens.WHITE_SPACE_TOKENS.contains(type)) {
                    return true;
                }
                if (StringUtil.containsLineBreak((CharSequence)b.getOriginalText().subSequence(start, end))) break;
            }
            ++idx;
            start = end;
        }
        return false;
    }
}

