/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.database.util.Case;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCloseBlockProcessorImpl
implements SqlCloseBlockProcessor {
    private final SubstitutionDescriptor[] myDescriptors;

    public SqlCloseBlockProcessorImpl(SubstitutionDescriptor ... descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/sql/editor/SqlCloseBlockProcessorImpl", "<init>"));
        }
        this.myDescriptors = descriptors;
    }

    @Override
    public boolean process(@NotNull PsiElement workingElement, @NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        if (workingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingElement", "com/intellij/sql/editor/SqlCloseBlockProcessorImpl", "process"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/editor/SqlCloseBlockProcessorImpl", "process"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/editor/SqlCloseBlockProcessorImpl", "process"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/sql/editor/SqlCloseBlockProcessorImpl", "process"));
        }
        for (SubstitutionDescriptor descriptor : this.myDescriptors) {
            PsiElement root2 = descriptor.getExprRoot(workingElement);
            if (root2 == null) continue;
            ArrayList path = ContainerUtil.newArrayList();
            do {
                path.add(workingElement);
            } while (workingElement != root2 && (workingElement = workingElement.getParent()) != null);
            return this.processDescriptor(path, descriptor, editor, dataContext);
        }
        return false;
    }

    private boolean needsSubstitution(@NotNull List<PsiElement> path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/sql/editor/SqlCloseBlockProcessorImpl", "needsSubstitution"));
        }
        for (SubstitutionDescriptor descriptor : this.myDescriptors) {
            if (!descriptor.isExprRoot(path)) continue;
            if (!descriptor.needsSubstitution(path)) break;
            return true;
        }
        return false;
    }

    private boolean processDescriptor(@NotNull List<PsiElement> path, @NotNull SubstitutionDescriptor desc, @NotNull Editor editor, @NotNull DataContext dataContext) {
        int i2;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/sql/editor/SqlCloseBlockProcessorImpl", "processDescriptor"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/sql/editor/SqlCloseBlockProcessorImpl", "processDescriptor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/editor/SqlCloseBlockProcessorImpl", "processDescriptor"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/sql/editor/SqlCloseBlockProcessorImpl", "processDescriptor"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        int oldSize = path.size();
        if (!desc.needsSubstitution(path)) {
            boolean mismatchFound = false;
            while (((PsiElement)ContainerUtil.getLastItem(path)).getNode() != null && ((PsiElement)ContainerUtil.getLastItem(path)).getParent() != null && !mismatchFound) {
                path.add(((PsiElement)ContainerUtil.getLastItem(path)).getParent());
                mismatchFound = this.needsSubstitution(path);
            }
            if (!mismatchFound) {
                return false;
            }
        }
        Pair<String, String> substitution = desc.getSubstitution(path.subList(0, oldSize));
        int caret = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(caret);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        SqlCodeStyleSettings sqlSettings = (SqlCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(SqlCodeStyleSettings.class);
        Case caseModeExt = sqlSettings.getCaseModeExt(sqlSettings.KEYWORD_CASE);
        int nlines1 = ((String)substitution.getFirst()).split("\\n").length;
        int nlines2 = ((String)substitution.getSecond()).split("\\n").length;
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + caseModeExt.apply((String)substitution.getFirst())));
        editor.getCaretModel().moveToOffset(lineEndOffset + 1 + ((String)substitution.getFirst()).length());
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + caseModeExt.apply((String)substitution.getSecond())));
        for (i2 = 1; i2 < nlines1; ++i2) {
            SqlCloseBlockProcessorImpl.indentLine(project, document, lineNumber + i2);
        }
        for (i2 = 0; i2 < nlines2; ++i2) {
            SqlCloseBlockProcessorImpl.indentLine(project, document, lineNumber + nlines1 + 1 + i2);
        }
        SqlCloseBlockProcessorImpl.indentLineAndMoveCaret(project, editor, document, lineNumber + nlines1);
        return true;
    }

    protected static int indentLine(@NotNull Project project, @NotNull Document document, int lineNumber) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/editor/SqlCloseBlockProcessorImpl", "indentLine"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/sql/editor/SqlCloseBlockProcessorImpl", "indentLine"));
        }
        if (0 > lineNumber || lineNumber >= document.getLineCount()) {
            return -1;
        }
        return CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, document.getLineStartOffset(lineNumber));
    }

    protected static int indentLineAndMoveCaret(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, int lineNumber) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/editor/SqlCloseBlockProcessorImpl", "indentLineAndMoveCaret"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/editor/SqlCloseBlockProcessorImpl", "indentLineAndMoveCaret"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/sql/editor/SqlCloseBlockProcessorImpl", "indentLineAndMoveCaret"));
        }
        int offset = SqlCloseBlockProcessorImpl.indentLine(project, document, lineNumber);
        if (offset != -1) {
            editor.getCaretModel().moveToOffset(offset);
        }
        return offset;
    }

    public static interface SubstitutionDescriptor {
        public boolean isExprRoot(@NotNull List<PsiElement> var1);

        @Nullable
        public PsiElement getExprRoot(@NotNull PsiElement var1);

        public boolean needsSubstitution(@NotNull List<PsiElement> var1);

        @NotNull
        public Pair<String, String> getSubstitution(@NotNull List<PsiElement> var1);
    }
}

