/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterInStringLiteralHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class SqlEnterInStringHandler
extends EnterInStringLiteralHandler {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/editor/SqlEnterInStringHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/editor/SqlEnterInStringHandler", "preprocessEnter"));
        }
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsetRef", "com/intellij/sql/editor/SqlEnterInStringHandler", "preprocessEnter"));
        }
        if (caretAdvanceRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvanceRef", "com/intellij/sql/editor/SqlEnterInStringHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/sql/editor/SqlEnterInStringHandler", "preprocessEnter"));
        }
        SqlEditorOptions instance = SqlEditorOptions.getInstance();
        if (!instance.isConcatenateStringsOnEnter()) {
            return EnterHandlerDelegate.Result.DefaultSkipIndent;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        if (!SqlEnterInStringHandler.isInsideStringLiteral(file, caretOffset)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        SqlStringTokenElement psiAtOffset = (SqlStringTokenElement)((Object)ObjectUtils.tryCast((Object)file.findElementAt(caretOffset), SqlStringTokenElement.class));
        if (psiAtOffset != null && psiAtOffset.getTextOffset() < caretOffset) {
            Document document = editor.getDocument();
            ASTNode token = psiAtOffset.getNode();
            JavaLikeQuoteHandler quoteHandler = this.getJavaLikeQuoteHandler(editor, (PsiElement)psiAtOffset);
            if (quoteHandler != null && quoteHandler.getConcatenatableStringTokenTypes() != null && quoteHandler.getConcatenatableStringTokenTypes().contains(token.getElementType())) {
                int start = psiAtOffset.getTextRange().getStartOffset();
                TextRange range = psiAtOffset.getRangeInElement();
                String str = token.getText();
                String open = str.substring(0, range.getStartOffset());
                String close = str.substring(range.getEndOffset(), str.length());
                if (caretOffset < range.getStartOffset() + start) {
                    caretOffset = range.getStartOffset() + start;
                }
                if (caretOffset >= range.getEndOffset() + start) {
                    caretOffset = range.getEndOffset() + start;
                }
                String insertedFragment = close + " " + quoteHandler.getStringConcatenationOperatorRepresentation();
                document.insertString(caretOffset, (CharSequence)(insertedFragment + " " + open));
                caretOffset += insertedFragment.length();
                int caretAdvance = 1;
                CommonCodeStyleSettings langSettings = CodeStyleSettingsManager.getSettings((Project)file.getProject()).getCommonSettings(file.getLanguage());
                if (langSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
                    --caretOffset;
                    caretAdvance = 3;
                }
                caretOffsetRef.set((Object)caretOffset);
                caretAdvanceRef.set((Object)caretAdvance);
                return EnterHandlerDelegate.Result.DefaultForceIndent;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isInsideStringLiteral(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/editor/SqlEnterInStringHandler", "isInsideStringLiteral"));
        }
        SqlStringTokenElement psiAtOffset = (SqlStringTokenElement)((Object)ObjectUtils.tryCast((Object)file.findElementAt(offset), SqlStringTokenElement.class));
        return psiAtOffset != null;
    }
}

