/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlGenerateGroup
extends ActionGroup
implements DumbAware {
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = new AnAction[]{new OraclePackage(), new OraclePackageBody(), new Function(), new Procedure(), new Block(), new Trigger()};
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup", "getChildren"));
        }
        return anActionArray;
    }

    private static boolean onTopLevel(@Nullable PsiElement element) {
        return SyntaxTraverser.psiApi().parents((Object)element).skip(1).filter(SqlStatement.class).isEmpty();
    }

    @NotNull
    private static Pair<String, Expression> constantNodeKeyValuePair(@NotNull String key, @NotNull String value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/sql/generation/SqlGenerateGroup", "constantNodeKeyValuePair"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/sql/generation/SqlGenerateGroup", "constantNodeKeyValuePair"));
        }
        Pair pair = Pair.create((Object)key, (Object)new ConstantNode(value));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup", "constantNodeKeyValuePair"));
        }
        return pair;
    }

    private static class MyResult
    extends TextResult {
        private final Result myDelegate;

        private MyResult(@NotNull Result delegate, @NotNull String text) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/sql/generation/SqlGenerateGroup$MyResult", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/generation/SqlGenerateGroup$MyResult", "<init>"));
            }
            super(text);
            this.myDelegate = delegate;
        }

        public void handleFocused(PsiFile psiFile, Document document, int segmentStart, int segmentEnd) {
            this.myDelegate.handleFocused(psiFile, document, segmentStart, segmentEnd);
        }
    }

    private static class MyNode
    extends MacroCallNode {
        private final String myValue;

        public MyNode(@NotNull Macro macro, @NotNull String value) {
            if (macro == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macro", "com/intellij/sql/generation/SqlGenerateGroup$MyNode", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/sql/generation/SqlGenerateGroup$MyNode", "<init>"));
            }
            super(macro);
            this.myValue = value;
        }

        public Result calculateQuickResult(ExpressionContext context) {
            Result delegate = super.calculateQuickResult(context);
            return delegate == null ? null : new MyResult(delegate, this.myValue);
        }

        public Result calculateResult(ExpressionContext context) {
            Result delegate = super.calculateResult(context);
            return delegate == null ? null : new MyResult(delegate, this.myValue);
        }
    }

    public static class OraclePackageBody
    extends Oracle {
        @Override
        @NotNull
        protected String getTemplateText(@NotNull SqlLanguageDialect language, @NotNull String delimiter) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/generation/SqlGenerateGroup$OraclePackageBody", "getTemplateText"));
            }
            if (delimiter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delimiter", "com/intellij/sql/generation/SqlGenerateGroup$OraclePackageBody", "getTemplateText"));
            }
            if ("CREATE OR REPLACE PACKAGE BODY $name$ AS\n  $END$\nEND $name$;\n/" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$OraclePackageBody", "getTemplateText"));
            }
            return "CREATE OR REPLACE PACKAGE BODY $name$ AS\n  $END$\nEND $name$;\n/";
        }

        @Override
        @NotNull
        protected Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/generation/SqlGenerateGroup$OraclePackageBody", "getVariables"));
            }
            LinkedHashMap linkedHashMap = ContainerUtil.newLinkedHashMap((Pair)SqlGenerateGroup.constantNodeKeyValuePair("name", "new_package"), (Pair[])new Pair[0]);
            if (linkedHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$OraclePackageBody", "getVariables"));
            }
            return linkedHashMap;
        }

        @Override
        @NotNull
        String getText() {
            if ("Package body" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$OraclePackageBody", "getText"));
            }
            return "Package body";
        }
    }

    public static class OraclePackage
    extends Oracle {
        @Override
        @NotNull
        protected String getTemplateText(@NotNull SqlLanguageDialect language, @NotNull String delimiter) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/generation/SqlGenerateGroup$OraclePackage", "getTemplateText"));
            }
            if (delimiter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delimiter", "com/intellij/sql/generation/SqlGenerateGroup$OraclePackage", "getTemplateText"));
            }
            if ("CREATE OR REPLACE PACKAGE $name$ AS\n  $END$ \nEND $name$;\n/" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$OraclePackage", "getTemplateText"));
            }
            return "CREATE OR REPLACE PACKAGE $name$ AS\n  $END$ \nEND $name$;\n/";
        }

        @Override
        @NotNull
        protected Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/generation/SqlGenerateGroup$OraclePackage", "getVariables"));
            }
            LinkedHashMap linkedHashMap = ContainerUtil.newLinkedHashMap((Pair)SqlGenerateGroup.constantNodeKeyValuePair("name", "new_package"), (Pair[])new Pair[0]);
            if (linkedHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$OraclePackage", "getVariables"));
            }
            return linkedHashMap;
        }

        @Override
        @NotNull
        String getText() {
            if ("Package" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$OraclePackage", "getText"));
            }
            return "Package";
        }
    }

    static abstract class Oracle
    extends GenerateActionBase {
        Oracle() {
        }

        @Override
        protected boolean isSqlDialectSupported(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/generation/SqlGenerateGroup$Oracle", "isSqlDialectSupported"));
            }
            return dialect.getDatabaseDialect().getFamilyId().isOracle();
        }
    }

    public static class Block
    extends GenerateActionBase {
        @Override
        protected String getTemplateText(@NotNull SqlLanguageDialect dialect, @NotNull String delimiter) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/generation/SqlGenerateGroup$Block", "getTemplateText"));
            }
            if (delimiter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delimiter", "com/intellij/sql/generation/SqlGenerateGroup$Block", "getTemplateText"));
            }
            DatabaseFamilyId familyId = dialect.getDatabaseDialect().getFamilyId();
            if (familyId.isOracle() || familyId.isDb2() || familyId.isMicrosoft() || familyId.isSybase() || familyId.isPostgres() && dialect instanceof InjectableLanguage) {
                return "BEGIN\n  $END$\nEND" + delimiter;
            }
            return null;
        }

        @Override
        @NotNull
        protected Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/generation/SqlGenerateGroup$Block", "getVariables"));
            }
            HashMap hashMap = ContainerUtil.newHashMap();
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$Block", "getVariables"));
            }
            return hashMap;
        }

        @Override
        @NotNull
        String getText() {
            if ("Block" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$Block", "getText"));
            }
            return "Block";
        }

        @Override
        protected boolean isInContext(@Nullable PsiElement element) {
            return super.isInContext(element) || !SyntaxTraverser.psiApi().parents((Object)element).filter(SqlBlockStatementImpl.class).isEmpty();
        }
    }

    public static class Procedure
    extends GenerateActionBase {
        @Override
        protected String getTemplateText(@NotNull SqlLanguageDialect language, @NotNull String delimiter) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/generation/SqlGenerateGroup$Procedure", "getTemplateText"));
            }
            if (delimiter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delimiter", "com/intellij/sql/generation/SqlGenerateGroup$Procedure", "getTemplateText"));
            }
            DatabaseFamilyId familyId = language.getDatabaseDialect().getFamilyId();
            if (familyId.isOracle()) {
                return "CREATE OR REPLACE PROCEDURE $name$() AS\nBEGIN\n  $END$\nEND;\n/";
            }
            if (familyId.isMysql() || familyId.isDb2()) {
                return "CREATE PROCEDURE $name$()\nBEGIN\n  $END$\nEND" + delimiter;
            }
            if (familyId.isMicrosoft()) {
                return "CREATE PROCEDURE $name$() AS\nBEGIN\n  $END$\nEND\nGO";
            }
            if (familyId.isSybase()) {
                return "CREATE PROCEDURE $name$() AS\n  $END$\nGO";
            }
            return null;
        }

        @Override
        @NotNull
        protected Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/generation/SqlGenerateGroup$Procedure", "getVariables"));
            }
            LinkedHashMap linkedHashMap = ContainerUtil.newLinkedHashMap((Pair)SqlGenerateGroup.constantNodeKeyValuePair("name", "name"), (Pair[])new Pair[0]);
            if (linkedHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$Procedure", "getVariables"));
            }
            return linkedHashMap;
        }

        @Override
        @NotNull
        String getText() {
            if ("Procedure" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$Procedure", "getText"));
            }
            return "Procedure";
        }
    }

    public static class Function
    extends GenerateActionBase {
        @Override
        @Nullable
        protected String getTemplateText(@NotNull SqlLanguageDialect language, @NotNull String delimiter) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/generation/SqlGenerateGroup$Function", "getTemplateText"));
            }
            if (delimiter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delimiter", "com/intellij/sql/generation/SqlGenerateGroup$Function", "getTemplateText"));
            }
            DatabaseFamilyId familyId = language.getDatabaseDialect().getFamilyId();
            if (familyId.isOracle()) {
                return "CREATE OR REPLACE FUNCTION $name$() RETURN $type$ AS\nBEGIN\n  $END$\nEND;\n/";
            }
            if (familyId.isPostgres()) {
                return "CREATE OR REPLACE FUNCTION $name$()\nRETURNS $type$ AS $$$$\nBEGIN\n  $END$\nEND;\n$$$$ LANGUAGE 'plpgsql';";
            }
            if (familyId.isMysql() || familyId.isDb2()) {
                return "CREATE FUNCTION $name$() RETURNS $type$\nBEGIN\n  $END$\nEND" + delimiter;
            }
            if (familyId.isMicrosoft()) {
                return "CREATE FUNCTION $name$() RETURNS $type$\nBEGIN\n  $END$\nEND\nGO";
            }
            if (familyId.isSybase()) {
                return "CREATE FUNCTION $name$() RETURNS $type$ AS \n  $END$\nGO";
            }
            return null;
        }

        @Override
        @NotNull
        protected Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/generation/SqlGenerateGroup$Function", "getVariables"));
            }
            LinkedHashMap linkedHashMap = ContainerUtil.newLinkedHashMap((Pair)SqlGenerateGroup.constantNodeKeyValuePair("name", "name"), (Pair[])new Pair[]{SqlGenerateGroup.constantNodeKeyValuePair("type", "int")});
            if (linkedHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$Function", "getVariables"));
            }
            return linkedHashMap;
        }

        @Override
        @NotNull
        String getText() {
            if ("Function" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$Function", "getText"));
            }
            return "Function";
        }
    }

    public static class Trigger
    extends GenerateActionBase {
        @Override
        @Nullable
        protected String getTemplateText(@NotNull SqlLanguageDialect language, @NotNull String delimiter) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/generation/SqlGenerateGroup$Trigger", "getTemplateText"));
            }
            if (delimiter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delimiter", "com/intellij/sql/generation/SqlGenerateGroup$Trigger", "getTemplateText"));
            }
            DatabaseFamilyId id = language.getDatabaseDialect().getFamilyId();
            if (id.isOracle()) {
                return "CREATE TRIGGER $trigger_name$\n  $type$ $event$ ON $object_name$\n  BEGIN\n    $END$\n  END;";
            }
            if (id.isPostgres()) {
                return "CREATE TRIGGER $trigger_name$\n  $type$ $event$ ON $object_name$\n  EXECUTE PROCEDURE $call$($END$);";
            }
            if (id.isMysql()) {
                return "CREATE TRIGGER $trigger_name$\n  $type$ $event$ ON $object_name$\n  FOR EACH ROW\n  BEGIN\n    $END$\n  END;\n";
            }
            if (id.isDb2()) {
                return "CREATE TRIGGER $trigger_name$\n  $type$ $event$ ON $object_name$\n  FOR EACH $each_clause$\n  BEGIN ATOMIC\n    $END$\n  END;\n";
            }
            if (id.isTransactSql()) {
                return "CREATE TRIGGER $trigger_name$\n  ON $object_name$\n  $type$ $event$\n  AS $call$;\n";
            }
            if (id.isHsqldb()) {
                return "CREATE TRIGGER $trigger_name$ $type$ $event$\n  ON $object_name$\n  BEGIN ATOMIC\n    $END$\n  END;\n";
            }
            if (id.isH2()) {
                return "CREATE TRIGGER $trigger_name$ $type$ $event$\n  ON $object_name$\n  CALL $call$;\n";
            }
            if (id.isSqlite()) {
                return "CREATE TRIGGER $trigger_name$ $type$ $event$\n  ON $object_name$\n  BEGIN\n    $END$\n  END;\n";
            }
            return null;
        }

        @Override
        @NotNull
        Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/generation/SqlGenerateGroup$Trigger", "getVariables"));
            }
            LinkedHashMap map = ContainerUtil.newLinkedHashMap();
            DatabaseFamilyId id = dialect.getDatabaseDialect().getFamilyId();
            boolean isTransactSql = id.isTransactSql();
            map.put("trigger_name", new ConstantNode("trigger_name"));
            if (isTransactSql) {
                Trigger.putObjectName(map, id);
            }
            map.put("type", new ConstantNode(isTransactSql ? "FOR" : "BEFORE"));
            map.put("event", new ConstantNode("INSERT"));
            if (!isTransactSql) {
                Trigger.putObjectName(map, id);
            }
            if (id.isDb2()) {
                map.put("each_clause", new ConstantNode("ROW"));
            }
            Trigger.putCall(map, id);
            LinkedHashMap linkedHashMap = map;
            if (linkedHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$Trigger", "getVariables"));
            }
            return linkedHashMap;
        }

        @Override
        @NotNull
        String getText() {
            if ("Trigger" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$Trigger", "getText"));
            }
            return "Trigger";
        }

        private static void putObjectName(@NotNull Map<String, Expression> map, @NotNull DatabaseFamilyId id) {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/sql/generation/SqlGenerateGroup$Trigger", "putObjectName"));
            }
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/sql/generation/SqlGenerateGroup$Trigger", "putObjectName"));
            }
            MyNode node = new MyNode((Macro)new CompleteMacro(), id.isOracle() ? "object_name" : "table_name");
            map.put("object_name", (Expression)node);
        }

        private static void putCall(@NotNull Map<String, Expression> map, @NotNull DatabaseFamilyId id) {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/sql/generation/SqlGenerateGroup$Trigger", "putCall"));
            }
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/sql/generation/SqlGenerateGroup$Trigger", "putCall"));
            }
            if (!(id.isPostgres() || id.isH2() || id.isTransactSql())) {
                return;
            }
            map.put("call", (Expression)(id.isPostgres() ? new MyNode((Macro)new CompleteMacro(), "procedure_name") : new ConstantNode(id.isH2() ? "triggeredClassName" : "statements")));
        }
    }

    private static abstract class GenerateActionBase
    extends CodeInsightAction
    implements CodeInsightActionHandler {
        private GenerateActionBase() {
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            int targetOffset;
            PsiFile targetFile;
            String delimiter;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/generation/SqlGenerateGroup$GenerateActionBase", "invoke"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/generation/SqlGenerateGroup$GenerateActionBase", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/generation/SqlGenerateGroup$GenerateActionBase", "invoke"));
            }
            int offset = editor.getCaretModel().getOffset();
            PsiElement elementAt = GenerateActionBase.findElementAt(file, offset);
            SqlLanguageDialect dialect = GenerateActionBase.getDialectAt(file, elementAt);
            String text = this.getTemplateText(dialect, delimiter = this.getDelimiter(targetFile = elementAt == null ? file : elementAt.getContainingFile(), targetOffset = elementAt == null ? offset : elementAt.getTextOffset()));
            if (text == null) {
                return;
            }
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = templateManager.createTemplate("", "", text);
            Map<String, Expression> vars = this.getVariables(dialect);
            for (Map.Entry<String, Expression> var : vars.entrySet()) {
                template.addVariable(var.getKey(), var.getValue(), true);
            }
            template.setToReformat(true);
            templateManager.startTemplate(editor, template);
        }

        @Nullable
        protected abstract String getTemplateText(@NotNull SqlLanguageDialect var1, @NotNull String var2);

        @NotNull
        abstract Map<String, Expression> getVariables(@NotNull SqlLanguageDialect var1);

        @NotNull
        protected CodeInsightActionHandler getHandler() {
            GenerateActionBase generateActionBase = this;
            if (generateActionBase == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$GenerateActionBase", "getHandler"));
            }
            return generateActionBase;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            boolean available = this.isAvailable(e);
            Presentation presentation = e.getPresentation();
            if (!available) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            presentation.setText(this.getText());
            presentation.setDescription(this.getDescription());
        }

        protected boolean isAvailable(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/generation/SqlGenerateGroup$GenerateActionBase", "isAvailable"));
            }
            PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (!(file instanceof SqlFile) || editor == null) {
                return false;
            }
            int offset = editor.getCaretModel().getOffset();
            PsiElement elementAt = GenerateActionBase.findElementAt(file, offset);
            SqlLanguageDialect dialect = GenerateActionBase.getDialectAt(file, elementAt);
            if (!this.isSqlDialectSupported(dialect)) {
                return false;
            }
            return this.isInContext(elementAt);
        }

        @NotNull
        private static SqlLanguageDialect getDialectAt(PsiFile file, PsiElement elementAt) {
            SqlLanguageDialectEx dialect = null;
            if (elementAt != null) {
                PsiElement o;
                IElementType elementType;
                Iterator iterator = SyntaxTraverser.psiApi().parents((Object)elementAt).iterator();
                while (iterator.hasNext() && (dialect = (SqlLanguageDialect)ObjectUtils.tryCast((Object)(elementType = PsiUtilCore.getElementType((PsiElement)(o = (PsiElement)iterator.next()))).getLanguage(), SqlLanguageDialect.class)) == null) {
                }
            }
            if (dialect == null) {
                dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)(elementAt != null ? elementAt : file));
            }
            SqlLanguageDialectEx sqlLanguageDialectEx = dialect;
            if (sqlLanguageDialectEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$GenerateActionBase", "getDialectAt"));
            }
            return sqlLanguageDialectEx;
        }

        @Nullable
        private static PsiElement findElementAt(@NotNull PsiFile file, int offset) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/generation/SqlGenerateGroup$GenerateActionBase", "findElementAt"));
            }
            PsiElement e1 = InjectedLanguageManager.getInstance((Project)file.getProject()).findInjectedElementAt(file, offset);
            return e1 != null ? e1 : file.findElementAt(offset);
        }

        protected boolean isInContext(@Nullable PsiElement element) {
            return SqlGenerateGroup.onTopLevel(element);
        }

        @NotNull
        abstract String getText();

        @NotNull
        protected String getDescription() {
            String string = "Creates " + StringUtil.toLowerCase((String)this.getText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$GenerateActionBase", "getDescription"));
            }
            return string;
        }

        protected boolean isSqlDialectSupported(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/generation/SqlGenerateGroup$GenerateActionBase", "isSqlDialectSupported"));
            }
            return this.getTemplateText(dialect, "") != null;
        }

        @NotNull
        protected String getDelimiter(@NotNull PsiFile file, int offset) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/generation/SqlGenerateGroup$GenerateActionBase", "getDelimiter"));
            }
            String delim = DbSqlUtil.getDelimiterAt(file, offset).replace("$", "$$");
            String string = DbSqlUtil.delimiterNeedsSpacing(delim) ? " " + delim : delim;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/SqlGenerateGroup$GenerateActionBase", "getDelimiter"));
            }
            return string;
        }
    }
}

