/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.highlighting;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.ChangeDialectAction;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeSqlDialectIntentionFix
extends IntentionAndQuickFixAction {
    @NotNull
    public String getName() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/highlighting/ChangeSqlDialectIntentionFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlMessages.message("quickfix.change.dialect.family.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/highlighting/ChangeSqlDialectIntentionFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/highlighting/ChangeSqlDialectIntentionFix", "applyFix"));
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        if (virtualFile == null) {
            return;
        }
        if (!ChangeDialectAction.FILE_FILTER(project).value((Object)virtualFile)) {
            SqlDialectsConfigurable.openDialectsConfigurable(project, file.getVirtualFile());
        } else {
            ListPopup popup = ChangeDialectAction.buildDialectsPopup(project, (JBIterable<VirtualFile>)JBIterable.of((Object)virtualFile));
            if (editor != null) {
                popup.showInBestPositionFor(editor);
            } else {
                popup.showInFocusCenter();
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

