/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.parser;

import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlGeneratedParserUtil;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SqlParserUtil {
    private SqlParserUtil() {
    }

    public static void replaceLatestMarkerType(PsiBuilder builder, boolean result, IElementType from, IElementType to) {
        LighterASTNode m;
        if (result && to != null && (m = (LighterASTNode)ObjectUtils.assertNotNull((Object)builder.getLatestDoneMarker())).getTokenType() == from) {
            SqlParserUtil.remapLatestDoneMarker(m, to);
        }
    }

    public static void remapLatestDoneMarker(LighterASTNode node, IElementType to) {
        PsiBuilder.Marker m = (PsiBuilder.Marker)node;
        m.precede().done(to);
        m.drop();
    }

    @Deprecated
    public static boolean consumeToken(PsiBuilder builder, boolean optional, IElementType elementType, @Nullable String error) {
        boolean bad;
        IElementType tokenType = builder.getTokenType();
        boolean bl = bad = tokenType != elementType;
        if (bad) {
            if (!optional) {
                String errorText = error != null ? error : SqlMessages.message("0.expected", SqlParserUtil.getPresentableText(elementType));
                builder.error(errorText);
            }
            return false;
        }
        builder.advanceLexer();
        return true;
    }

    @Deprecated
    @Nullable
    public static IElementType consumeOneOfTokens(PsiBuilder builder, boolean optional, IElementType ... elementTypes) {
        IElementType t = builder.getTokenType();
        for (IElementType type : elementTypes) {
            if (!optional) {
                GeneratedParserUtilBase.addVariant((PsiBuilder)builder, (String)type.toString());
            }
            if (t != type) continue;
            builder.advanceLexer();
            return t;
        }
        if (!optional) {
            GeneratedParserUtilBase.report_error_((PsiBuilder)builder, (boolean)false);
        }
        return null;
    }

    public static boolean endsWithNewLine(PsiBuilder builder) {
        return SqlParserUtil.endsWithNewLine(builder, 0);
    }

    static boolean endsWithNewLine(PsiBuilder builder, int ignoreCount) {
        int idx = -1;
        int end = builder.getCurrentOffset();
        IElementType type;
        while ((type = builder.rawLookup(idx)) != null) {
            int start = builder.rawTokenTypeStart(idx);
            if (GeneratedParserUtilBase.isWhitespaceOrComment((PsiBuilder)builder, (IElementType)type)) {
                CharSequence s = builder.getOriginalText().subSequence(start, end);
                if (StringUtil.countNewLines((CharSequence)s) > 0) {
                    return true;
                }
            } else if (-idx > ignoreCount) {
                return false;
            }
            --idx;
            end = start;
        }
        return true;
    }

    static boolean hasNMeaningfulNewLines(PsiBuilder builder, int count) {
        boolean commentLine = false;
        int nCommentLines = 0;
        int nNewLines = 0;
        int idx = -1;
        IElementType type;
        while ((type = builder.rawLookup(idx)) != null) {
            if (GeneratedParserUtilBase.isWhitespaceOrComment((PsiBuilder)builder, (IElementType)type)) {
                if (SqlTokens.COMMENT_TOKENS.contains(type)) {
                    if (!commentLine) {
                        ++nCommentLines;
                    }
                    commentLine = true;
                } else {
                    int counted;
                    CharSequence text = builder.getOriginalText().subSequence(builder.rawTokenTypeStart(idx), builder.rawTokenTypeStart(idx + 1));
                    int n = counted = text == null ? 0 : StringUtil.countNewLines((CharSequence)text);
                    if (counted > 0) {
                        commentLine = false;
                        if ((nNewLines += counted) - nCommentLines >= count) {
                            return true;
                        }
                    }
                }
            } else {
                return false;
            }
            --idx;
        }
        return false;
    }

    @Nullable
    public static IElementType consumeAllTokensUpTo(PsiBuilder builder, IElementType ... tokens) {
        SqlGeneratedParserUtil.parseAsTree(builder, 0, (IElementType)SqlCompositeElementTypes.SQL_GENERIC_ELEMENT, true, GeneratedParserUtilBase.TOKEN_ADVANCER, SqlParserUtil.newTokenCondition(tokens));
        return builder.getTokenType();
    }

    public static boolean tryConsumeToken(PsiBuilder builder, IElementType ... expectedTypeAndStoppers) {
        assert (expectedTypeAndStoppers.length > 0);
        IElementType tokenType = builder.getTokenType();
        IElementType expectedType = expectedTypeAndStoppers[0];
        if (tokenType != null && tokenType != expectedType) {
            if (-1 != ArrayUtilRt.find((Object[])expectedTypeAndStoppers, (Object)tokenType)) {
                return false;
            }
            SqlParserUtil.markTokenAsUnexpectedAndAdvance(builder, SqlParserUtil.getPresentableText(expectedType));
            if (expectedType != SqlParserUtil.consumeAllTokensUpTo(builder, expectedTypeAndStoppers)) {
                return false;
            }
        }
        return SqlParserUtil.consumeToken(builder, tokenType == null, expectedType, null);
    }

    public static String getPresentableText(IElementType elementType) {
        String name;
        String string = name = elementType == null ? "<EOF>" : elementType.toString();
        if (elementType instanceof SqlKeywordTokenType) {
            return name;
        }
        return name.length() > 3 ? name.substring(name.indexOf(95) + 1).replace('_', ' ') : name;
    }

    public static void markTokenAsUnexpectedAndAdvance(PsiBuilder builder, String expected) {
        SqlParserUtil.markTokenAsUnexpected(builder, expected, true);
    }

    public static void markTokenAsUnexpected(PsiBuilder builder, String expected, boolean advance) {
        String curTokenText = builder.getTokenText();
        String curText = curTokenText == null ? "<EOF>" : curTokenText;
        String message = expected == null ? SqlMessages.message("0.unexpected", curText) : SqlMessages.message("unexpected.token.0.expected.1", curText, expected);
        SqlParserUtil.error(builder, message, advance);
    }

    public static void error(PsiBuilder builder, String message, boolean advance) {
        if (StringUtil.isEmpty((String)message)) {
            message = SqlMessages.message("0.unexpected", builder.getTokenText());
        }
        PsiBuilder.Marker errMarker = builder.mark();
        if (advance) {
            builder.advanceLexer();
        }
        errMarker.error(message);
    }

    @Nullable
    public static <T> T getParserMetrics(PsiBuilder builder, int level, ParserChoice<T> parser, int[] len, boolean[] success) {
        int basePos = builder.rawTokenIndex();
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        T curResult = parser.parse(builder, level);
        PsiBuilder.Marker marker = null;
        if (parser.hasLookahead()) {
            marker = GeneratedParserUtilBase.enter_section_((PsiBuilder)builder, (int)1, (int)0, null);
            curResult = parser.lookahead(curResult, builder, level);
        }
        len[0] = builder.rawTokenIndex() - basePos;
        if (curResult instanceof Integer) {
            len[0] = len[0] * 100 - (Integer)curResult;
        } else if (frame.errorReportedAt >= basePos && frame.errorReportedAt - basePos < len[0]) {
            len[0] = frame.errorReportedAt - basePos;
        }
        boolean bl = success[0] = curResult != null && !Boolean.FALSE.equals(curResult);
        if (marker != null) {
            GeneratedParserUtilBase.exit_section_((PsiBuilder)builder, (int)1, (PsiBuilder.Marker)marker, null, (boolean)false, (boolean)false, null);
        }
        return curResult;
    }

    @Nullable
    public static <T> T chooseTheBestParser(PsiBuilder builder, int level, List<ParserChoice<T>> parsers) {
        assert (!parsers.isEmpty());
        int curMaxIdx = 0;
        int curMaxLen = -1;
        int curMaxIdx2 = 0;
        int curMaxLen2 = -1;
        Object result = null;
        int[] len = new int[1];
        boolean[] success = new boolean[1];
        for (int i2 = 0; i2 < parsers.size(); ++i2) {
            boolean leaveThis = false;
            PsiBuilder.Marker marker = GeneratedParserUtilBase.enter_section_((PsiBuilder)builder, (int)1, (int)0, null);
            T curResult = SqlParserUtil.getParserMetrics(builder, level, parsers.get(i2), len, success);
            if (success[0]) {
                if (curMaxLen < len[0]) {
                    curMaxIdx = i2;
                    curMaxLen = len[0];
                    leaveThis = i2 == parsers.size() - 1;
                }
            } else if (curMaxLen2 < len[0] && len[0] > 0) {
                curMaxIdx2 = i2;
                curMaxLen2 = len[0];
                leaveThis = curMaxLen < 0 && i2 == parsers.size() - 1;
            }
            GeneratedParserUtilBase.exit_section_((PsiBuilder)builder, (int)1, (PsiBuilder.Marker)marker, null, (boolean)leaveThis, (boolean)false, null);
            if (!leaveThis) continue;
            result = curResult;
            break;
        }
        if (result == null) {
            PsiBuilder.Marker marker = GeneratedParserUtilBase.enter_section_((PsiBuilder)builder, (int)1, (int)0, null);
            result = curMaxLen >= 0 ? parsers.get(curMaxIdx).parse(builder, level) : (curMaxLen2 >= 0 ? parsers.get(curMaxIdx2).parse(builder, level) : null);
            GeneratedParserUtilBase.exit_section_((PsiBuilder)builder, (int)1, (PsiBuilder.Marker)marker, null, (boolean)true, (boolean)false, null);
        }
        return result;
    }

    static GeneratedParserUtilBase.Parser newTokenCondition(final IElementType ... endTokens) {
        return new GeneratedParserUtilBase.Parser(){

            public boolean parse(PsiBuilder builder, int level) {
                IElementType type = builder.getTokenType();
                for (IElementType token : endTokens) {
                    if (token != type) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static boolean nextTokenIs(PsiBuilder builder, IElementType tokenType) {
        return GeneratedParserUtilBase.nextTokenIsFast((PsiBuilder)builder, (IElementType)tokenType);
    }

    public static boolean consumeOptionalToken(PsiBuilder builder, IElementType elementType) {
        return GeneratedParserUtilBase.consumeTokenSmart((PsiBuilder)builder, (IElementType)elementType);
    }

    public static boolean consumeToken(PsiBuilder builder, IElementType elementType) {
        return SqlParserUtil.consumeToken(builder, false, elementType, null);
    }

    public static boolean consumeToken(PsiBuilder builder, boolean optional, IElementType elementType) {
        return optional ? SqlParserUtil.consumeOptionalToken(builder, elementType) : SqlParserUtil.consumeToken(builder, elementType);
    }

    @Nullable
    public static IElementType consumeOneOfTokens(PsiBuilder builder, IElementType ... elementTypes) {
        return SqlParserUtil.consumeOneOfTokens(builder, false, elementTypes);
    }

    public static abstract class ParserChoice<T> {
        public abstract T parse(PsiBuilder var1, int var2);

        public boolean hasLookahead() {
            return false;
        }

        public T lookahead(T prev, PsiBuilder builder, int level) {
            return prev;
        }
    }
}

