/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.checkin;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.HashSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.checkin.DuplicatePolicyIdException;
import org.jetbrains.tfsIntegration.checkin.PolicyBase;
import org.jetbrains.tfsIntegration.checkin.PolicyContext;
import org.jetbrains.tfsIntegration.checkin.PolicyFailure;
import org.jetbrains.tfsIntegration.checkin.PolicyType;
import org.jetbrains.tfsIntegration.core.TFSVcs;

public class CheckinPoliciesManager {
    private static PolicyBase[] ourInstalledPolicies;
    public static final PolicyBase DUMMY_POLICY;

    public static PolicyBase[] getInstalledPolicies() throws DuplicatePolicyIdException {
        if (ourInstalledPolicies == null) {
            PolicyBase[] installedPolicies = (PolicyBase[])Extensions.getExtensions(PolicyBase.EP_NAME);
            HashSet<PolicyType> types = new HashSet<PolicyType>(installedPolicies.length);
            for (PolicyBase policy : installedPolicies) {
                if (types.add(policy.getPolicyType())) continue;
                TFSVcs.LOG.warn("Duplicate checkin policy type: " + policy.getPolicyType().getId());
                throw new DuplicatePolicyIdException(policy.getPolicyType().getId());
            }
            ourInstalledPolicies = installedPolicies;
        }
        return ourInstalledPolicies;
    }

    @Nullable
    public static PolicyBase find(PolicyType type) throws DuplicatePolicyIdException {
        PolicyBase result = null;
        for (PolicyBase p : CheckinPoliciesManager.getInstalledPolicies()) {
            if (!p.getPolicyType().equals(type)) continue;
            result = p;
            break;
        }
        return result;
    }

    static {
        DUMMY_POLICY = new PolicyBase(){
            final PolicyType DUMMY = new PolicyType("DUMMY_POLICY", "", "", "");

            @Override
            @NotNull
            public PolicyType getPolicyType() {
                PolicyType policyType = this.DUMMY;
                if (policyType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/checkin/CheckinPoliciesManager$1", "getPolicyType"));
                }
                return policyType;
            }

            @Override
            public PolicyFailure[] evaluate(@NotNull PolicyContext policycontext, @NotNull ProgressIndicator progressIndicator) {
                if (policycontext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policycontext", "org/jetbrains/tfsIntegration/checkin/CheckinPoliciesManager$1", "evaluate"));
                }
                if (progressIndicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "org/jetbrains/tfsIntegration/checkin/CheckinPoliciesManager$1", "evaluate"));
                }
                return new PolicyFailure[0];
            }

            @Override
            public boolean canEdit() {
                return false;
            }

            @Override
            public boolean edit(Project project) {
                return false;
            }

            @Override
            public void loadState(@NotNull Element element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/tfsIntegration/checkin/CheckinPoliciesManager$1", "loadState"));
                }
            }

            @Override
            public void saveState(@NotNull Element element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/tfsIntegration/checkin/CheckinPoliciesManager$1", "saveState"));
                }
            }
        };
    }
}

